/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.economy.TownEntersBankruptcyEvent;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public class BankAccount
extends Account {
    private double debtCap;
    private Government government;

    public BankAccount(String name, World world, Government government) {
        super(name, world);
        this.government = government;
    }

    @Deprecated
    public BankAccount(String name, World world, double balanceCap) {
        super(name, world);
        this.government = this.getName().startsWith(TownySettings.getTownAccountPrefix()) ? TownyUniverse.getInstance().getTown(this.getName().replace(TownySettings.getTownAccountPrefix(), "")) : TownyUniverse.getInstance().getNation(this.getName().replace(TownySettings.getNationAccountPrefix(), ""));
    }

    @Deprecated
    public void setBalanceCap(double balanceCap) {
    }

    public double getBalanceCap() {
        return this.government.getBankCap();
    }

    @Override
    protected synchronized boolean subtractMoney(double amount) {
        if (this.isBankrupt()) {
            return this.addDebt(amount);
        }
        if (!this.canPayFromHoldings(amount) && this.isAllowedToEnterBankruptcy()) {
            double newDebt = amount - this.getHoldingBalance();
            if (newDebt <= this.getDebtCap()) {
                boolean success = TownyEconomyHandler.setBalance(this.getName(), 0.0, this.world);
                if (success &= this.addDebt(newDebt)) {
                    BukkitTools.fireEvent(new TownEntersBankruptcyEvent(this.getTown()));
                }
                return success;
            }
            return false;
        }
        return TownyEconomyHandler.subtract(this.getName(), amount, this.world);
    }

    @Override
    protected synchronized boolean addMoney(double amount) {
        if (this.getBalanceCap() != 0.0 && this.getHoldingBalance() + amount > this.getBalanceCap()) {
            return false;
        }
        if (this.isBankrupt()) {
            return this.removeDebt(amount);
        }
        return TownyEconomyHandler.add(this.getName(), amount, this.world);
    }

    @Override
    public synchronized boolean canPayFromHoldings(double amount) {
        if (this.isBankrupt()) {
            return this.getTownDebt() + amount <= this.getDebtCap();
        }
        return super.canPayFromHoldings(amount);
    }

    @Override
    public synchronized double getHoldingBalance(boolean setCache) {
        double balance;
        double d = balance = this.isBankrupt() ? (balance = this.getTownDebt() * -1.0) : TownyEconomyHandler.getBalance(this.getName(), this.getBukkitWorld());
        if (setCache) {
            this.cachedBalance.setBalance(balance);
        }
        return balance;
    }

    @Override
    public String getHoldingFormattedBalance() {
        if (this.isBankrupt()) {
            return "-" + TownyEconomyHandler.getFormattedBalance(this.getTownDebt());
        }
        return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
    }

    @Override
    public void removeAccount() {
        TownyEconomyHandler.removeAccount(this.getName());
    }

    private boolean isTownAccount() {
        return this.government instanceof Town;
    }

    @Nullable
    private Town getTown() {
        return this.isTownAccount() ? (Town)this.government : null;
    }

    public boolean isBankrupt() {
        Town town;
        Government government = this.government;
        return government instanceof Town && (town = (Town)government).isBankrupt();
    }

    private synchronized boolean addDebt(double amount) {
        if (this.isTownAccount() && TownySettings.isTownBankruptcyEnabled()) {
            double newDebtBalance = this.getTownDebt() + amount;
            if (newDebtBalance > this.getDebtCap()) {
                return false;
            }
            this.setTownDebt(newDebtBalance);
            return true;
        }
        return false;
    }

    private synchronized boolean removeDebt(double amount) {
        if (this.getTownDebt() < amount) {
            double netMoney = amount - this.getTownDebt();
            this.setTownDebt(0.0);
            double bankBalance = TownyEconomyHandler.getBalance(this.getName(), this.getBukkitWorld());
            TownyEconomyHandler.setBalance(this.getName(), bankBalance + netMoney, this.world);
            return true;
        }
        this.setTownDebt(this.getTownDebt() - amount);
        return true;
    }

    public synchronized double getDebtCap() {
        if (!this.isTownAccount()) {
            return Double.MAX_VALUE;
        }
        if (TownySettings.isDebtCapDeterminedByTownLevel()) {
            return TownySettings.getTownLevel(this.getTown()).debtCapModifier() * TownySettings.getDebtCapOverride();
        }
        if (TownySettings.getDebtCapOverride() != 0.0) {
            return TownySettings.getDebtCapOverride();
        }
        if (TownySettings.getDebtCapMaximum() != 0.0) {
            return Math.min(this.debtCap, TownySettings.getDebtCapMaximum());
        }
        return this.debtCap;
    }

    public void setDebtCap(double debtCap) {
        this.debtCap = debtCap;
    }

    private boolean isAllowedToEnterBankruptcy() {
        return TownySettings.isTownBankruptcyEnabled() && this.isTownAccount();
    }

    private double getTownDebt() {
        return this.getTown().getDebtBalance();
    }

    private void setTownDebt(double amount) {
        this.getTown().setDebtBalance(amount);
        this.getTown().save();
    }
}

