/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.EconomyAccount;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.economy.AccountAuditor;
import com.palmergames.bukkit.towny.object.economy.AccountObserver;
import com.palmergames.bukkit.towny.object.economy.GlobalAccountObserver;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.World;

public abstract class Account
implements Nameable {
    private static final long CACHE_TIMEOUT = TownySettings.getCachedBankTimeout();
    private static final AccountObserver GLOBAL_OBSERVER = new GlobalAccountObserver();
    private final List<AccountObserver> observers = new ArrayList<AccountObserver>();
    private AccountAuditor auditor;
    protected CachedBalance cachedBalance = null;
    String name;
    World world;

    public Account(String name) {
        this.name = name;
        this.observers.add(GLOBAL_OBSERVER);
        try {
            this.cachedBalance = new CachedBalance(this.getHoldingBalance(false));
        }
        catch (Exception e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, String.format("An exception occurred when initializing cached balance for an account (name: %s), see the below error for more details.", name), e);
            this.cachedBalance = new CachedBalance(0.0);
        }
    }

    public Account(String name, World world) {
        this(name);
        this.world = world;
    }

    protected abstract boolean addMoney(double var1);

    protected abstract boolean subtractMoney(double var1);

    public synchronized boolean deposit(double amount, String reason) {
        if (this.addMoney(amount)) {
            this.notifyObserversDeposit(this, amount, reason);
            if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
                return this.payFromServer(amount, reason);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean withdraw(double amount, String reason) {
        if (this.subtractMoney(amount)) {
            this.notifyObserversWithdraw(this, amount, reason);
            if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
                return this.payToServer(amount, reason);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean payTo(double amount, EconomyHandler collector, String reason) {
        return this.payTo(amount, collector.getAccount(), reason);
    }

    protected synchronized boolean payToServer(double amount, String reason) {
        this.notifyObserversDeposit(EconomyAccount.SERVER_ACCOUNT, amount, reason);
        return TownyEconomyHandler.addToServer(amount, this.getBukkitWorld());
    }

    protected synchronized boolean payFromServer(double amount, String reason) {
        this.notifyObserversWithdraw(EconomyAccount.SERVER_ACCOUNT, amount, reason);
        return TownyEconomyHandler.subtractFromServer(amount, this.getBukkitWorld());
    }

    public synchronized boolean payTo(double amount, Account collector, String reason) {
        if (amount > this.getHoldingBalance()) {
            return false;
        }
        return this.withdraw(amount, reason) && collector.deposit(amount, reason);
    }

    public World getBukkitWorld() {
        return BukkitTools.getWorlds().get(0);
    }

    public boolean setBalance(double amount, String reason) {
        double balance = this.getHoldingBalance();
        double diff = amount - balance;
        if (diff > 0.0) {
            return this.deposit(diff, reason);
        }
        if (balance > amount) {
            diff = -diff;
            return this.withdraw(diff, reason);
        }
        return true;
    }

    public synchronized double getHoldingBalance() {
        return this.getHoldingBalance(true);
    }

    public synchronized double getHoldingBalance(boolean setCache) {
        double balance = TownyEconomyHandler.getBalance(this.getName(), this.getBukkitWorld());
        if (setCache) {
            this.cachedBalance.setBalance(balance);
        }
        return balance;
    }

    public synchronized boolean canPayFromHoldings(double amount) {
        return TownyEconomyHandler.hasEnough(this.getName(), amount, this.getBukkitWorld());
    }

    public String getHoldingFormattedBalance() {
        return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
    }

    public void removeAccount() {
        TownyEconomyHandler.removeAccount(this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<AccountObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    private void notifyObserversDeposit(Account account, double amount, String reason) {
        for (AccountObserver observer : this.getObservers()) {
            observer.deposited(account, amount, reason);
        }
    }

    private void notifyObserversWithdraw(Account account, double amount, String reason) {
        for (AccountObserver observer : this.getObservers()) {
            observer.withdrew(account, amount, reason);
        }
    }

    public final void addObserver(AccountObserver observer) {
        this.observers.add(observer);
    }

    public final void removeObserver(AccountObserver observer) {
        this.observers.remove(observer);
    }

    public final AccountAuditor getAuditor() {
        return this.auditor;
    }

    public final void setAuditor(AccountAuditor auditor) {
        this.auditor = auditor;
        this.addObserver(auditor);
    }

    public double getCachedBalance() {
        return this.getCachedBalance(true);
    }

    public synchronized double getCachedBalance(boolean refreshIfStale) {
        if (refreshIfStale && this.cachedBalance.isStale()) {
            this.cachedBalance.updateCache();
        }
        return this.cachedBalance.getBalance();
    }

    class CachedBalance {
        private double balance = 0.0;
        private long time;

        CachedBalance(double _balance) {
            this.balance = _balance;
            this.time = System.currentTimeMillis();
        }

        double getBalance() {
            return this.balance;
        }

        boolean isStale() {
            return System.currentTimeMillis() - this.time > CACHE_TIMEOUT;
        }

        void setBalance(double _balance) {
            this.balance = _balance;
            this.time = System.currentTimeMillis();
        }

        void updateCache() {
            this.time = System.currentTimeMillis();
            TownyEconomyHandler.economyExecutor().execute(() -> this.setBalance(Account.this.getHoldingBalance()));
        }
    }
}

