/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.comparators;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.adventure.text.format.NamedTextColor;
import com.palmergames.adventure.text.format.TextColor;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.nation.DisplayedNationsListSortEvent;
import com.palmergames.bukkit.towny.event.nation.NationListDisplayedNumOnlinePlayersCalculationEvent;
import com.palmergames.bukkit.towny.event.nation.NationListDisplayedNumResidentsCalculationEvent;
import com.palmergames.bukkit.towny.event.nation.NationListDisplayedNumTownBlocksCalculationEvent;
import com.palmergames.bukkit.towny.event.nation.NationListDisplayedNumTownsCalculationEvent;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public class ComparatorCaches {
    private static final LoadingCache<ComparatorType, List<TextComponent>> townCompCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ComparatorType, List<TextComponent>>(){

        @NotNull
        public List<TextComponent> load(@NotNull ComparatorType compType) {
            return ComparatorCaches.gatherTownLines(compType);
        }
    });
    private static final LoadingCache<ComparatorType, List<TextComponent>> nationCompCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ComparatorType, List<TextComponent>>(){

        @NotNull
        public List<TextComponent> load(@NotNull ComparatorType compType) {
            return ComparatorCaches.gatherNationLines(compType);
        }
    });

    public static List<TextComponent> getTownListCache(ComparatorType compType) {
        try {
            return (List)townCompCache.get((Object)compType);
        }
        catch (ExecutionException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "exception occurred while updating town comparator cache", e);
            return new ArrayList<TextComponent>();
        }
    }

    public static List<TextComponent> getNationListCache(ComparatorType compType) {
        try {
            return (List)nationCompCache.get((Object)compType);
        }
        catch (ExecutionException e) {
            Towny.getPlugin().getLogger().log(Level.WARNING, "exception occurred while updating nation comparator cache", e);
            return new ArrayList<TextComponent>();
        }
    }

    private static List<TextComponent> gatherTownLines(ComparatorType compType) {
        ArrayList<TextComponent> output = new ArrayList<TextComponent>();
        ArrayList<Town> towns = new ArrayList<Town>(TownyUniverse.getInstance().getTowns());
        towns.sort(compType.getComparator());
        for (Town town : towns) {
            TextComponent townName = (TextComponent)Component.text(StringMgmt.remUnderscore(town.getName()), (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand("/towny:town spawn " + town + " -ignore"));
            String slug = "";
            switch (compType) {
                case BALANCE: {
                    slug = "(" + TownyEconomyHandler.getFormattedBalance(town.getAccount().getCachedBalance()) + ")";
                    break;
                }
                case TOWNBLOCKS: {
                    slug = "(" + town.getTownBlocks().size() + ")";
                    break;
                }
                case RUINED: {
                    slug = "(" + town.getResidents().size() + ") " + (town.isRuined() ? Translation.of("msg_ruined") : "");
                    break;
                }
                case BANKRUPT: {
                    slug = "(" + town.getResidents().size() + ") " + (town.isBankrupt() ? Translation.of("msg_bankrupt") : "");
                    break;
                }
                case ONLINE: {
                    slug = "(" + TownyAPI.getInstance().getOnlinePlayersInTown(town).size() + ")";
                    break;
                }
                case FOUNDED: {
                    if (town.getRegistered() == 0L) break;
                    slug = "(" + TownyFormatter.registeredFormat.format(town.getRegistered()) + ")";
                    break;
                }
                case UPKEEP: {
                    slug = "(" + TownyEconomyHandler.getFormattedBalance(TownySettings.getTownUpkeepCost(town)) + ")";
                    break;
                }
                default: {
                    slug = "(" + town.getResidents().size() + ")";
                }
            }
            townName = (TextComponent)((TextComponent)townName.append(Component.text(" - ", (TextColor)NamedTextColor.DARK_GRAY))).append(Component.text(slug, (TextColor)NamedTextColor.AQUA));
            if (town.isOpen()) {
                townName = (TextComponent)((TextComponent)townName.append(Component.space())).append(Translatable.of("status_title_open").component());
            }
            Translatable spawnCost = Translatable.of("msg_spawn_cost_free");
            if (TownyEconomyHandler.isActive()) {
                spawnCost = Translatable.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(town.getSpawnCost()));
            }
            townName = (TextComponent)townName.hoverEvent(HoverEvent.showText(Translatable.of("msg_click_spawn", town).append("\n").append(spawnCost).component()));
            output.add(townName);
        }
        return output;
    }

    private static List<TextComponent> gatherNationLines(ComparatorType compType) {
        ArrayList<TextComponent> output = new ArrayList<TextComponent>();
        List<Nation> nations = new ArrayList<Nation>(TownyUniverse.getInstance().getNations());
        nations.sort(compType.getComparator());
        DisplayedNationsListSortEvent nationListSortEvent = new DisplayedNationsListSortEvent(nations, compType);
        BukkitTools.fireEvent(nationListSortEvent);
        nations = nationListSortEvent.getNations();
        for (Nation nation : nations) {
            TextComponent nationName = (TextComponent)Component.text(StringMgmt.remUnderscore(nation.getName()), (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand("/towny:nation spawn " + nation + " -ignore"));
            String slug = "";
            switch (compType) {
                case BALANCE: {
                    slug = TownyEconomyHandler.getFormattedBalance(nation.getAccount().getCachedBalance());
                    break;
                }
                case TOWNBLOCKS: {
                    int rawNumTownsBlocks = nation.getTownBlocks().size();
                    NationListDisplayedNumTownBlocksCalculationEvent tbEvent = new NationListDisplayedNumTownBlocksCalculationEvent(nation, rawNumTownsBlocks);
                    BukkitTools.fireEvent(tbEvent);
                    slug = tbEvent.getDisplayedValue() + "";
                    break;
                }
                case TOWNS: {
                    int rawNumTowns = nation.getTowns().size();
                    NationListDisplayedNumTownsCalculationEvent tEvent = new NationListDisplayedNumTownsCalculationEvent(nation, rawNumTowns);
                    BukkitTools.fireEvent(tEvent);
                    slug = tEvent.getDisplayedValue() + "";
                    break;
                }
                case ONLINE: {
                    int rawNumOnlinePlayers = TownyAPI.getInstance().getOnlinePlayersInNation(nation).size();
                    NationListDisplayedNumOnlinePlayersCalculationEvent opEvent = new NationListDisplayedNumOnlinePlayersCalculationEvent(nation, rawNumOnlinePlayers);
                    BukkitTools.fireEvent(opEvent);
                    slug = opEvent.getDisplayedValue() + "";
                    break;
                }
                case FOUNDED: {
                    if (nation.getRegistered() == 0L) break;
                    slug = TownyFormatter.registeredFormat.format(nation.getRegistered());
                    break;
                }
                case UPKEEP: {
                    slug = TownyEconomyHandler.getFormattedBalance(TownySettings.getNationUpkeepCost(nation));
                    break;
                }
                default: {
                    int rawNumResidents = nation.getResidents().size();
                    NationListDisplayedNumResidentsCalculationEvent rEvent = new NationListDisplayedNumResidentsCalculationEvent(nation, rawNumResidents);
                    BukkitTools.fireEvent(rEvent);
                    slug = rEvent.getDisplayedValue() + "";
                }
            }
            nationName = (TextComponent)((TextComponent)nationName.append(Component.text(" - ", (TextColor)NamedTextColor.DARK_GRAY))).append(Component.text("(" + slug + ")", (TextColor)NamedTextColor.AQUA));
            if (nation.isOpen()) {
                nationName = (TextComponent)((TextComponent)nationName.append(Component.space())).append(Translatable.of("status_title_open").component());
            }
            Translatable spawnCost = Translatable.of("msg_spawn_cost_free");
            if (TownyEconomyHandler.isActive()) {
                spawnCost = Translatable.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(nation.getSpawnCost()));
            }
            nationName = (TextComponent)nationName.hoverEvent(HoverEvent.showText(Translatable.of("msg_click_spawn", nation).append("\n").append(spawnCost).component()));
            output.add(nationName);
        }
        return output;
    }
}

