/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.compress.utils.FileNameUtils;
import com.palmergames.util.FileMgmt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class TranslationLoader {
    private final Path langFolderPath;
    private final Plugin plugin;
    private final Class<?> clazz;
    private static Map<String, Map<String, String>> newTranslations = new HashMap<String, Map<String, String>>();
    private static final Map<String, String> oldLangFileNames = TranslationLoader.createLegacyLangMap();

    public TranslationLoader(Path langFolderPath, Plugin plugin, Class<?> clazz) {
        this.langFolderPath = langFolderPath;
        this.plugin = plugin;
        this.clazz = clazz;
    }

    public TranslationLoader(Plugin plugin) {
        this.langFolderPath = Paths.get(plugin.getDataFolder().getPath(), new String[0]).resolve("lang");
        this.plugin = plugin;
        this.clazz = plugin.getClass();
    }

    public void load() {
        newTranslations = new HashMap<String, Map<String, String>>();
        this.loadTranslationsIntoMemory();
        this.loadOverrideFiles();
        this.loadGlobalFile();
        this.plugin.getLogger().info(String.format("Successfully loaded translations for %d languages.", newTranslations.keySet().size()));
    }

    public Map<String, Map<String, String>> getTranslations() {
        return newTranslations;
    }

    void setTranslations(Map<String, Map<String, String>> translations) {
        newTranslations = translations;
    }

    void loadTranslationsIntoMemory() {
        try {
            Files.createDirectories(this.langFolderPath.resolve("reference"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to create language reference folder.", TownyInitException.TownyError.LOCALIZATION, e);
        }
        for (String lang : this.getLangFileNamesFromPlugin()) {
            try {
                InputStream is = this.clazz.getResourceAsStream("/lang/" + lang + ".yml");
                try {
                    if (is == null) {
                        throw new TownyInitException("Could not find '/lang/" + lang + ".yml' in the JAR", TownyInitException.TownyError.LOCALIZATION);
                    }
                    Map values = (Map)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(is);
                    this.saveReferenceFile(lang);
                    lang = lang.replace("-", "_");
                    if (!newTranslations.containsKey(lang)) {
                        newTranslations.put(lang, new HashMap());
                    }
                    for (Map.Entry entry : values.entrySet()) {
                        newTranslations.get(lang).put(((String)entry.getKey()).toLowerCase(Locale.ROOT), String.valueOf(entry.getValue()));
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Unabled to read yaml file: '" + lang + ".yml' from within the " + this.plugin.getName() + ".jar.", e);
            }
        }
    }

    private Set<String> getLangFileNamesFromPlugin() {
        HashSet<String> lang = new HashSet<String>();
        try {
            URI uri = this.clazz.getResource("").toURI();
            try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                 Stream<Path> stream = Files.list(fs.getRootDirectories().iterator().next().resolve("/lang"));){
                stream.filter(p -> TownySettings.isLanguageEnabled(FileNameUtils.getBaseName(p.toString().replace("-", "_")))).forEach(p -> lang.add(FileNameUtils.getBaseName(p.toString())));
            }
        }
        catch (IOException | URISyntaxException e) {
            this.plugin.getLogger().log(Level.WARNING, "An exception occurred while getting language file names from the plugin jar", e);
        }
        return lang;
    }

    private void saveReferenceFile(String lang) {
        Path langPath = this.langFolderPath.resolve("reference").resolve(lang + ".yml");
        try (InputStream resource = this.clazz.getResourceAsStream("/lang/" + lang + ".yml");){
            if (resource == null) {
                return;
            }
            if (!Files.exists(langPath, new LinkOption[0])) {
                Files.createFile(langPath, new FileAttribute[0]);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(resource));
                 Stream<String> lines = Files.lines(langPath);){
                String string = br.lines().collect(Collectors.joining("\n"));
                if (!string.equals(lines.collect(Collectors.joining("\n")))) {
                    FileMgmt.writeString(langPath, string);
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to copy '/lang/" + lang + ".yml' from the JAR to '" + langPath.toAbsolutePath() + "' during a reference language file update.", e);
        }
    }

    void loadOverrideFiles() {
        try {
            Files.createDirectories(this.langFolderPath.resolve("override"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to create language override folder.", TownyInitException.TownyError.LOCALIZATION, e);
        }
        File[] overrideFiles = new File(this.langFolderPath + File.separator + "override").listFiles();
        if (overrideFiles != null) {
            for (File file : overrideFiles) {
                if (!file.isFile() || !FileNameUtils.getExtension(file.getName()).equalsIgnoreCase("yml") || file.getName().equalsIgnoreCase("global.yml") || !TownySettings.isLanguageEnabled(FileNameUtils.getBaseName(file.getName()).replaceAll("-", "_"))) continue;
                try (FileInputStream is = new FileInputStream(file);){
                    Map values = (Map)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load((InputStream)is);
                    String lang = FileNameUtils.getBaseName(file.getName()).replaceAll("-", "_");
                    if (values == null) continue;
                    newTranslations.computeIfAbsent(lang, k -> new HashMap());
                    for (Map.Entry<String, Object> entry : values.entrySet()) {
                        newTranslations.get(lang).put(((String)entry.getKey()).toLowerCase(Locale.ROOT), TranslationLoader.getTranslationValue(entry));
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Unabled to read yaml file: '" + file.getName() + "' in the override folder.", e);
                }
            }
        }
    }

    private static String getTranslationValue(Map.Entry<String, Object> entry) {
        if (entry.getKey().toLowerCase().startsWith("msg_ptw_warning")) {
            String msg = String.valueOf(entry.getValue());
            Towny.getPlugin().getLogger().warning("Attempted to override an protected string. Skipped " + entry.getKey());
            if (!msg.contains("Towny")) {
                String string;
                switch (entry.getKey()) {
                    case "msg_ptw_warning_1": {
                        string = "If you have paid any real-life money for these townblocks please understand: the server you play on is in violation of the Minecraft EULA and the Towny license.";
                        break;
                    }
                    case "msg_ptw_warning_2": {
                        string = "The Towny team never intended for townblocks to be purchaseable with real money.";
                        break;
                    }
                    case "msg_ptw_warning_3": {
                        string = "If you did pay real money you should consider playing on a Towny server that respects the wishes of the Towny Team.";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value: " + entry.getKey());
                    }
                }
                return string;
            }
            return msg;
        }
        return String.valueOf(entry.getValue());
    }

    void loadGlobalFile() {
        try (InputStream resourceAsStream = this.clazz.getResourceAsStream("/global.yml");){
            Map<String, Object> globalOverrides;
            if (resourceAsStream == null) {
                return;
            }
            Path globalYMLPath = this.langFolderPath.resolve("override").resolve("global.yml");
            Path glitchedGlobalPath = this.langFolderPath.resolve("global.yml");
            if (Files.exists(glitchedGlobalPath, new LinkOption[0])) {
                Files.move(glitchedGlobalPath, globalYMLPath, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!Files.exists(globalYMLPath, new LinkOption[0])) {
                this.createGlobalYML(globalYMLPath, resourceAsStream);
            }
            if ((globalOverrides = this.loadGlobalFile(globalYMLPath)) != null) {
                this.overwriteKeysWithGlobalOverrides(globalOverrides);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createGlobalYML(Path globalYMLPath, InputStream resource) {
        if (!FileMgmt.checkOrCreateFile(globalYMLPath.toString())) {
            throw new TownyInitException("Failed to touch '" + globalYMLPath + "'.", TownyInitException.TownyError.LOCALIZATION);
        }
        try {
            if (resource == null) {
                throw new TownyInitException("Could not find global.yml in the JAR", TownyInitException.TownyError.LOCALIZATION);
            }
            Files.copy(resource, globalYMLPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to copy global.yml from the JAR to '" + globalYMLPath + "'", TownyInitException.TownyError.LOCALIZATION, e);
        }
    }

    private Map<String, Object> loadGlobalFile(Path globalYMLPath) {
        Map<String, Object> globalOverrides = new HashMap<String, Object>();
        try (InputStream is = Files.newInputStream(globalYMLPath, new OpenOption[0]);){
            globalOverrides = (Map)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(is);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "An exception occurred while reading the global.yml file", e);
        }
        return globalOverrides;
    }

    private void overwriteKeysWithGlobalOverrides(Map<String, Object> globalOverrides) {
        for (Map.Entry<String, Object> entry : globalOverrides.entrySet()) {
            for (String lang : newTranslations.keySet()) {
                newTranslations.get(lang).put(entry.getKey().toLowerCase(Locale.ROOT), TranslationLoader.getTranslationValue(entry));
            }
        }
    }

    void updateLegacyLangFileName(String lang) {
        File newFile;
        if (!oldLangFileNames.containsKey(lang)) {
            return;
        }
        String path = Towny.getPlugin().getDataFolder().getPath() + File.separator + "settings" + File.separator;
        File oldFile = new File(path + lang);
        boolean rename = oldFile.renameTo(newFile = new File(path + oldLangFileNames.get(lang)));
        if (rename) {
            Towny.getPlugin().getLogger().info("Language file name updated.");
            TownySettings.setLanguage(oldLangFileNames.get(lang));
        } else {
            Towny.getPlugin().getLogger().warning("Language file was not updated.");
        }
    }

    private static Map<String, String> createLegacyLangMap() {
        HashMap<String, String> oldLangFileNames = new HashMap<String, String>();
        oldLangFileNames.put("danish.yml", "da-DK.yml");
        oldLangFileNames.put("german.yml", "de-DE.yml");
        oldLangFileNames.put("english.yml", "en-US.yml");
        oldLangFileNames.put("spanish.yml", "es-ES.yml");
        oldLangFileNames.put("french.yml", "fr-FR.yml");
        oldLangFileNames.put("italian.yml", "it-IT.yml");
        oldLangFileNames.put("korean.yml", "ko-KR.yml");
        oldLangFileNames.put("norwegian.yml", "no-NO.yml");
        oldLangFileNames.put("polish.yml", "pl-PL.yml");
        oldLangFileNames.put("pt-br.yml", "pt-BR.yml");
        oldLangFileNames.put("russian.yml", "ru-RU.yml");
        oldLangFileNames.put("sv-SE.yml", "sv-SE.yml");
        oldLangFileNames.put("chinese.yml", "zh-CN.yml");
        return oldLangFileNames;
    }
}

