/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.TownBlockTypeRegisterEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.TownBlockData;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ItemLists;
import com.palmergames.util.StringMgmt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TownBlockTypeHandler {
    private static final Map<String, TownBlockType> townBlockTypeMap = new ConcurrentHashMap<String, TownBlockType>();

    public static void initialize() {
        ConcurrentHashMap<String, TownBlockType> newData = new ConcurrentHashMap<String, TownBlockType>();
        for (Field field : TownBlockType.class.getFields()) {
            try {
                TownBlockType type = (TownBlockType)field.get(null);
                newData.put(type.getName().toLowerCase(Locale.ROOT), type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TownBlockTypeHandler.applyConfigSettings(newData);
        townBlockTypeMap.putAll(newData);
        BukkitTools.fireEvent(new TownBlockTypeRegisterEvent());
        Towny.getPlugin().getLogger().info(String.format("Config: Loaded %d townblock types: %s.", townBlockTypeMap.size(), StringMgmt.join(townBlockTypeMap.keySet(), ", ")));
    }

    public static void registerType(@NotNull TownBlockType type) throws TownyException {
        if (TownBlockTypeHandler.exists(type.getName())) {
            throw new TownyException(String.format("API: A type named '%s' is already registered!", type.getName()));
        }
        townBlockTypeMap.put(type.getName().toLowerCase(), type);
        Towny.getPlugin().getLogger().info(String.format("API: A new townblock type was registered: %s", type.getName()));
    }

    public static Map<String, TownBlockType> getTypes() {
        return Collections.unmodifiableMap(townBlockTypeMap);
    }

    public static List<String> getTypeNames() {
        return new ArrayList<String>(townBlockTypeMap.keySet());
    }

    @Nullable
    public static TownBlockType getType(@NotNull String typeName) {
        return townBlockTypeMap.get(typeName.toLowerCase(Locale.ROOT));
    }

    public static TownBlockType getTypeInternal(@NotNull String input) {
        try {
            int id = Integer.parseInt(input);
            return TownBlockTypeHandler.getType(TownBlockType.getLegacylookupmap().getOrDefault(id, "default"));
        }
        catch (NumberFormatException e) {
            return TownBlockTypeHandler.getType(input);
        }
    }

    public static boolean exists(@NotNull String typeName) {
        return TownBlockTypeHandler.getType(typeName) != null;
    }

    private static void applyConfigSettings(Map<String, TownBlockType> newData) {
        List types = TownySettings.getConfig().getMapList("townblocktypes.types");
        for (Map genericType : types) {
            String name = "unknown type";
            try {
                TownBlockData data;
                Map type = genericType;
                name = String.valueOf(type.get("name"));
                double cost = TownBlockTypeHandler.parseDouble(((Object)type.getOrDefault("cost", 0.0)).toString());
                double tax = TownBlockTypeHandler.parseDouble(((Object)type.getOrDefault("tax", 0.0)).toString());
                String mapKey = String.valueOf(type.getOrDefault("mapKey", "+"));
                Set<Material> itemUseIds = TownBlockTypeHandler.loadMaterialList("itemUseIds", String.valueOf(type.getOrDefault("itemUseIds", "")), name);
                Set<Material> switchIds = TownBlockTypeHandler.loadMaterialList("switchIds", String.valueOf(type.getOrDefault("switchIds", "")), name);
                Set<Material> allowedBlocks = TownBlockTypeHandler.loadMaterialList("allowedBlocks", String.valueOf(type.getOrDefault("allowedBlocks", "")), name);
                TownBlockType townBlockType = newData.get(name.toLowerCase());
                if (townBlockType == null) {
                    data = new TownBlockData();
                    townBlockType = new TownBlockType(name, data);
                } else {
                    data = townBlockType.getData();
                }
                data.setCost(cost);
                data.setTax(tax);
                data.setMapKey(mapKey);
                data.setItemUseIds(itemUseIds);
                data.setSwitchIds(switchIds);
                data.setAllowedBlocks(allowedBlocks);
                newData.put(name.toLowerCase(Locale.ROOT), townBlockType);
            }
            catch (Exception e) {
                Towny.getPlugin().getLogger().log(Level.WARNING, String.format("Config: Error while loading townblock type '%s', skipping...", name), e);
            }
        }
    }

    private static Set<Material> loadMaterialList(String listName, String materialList, String typeName) {
        if (!materialList.isEmpty()) {
            HashSet<Material> set = new HashSet<Material>();
            for (String materialName : materialList.split(",")) {
                if (ItemLists.GROUPS.contains(materialName)) {
                    set.addAll(ItemLists.getGrouping(materialName));
                    continue;
                }
                Material material = TownBlockTypeHandler.matchMaterial(materialName, listName, typeName);
                if (material == null) continue;
                set.add(material);
            }
            return set;
        }
        return new HashSet<Material>();
    }

    @Nullable
    private static Material matchMaterial(String materialName, String listName, String typeName) {
        Material material = (Material)BukkitTools.matchRegistry(Registry.MATERIAL, materialName);
        if (material == null) {
            TownyMessaging.sendDebugMsg(String.format("Could not find a material named '%s' while loading the " + listName + " list for the %s type.", materialName, typeName));
        }
        return material;
    }

    private static double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NullPointerException | NumberFormatException e) {
            return 0.0;
        }
    }

    private TownBlockTypeHandler() {
    }

    public static class Migrator {
        private static final Set<Migration> migrations = new HashSet<Migration>();

        public static void checkForLegacyOptions(CommentedConfiguration config) {
            if (!config.contains(ConfigNodes.TOWNBLOCKTYPES_TYPES.getRoot())) {
                return;
            }
            double shopCost = TownBlockTypeHandler.parseDouble(config.getString("economy.plot_type_costs.set_commercial"));
            double arenaCost = TownBlockTypeHandler.parseDouble(config.getString("economy.plot_type_costs.set_arena"));
            double embassyCost = TownBlockTypeHandler.parseDouble(config.getString("economy.plot_type_costs.set_embassy"));
            double wildsCost = TownBlockTypeHandler.parseDouble(config.getString("economy.plot_type_costs.set_wilds"));
            double innCost = TownBlockTypeHandler.parseDouble(config.getString("economy.plot_type_costs.set_inn"));
            double jailCost = TownBlockTypeHandler.parseDouble(config.getString("economy.plot_type_costs.set_jail"));
            double farmCost = TownBlockTypeHandler.parseDouble(config.getString("economy.plot_type_costs.set_farm"));
            double bankCost = TownBlockTypeHandler.parseDouble(config.getString("economy.plot_type_costs.set_bank"));
            String farmPlotBlocks = config.getString("global_town_settings.farm_plot_allow_blocks", TownySettings.getDefaultFarmblocks());
            migrations.add(new Migration("shop", "cost", shopCost));
            migrations.add(new Migration("arena", "cost", arenaCost));
            migrations.add(new Migration("embassy", "cost", embassyCost));
            migrations.add(new Migration("wilds", "cost", wildsCost));
            migrations.add(new Migration("inn", "cost", innCost));
            migrations.add(new Migration("jail", "cost", jailCost));
            migrations.add(new Migration("farm", "cost", farmCost));
            migrations.add(new Migration("farm", "allowedBlocks", farmPlotBlocks));
            migrations.add(new Migration("bank", "cost", bankCost));
        }

        public static void migrate() {
            if (migrations.isEmpty()) {
                return;
            }
            List mapList = TownySettings.getConfig().getMapList("townblocktypes.types");
            for (Migration migration : migrations) {
                for (Map map : mapList) {
                    if (!map.get("name").toString().equalsIgnoreCase(migration.type())) continue;
                    map.put(migration.key(), migration.value());
                }
            }
            TownySettings.getConfig().set("townblocktypes.types", mapList);
            TownySettings.getConfig().save();
            migrations.clear();
        }

        private static final class Migration {
            private final String type;
            private final String key;
            private final Object value;

            private Migration(String type, String key, Object value) {
                this.type = type;
                this.key = key;
                this.value = value;
            }

            public String toString() {
                return "Migration[" + "type=" + this.type + "," + "key=" + this.key + "," + "value=" + this.value + "]";
            }

            public int hashCode() {
                int result = 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }

            public final boolean equals(Object arg0) {
                if (this == arg0) {
                    return true;
                }
                if (arg0 == null) {
                    return false;
                }
                if (arg0.getClass() != this.getClass()) {
                    return false;
                }
                if (!Objects.equals(((Migration)arg0).type, this.type)) {
                    return false;
                }
                if (!Objects.equals(((Migration)arg0).key, this.key)) {
                    return false;
                }
                return Objects.equals(((Migration)arg0).value, this.value);
                {
                }
            }

            public String type() {
                return this.type;
            }

            public String key() {
                return this.key;
            }

            public Object value() {
                return this.value;
            }
        }
    }
}

