/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.adventure.audience.Audience;
import com.palmergames.adventure.audience.ForwardingAudience;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.event.resident.ResidentToggleModeEvent;
import com.palmergames.bukkit.towny.event.town.TownPreRemoveResidentEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.InviteReceiver;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.EconomyAccount;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.Identifiable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.TeleportRequest;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.gui.SelectionGUI;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MetaDataUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Resident
extends TownyObject
implements InviteReceiver,
EconomyHandler,
TownBlockOwner,
Identifiable,
ForwardingAudience.Single {
    private List<Resident> friends = new ArrayList<Resident>();
    private UUID uuid = null;
    private Town town = null;
    private long lastOnline;
    private long registered;
    private long joinedTownAt;
    private boolean isNPC = false;
    private String title = "";
    private String surname = "";
    private final List<String> modes = new ArrayList<String>();
    private transient Confirmation confirmation;
    private final transient List<Invite> receivedInvites = new ArrayList<Invite>();
    private transient EconomyAccount account;
    private Jail jail = null;
    private int jailCell;
    private int jailHours;
    private double jailBail;
    private final List<String> townRanks = new ArrayList<String>();
    private final List<String> nationRanks = new ArrayList<String>();
    private List<TownBlock> townBlocks = new ArrayList<TownBlock>();
    private final TownyPermission permissions = new TownyPermission();
    private ArrayList<Inventory> guiPages;
    private int guiPageNum = 0;
    private SelectionGUI.SelectionType guiSelectionType;
    private ScheduledTask respawnProtectionTask = null;
    private boolean respawnPickupWarningShown = false;

    public Resident(String name) {
        super(name);
        this.permissions.loadDefault(this);
    }

    public void setLastOnline(long lastOnline) {
        this.lastOnline = lastOnline;
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setNPC(boolean isNPC) {
        this.isNPC = isNPC;
    }

    public boolean isNPC() {
        return this.isNPC;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean hasUUID() {
        return this.uuid != null;
    }

    public Jail getJail() {
        return this.jail;
    }

    public void setJail(Jail jail) {
        this.jail = jail;
    }

    public boolean isJailed() {
        return this.jail != null;
    }

    public int getJailCell() {
        return this.jailCell;
    }

    public void setJailCell(int i) {
        this.jailCell = this.jail.hasJailCell(i) ? i : 0;
    }

    public Town getJailTown() {
        return this.jail.getTown();
    }

    public boolean hasJailTown(String jailtown) {
        return this.getJailTown().getName().equalsIgnoreCase(jailtown);
    }

    public int getJailHours() {
        return this.jailHours;
    }

    public void setJailHours(Integer hours) {
        this.jailHours = hours;
    }

    public double getJailBailCost() {
        return this.jailBail;
    }

    public void setJailBailCost(double bail) {
        this.jailBail = bail;
    }

    public boolean hasJailTime() {
        return this.jailHours > 0;
    }

    public Location getJailSpawn() {
        return this.getJail().getJailCellLocations().get(this.getJailCell());
    }

    public String getPrimaryRankPrefix() {
        return TownyPerms.getResidentPrimaryRankPrefix(this);
    }

    public void setTitle(String title) {
        this.title = title.trim();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    public void setSurname(String surname) {
        this.surname = surname.trim();
    }

    public String getSurname() {
        return this.surname;
    }

    public boolean hasSurname() {
        return !this.surname.isEmpty();
    }

    public boolean isKing() {
        return this.hasNation() && this.town.getNationOrNull().isKing(this);
    }

    public boolean isMayor() {
        return this.hasTown() && this.town.isMayor(this);
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public boolean hasNation() {
        return this.hasTown() && this.town.hasNation();
    }

    public Town getTown() throws NotRegisteredException {
        if (this.hasTown()) {
            return this.town;
        }
        throw new NotRegisteredException(Translation.of("msg_err_resident_doesnt_belong_to_any_town"));
    }

    @Nullable
    public Town getTownOrNull() {
        return this.town;
    }

    public void setTown(Town town) throws AlreadyRegisteredException {
        this.setTown(town, true);
    }

    public void setTown(Town town, boolean updateJoinedAt) throws AlreadyRegisteredException {
        if (this.town == town) {
            return;
        }
        Towny.getPlugin().deleteCache(this);
        this.setTitle("");
        this.setSurname("");
        if (town == null) {
            this.town = null;
            this.updatePerms();
            return;
        }
        if (this.hasTown()) {
            town.addResidentCheck(this);
        }
        this.town = town;
        this.updatePerms();
        town.addResident(this);
        if (updateJoinedAt) {
            this.setJoinedTownAt(System.currentTimeMillis());
            BukkitTools.fireEvent(new TownAddResidentEvent(this, town));
        }
    }

    public void removeTown() {
        if (!this.hasTown()) {
            return;
        }
        Town town = this.town;
        BukkitTools.fireEvent(new TownPreRemoveResidentEvent(this, town));
        try {
            town.removeResident(this);
        }
        catch (EmptyTownException | NotRegisteredException exception) {
            // empty catch block
        }
        BukkitTools.fireEvent(new TownRemoveResidentEvent(this, town));
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (townBlock.getType() == TownBlockType.EMBASSY || !townBlock.hasResident(this) || !townBlock.removeResident()) continue;
            this.townBlocks.remove(townBlock);
            townBlock.setPlotPrice(town.getPlotPrice());
            townBlock.setType(townBlock.getType());
            townBlock.save();
        }
        try {
            this.setTown(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.save();
        Towny.getPlugin().resetCache();
    }

    public void setFriends(List<Resident> newFriends) {
        this.friends = newFriends;
    }

    public List<Resident> getFriends() {
        return Collections.unmodifiableList(this.friends);
    }

    public void removeFriend(Resident resident) {
        if (this.hasFriend(resident)) {
            this.friends.remove(resident);
        }
    }

    public boolean hasFriend(Resident resident) {
        return this.friends.contains(resident);
    }

    public void addFriend(Resident resident) throws AlreadyRegisteredException {
        if (this.hasFriend(resident) || this.equals(resident) || resident.isNPC()) {
            throw new AlreadyRegisteredException();
        }
        this.friends.add(resident);
    }

    public void removeAllFriends() {
        this.friends.clear();
    }

    public void updatePerms() {
        this.townRanks.clear();
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void updatePermsForNationRemoval() {
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void setRegistered(long registered) {
        this.registered = registered;
    }

    public long getRegistered() {
        return this.registered;
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Resident (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Registered: " + this.getRegistered());
        out.add(this.getTreeDepth(depth + 1) + "Last Online: " + this.getLastOnline());
        if (this.getFriends().size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Friends (" + this.getFriends().size() + "): " + Arrays.toString(this.getFriends().toArray(new Resident[0])));
        }
        return out;
    }

    @Deprecated
    public void clearTeleportRequest() {
    }

    @Deprecated
    public void setTeleportRequestTime() {
    }

    @ApiStatus.Obsolete
    public long getTeleportRequestTime() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? -1L : request.requestTime();
    }

    @Deprecated
    public void setTeleportDestination(Location spawnLoc) {
    }

    @ApiStatus.Obsolete
    public Location getTeleportDestination() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? null : request.destinationLocation();
    }

    @Deprecated
    public void setTeleportCooldown(int cooldown) {
    }

    @ApiStatus.Obsolete
    public int getTeleportCooldown() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? -1 : request.cooldown();
    }

    public boolean hasRequestedTeleport() {
        return TeleportWarmupTimerTask.hasTeleportRequest(this);
    }

    @Deprecated
    public void setTeleportCost(double cost) {
    }

    @ApiStatus.Obsolete
    public double getTeleportCost() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? 0.0 : request.teleportCost();
    }

    @Deprecated
    public void setTeleportAccount(Account payee) {
    }

    @ApiStatus.Obsolete
    public Account getTeleportAccount() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? null : request.teleportAccount();
    }

    public boolean hasPermissionNode(String node) {
        return this.getPlayer() != null && TownyUniverse.getInstance().getPermissionSource().testPermission((Permissible)this.getPlayer(), node);
    }

    public boolean isAdmin() {
        return this.getPlayer() != null && TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)this.getPlayer());
    }

    public List<String> getModes() {
        return Collections.unmodifiableList(this.modes);
    }

    public boolean hasMode(String mode) {
        return this.modes.contains(mode.toLowerCase());
    }

    public void toggleMode(String[] newModes, boolean notify) {
        for (int i = 0; i < newModes.length; ++i) {
            String bool;
            String mode = newModes[i].toLowerCase(Locale.ROOT);
            Optional<Boolean> choice = Optional.empty();
            if (i + 1 < newModes.length && BaseCommand.setOnOffCompletes.contains(bool = newModes[i + 1].toLowerCase(Locale.ROOT))) {
                choice = Optional.of(bool.equalsIgnoreCase("on"));
                ++i;
            }
            boolean modeEnabled = this.modes.contains(mode);
            ResidentToggleModeEvent event = new ResidentToggleModeEvent(this, mode);
            if (BukkitTools.isEventCancelled(event)) {
                TownyMessaging.sendErrorMsg(this, event.getCancelMessage());
                continue;
            }
            if (choice.orElse(!modeEnabled).booleanValue()) {
                if (modeEnabled) continue;
                this.modes.add(mode);
                continue;
            }
            this.modes.remove(mode);
        }
        if (this.modes.isEmpty()) {
            this.clearModes();
            return;
        }
        if (notify) {
            TownyMessaging.sendMsg(this, Translatable.of("msg_modes_set").append(StringMgmt.join(this.getModes(), ",")));
        }
    }

    public void setModes(String[] modes, boolean notify) {
        this.modes.clear();
        this.toggleMode(modes, false);
        if (notify) {
            TownyMessaging.sendMsg(this, Translatable.of("msg_modes_set").append(StringMgmt.join(this.getModes(), ",")));
        }
    }

    public void clearModes() {
        this.modes.clear();
        TownyMessaging.sendMsg(this, Translatable.of("msg_modes_set"));
        Towny.getPlugin().getScheduler().runAsyncLater(new SetDefaultModes(this.getName(), true), 1L);
    }

    public void resetModes(String[] modes, boolean notify) {
        if (modes.length > 0) {
            this.toggleMode(modes, false);
        }
        if (notify) {
            TownyMessaging.sendMsg(this, Translatable.of("msg_modes_set").append(StringMgmt.join(this.getModes(), ",")));
        }
    }

    @Nullable
    public Player getPlayer() {
        return BukkitTools.getPlayerExact(this.getName());
    }

    public boolean addTownRank(String rank) {
        if (!this.hasTownRank(rank)) {
            this.townRanks.add(rank);
            if (this.isOnline()) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    public void setTownRanks(List<String> ranks) {
        for (String rank : ranks) {
            if ((rank = TownyPerms.matchTownRank(rank)) == null || this.hasTownRank(rank)) continue;
            this.townRanks.add(rank);
        }
    }

    public boolean hasTownRank(String rank) {
        if ((rank = TownyPerms.matchTownRank(rank)) != null) {
            for (String ownedRank : this.townRanks) {
                if (!ownedRank.equalsIgnoreCase(rank)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTownRanks() {
        return Collections.unmodifiableList(this.townRanks);
    }

    public boolean removeTownRank(String rank) {
        if (this.hasTownRank(rank)) {
            this.townRanks.remove(rank);
            if (this.isOnline()) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public String getHighestPriorityTownRank() {
        if (this.getTownRanks().isEmpty()) {
            return null;
        }
        return TownyPerms.getHighestPriorityRank(this, this.getTownRanks(), r -> TownyPerms.getTownRankPermissions(r));
    }

    public boolean addNationRank(String rank) {
        if (!this.hasNationRank(rank)) {
            this.nationRanks.add(rank);
            if (this.isOnline()) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    public void setNationRanks(List<String> ranks) {
        for (String rank : ranks) {
            if ((rank = TownyPerms.matchNationRank(rank)) == null || this.hasNationRank(rank)) continue;
            this.nationRanks.add(rank);
        }
    }

    public boolean hasNationRank(String rank) {
        if ((rank = TownyPerms.matchNationRank(rank)) != null) {
            for (String ownedRank : this.nationRanks) {
                if (!ownedRank.equalsIgnoreCase(rank)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getNationRanks() {
        return Collections.unmodifiableList(this.nationRanks);
    }

    public boolean removeNationRank(String rank) {
        if (this.hasNationRank(rank)) {
            this.nationRanks.remove(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public String getHighestPriorityNationRank() {
        if (this.getNationRanks().isEmpty()) {
            return null;
        }
        return TownyPerms.getHighestPriorityRank(this, this.getNationRanks(), r -> TownyPerms.getNationRankPermissions(r));
    }

    public boolean isAlliedWith(Resident otherresident) {
        return CombatUtil.isAlly(this, otherresident);
    }

    public List<Invite> getReceivedInvites() {
        return Collections.unmodifiableList(this.receivedInvites);
    }

    @Override
    public void newReceivedInvite(Invite invite) throws TooManyInvitesException {
        if (this.receivedInvites.size() > InviteHandler.getReceivedInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(Translation.of("msg_err_player_has_too_many_invites", this.getName()));
        }
        this.receivedInvites.add(invite);
    }

    @Override
    public void deleteReceivedInvite(Invite invite) {
        this.receivedInvites.remove(invite);
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    @Override
    public Account getAccount() {
        if (this.account == null) {
            String accountName = StringMgmt.trimMaxLength(this.getName(), 32);
            Player player = this.getPlayer();
            World world = player != null ? player.getWorld() : BukkitTools.getWorlds().get(0);
            this.account = new EconomyAccount(accountName, world);
        }
        return this.account;
    }

    @Nullable
    public Account getAccountOrNull() {
        return this.account;
    }

    @Override
    public String getFormattedName() {
        String prefix = Colors.translateColorCodes(this.hasTitle() ? this.getTitle() + " " : (this.isKing() && !TownySettings.getKingPrefix(this).isEmpty() ? TownySettings.getKingPrefix(this) : (this.isMayor() && !TownySettings.getMayorPrefix(this).isEmpty() ? TownySettings.getMayorPrefix(this) : "")));
        String postfix = Colors.translateColorCodes(this.hasSurname() ? " " + this.getSurname() : (this.isKing() && !TownySettings.getKingPostfix(this).isEmpty() ? TownySettings.getKingPostfix(this) : (this.isMayor() && !TownySettings.getMayorPostfix(this).isEmpty() ? TownySettings.getMayorPostfix(this) : "")));
        return prefix + this.getName() + postfix;
    }

    public String getNamePrefix() {
        if (this.isKing()) {
            return TownySettings.getKingPrefix(this);
        }
        if (this.isMayor()) {
            return TownySettings.getMayorPrefix(this);
        }
        return "";
    }

    public String getNamePostfix() {
        if (this.isKing()) {
            return TownySettings.getKingPostfix(this);
        }
        if (this.isMayor()) {
            return TownySettings.getMayorPostfix(this);
        }
        return "";
    }

    public String getFormattedTitleName() {
        if (!this.hasTitle()) {
            return this.getFormattedName();
        }
        return this.getTitle() + " " + this.getName();
    }

    public void setTownblocks(Collection<TownBlock> townBlocks) {
        this.townBlocks = new ArrayList<TownBlock>(townBlocks);
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks);
    }

    @Override
    public boolean hasTownBlock(TownBlock townBlock) {
        return this.townBlocks.contains(townBlock);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.add(townBlock);
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        this.townBlocks.remove(townBlock);
    }

    @Override
    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    @Override
    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public Confirmation getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(Confirmation confirmation) {
        this.confirmation = confirmation;
    }

    public Inventory getGUIPage() {
        return this.guiPages.get(this.guiPageNum);
    }

    public ArrayList<Inventory> getGUIPages() {
        return this.guiPages;
    }

    public void setGUIPages(ArrayList<Inventory> inventory) {
        this.guiPages = inventory;
    }

    public int getGUIPageNum() {
        return this.guiPageNum;
    }

    public void setGUIPageNum(int currentInventoryPage) {
        this.guiPageNum = currentInventoryPage;
    }

    public SelectionGUI.SelectionType getGUISelectionType() {
        return this.guiSelectionType;
    }

    public void setGUISelectionType(SelectionGUI.SelectionType selectionType) {
        this.guiSelectionType = selectionType;
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveResident(this);
    }

    public List<Town> getEmbassyTowns() {
        ArrayList<Town> townEmbassies = new ArrayList<Town>();
        for (TownBlock tB : this.getTownBlocks()) {
            Town town = tB.getTownOrNull();
            if (town == null || townEmbassies.contains(town) || town.hasResident(this)) continue;
            townEmbassies.add(town);
        }
        return townEmbassies;
    }

    public long getJoinedTownAt() {
        return this.joinedTownAt;
    }

    public void setJoinedTownAt(long joinedTownAt) {
        this.joinedTownAt = joinedTownAt;
    }

    public Nation getNation() throws TownyException {
        return this.getTown().getNation();
    }

    @Nullable
    public Nation getNationOrNull() {
        if (!this.hasNation()) {
            return null;
        }
        return this.getTownOrNull().getNationOrNull();
    }

    public boolean isOnline() {
        return BukkitTools.isOnline(this.getName());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public int getRespawnProtectionTaskID() {
        return -1;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setRespawnProtectionTaskID(int respawnProtectionTaskID) {
    }

    public boolean hasRespawnProtection() {
        return this.respawnProtectionTask != null && !this.respawnProtectionTask.isCancelled();
    }

    public void addRespawnProtection(long protectionTime) {
        if (protectionTime <= 0L) {
            return;
        }
        if (this.respawnProtectionTask != null) {
            this.respawnProtectionTask.cancel();
        }
        this.respawnPickupWarningShown = false;
        this.respawnProtectionTask = Towny.getPlugin().getScheduler().runAsyncLater(this::removeRespawnProtection, protectionTime);
    }

    public void removeRespawnProtection() {
        if (this.respawnProtectionTask == null) {
            return;
        }
        this.respawnProtectionTask.cancel();
        this.respawnProtectionTask = null;
        TownyMessaging.sendMsg(this, Translatable.of("msg_you_have_lost_your_respawn_protection"));
    }

    public boolean isRespawnPickupWarningShown() {
        return this.respawnPickupWarningShown;
    }

    public void setRespawnPickupWarningShown(boolean respawnPickupWarningShown) {
        this.respawnPickupWarningShown = respawnPickupWarningShown;
    }

    @Override
    @NotNull
    public Audience audience() {
        Player player = this.getPlayer();
        return player == null ? Audience.empty() : Towny.getAdventure().player(player);
    }

    public boolean isSeeingBorderTitles() {
        BooleanDataField borderMeta = new BooleanDataField("bordertitles");
        return !MetaDataUtil.hasMeta((TownyObject)this, borderMeta) || MetaDataUtil.getBoolean(this, borderMeta);
    }
}

