/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class CommandList {
    private static final Pattern REMOVE_LEADING_SPACE = Pattern.compile("^[/ ]{1,2}");
    private static final Pattern MATCH_NAMESPACE = Pattern.compile("^(.+:)");
    final CommandNode root = new CommandNode("");

    public CommandList(Collection<String> commands) {
        for (String command : commands) {
            this.addCommand(command);
        }
    }

    public void addCommand(@NotNull String command) {
        Preconditions.checkNotNull((Object)command, (Object)"command");
        String normalized = CommandList.normalizeCommand(command.toLowerCase(Locale.ROOT));
        if (normalized.isEmpty()) {
            return;
        }
        CommandNode current = this.root;
        for (String part : normalized.split(" ")) {
            current = current.children.computeIfAbsent(part, k -> new CommandNode(part));
        }
        current.endOfWord = true;
    }

    @VisibleForTesting
    public static String normalizeCommand(String command) {
        command = REMOVE_LEADING_SPACE.matcher(command).replaceAll("");
        return MATCH_NAMESPACE.matcher(command).replaceAll("");
    }

    public boolean containsCommand(@NotNull String command) {
        String part;
        Preconditions.checkNotNull((Object)command, (Object)"command");
        String normalized = CommandList.normalizeCommand(command.toLowerCase(Locale.ROOT));
        CommandNode current = this.root;
        String[] stringArray = normalized.split(" ");
        int n = stringArray.length;
        for (int i = 0; i < n && (current = current.children.get(part = stringArray[i])) != null; ++i) {
            if (!current.endOfWord) continue;
            return true;
        }
        return false;
    }

    public static class CommandNode {
        final Map<String, CommandNode> children = new HashMap<String, CommandNode>();
        final String command;
        boolean endOfWord = false;

        public CommandNode(String command) {
            this.command = command;
        }
    }
}

