/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.util.EntityLists;
import com.palmergames.bukkit.util.ItemLists;
import org.bukkit.Material;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.inventory.ItemStack;

public class TownyVehicleListener
implements Listener {
    private final Towny plugin;

    public TownyVehicleListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onVehicleDamage(VehicleDamageEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getVehicle().getWorld()) || event.getAttacker() == null && event.getVehicle().getFireTicks() > 0) {
            return;
        }
        if (event.getAttacker() == null) {
            event.setCancelled(!TownyActionEventExecutor.canExplosionDamageEntities(event.getVehicle().getLocation(), (Entity)event.getVehicle(), EntityDamageEvent.DamageCause.ENTITY_EXPLOSION));
            return;
        }
        Entity entity = event.getAttacker();
        if (entity instanceof Player) {
            Material vehicle;
            Player player = (Player)entity;
            EntityType vehicleType = event.getVehicle().getType();
            Material material = vehicle = EntityLists.VEHICLES.contains(vehicleType) ? EntityTypeUtil.parseEntityToMaterial(vehicleType) : null;
            if (vehicle != null) {
                event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getVehicle().getLocation(), vehicle));
            }
        } else if (EntityTypeUtil.isExplosive(event.getAttacker().getType()) && !TownyActionEventExecutor.canExplosionDamageEntities(event.getVehicle().getLocation(), (Entity)event.getVehicle(), EntityDamageEvent.DamageCause.ENTITY_EXPLOSION)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleCollide(VehicleBlockCollisionEvent event) {
        if (this.plugin.isError() || !TownyAPI.getInstance().isTownyWorld(event.getVehicle().getWorld())) {
            return;
        }
        if (event.getVehicle() instanceof Minecart && ItemLists.MINECART_KILLERS.contains(event.getBlock().getType())) {
            event.getVehicle().remove();
            event.getBlock().getWorld().dropItemNaturally(event.getVehicle().getLocation(), new ItemStack(EntityTypeUtil.parseEntityToMaterial(event.getVehicle().getType())));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        Boat boat;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getVehicle().getWorld())) {
            return;
        }
        Entity entity = event.getEntered();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            EntityType vehicleType = event.getVehicle().getType();
            Material vehicle = null;
            if (EntityLists.VEHICLES.contains(vehicleType)) {
                vehicle = EntityTypeUtil.parseEntityToMaterial(vehicleType);
            } else if (EntityLists.MOUNTABLE.contains(vehicleType)) {
                vehicle = Material.SADDLE;
            }
            if (vehicle != null && TownySettings.isSwitchMaterial(vehicle, event.getVehicle().getLocation())) {
                event.setCancelled(!TownyActionEventExecutor.canSwitch(player, event.getVehicle().getLocation(), vehicle));
            }
        }
        if (TownySettings.isTownyPreventingProtectedMobsEnteringBoatsInTown() && (entity = event.getVehicle()) instanceof Boat && this.isProtectedMobEnteringEmptyBoatInTown(boat = (Boat)entity, event.getEntered())) {
            event.setCancelled(true);
            return;
        }
    }

    private boolean isProtectedMobEnteringEmptyBoatInTown(Boat boat, Entity entity) {
        return boat.isEmpty() && !TownyAPI.getInstance().isWilderness(entity.getLocation()) && EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), entity);
    }
}

