/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Translatable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;

public class TownyLoginListener
implements Listener {
    private Set<String> disallowedNames = this.populateDisallowedNames();

    public TownyLoginListener() {
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:login-listener"), config -> {
            this.disallowedNames = this.populateDisallowedNames();
        });
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLogin(AsyncPlayerPreLoginEvent event) {
        boolean disallowed;
        String logInName = event.getName();
        boolean bl = disallowed = this.isServerAccount(logInName) || this.isGovernmentAccount(logInName);
        if (!(disallowed |= logInName.toLowerCase(Locale.ROOT).startsWith(TownySettings.getNPCPrefix().toLowerCase(Locale.ROOT)))) {
            return;
        }
        event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, "Towny is preventing you from logging in using this account name.");
        TownyMessaging.sendMsgToOnlineAdmins(Translatable.of("msg_admin_blocked_login", event.getAddress().toString().substring(1), logInName));
    }

    private boolean isServerAccount(String logInName) {
        return this.disallowedNames.contains(logInName);
    }

    private boolean isGovernmentAccount(String logInName) {
        return this.isTownBank(logInName) || this.isNationBank(logInName);
    }

    private boolean isTownBank(String logInName) {
        return this.isDisallowedName(logInName, TownySettings.getTownAccountPrefix());
    }

    private boolean isNationBank(String logInName) {
        return this.isDisallowedName(logInName, TownySettings.getNationAccountPrefix());
    }

    private boolean isDisallowedName(String logInName, String disallowedName) {
        return logInName.startsWith(disallowedName) || logInName.startsWith(disallowedName.replace("-", "_"));
    }

    private Set<String> populateDisallowedNames() {
        String serverAccount = TownySettings.getString(ConfigNodes.ECO_CLOSED_ECONOMY_SERVER_ACCOUNT);
        return new HashSet<String>(Arrays.asList("towny-war-chest", "towny_war_chest", serverAccount, serverAccount.replace("-", "_")));
    }
}

