/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.adventure.key.Key;
import com.palmergames.adventure.sound.Sound;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyInventory;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.gui.EditGUI;
import com.palmergames.bukkit.towny.object.gui.PermissionGUI;
import com.palmergames.bukkit.towny.object.gui.SelectionGUI;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.paperlib.PaperLib;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.meta.ItemMeta;

public class TownyInventoryListener
implements Listener {
    private final Towny plugin;
    private final Sound clickSound = Sound.sound(Key.key("minecraft", "block.stone_button.click_on"), Sound.Source.PLAYER, 1.0f, 1.0f);

    public TownyInventoryListener(Towny plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        InventoryHolder meta;
        TownyInventory townyInventory;
        block44: {
            block43: {
                InventoryHolder inventoryHolder = PaperLib.getHolder(event.getInventory(), false).getHolder();
                if (!(inventoryHolder instanceof TownyInventory)) break block43;
                townyInventory = (TownyInventory)inventoryHolder;
                if (event.getCurrentItem() != null) break block44;
            }
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null || event.getClickedInventory() != null && !(PaperLib.getHolder(event.getClickedInventory(), false).getHolder() instanceof TownyInventory)) {
            return;
        }
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof EditGUI) {
            EditGUI editGUI = (EditGUI)inventoryHolder;
            meta = event.getCurrentItem().getItemMeta();
            if (meta == null) {
                return;
            }
            Material type = event.getCurrentItem().getType();
            if (type == Material.LIME_WOOL) {
                if (meta.getDisplayName().equals("\u00a7a" + ChatColor.BOLD + "Save")) {
                    editGUI.saveChanges();
                } else {
                    meta.setDisplayName("\u00a74" + ChatColor.BOLD + Colors.strip(meta.getDisplayName()));
                    event.getCurrentItem().setType(Material.RED_WOOL);
                }
            } else if (type == Material.RED_WOOL) {
                if (meta.getDisplayName().equals("\u00a74" + ChatColor.BOLD + "Back")) {
                    editGUI.exitScreen();
                } else if (meta.getDisplayName().equals("\u00a74" + ChatColor.BOLD + "Delete")) {
                    editGUI.deleteResident();
                } else {
                    meta.setDisplayName("\u00a78" + ChatColor.BOLD + Colors.strip(meta.getDisplayName()));
                    event.getCurrentItem().setType(Material.GRAY_WOOL);
                }
            } else if (type == Material.GRAY_WOOL) {
                meta.setDisplayName("\u00a7a" + ChatColor.BOLD + Colors.strip(meta.getDisplayName()));
                event.getCurrentItem().setType(Material.LIME_WOOL);
            } else {
                return;
            }
            event.getCurrentItem().setItemMeta((ItemMeta)meta);
            editGUI.playClickSound(player);
        } else {
            meta = event.getInventory().getHolder();
            if (meta instanceof PermissionGUI) {
                PermissionGUI permissionGUI = (PermissionGUI)meta;
                if (event.getCurrentItem().getType() == Material.PLAYER_HEAD && permissionGUI.canEdit()) {
                    PermissionGUIUtil.openPermissionEditorGUI(resident, permissionGUI.getTownBlock(), event.getCurrentItem());
                    Towny.getAdventure().player(player).playSound(this.clickSound);
                } else if (event.getCurrentItem().getType() == Material.WRITTEN_BOOK) {
                    player.openBook(PermissionGUIUtil.createTutorialBook());
                } else if (event.getCurrentItem().getType() == Material.NAME_TAG) {
                    if (this.plugin.isFolia()) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_perm_gui_folia"));
                        return;
                    }
                    PermissionGUIUtil.handleConversation(player);
                    event.getWhoClicked().closeInventory();
                } else {
                    permissionGUI.tryPaginate(event.getCurrentItem(), player, resident, event.getView());
                }
            } else {
                meta = event.getInventory().getHolder();
                if (meta instanceof SelectionGUI) {
                    String string;
                    Set<Material> materialSet;
                    SelectionGUI selectionGUI = (SelectionGUI)meta;
                    TownBlockType type = TownBlockTypeHandler.getType(Colors.strip(event.getCurrentItem().getItemMeta().getDisplayName()));
                    if (type == null) {
                        selectionGUI.playClickSound(player);
                        return;
                    }
                    switch (selectionGUI.getType()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case ITEMUSE: {
                            Set<Material> set = type.getData().getItemUseIds();
                            break;
                        }
                        case ALLOWEDBLOCKS: {
                            Set<Material> set = type.getData().getAllowedBlocks();
                            break;
                        }
                        case SWITCHES: {
                            Set<Material> set = materialSet = type.getData().getSwitchIds();
                        }
                    }
                    if (materialSet.isEmpty()) {
                        string = Translatable.of("gui_title_no_restrictions").forLocale(resident);
                    } else {
                        switch (selectionGUI.getType()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case ALLOWEDBLOCKS: {
                                string = Translatable.of("gui_title_towny_allowedblocks", type.getName()).forLocale(resident);
                                break;
                            }
                            case SWITCHES: {
                                string = Translatable.of("gui_title_towny_switch").forLocale(resident);
                                break;
                            }
                            case ITEMUSE: {
                                string = Translatable.of("gui_title_towny_itemuse").forLocale(resident);
                            }
                        }
                    }
                    String title = string;
                    resident.setGUISelectionType(selectionGUI.getType());
                    selectionGUI.playClickSound(player);
                    ResidentUtil.openGUIInventory(resident, materialSet, title);
                } else {
                    townyInventory.tryPaginate(event.getCurrentItem(), player, resident, event.getView());
                }
            }
        }
    }
}

