/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.event.mobs.MobSpawnRemovalEvent;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.EntityLists;
import com.palmergames.bukkit.util.ItemLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Creature;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class TownyEntityListener
implements Listener {
    private final Towny plugin;

    public TownyEntityListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Entity attacker = event.getDamager();
        Entity defender = event.getEntity();
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && !(attacker instanceof Projectile)) {
            boolean cancelExplosiveDamage = false;
            if (EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defender) && TownySettings.areProtectedEntitiesProtectedAgainstMobs() && this.entityProtectedFromExplosiveDamageHere(defender, event.getCause())) {
                cancelExplosiveDamage = true;
            }
            if (defender instanceof Player && EntityTypeUtil.isPVPExplosive(attacker.getType())) {
                cancelExplosiveDamage = CombatUtil.preventPvP(TownyAPI.getInstance().getTownyWorld(defender.getWorld()), TownyAPI.getInstance().getTownBlock(defender.getLocation()));
            }
            if (cancelExplosiveDamage) {
                event.setDamage(0.0);
                event.setCancelled(true);
                return;
            }
        }
        if (CombatUtil.preventDamageCall(attacker, defender, event.getCause())) {
            if (attacker instanceof Projectile && !attacker.getType().equals((Object)EntityType.TRIDENT)) {
                attacker.remove();
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAxolotlTarget(EntityTargetLivingEntityEvent event) {
        Mob defender;
        Mob attacker;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && (attacker = (Mob)entity).getType().getKey().equals((Object)NamespacedKey.minecraft((String)"axolotl")) && (entity = event.getTarget()) instanceof Mob && CombatUtil.preventDamageCall((Entity)attacker, (Entity)(defender = (Mob)entity), EntityDamageEvent.DamageCause.ENTITY_ATTACK)) {
            attacker.setMemory(MemoryKey.HAS_HUNTING_COOLDOWN, (Object)true);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!TownyAPI.getInstance().isTownyWorld(entity.getWorld()) || TownyAPI.getInstance().isWilderness(entity.getLocation())) {
            return;
        }
        if (entity instanceof Monster && TownyAPI.getInstance().getTownBlock(entity.getLocation()).getType() == TownBlockType.ARENA) {
            event.getDrops().clear();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityTakesBlockExplosionDamage(EntityDamageEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if ((event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) && this.entityProtectedFromExplosiveDamageHere(event.getEntity(), event.getCause())) {
            event.setDamage(0.0);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDragonFireBallCloudDamage(AreaEffectCloudApplyEvent event) {
        TownBlock townBlock;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getEntity().getCustomEffects().stream().noneMatch(effect -> effect.getType().getKey().equals((Object)NamespacedKey.minecraft((String)"instant_damage")))) {
            return;
        }
        if (!(event.getEntity().getSource() instanceof Player) || !(event.getEntity().getSource() instanceof DragonFireball)) {
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getEntity().getWorld());
        if (CombatUtil.preventPvP(townyWorld, townBlock = TownyAPI.getInstance().getTownBlock(event.getEntity().getLocation()))) {
            event.setCancelled(true);
            event.getEntity().remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onLingeringPotionSplashEvent(LingeringPotionSplashEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        ThrownPotion potion = event.getEntity();
        boolean detrimental = false;
        List<String> detrimentalPotions = TownySettings.getPotionTypes();
        for (PotionEffect effect : potion.getEffects()) {
            if (!detrimentalPotions.contains(effect.getType().getName())) continue;
            detrimental = true;
            break;
        }
        if (!detrimental) {
            return;
        }
        Location loc = potion.getLocation();
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(loc.getWorld());
        float radius = event.getAreaEffectCloud().getRadius();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (double x = loc.getX() - (double)radius; x < loc.getX() + (double)radius; x += 1.0) {
            for (double z = loc.getZ() - (double)radius; z < loc.getZ() + (double)radius; z += 1.0) {
                Location loc2 = new Location(potion.getWorld(), x, loc.getY(), z);
                Block b = loc2.getBlock();
                if (!b.getType().equals((Object)Material.AIR)) continue;
                blocks.add(b);
            }
        }
        for (Block block : blocks) {
            if (TownyAPI.getInstance().isWilderness(block.getLocation()) || !CombatUtil.preventPvP(townyWorld, TownyAPI.getInstance().getTownBlock(block.getLocation()))) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        boolean detrimental = false;
        List<String> detrimentalPotions = TownySettings.getPotionTypes();
        for (PotionEffect effect : event.getPotion().getEffects()) {
            if (!detrimentalPotions.contains(effect.getType().getName())) continue;
            detrimental = true;
            break;
        }
        if (!detrimental) {
            return;
        }
        for (LivingEntity defender : event.getAffectedEntities()) {
            if (!CombatUtil.preventDamageCall((Entity)event.getPotion(), (Entity)defender, EntityDamageEvent.DamageCause.MAGIC)) continue;
            event.setIntensity(defender, -1.0);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (this.entityIsExempt(livingEntity)) {
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getEntity().getWorld());
        if (this.disallowedWorldMob(townyWorld.hasWorldMobs(), livingEntity)) {
            if (this.weAreAllowedToRemoveThis(livingEntity)) {
                event.setCancelled(true);
            }
        } else if (this.disallowedWildernessMob(townyWorld.hasWildernessMobs(), livingEntity)) {
            if (this.weAreAllowedToRemoveThis(livingEntity)) {
                event.setCancelled(true);
            }
        } else if (this.disallowedTownMob(livingEntity) && this.weAreAllowedToRemoveThis(livingEntity)) {
            event.setCancelled(true);
        }
    }

    private boolean entityIsExempt(LivingEntity livingEntity) {
        return PluginIntegrations.getInstance().checkCitizens((Entity)livingEntity) || this.entityIsExemptByName(livingEntity);
    }

    private boolean entityIsExemptByName(LivingEntity livingEntity) {
        return TownySettings.isSkippingRemovalOfNamedMobs() && livingEntity.getCustomName() != null && !PluginIntegrations.getInstance().checkHostileEliteMobs((Entity)livingEntity);
    }

    private boolean disallowedWorldMob(boolean worldAllowsMobs, LivingEntity livingEntity) {
        return !worldAllowsMobs && MobRemovalTimerTask.isRemovingWorldEntity(livingEntity) || this.disallowedWorldVillagerBaby(livingEntity);
    }

    private boolean disallowedWorldVillagerBaby(LivingEntity livingEntity) {
        Villager villager;
        return TownySettings.isRemovingVillagerBabiesWorld() && livingEntity instanceof Villager && !(villager = (Villager)livingEntity).isAdult();
    }

    private boolean disallowedWildernessMob(boolean wildernessAllowsMobs, LivingEntity livingEntity) {
        return TownyAPI.getInstance().isWilderness(livingEntity.getLocation()) && !wildernessAllowsMobs && MobRemovalTimerTask.isRemovingWildernessEntity(livingEntity);
    }

    private boolean disallowedTownMob(LivingEntity livingEntity) {
        return !TownyAPI.getInstance().isWilderness(livingEntity.getLocation()) && (this.disallowedByTown(livingEntity) || this.disallowedTownVillagerBaby(livingEntity));
    }

    private boolean disallowedByTown(LivingEntity livingEntity) {
        return !TownyAPI.getInstance().areMobsEnabled(livingEntity.getLocation()) && MobRemovalTimerTask.isRemovingTownEntity(livingEntity);
    }

    private boolean disallowedTownVillagerBaby(LivingEntity livingEntity) {
        Villager villager;
        return TownySettings.isRemovingVillagerBabiesTown() && livingEntity instanceof Villager && !(villager = (Villager)livingEntity).isAdult();
    }

    private boolean weAreAllowedToRemoveThis(LivingEntity livingEntity) {
        return !BukkitTools.isEventCancelled(new MobSpawnRemovalEvent((Entity)livingEntity));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        List passengers = entity.getPassengers();
        if (passengers != null) {
            for (Entity passenger : passengers) {
                if (!(passenger instanceof Player)) continue;
                Player player = (Player)passenger;
                if (!TownySettings.isSwitchMaterial(block.getType(), block.getLocation())) continue;
                event.setCancelled(!TownyActionEventExecutor.canSwitch(player, block.getLocation(), block.getType()));
                return;
            }
        }
        if (!(entity instanceof Creature)) {
            return;
        }
        if (entity instanceof Villager && ItemLists.WOOD_DOORS.contains(block.getType())) {
            return;
        }
        if (TownySettings.isSwitchMaterial(block.getType(), block.getLocation()) || TownySettings.isCreatureTriggeringPressurePlateDisabled() && block.getType() == Material.STONE_PRESSURE_PLATE) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        EntityType type;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getBlock().getWorld());
        if (townyWorld == null || !townyWorld.isUsingTowny()) {
            return;
        }
        if (event.getBlock().getType().equals((Object)Material.FARMLAND)) {
            if (!event.getEntityType().equals((Object)EntityType.PLAYER) && townyWorld.isDisableCreatureTrample()) {
                event.setCancelled(true);
                return;
            }
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                event.setCancelled(TownySettings.isPlayerCropTramplePrevented() || !TownyActionEventExecutor.canDestroy(player, event.getBlock().getLocation(), Material.FARMLAND));
                return;
            }
        }
        if ((type = event.getEntityType()) == EntityType.ENDERMAN) {
            if (townyWorld.isEndermanProtect()) {
                event.setCancelled(true);
            }
        } else if (EntityLists.BOATS.contains(type)) {
            Object e;
            if (!event.getBlock().getType().equals((Object)Material.LILY_PAD)) {
                return;
            }
            List passengers = event.getEntity().getPassengers();
            if (!passengers.isEmpty() && (e = passengers.get(0)) instanceof Player) {
                Player player = (Player)e;
                event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getBlock()));
            } else if (!TownyAPI.getInstance().isWilderness(event.getBlock())) {
                event.setCancelled(true);
            }
        } else if (type == EntityType.RAVAGER) {
            if (townyWorld.isDisableCreatureTrample()) {
                event.setCancelled(true);
            }
        } else if (type == EntityType.WITHER) {
            List<Block> allowed = TownyActionEventExecutor.filterExplodableBlocks(Collections.singletonList(event.getBlock()), event.getBlock().getType(), event.getEntity(), (Event)event);
            event.setCancelled(allowed.isEmpty());
        } else {
            Entity allowed = event.getEntity();
            if (allowed instanceof ThrownPotion) {
                ThrownPotion potion = (ThrownPotion)allowed;
                if (event.getBlock().getType() != Material.CAMPFIRE || !potion.getEffects().isEmpty()) {
                    return;
                }
                ProjectileSource projectileSource = potion.getShooter();
                if (projectileSource instanceof BlockProjectileSource) {
                    BlockProjectileSource bps = (BlockProjectileSource)projectileSource;
                    event.setCancelled(!BorderUtil.allowedMove(bps.getBlock(), event.getBlock()));
                } else {
                    projectileSource = potion.getShooter();
                    if (projectileSource instanceof Player) {
                        Player player = (Player)projectileSource;
                        event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getBlock().getLocation(), Material.CAMPFIRE));
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getEntity().getWorld());
        if (townyWorld == null || !townyWorld.isUsingTowny()) {
            return;
        }
        List<Block> blocks = TownyActionEventExecutor.filterExplodableBlocks(event.blockList(), null, event.getEntity(), (Event)event);
        event.blockList().clear();
        event.blockList().addAll(blocks);
        if (event.blockList().isEmpty()) {
            return;
        }
        Entity entity = event.getEntity();
        if (townyWorld.isUsingPlotManagementWildEntityRevert() && entity != null && townyWorld.isProtectingExplosionEntity(entity)) {
            int count = 0;
            for (Block block : event.blockList()) {
                if (!TownyAPI.getInstance().isWilderness(block) || !townyWorld.isExplodedBlockAllowedToRevert(block.getType()) || TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation()))) continue;
                TownyRegenAPI.beginProtectionRegenTask(block, ++count, townyWorld, (Event)event);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityCombustByEntityEvent(EntityCombustByEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Entity combuster = event.getCombuster();
        Entity defender = event.getEntity();
        LivingEntity attacker = null;
        if (combuster instanceof Projectile) {
            Projectile projectile = (Projectile)combuster;
            ProjectileSource source = projectile.getShooter();
            if (source instanceof BlockProjectileSource) {
                if (CombatUtil.preventDispenserDamage(((BlockProjectileSource)source).getBlock(), defender, EntityDamageEvent.DamageCause.PROJECTILE)) {
                    combuster.remove();
                    event.setCancelled(true);
                    return;
                }
            } else {
                attacker = (LivingEntity)source;
            }
            if (attacker != null && CombatUtil.preventDamageCall((Entity)attacker, defender, EntityDamageEvent.DamageCause.PROJECTILE)) {
                combuster.remove();
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Hanging hanging = event.getEntity();
        HangingBreakEvent.RemoveCause removeCause = event.getCause();
        if (removeCause.equals((Object)HangingBreakEvent.RemoveCause.PHYSICS)) {
            if (this.attachedToRegeneratingBlock((Entity)hanging) || this.itemFrameBrokenByBoatExploit((Entity)hanging)) {
                event.setCancelled(true);
            }
            return;
        }
        if (event instanceof HangingBreakByEntityEvent) {
            HangingBreakByEntityEvent evt = (HangingBreakByEntityEvent)event;
            if (this.preventHangingBrokenByEntity((Entity)hanging, removeCause, evt.getRemover())) {
                event.setCancelled(true);
            }
            return;
        }
        if (removeCause.equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION)) {
            if (this.entityProtectedFromExplosiveDamageHere((Entity)hanging, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) || this.weAreRevertingBlockExplosionsInWild(hanging.getLocation())) {
                event.setCancelled(true);
            }
            return;
        }
    }

    private boolean attachedToRegeneratingBlock(Entity hanging) {
        return EntityLists.HANGING.contains(hanging) && TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(hanging.getLocation().add(hanging.getFacing().getOppositeFace().getDirection())));
    }

    private boolean itemFrameBrokenByBoatExploit(Entity hanging) {
        if (EntityLists.ITEM_FRAMES.contains(hanging)) {
            Block block = hanging.getLocation().add(hanging.getFacing().getOppositeFace().getDirection()).getBlock();
            if (block.isLiquid() || block.isEmpty()) {
                return false;
            }
            for (Entity entity : hanging.getNearbyEntities(0.5, 0.5, 0.5)) {
                if (!(entity instanceof Vehicle)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean preventHangingBrokenByEntity(Entity hanging, HangingBreakEvent.RemoveCause removeCause, Object remover) {
        Player player;
        if (removeCause.equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION) && (this.entityProtectedFromExplosiveDamageHere(hanging, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) || this.weAreRevertingThisRemoversExplosionsInWild(hanging.getLocation(), remover))) {
            return true;
        }
        if (remover instanceof Projectile) {
            Projectile projectile = (Projectile)remover;
            remover = projectile.getShooter();
        }
        return remover instanceof Player ? !this.allowedToBreak(player = (Player)remover, hanging) : remover instanceof Entity && !TownyAPI.getInstance().isWilderness(hanging.getLocation());
    }

    private boolean allowedToBreak(Player player, Entity hanging) {
        return TownyActionEventExecutor.canDestroy(player, hanging.getLocation(), EntityTypeUtil.parseEntityToMaterial(hanging.getType(), Material.GRASS_BLOCK));
    }

    private boolean weAreRevertingThisRemoversExplosionsInWild(Location loc, Object remover) {
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(loc.getWorld());
        return remover != null && TownyAPI.getInstance().isWilderness(loc) && townyWorld.isUsingPlotManagementWildEntityRevert() && townyWorld.isProtectingExplosionEntity((Entity)remover);
    }

    private boolean weAreRevertingBlockExplosionsInWild(Location loc) {
        return TownyAPI.getInstance().isWilderness(loc) && TownyAPI.getInstance().getTownyWorld(loc.getWorld()).isUsingPlotManagementWildBlockRevert();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Material mat = EntityTypeUtil.parseEntityToMaterial(event.getEntity().getType(), Material.GRASS_BLOCK);
        event.setCancelled(!TownyActionEventExecutor.canBuild(event.getPlayer(), event.getEntity().getLocation(), mat));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPigHitByLightning(PigZapEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (this.entityProtectedFromExplosiveDamageHere((Entity)event.getEntity(), EntityDamageEvent.DamageCause.LIGHTNING)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileHitEventButtonOrPlate(ProjectileHitEvent event) {
        if (this.plugin.isError() || !TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld()) || event.getHitBlock() == null || !(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Block block = event.getHitBlock().getRelative(event.getHitBlockFace());
        Material material = block.getType();
        if (ItemLists.PROJECTILE_TRIGGERED_REDSTONE.contains(material) && TownySettings.isSwitchMaterial(material, block.getLocation()) && !TownyActionEventExecutor.canSwitch((Player)event.getEntity().getShooter(), block.getLocation(), material)) {
            BlockData data = block.getBlockData();
            block.setType(Material.AIR);
            this.plugin.getScheduler().run(block.getLocation(), () -> block.setBlockData(data));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileHitBlockEvent(ProjectileHitEvent event) {
        Block hitBlock = event.getHitBlock();
        if (this.plugin.isError() || !TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld()) || hitBlock == null || hitBlock.getType() != Material.TARGET && hitBlock.getType() != Material.CHORUS_FLOWER) {
            return;
        }
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            if (!TownyAPI.getInstance().isWilderness(hitBlock)) {
                this.cancelProjectileHitEvent(event, hitBlock);
            }
            return;
        }
        Player player = (Player)projectileSource;
        if (this.disallowedTargetSwitch(hitBlock, player) || this.disallowedChorusFlowerBreak(hitBlock, player)) {
            this.cancelProjectileHitEvent(event, hitBlock);
        }
    }

    private boolean disallowedTargetSwitch(Block hitBlock, Player player) {
        return hitBlock.getType() == Material.TARGET && TownySettings.isSwitchMaterial(Material.TARGET, hitBlock.getLocation()) && !TownyActionEventExecutor.canSwitch(player, hitBlock.getLocation(), hitBlock.getType());
    }

    private boolean disallowedChorusFlowerBreak(Block hitBlock, Player player) {
        return hitBlock.getType() == Material.CHORUS_FLOWER && !TownyActionEventExecutor.canDestroy(player, hitBlock.getLocation(), hitBlock.getType());
    }

    private void cancelProjectileHitEvent(ProjectileHitEvent event, Block block) {
        if (event instanceof Cancellable) {
            event.setCancelled(true);
            return;
        }
        BlockData data = block.getBlockData();
        block.setType(Material.AIR);
        this.plugin.getScheduler().run(block.getLocation(), () -> block.setBlockData(data));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onDoorBreak(EntityBreakDoorEvent event) {
        if (TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld()) && !TownyAPI.getInstance().isWilderness(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    private boolean entityProtectedFromExplosiveDamageHere(Entity entity, EntityDamageEvent.DamageCause cause) {
        return !TownyActionEventExecutor.canExplosionDamageEntities(entity.getLocation(), entity, cause);
    }
}

