/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.adventure.bossbar.BossBar;
import com.palmergames.adventure.text.Component;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.event.BedExplodeEvent;
import com.palmergames.bukkit.towny.event.ChunkNotificationEvent;
import com.palmergames.bukkit.towny.event.NewTownEvent;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.SpawnEvent;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownClaimEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.event.damage.TownyPlayerDamagePlayerEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownLeaveEvent;
import com.palmergames.bukkit.towny.event.town.TownPreUnclaimCmdEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.DrawSmokeTaskFactory;
import com.palmergames.util.TimeMgmt;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;

public class TownyCustomListener
implements Listener {
    private final Towny plugin;
    private final Map<Player, ScheduledTask> playerActionTasks = new HashMap<Player, ScheduledTask>();
    private final Map<Player, BossBar> playerBossBarMap = new HashMap<Player, BossBar>();

    public TownyCustomListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent event) {
        Player player = event.getPlayer();
        WorldCoord from = event.getFrom();
        WorldCoord to = event.getTo();
        if (!TownyAPI.getInstance().isTownyWorld(to.getBukkitWorld())) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null) {
            return;
        }
        try {
            if (resident.hasMode("townclaim")) {
                TownCommand.parseTownClaimCommand(player, new String[0]);
            }
            if (resident.hasMode("townunclaim")) {
                TownCommand.parseTownUnclaimCommand(player, new String[0]);
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
        if (resident.hasMode("map")) {
            TownyCommand.showMap(player);
        }
        if (resident.hasMode("plotborder") || resident.hasMode("constantplotborder")) {
            BorderUtil.getPlotBorder(to).runBorderedOnSurface(1, 2, DrawSmokeTaskFactory.showToPlayer(player, to));
        }
        if (event.isShowingPlotNotifications()) {
            String msg = null;
            try {
                ChunkNotification chunkNotifier = new ChunkNotification(from, to);
                msg = chunkNotifier.getNotificationString(resident);
            }
            catch (NullPointerException e) {
                this.plugin.getLogger().log(Level.WARNING, "ChunkNotifier generated an NPE, this is harmless but if you'd like to report it the following information will be useful: " + System.lineSeparator() + "  Player: " + player.getName() + "  To: " + to.getWorldName() + "," + to.getX() + "," + to.getZ() + "  From: " + from.getWorldName() + "," + from.getX() + "," + from.getZ(), e);
            }
            if (msg == null) {
                return;
            }
            ChunkNotificationEvent cne = new ChunkNotificationEvent(player, msg, to, from);
            BukkitTools.fireEvent(cne);
            msg = cne.getMessage();
            if (cne.isCancelled() || msg == null || msg.isEmpty()) {
                return;
            }
            this.sendChunkNoticiation(player, msg);
        }
    }

    private void sendChunkNoticiation(Player player, String msg) {
        switch (TownySettings.getNotificationsAppearAs().toLowerCase(Locale.ROOT)) {
            case "bossbar": {
                this.sendBossBarChunkNotification(player, TownyComponents.miniMessage(msg));
                break;
            }
            case "chat": {
                TownyMessaging.sendMessage((Object)player, msg);
                break;
            }
            case "none": {
                break;
            }
            default: {
                this.sendActionBarChunkNotification(player, TownyComponents.miniMessage(msg));
            }
        }
    }

    private void sendActionBarChunkNotification(Player player, Component msgComponent) {
        int seconds = TownySettings.getInt(ConfigNodes.NOTIFICATION_DURATION);
        if (seconds > 3) {
            if (this.playerActionTasks.get(player) != null) {
                this.removePlayerActionTasks(player);
            }
            AtomicInteger remainingSeconds = new AtomicInteger(seconds);
            ScheduledTask task = this.plugin.getScheduler().runAsyncRepeating(() -> {
                TownyMessaging.sendActionBarMessageToPlayer(player, msgComponent);
                remainingSeconds.getAndDecrement();
                if (remainingSeconds.get() == 0 && this.playerActionTasks.containsKey(player)) {
                    this.removePlayerActionTasks(player);
                }
            }, 0L, 20L);
            this.playerActionTasks.put(player, task);
        } else {
            TownyMessaging.sendActionBarMessageToPlayer(player, msgComponent);
        }
    }

    private void sendBossBarChunkNotification(Player player, Component message) {
        int ticks = TownySettings.getInt(ConfigNodes.NOTIFICATION_DURATION) * 20;
        if (this.playerBossBarMap.containsKey(player)) {
            this.removePlayerActionTasks(player);
            this.removePlayerBossBar(player);
        }
        BossBar.Color color = BossBar.Color.NAMES.valueOr(TownySettings.getBossBarNotificationColor().toLowerCase(Locale.ROOT), BossBar.Color.WHITE);
        BossBar.Overlay overlay = BossBar.Overlay.NAMES.valueOr(TownySettings.getBossBarNotificationOverlay().toLowerCase(Locale.ROOT), BossBar.Overlay.PROGRESS);
        BossBar bossBar = BossBar.bossBar(message, TownySettings.getBossBarNotificationProgress(), color, overlay);
        TownyMessaging.sendBossBarMessageToPlayer(player, bossBar);
        ScheduledTask task = this.plugin.getScheduler().runAsyncLater(() -> {
            this.playerActionTasks.remove(player);
            this.removePlayerBossBar(player);
        }, ticks);
        this.playerBossBarMap.put(player, bossBar);
        this.playerActionTasks.put(player, task);
    }

    private void removePlayerActionTasks(Player player) {
        ScheduledTask task = this.playerActionTasks.remove(player);
        if (task != null) {
            task.cancel();
        }
    }

    private void removePlayerBossBar(Player player) {
        BossBar bar = this.playerBossBarMap.remove(player);
        if (bar != null) {
            Towny.getAdventure().player(player).hideBossBar(bar);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerCreateTown(NewTownEvent event) {
        Town town = event.getTown();
        double upkeep = TownySettings.getTownUpkeepCost(town);
        if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily() && upkeep > 0.0) {
            String cost = TownyEconomyHandler.getFormattedBalance(upkeep);
            String time = TimeMgmt.formatCountdownTime(TimeMgmt.townyTime(true));
            TownyMessaging.sendTownMessagePrefixed(town, Translatable.of("msg_new_town_advice", cost, time));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBedExplodeEvent(BedExplodeEvent event) {
        TownyWorld world = Optional.ofNullable(event.getLocation().getWorld()).map(w -> TownyAPI.getInstance().getTownyWorld((World)w)).orElse(null);
        if (world == null) {
            return;
        }
        world.addBedExplosionAtBlock(event.getLocation(), event.getMaterial());
        if (event.getLocation2() != null) {
            world.addBedExplosionAtBlock(event.getLocation2(), event.getMaterial());
        }
        this.plugin.getScheduler().runLater(event.getLocation(), () -> {
            world.removeBedExplosionAtBlock(event.getLocation());
            world.removeBedExplosionAtBlock(event.getLocation2());
        }, 20L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTownLeaveNation(NationPreTownLeaveEvent event) {
        if (event.getTown().isConquered()) {
            event.setCancelMessage(Translation.of("msg_err_your_conquered_town_cannot_leave_the_nation_yet"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDamagePlayerEvent(TownyPlayerDamagePlayerEvent event) {
        Resident victim = event.getVictimResident();
        Resident attacker = event.getAttackingResident();
        if (victim != null && victim.hasRespawnProtection()) {
            event.setCancelled(true);
            event.setMessage(Translatable.of("msg_err_player_cannot_be_harmed", victim.getName()).forLocale(attacker));
        }
        if (attacker != null && attacker.hasRespawnProtection()) {
            event.setCancelled(true);
            attacker.removeRespawnProtection();
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerSpawnsWithTown(SpawnEvent event) {
        if (TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)event.getPlayer())) {
            return;
        }
        Town town = TownyAPI.getInstance().getTown(event.getTo());
        if (town == null || !town.hasOutlaw(event.getPlayer().getName())) {
            return;
        }
        event.setCancelled(true);
        event.setCancelMessage(Translatable.of("msg_error_cannot_town_spawn_youre_an_outlaw_in_town", town.getName()).forLocale((CommandSender)event.getPlayer()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onTownUnclaim(TownPreUnclaimCmdEvent event) {
        Player player = event.getResident().getPlayer();
        if (!TownySettings.getOutsidersUnclaimingTownBlocks() || player == null) {
            return;
        }
        List<WorldCoord> unclaimSelection = event.getUnclaimSelection();
        Town town = event.getTown();
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (town.hasResident(target) || TownyAPI.getInstance().isWilderness(target.getLocation()) || !unclaimSelection.contains(WorldCoord.parseWorldCoord((Entity)target))) continue;
            event.setCancelled(true);
            event.setCancelMessage(Translatable.of("msg_cant_unclaim_outsider_in_town").forLocale(event.getResident()));
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTownClaim(TownClaimEvent event) {
        if (!TownySettings.isOverClaimingAllowingStolenLand()) {
            return;
        }
        if (event.getTown().availableTownBlocks() <= TownySettings.getTownBlockRatio()) {
            TownyMessaging.sendMsg(event.getResident(), Translatable.literal("\u00a74").append(Translatable.of("msg_warning_you_are_almost_out_of_townblocks")));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTownLosesResident(TownRemoveResidentEvent event) {
        if (!TownySettings.isOverClaimingAllowingStolenLand()) {
            return;
        }
        if (event.getTown().getTownBlocks().size() > event.getTown().getMaxTownBlocks()) {
            TownyMessaging.sendPrefixedTownMessage(event.getTown(), Translatable.literal("\u00a74").append(Translatable.of("msg_warning_your_town_is_overclaimed")));
        }
    }

    @EventHandler
    public void onChunkNotification(ChunkNotificationEvent event) {
        if (!TownySettings.isOverClaimingAllowingStolenLand() || event.getToCoord().isWilderness() || event.getFromCoord().isWilderness()) {
            return;
        }
        Resident resident = TownyAPI.getInstance().getResident(event.getPlayer());
        if (resident == null || !resident.hasTown()) {
            return;
        }
        Town town = resident.getTownOrNull();
        if (town.availableTownBlocks() < 1 || !event.getFromCoord().getTownOrNull().equals(town)) {
            return;
        }
        if (!event.getToCoord().canBeStolen()) {
            return;
        }
        String message = event.getMessage() + Translatable.of("chunk_notification_takeover_available").forLocale((CommandSender)event.getPlayer());
        event.setMessage(message);
    }

    @EventHandler(ignoreCancelled=true)
    public void onResidentJoinTown(TownAddResidentEvent event) {
        if (!TownySettings.isPromptingNewResidentsToTownSpawn() || !TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN)) {
            return;
        }
        Town town = event.getTown();
        Player player = event.getResident().getPlayer();
        if (player == null || TownyAPI.getInstance().getTown(player).equals(town)) {
            return;
        }
        String notAffordMsg = Translatable.of("msg_err_cant_afford_tp").forLocale((CommandSender)player);
        try {
            SpawnUtil.sendToTownySpawn(player, new String[0], town, notAffordMsg, false, false, SpawnType.TOWN);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }
}

