/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.town;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class TownMayorChangedEvent
extends Event {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Resident oldMayor;
    private final Resident newMayor;

    public TownMayorChangedEvent(Resident oldMayor, Resident newMayor) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.oldMayor = oldMayor;
        this.newMayor = newMayor;
    }

    public Resident getOldMayor() {
        return this.oldMayor;
    }

    public Resident getNewMayor() {
        return this.newMayor;
    }

    public Town getTown() {
        return TownyAPI.getInstance().getResidentTownOrNull(this.newMayor);
    }

    public boolean isNationCapital() {
        return this.getTown().isCapital();
    }

    public boolean isKingChange() {
        return this.oldMayor.isKing();
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }
}

