/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.player;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class PlayerKeepsInventoryEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean isCancelled = false;
    private final Player player;
    private final Location location;
    private final PlayerDeathEvent event;

    public PlayerKeepsInventoryEvent(PlayerDeathEvent event) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.player = event.getEntity();
        this.location = event.getEntity().getLocation();
        this.event = event;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Resident getResident() {
        return TownyAPI.getInstance().getResident(this.player);
    }

    public Location getLocation() {
        return this.location;
    }

    public PlayerDeathEvent getPlayerDeathEvent() {
        return this.event;
    }

    @Nullable
    public Resident getKiller() {
        EntityDamageEvent entityDamageEvent = this.player.getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            Projectile projectile;
            ProjectileSource projectileSource;
            EntityDamageByEntityEvent event = (EntityDamageByEntityEvent)entityDamageEvent;
            Entity attackerEntity = event.getDamager();
            if (attackerEntity instanceof Projectile && (projectileSource = (projectile = (Projectile)attackerEntity).getShooter()) instanceof Player) {
                Player player = (Player)projectileSource;
                return TownyAPI.getInstance().getResident(player);
            }
            if (attackerEntity instanceof Player) {
                Player player = (Player)attackerEntity;
                return TownyAPI.getInstance().getResident(player);
            }
        }
        return null;
    }

    @Nullable
    public Town getTownOrNull() {
        return TownyAPI.getInstance().getTown(this.location);
    }

    public boolean isWilderness() {
        return TownyAPI.getInstance().isWilderness(this.location);
    }
}

