/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.economy;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.event.CancellableTownyEvent;
import com.palmergames.bukkit.towny.object.Transaction;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class TownyPreTransactionEvent
extends CancellableTownyEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Transaction transaction;

    public TownyPreTransactionEvent(Transaction transaction) {
        this.transaction = transaction;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public int getNewBalance() {
        switch (this.transaction.getType()) {
            case ADD: {
                return (int)(TownyEconomyHandler.getBalance(this.transaction.getPlayer().getName(), this.transaction.getPlayer().getWorld()) + this.transaction.getAmount());
            }
            case SUBTRACT: {
                return (int)(TownyEconomyHandler.getBalance(this.transaction.getPlayer().getName(), this.transaction.getPlayer().getWorld()) - this.transaction.getAmount());
            }
        }
        return 0;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }
}

