/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.deathprice;

import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.economy.Account;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Nullable;

public abstract class DeathPriceEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    protected boolean cancelled;
    protected final Account payer;
    protected double amount;
    protected final Resident deadResident;
    protected final Player killer;

    public DeathPriceEvent(Account payer, double amount, Resident deadResident, Player killer) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.payer = payer;
        this.amount = amount;
        this.deadResident = deadResident;
        this.killer = killer;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public Account getPayer() {
        return this.payer;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public Resident getDeadResident() {
        return this.deadResident;
    }

    @Nullable
    public Player getKiller() {
        return this.killer;
    }

    public boolean isPVPDeath() {
        return this.killer != null;
    }

    public boolean isCancelled() {
        return this.cancelled || this.getAmount() <= 0.0;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

