/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.asciimap;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.format.NamedTextColor;
import com.palmergames.adventure.text.format.TextColor;
import com.palmergames.bukkit.towny.TownyAsciiMap;
import com.palmergames.bukkit.towny.object.WorldCoord;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class WildernessMapEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private String mapSymbol = TownyAsciiMap.wildernessSymbol;
    private TextComponent hoverText;
    private String clickCommand = "/towny:townyworld";
    private final WorldCoord worldCoord;

    public WildernessMapEvent(WorldCoord worldCoord) {
        this.worldCoord = worldCoord;
        this.hoverText = (TextComponent)Component.text(worldCoord.getTownyWorld().getFormattedUnclaimedZoneName(), (TextColor)NamedTextColor.DARK_RED).append(Component.text(" (" + worldCoord.getX() + ", " + worldCoord.getZ() + ")", (TextColor)NamedTextColor.WHITE));
    }

    public String getMapSymbol() {
        return this.mapSymbol;
    }

    public void setMapSymbol(String mapSymbol) {
        this.mapSymbol = mapSymbol;
    }

    public TextComponent getHoverText() {
        return this.hoverText;
    }

    public void setHoverText(TextComponent hoverText) {
        this.hoverText = hoverText;
    }

    public String getClickCommand() {
        return this.clickCommand;
    }

    public void setClickCommand(String clickCommand) {
        this.clickCommand = clickCommand;
    }

    public WorldCoord getWorldCoord() {
        return this.worldCoord;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

