/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownySQLSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class SQLSchema {
    private static final String SQLDB_NAME = TownySettings.getSQLDBName();
    private static final String TABLE_PREFIX = TownySettings.getSQLTablePrefix().toUpperCase(Locale.ROOT);
    private static final int MYSQL_DUPLICATE_COLUMN_ERR = 1060;

    public static void initTables(Connection cntx) {
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.WORLD);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.WORLD, SQLSchema.getWorldColumns());
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.NATION);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.NATION, SQLSchema.getNationColumns());
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.TOWN);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.TOWN, SQLSchema.getTownColumns());
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.RESIDENT);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.RESIDENT, SQLSchema.getResidentColumns());
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.TOWNBLOCK);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.TOWNBLOCK, SQLSchema.getTownBlockColumns());
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.PLOTGROUP);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.PLOTGROUP, SQLSchema.getPlotGroupColumns());
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.JAIL);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.JAIL, SQLSchema.getJailsColumns());
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.HIBERNATED_RESIDENT);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.HIBERNATED_RESIDENT, SQLSchema.getHibernatedResidentsColumns());
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.COOLDOWN);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.COOLDOWN, SQLSchema.getCooldownColumns());
    }

    private static void initTable(Connection cntx, TownySQLSource.TownyDBTableType tableType) {
        try (Statement s = cntx.createStatement();){
            s.executeUpdate(SQLSchema.fetchTableSchema(tableType));
            TownyMessaging.sendDebugMsg("Table " + tableType.tableName() + " is ok!");
        }
        catch (SQLException ee) {
            TownyMessaging.sendErrorMsg("Error Creating table " + tableType.tableName() + " : " + ee.getMessage());
        }
    }

    private static String fetchTableSchema(TownySQLSource.TownyDBTableType tableType) {
        String string;
        switch (tableType) {
            case TOWNBLOCK: {
                string = SQLSchema.fetchCreateTownBlocksStatement();
                break;
            }
            case JAIL: {
                string = SQLSchema.fetchCreateUUIDStatement(tableType);
                break;
            }
            case PLOTGROUP: {
                string = SQLSchema.fetchCreatePlotGroupStatement(tableType);
                break;
            }
            case COOLDOWN: {
                string = SQLSchema.fetchCreateCooldownsStatement(tableType);
                break;
            }
            default: {
                string = SQLSchema.fetchCreateNamedStatement(tableType);
            }
        }
        return string;
    }

    private static String fetchCreateNamedStatement(TownySQLSource.TownyDBTableType tableType) {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + tableType.tableName() + " (`name` VARCHAR(32) NOT NULL,PRIMARY KEY (`name`))";
    }

    private static String fetchCreatePlotGroupStatement(TownySQLSource.TownyDBTableType tableType) {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + tableType.tableName() + " (`groupID` VARCHAR(36) NOT NULL,PRIMARY KEY (`groupID`))";
    }

    private static String fetchCreateUUIDStatement(TownySQLSource.TownyDBTableType tableType) {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + tableType.tableName() + " (`uuid` VARCHAR(36) NOT NULL,PRIMARY KEY (`uuid`))";
    }

    private static String fetchCreateTownBlocksStatement() {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + "TOWNBLOCKS (`world` VARCHAR(36) NOT NULL,`x` mediumint NOT NULL,`z` mediumint NOT NULL,PRIMARY KEY (`world`,`x`,`z`))";
    }

    private static String fetchCreateCooldownsStatement(TownySQLSource.TownyDBTableType tableType) {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + tableType.tableName() + " (`key` varchar(200) not null, primary key (`key`))";
    }

    private static void updateTable(Connection cntx, TownySQLSource.TownyDBTableType tableType, List<String> columns) {
        String update = "ALTER TABLE `" + SQLDB_NAME + "`.`" + TABLE_PREFIX + tableType.tableName() + "` ADD COLUMN ";
        for (String column : columns) {
            try {
                PreparedStatement ps = cntx.prepareStatement(update + column);
                try {
                    ps.executeUpdate();
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
            catch (SQLException ee) {
                if (ee.getErrorCode() == 1060) continue;
                TownyMessaging.sendErrorMsg("Error updating table " + tableType.tableName() + ":" + ee.getMessage());
            }
        }
        TownyMessaging.sendDebugMsg("Table " + tableType.tableName() + " is updated!");
    }

    private static List<String> getJailsColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`townBlock` mediumtext NOT NULL");
        columns.add("`spawns`  mediumtext DEFAULT NULL");
        return columns;
    }

    private static List<String> getPlotGroupColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`groupName` mediumtext NOT NULL");
        columns.add("`groupPrice` float DEFAULT NULL");
        columns.add("`town` VARCHAR(32) NOT NULL");
        return columns;
    }

    private static List<String> getResidentColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`town` mediumtext");
        columns.add("`town-ranks` mediumtext");
        columns.add("`nation-ranks` mediumtext");
        columns.add("`lastOnline` BIGINT NOT NULL");
        columns.add("`registered` BIGINT NOT NULL");
        columns.add("`joinedTownAt` BIGINT NOT NULL");
        columns.add("`isNPC` bool NOT NULL DEFAULT '0'");
        columns.add("`jailUUID` VARCHAR(36) DEFAULT NULL");
        columns.add("`jailCell` mediumint");
        columns.add("`jailHours` mediumint");
        columns.add("`jailBail` float DEFAULT NULL");
        columns.add("`title` mediumtext");
        columns.add("`surname` mediumtext");
        columns.add("`protectionStatus` mediumtext");
        columns.add("`friends` mediumtext");
        columns.add("`metadata` text DEFAULT NULL");
        columns.add("`uuid` VARCHAR(36) NOT NULL");
        return columns;
    }

    private static List<String> getHibernatedResidentsColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`registered` BIGINT DEFAULT NULL");
        return columns;
    }

    private static List<String> getTownColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`mayor` mediumtext");
        columns.add("`nation` mediumtext");
        columns.add("`townBoard` mediumtext DEFAULT NULL");
        columns.add("`tag` mediumtext DEFAULT NULL");
        columns.add("`founder` mediumtext DEFAULT NULL");
        columns.add("`protectionStatus` mediumtext DEFAULT NULL");
        columns.add("`bonus` int(11) DEFAULT 0");
        columns.add("`purchased` int(11)  DEFAULT 0");
        columns.add("`taxpercent` bool NOT NULL DEFAULT '0'");
        columns.add("`maxPercentTaxAmount` float DEFAULT NULL");
        columns.add("`taxes` float DEFAULT 0");
        columns.add("`hasUpkeep` bool NOT NULL DEFAULT '0'");
        columns.add("`plotPrice` float DEFAULT NULL");
        columns.add("`plotTax` float DEFAULT NULL");
        columns.add("`commercialPlotPrice` float DEFAULT NULL");
        columns.add("`commercialPlotTax` float NOT NULL");
        columns.add("`embassyPlotPrice` float NOT NULL");
        columns.add("`embassyPlotTax` float NOT NULL");
        columns.add("`open` bool NOT NULL DEFAULT '0'");
        columns.add("`public` bool NOT NULL DEFAULT '0'");
        columns.add("`adminEnabledMobs` bool NOT NULL DEFAULT '0'");
        columns.add("`admindisabledpvp` bool NOT NULL DEFAULT '0'");
        columns.add("`adminenabledpvp` bool NOT NULL DEFAULT '0'");
        columns.add("`allowedToWar` bool NOT NULL DEFAULT '1'");
        columns.add("`homeblock` mediumtext NOT NULL");
        columns.add("`spawn` mediumtext NOT NULL");
        columns.add("`outpostSpawns` mediumtext DEFAULT NULL");
        columns.add("`jailSpawns` mediumtext DEFAULT NULL");
        columns.add("`outlaws` mediumtext DEFAULT NULL");
        columns.add("`uuid` VARCHAR(36) DEFAULT NULL");
        columns.add("`registered` BIGINT DEFAULT NULL");
        columns.add("`spawnCost` float NOT NULL");
        columns.add("`mapColorHexCode` mediumtext DEFAULT NULL");
        columns.add("`metadata` text DEFAULT NULL");
        columns.add("`conqueredDays` mediumint");
        columns.add("`conquered` bool NOT NULL DEFAULT '0'");
        columns.add("`ruined` bool NOT NULL DEFAULT '0'");
        columns.add("`ruinedTime` BIGINT DEFAULT '0'");
        columns.add("`neutral` bool NOT NULL DEFAULT '0'");
        columns.add("`debtBalance` float NOT NULL");
        columns.add("`joinedNationAt` BIGINT NOT NULL");
        columns.add("`primaryJail` VARCHAR(36) DEFAULT NULL");
        columns.add("`movedHomeBlockAt` BIGINT NOT NULL");
        columns.add("`trustedResidents` mediumtext DEFAULT NULL");
        columns.add("`trustedTowns` mediumtext NOT NULL");
        columns.add("`nationZoneOverride` int(11) DEFAULT 0");
        columns.add("`nationZoneEnabled` bool NOT NULL DEFAULT '1'");
        columns.add("`allies` mediumtext NOT NULL");
        columns.add("`enemies` mediumtext NOT NULL");
        columns.add("`hasUnlimitedClaims` bool NOT NULL DEFAULT '0'");
        columns.add("`manualTownLevel` BIGINT DEFAULT '-1'");
        return columns;
    }

    private static List<String> getNationColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`capital` mediumtext NOT NULL");
        columns.add("`tag` mediumtext NOT NULL");
        columns.add("`allies` mediumtext NOT NULL");
        columns.add("`enemies` mediumtext NOT NULL");
        columns.add("`taxes` float NOT NULL");
        columns.add("`taxpercent` bool NOT NULL DEFAULT '0'");
        columns.add("`maxPercentTaxAmount` float DEFAULT NULL");
        columns.add("`spawnCost` float NOT NULL");
        columns.add("`neutral` bool NOT NULL DEFAULT '0'");
        columns.add("`uuid` VARCHAR(36) DEFAULT NULL");
        columns.add("`registered` BIGINT DEFAULT NULL");
        columns.add("`nationBoard` mediumtext DEFAULT NULL");
        columns.add("`mapColorHexCode` mediumtext DEFAULT NULL");
        columns.add("`nationSpawn` mediumtext DEFAULT NULL");
        columns.add("`isPublic` bool NOT NULL DEFAULT '1'");
        columns.add("`isOpen` bool NOT NULL DEFAULT '1'");
        columns.add("`metadata` text DEFAULT NULL");
        columns.add("`conqueredTax` float NOT NULL");
        return columns;
    }

    private static List<String> getWorldColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`uuid` VARCHAR(36) DEFAULT NULL");
        columns.add("`claimable` bool NOT NULL DEFAULT '0'");
        columns.add("`pvp` bool NOT NULL DEFAULT '0'");
        columns.add("`forcepvp` bool NOT NULL DEFAULT '0'");
        columns.add("`forcetownmobs` bool NOT NULL DEFAULT '0'");
        columns.add("`friendlyFire` bool NOT NULL DEFAULT '0'");
        columns.add("`worldmobs` bool NOT NULL DEFAULT '0'");
        columns.add("`wildernessmobs` bool NOT NULL DEFAULT '0'");
        columns.add("`firespread` bool NOT NULL DEFAULT '0'");
        columns.add("`forcefirespread` bool NOT NULL DEFAULT '0'");
        columns.add("`explosions` bool NOT NULL DEFAULT '0'");
        columns.add("`forceexplosions` bool NOT NULL DEFAULT '0'");
        columns.add("`endermanprotect` bool NOT NULL DEFAULT '0'");
        columns.add("`disablecreaturetrample` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneBuild` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneDestroy` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneSwitch` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneItemUse` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneName` mediumtext NOT NULL");
        columns.add("`unclaimedZoneIgnoreIds` mediumtext NOT NULL");
        columns.add("`usingPlotManagementDelete` bool NOT NULL DEFAULT '0'");
        columns.add("`plotManagementDeleteIds` mediumtext NOT NULL");
        columns.add("`isDeletingEntitiesOnUnclaim` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimDeleteEntityTypes` mediumtext NOT NULL");
        columns.add("`usingPlotManagementMayorDelete` bool NOT NULL DEFAULT '0'");
        columns.add("`plotManagementMayorDelete` mediumtext NOT NULL");
        columns.add("`usingPlotManagementRevert` bool NOT NULL DEFAULT '0'");
        columns.add("`plotManagementIgnoreIds` mediumtext NOT NULL");
        columns.add("`revertOnUnclaimWhitelistMaterials` mediumtext NOT NULL");
        columns.add("`usingPlotManagementWildRegen` bool NOT NULL DEFAULT '0'");
        columns.add("`plotManagementWildRegenEntities` mediumtext NOT NULL");
        columns.add("`plotManagementWildRegenBlockWhitelist` mediumtext NOT NULL");
        columns.add("`plotManagementWildRegenSpeed` long NOT NULL");
        columns.add("`usingPlotManagementWildRegenBlocks` bool NOT NULL DEFAULT '0'");
        columns.add("`plotManagementWildRegenBlocks` mediumtext NOT NULL");
        columns.add("`usingTowny` bool NOT NULL DEFAULT '0'");
        columns.add("`warAllowed` bool NOT NULL DEFAULT '0'");
        columns.add("`metadata` text DEFAULT NULL");
        return columns;
    }

    private static List<String> getTownBlockColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`name` mediumtext");
        columns.add("`price` float DEFAULT '-1'");
        columns.add("`town` mediumtext");
        columns.add("`resident` mediumtext");
        columns.add("`type` TINYINT NOT  NULL DEFAULT '0'");
        columns.add("`typeName` mediumtext");
        columns.add("`outpost` bool NOT NULL DEFAULT '0'");
        columns.add("`permissions` mediumtext NOT NULL");
        columns.add("`locked` bool NOT NULL DEFAULT '0'");
        columns.add("`changed` bool NOT NULL DEFAULT '0'");
        columns.add("`metadata` text DEFAULT NULL");
        columns.add("`groupID` VARCHAR(36) DEFAULT NULL");
        columns.add("`claimedAt` BIGINT NOT NULL");
        columns.add("`trustedResidents` mediumtext DEFAULT NULL");
        columns.add("`customPermissionData` mediumtext DEFAULT NULL");
        return columns;
    }

    private static List<String> getCooldownColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`key` varchar(200) NOT NULL");
        columns.add("`expiry` BIGINT NOT NULL");
        return columns;
    }

    public static void cleanup(Connection connection) {
        ArrayList<ColumnUpdate> cleanups = new ArrayList<ColumnUpdate>();
        cleanups.add(ColumnUpdate.update("TOWNS", "residents"));
        cleanups.add(ColumnUpdate.update("NATIONS", "assistants"));
        cleanups.add(ColumnUpdate.update("NATIONS", "towns"));
        cleanups.add(ColumnUpdate.update("WORLDS", "towns"));
        cleanups.add(ColumnUpdate.update("WORLDS", "plotManagementRevertSpeed"));
        cleanups.add(ColumnUpdate.update("PLOTGROUPS", "claimedAt"));
        cleanups.add(ColumnUpdate.update("RESIDENTS", "isJailed"));
        cleanups.add(ColumnUpdate.update("RESIDENTS", "JailSpawn"));
        cleanups.add(ColumnUpdate.update("RESIDENTS", "JailDays"));
        cleanups.add(ColumnUpdate.update("RESIDENTS", "JailTown"));
        cleanups.add(ColumnUpdate.update("TOWNS", "jailSpawns"));
        cleanups.add(ColumnUpdate.update("WORLDS", "disableplayertrample"));
        cleanups.add(ColumnUpdate.update("TOWNS", "assistants"));
        for (ColumnUpdate update : cleanups) {
            SQLSchema.dropColumn(connection, update.table(), update.column());
        }
    }

    private static void dropColumn(Connection cntx, String table, String column) {
        block10: {
            try (Statement s = cntx.createStatement();){
                DatabaseMetaData md = cntx.getMetaData();
                ResultSet rs = md.getColumns(null, null, table, column);
                if (!rs.next()) {
                    return;
                }
                String update = "ALTER TABLE `" + SQLDB_NAME + "`.`" + table + "` DROP COLUMN `" + column + "`";
                s.executeUpdate(update);
                TownyMessaging.sendDebugMsg("Table " + table + " has dropped the " + column + " column.");
            }
            catch (SQLException ee) {
                if (ee.getErrorCode() == 1060) break block10;
                TownyMessaging.sendErrorMsg("Error updating table " + table + ":" + ee.getMessage());
            }
        }
    }

    private static final class ColumnUpdate {
        private final String table;
        private final String column;

        private ColumnUpdate(String table, String column) {
            this.table = table;
            this.column = column;
        }

        private static ColumnUpdate update(String table, String column) {
            return new ColumnUpdate(TABLE_PREFIX + table, column);
        }

        public String toString() {
            return "ColumnUpdate[" + "table=" + this.table + "," + "column=" + this.column + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
            result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((ColumnUpdate)arg0).table, this.table)) {
                return false;
            }
            return Objects.equals(((ColumnUpdate)arg0).column, this.column);
            {
            }
        }

        public String table() {
            return this.table;
        }

        public String column() {
            return this.column;
        }
    }
}

