/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.util.FileMgmt;
import java.nio.file.Path;
import java.util.Locale;

public enum DatabaseConfig {
    DATABASE("database", "", ""),
    DATEBASE_VERSION("database.version", "1", "", "# The Database version number. Do not change."),
    DATABASE_LOAD("database.database_load", "flatfile", "", "# Valid load and save types are: flatfile and mysql."),
    DATABASE_SAVE("database.database_save", "flatfile", new String[0]),
    DATABASE_SQL_HEADER("database.sql", "", "", "# SQL database connection details (IF set to use mysql)."),
    DATABASE_HOSTNAME("database.sql.hostname", "localhost", new String[0]),
    DATABASE_PORT("database.sql.port", "3306", new String[0]),
    DATABASE_DBNAME("database.sql.dbname", "towny", new String[0]),
    DATABASE_TABLEPREFIX("database.sql.table_prefix", "towny_", new String[0]),
    DATABASE_USERNAME("database.sql.username", "root", new String[0]),
    DATABASE_PASSWORD("database.sql.password", "", new String[0]),
    DATABASE_FLAGS("database.sql.flags", "?verifyServerCertificate=false&useSSL=false&useUnicode=true&characterEncoding=utf-8", new String[0]),
    DATABASE_SQL_DISABLE_BACKUP_WARNING("database.sql.disable_backup_warning", "false", "", "# Disables the warning when a backup is made about not all Towny data being backed up when mysql is in use.", "# Set this to true when you fully understand what not having flatfile backups means, if your mysql database were to become unusable and you have not configured your own backup solution."),
    DATABASE_POOLING_HEADER("database.sql.pooling", "", "", "# Modifiable settings to control the connection pooling.", "# Unless you actually know what you're doing and how Towny uses its mysql connection,", "# it is strongly recommended you do not change these settings."),
    DATABASE_POOLING_MAX_POOL_SIZE("database.sql.pooling.max_pool_size", "5", new String[0]),
    DATABASE_POOLING_MAX_LIFETIME("database.sql.pooling.max_lifetime", "180000", new String[0]),
    DATABASE_POOLING_CONNECTION_TIMEOUT("database.sql.pooling.connection_timeout", "5000", new String[0]);

    private final String Root;
    private final String Default;
    private final String[] comments;
    private static CommentedConfiguration databaseConfig;
    private static CommentedConfiguration newDatabaseConfig;

    private DatabaseConfig(String root, String def, String ... comments) {
        this.Root = root;
        this.Default = def;
        this.comments = comments;
    }

    public String getRoot() {
        return this.Root;
    }

    public String getDefault() {
        return this.Default;
    }

    public String[] getComments() {
        if (this.comments != null) {
            return this.comments;
        }
        String[] comments = new String[]{""};
        return comments;
    }

    public static void loadDatabaseConfig(Path databaseConfigPath) {
        if (!FileMgmt.checkOrCreateFile(databaseConfigPath.toString())) {
            throw new TownyInitException("Failed to touch '" + databaseConfigPath + "'.", TownyInitException.TownyError.DATABASE_CONFIG);
        }
        databaseConfig = new CommentedConfiguration(databaseConfigPath);
        if (!databaseConfig.load()) {
            throw new TownyInitException("Database: Failed to load database.yml!", TownyInitException.TownyError.DATABASE_CONFIG);
        }
        DatabaseConfig.setDatabaseDefaults(databaseConfigPath);
        databaseConfig.save();
    }

    public static void setDatabaseDefaults(Path databaseConfigPath) {
        newDatabaseConfig = new CommentedConfiguration(databaseConfigPath);
        newDatabaseConfig.load();
        for (DatabaseConfig root : DatabaseConfig.values()) {
            String key = root.getRoot().toLowerCase();
            if (root.getComments().length > 0) {
                newDatabaseConfig.addComment(key, root.getComments());
            }
            Object value = databaseConfig.get(key) != null ? databaseConfig.get(key) : root.getDefault();
            newDatabaseConfig.set(key, value);
        }
        databaseConfig = newDatabaseConfig;
        newDatabaseConfig = null;
    }

    public static void setDatabaseVersion(String version) {
        databaseConfig.set("database.version", version);
        databaseConfig.save();
    }

    public static String getString(DatabaseConfig node) {
        return databaseConfig.getString(node.getRoot().toLowerCase(), node.getDefault());
    }

    public static int getInt(DatabaseConfig node) {
        try {
            return Integer.parseInt(databaseConfig.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            Towny.getPlugin().getLogger().severe(node.getRoot().toLowerCase() + " from database.yml");
            return 0;
        }
    }

    public static boolean getBoolean(DatabaseConfig node) {
        return Boolean.parseBoolean(databaseConfig.getString(node.getRoot().toLowerCase(Locale.ROOT), node.getDefault()));
    }
}

