/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.confirmations;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.economy.Account;
import java.util.function.Supplier;

public class ConfirmationTransaction {
    private final Supplier<Double> costSupplier;
    private double cost;
    private final Account payee;
    private final String loggedMessage;
    private final Translatable insufficientFundsMessage;

    public ConfirmationTransaction(Supplier<Double> costSupplier, Account payee, String loggedMessage, Translatable insufficientFundsMessage) {
        this.costSupplier = costSupplier;
        this.payee = payee;
        this.loggedMessage = loggedMessage;
        this.insufficientFundsMessage = insufficientFundsMessage;
    }

    public ConfirmationTransaction(Supplier<Double> costSupplier, Account payee, String loggedMessage) {
        this.costSupplier = costSupplier;
        this.payee = payee;
        this.loggedMessage = loggedMessage;
        this.insufficientFundsMessage = null;
    }

    public void supplyCost() {
        this.cost = this.costSupplier.get();
    }

    public double getCost() {
        return this.cost;
    }

    public Account getPayee() {
        return this.payee;
    }

    public String getLoggedMessage() {
        return this.loggedMessage;
    }

    public Translatable getInsufficientFundsMessage() {
        return this.insufficientFundsMessage != null ? this.insufficientFundsMessage : Translatable.of("msg_err_no_money", TownyEconomyHandler.getFormattedBalance(this.getCost()));
    }
}

