/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class TownyWorldCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static TownyWorld globalWorld;
    private static final List<String> townyWorldTabCompletes;
    private static final List<String> townyWorldToggleTabCompletes;
    private static List<String> townySetTabCompletes;

    public TownyWorldCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (plugin.isError() && sender instanceof Player) {
            TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
            return true;
        }
        this.parseWorldCommand(sender, args);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return this.tabComplete(sender, args, true);
    }

    public List<String> tabComplete(CommandSender sender, String[] args, boolean showWorlds) {
        switch (args[0].toLowerCase()) {
            case "toggle": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNYWORLD_TOGGLE, townyWorldToggleTabCompletes), args[1]);
                }
                if (args.length != 3) break;
                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
            }
            case "set": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, townySetTabCompletes), args[1]);
                }
                if (args.length <= 2 || !TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, args[1])) break;
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, args[1]).getTabCompletion(sender, StringMgmt.remFirstArg(args)), args[args.length - 1]);
            }
            default: {
                if (args.length == 1) {
                    return TownyWorldCommand.filterByStartOrGetTownyStartingWith(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNYWORLD, townyWorldTabCompletes), args[0], showWorlds ? "+w" : "");
                }
                if (args.length > 1 && TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD, args[0])) {
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
                }
                if (!showWorlds || !BukkitTools.getWorldNames(true).contains(args[0].toLowerCase())) break;
                return this.tabComplete(sender, StringMgmt.remFirstArg(args), false);
            }
        }
        return Collections.emptyList();
    }

    public void parseWorldCommand(CommandSender sender, String[] split) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (split.length > 0 && !townyWorldTabCompletes.contains(split[0].toLowerCase()) && TownyAPI.getInstance().getTownyWorld(split[0]) != null) {
                globalWorld = TownyAPI.getInstance().getTownyWorld(split[0]);
                split = StringMgmt.remFirstArg(split);
            } else {
                globalWorld = TownyAPI.getInstance().getTownyWorld(player.getWorld());
            }
            if (globalWorld == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_area_not_recog"));
                return;
            }
        } else {
            if (split.length == 0) {
                HelpMenu.TOWNYWORLD_HELP_CONSOLE.send(sender);
                return;
            }
            globalWorld = TownyAPI.getInstance().getTownyWorld(split[0]);
            if (globalWorld == null) {
                Translatable error = Translatable.of("msg_err_invalid_townyworld", split[0]);
                if (townyWorldTabCompletes.contains(split[0].toLowerCase())) {
                    error = Translatable.of("msg_err_enter_world_name_first");
                }
                TownyMessaging.sendErrorMsg(sender, error);
                return;
            }
            split = StringMgmt.remFirstArg(split);
        }
        if (split.length == 0) {
            TownyMessaging.sendStatusScreen(sender, TownyFormatter.getStatus(globalWorld, sender));
            return;
        }
        try {
            if (split[0].equalsIgnoreCase("?")) {
                if (sender instanceof Player) {
                    HelpMenu.TOWNYWORLD_HELP.send(sender);
                } else {
                    HelpMenu.TOWNYWORLD_HELP_CONSOLE.send(sender);
                }
            } else if (split[0].equalsIgnoreCase("list")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_LIST.getNode());
                this.listWorlds(sender);
            } else if (split[0].equalsIgnoreCase("set")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_SET.getNode());
                this.worldSet(sender, StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("toggle")) {
                this.worldToggle(sender, StringMgmt.remFirstArg(split));
            } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD, split[0])) {
                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD, split[0]).execute(sender, "townyworld", split);
            } else {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", "townyworld"));
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
        }
    }

    public void listWorlds(CommandSender sender) {
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(Translatable.of("world_plu").forLocale(sender)));
        ArrayList<String> formattedList = new ArrayList<String>();
        HashMap<String, Integer> playersPerWorld = BukkitTools.getPlayersPerWorld();
        for (TownyWorld world : TownyUniverse.getInstance().getTownyWorlds()) {
            int numPlayers = playersPerWorld.getOrDefault(world.getName(), 0);
            formattedList.add("\u00a7b" + world.getName() + "\u00a73" + " [" + numPlayers + "]" + "\u00a7f");
        }
        TownyMessaging.sendMessage((Object)sender, ChatTools.list(formattedList));
    }

    public void worldToggle(CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0) {
            if (sender instanceof Player) {
                HelpMenu.TOWNYWORLD_TOGGLE.send(sender);
            } else {
                HelpMenu.TOWNYWORLD_TOGGLE_CONSOLE.send(sender);
            }
        } else {
            if (!globalWorld.isUsingTowny() && !split[0].equalsIgnoreCase("usingtowny")) {
                throw new TownyException(Translatable.of("msg_err_usingtowny_disabled"));
            }
            Optional<Object> choice = Optional.empty();
            if (split.length == 2) {
                choice = TownyWorldCommand.parseToggleChoice(split[1]);
            }
            if (split[0].equalsIgnoreCase("claimable")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_CLAIMABLE.getNode());
                globalWorld.setClaimable(choice.orElse(!globalWorld.isClaimable()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_claim", globalWorld.getName(), this.formatBool(globalWorld.isClaimable())));
            } else if (split[0].equalsIgnoreCase("usingtowny")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_USINGTOWNY.getNode());
                globalWorld.setUsingTowny((Boolean)choice.orElse(!globalWorld.isUsingTowny()));
                plugin.resetCache();
                TownyMessaging.sendMsg(sender, globalWorld.isUsingTowny() ? Translatable.of("msg_set_use_towny_on") : Translatable.of("msg_set_use_towny_off"));
                if (!globalWorld.isUsingTowny() && globalWorld.isUsingPlotManagementRevert()) {
                    TownyRegenAPI.turnOffRevertOnUnclaimForWorld(globalWorld);
                }
            } else if (split[0].equalsIgnoreCase("warallowed")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_WARALLOWED.getNode());
                globalWorld.setWarAllowed((Boolean)choice.orElse(!globalWorld.isWarAllowed()));
                plugin.resetCache();
                TownyMessaging.sendMsg(sender, globalWorld.isWarAllowed() ? Translatable.of("msg_set_war_allowed_on") : Translatable.of("msg_set_war_allowed_off"));
            } else if (split[0].equalsIgnoreCase("pvp")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_PVP.getNode());
                globalWorld.setPVP((Boolean)choice.orElse(!globalWorld.isPVP()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Global PVP", globalWorld.getName(), this.formatBool(globalWorld.isPVP())));
            } else if (split[0].equalsIgnoreCase("forcepvp")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FORCEPVP.getNode());
                globalWorld.setForcePVP((Boolean)choice.orElse(!globalWorld.isForcePVP()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Force town PVP", globalWorld.getName(), this.formatBool(globalWorld.isForcePVP(), "forced", "adjustable")));
            } else if (split[0].equalsIgnoreCase("friendlyfire")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FRIENDLYFIRE.getNode());
                globalWorld.setFriendlyFire((Boolean)choice.orElse(!globalWorld.isFriendlyFireEnabled()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Friendly Fire", globalWorld.getName(), this.formatBool(globalWorld.isFriendlyFireEnabled())));
            } else if (split[0].equalsIgnoreCase("explosion")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_EXPLOSION.getNode());
                globalWorld.setExpl((Boolean)choice.orElse(!globalWorld.isExpl()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Explosions", globalWorld.getName(), this.formatBool(globalWorld.isExpl())));
            } else if (split[0].equalsIgnoreCase("forceexplosion")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FORCEEXPLOSION.getNode());
                globalWorld.setForceExpl((Boolean)choice.orElse(!globalWorld.isForceExpl()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Force town Explosions", globalWorld.getName(), this.formatBool(globalWorld.isForceExpl(), "forced", "adjustable")));
            } else if (split[0].equalsIgnoreCase("fire")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FIRE.getNode());
                globalWorld.setFire((Boolean)choice.orElse(!globalWorld.isFire()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Fire Spread", globalWorld.getName(), this.formatBool(globalWorld.isFire())));
            } else if (split[0].equalsIgnoreCase("forcefire")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FORCEFIRE.getNode());
                globalWorld.setForceFire((Boolean)choice.orElse(!globalWorld.isForceFire()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Force town Fire Spread", globalWorld.getName(), this.formatBool(globalWorld.isForceFire(), "forced", "adjustable")));
            } else if (split[0].equalsIgnoreCase("townmobs")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_TOWNMOBS.getNode());
                globalWorld.setForceTownMobs((Boolean)choice.orElse(!globalWorld.isForceTownMobs()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Town Mob spawns", globalWorld.getName(), this.formatBool(globalWorld.isForceTownMobs(), "forced", "adjustable")));
            } else if (split[0].equalsIgnoreCase("worldmobs")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_WORLDMOBS.getNode());
                globalWorld.setWorldMobs((Boolean)choice.orElse(!globalWorld.hasWorldMobs()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "World Mob spawns", globalWorld.getName(), this.formatBool(globalWorld.hasWorldMobs())));
            } else if (split[0].equalsIgnoreCase("wildernessmobs")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_WILDERNESSMOBS.getNode());
                globalWorld.setWildernessMobs((Boolean)choice.orElse(!globalWorld.hasWildernessMobs()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Wilderness Mob spawns", globalWorld.getName(), this.formatBool(globalWorld.hasWildernessMobs())));
            } else if (split[0].equalsIgnoreCase("revertunclaim")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_REVERTUNCLAIM.getNode());
                globalWorld.setUsingPlotManagementRevert((Boolean)choice.orElse(!globalWorld.isUsingPlotManagementRevert()));
                if (!globalWorld.isUsingPlotManagementRevert()) {
                    TownyRegenAPI.turnOffRevertOnUnclaimForWorld(globalWorld);
                }
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Unclaim Revert", globalWorld.getName(), this.formatBool(globalWorld.isUsingPlotManagementRevert())));
            } else if (split[0].equalsIgnoreCase("revertentityexpl")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_REVERTENTITYEXPL.getNode());
                globalWorld.setUsingPlotManagementWildEntityRevert((Boolean)choice.orElse(!globalWorld.isUsingPlotManagementWildEntityRevert()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Wilderness Entity Explosion Revert", globalWorld.getName(), this.formatBool(globalWorld.isUsingPlotManagementWildEntityRevert())));
            } else if (split[0].equalsIgnoreCase("revertblockexpl")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_REVERTBLOCKEXPL.getNode());
                globalWorld.setUsingPlotManagementWildBlockRevert((Boolean)choice.orElse(!globalWorld.isUsingPlotManagementWildBlockRevert()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Wilderness Block Explosion Revert", globalWorld.getName(), this.formatBool(globalWorld.isUsingPlotManagementWildBlockRevert())));
            } else if (split[0].equalsIgnoreCase("plotcleardelete")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_PLOTCLEARDELETE.getNode());
                globalWorld.setUsingPlotManagementMayorDelete((Boolean)choice.orElse(!globalWorld.isUsingPlotManagementMayorDelete()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Plot Clear Delete", globalWorld.getName(), this.formatBool(globalWorld.isUsingPlotManagementMayorDelete())));
            } else if (split[0].equalsIgnoreCase("unclaimblockdelete")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_UNCLAIMBLOCKDELETE.getNode());
                globalWorld.setUsingPlotManagementDelete((Boolean)choice.orElse(!globalWorld.isUsingPlotManagementDelete()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Unclaim Block Delete", globalWorld.getName(), this.formatBool(globalWorld.isUsingPlotManagementDelete())));
            } else if (split[0].equalsIgnoreCase("unclaimentitydelete")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_UNCLAIMENTITYDELETE.getNode());
                globalWorld.setDeletingEntitiesOnUnclaim((Boolean)choice.orElse(!globalWorld.isDeletingEntitiesOnUnclaim()));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Unclaim Entity Delete", globalWorld.getName(), this.formatBool(globalWorld.isDeletingEntitiesOnUnclaim())));
            } else if (split[0].equalsIgnoreCase("wildernessuse")) {
                TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_WILDERNESSUSE.getNode());
                String value = split.length > 1 ? split[1] : "";
                boolean toggle = TownyWorldCommand.parseToggleChoice(value).orElse(globalWorld.getUnclaimedZoneBuild() == false);
                globalWorld.setUnclaimedZoneBuild(toggle);
                globalWorld.setUnclaimedZoneDestroy(toggle);
                globalWorld.setUnclaimedZoneItemUse(toggle);
                globalWorld.setUnclaimedZoneSwitch(toggle);
                TownyMessaging.sendMsg(sender, Translatable.of("msg_wilderness_use_set_to", toggle, globalWorld.getName()));
            } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_TOGGLE, split[0])) {
                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_TOGGLE, split[0]).execute(sender, "townyworld", split);
            } else {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", "'" + split[0] + "'"));
                return;
            }
            globalWorld.save();
            BukkitTools.fireEvent(new TownBlockSettingsChangedEvent(globalWorld));
        }
    }

    public void worldSet(CommandSender sender, String[] split) {
        if (split.length == 0) {
            HelpMenu.TOWNYWORLD_SET.send(sender);
        } else {
            if (split[0].equalsIgnoreCase("usedefault")) {
                Confirmation.runOnAccept(() -> {
                    globalWorld.setUsingDefault();
                    plugin.resetCache();
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_usedefault", globalWorld.getName()));
                }).setTitle(Translatable.of("confirmation_are_you_sure_you_want_to_reset_this_worlds_settings")).sendTo(sender);
            } else if (split[0].equalsIgnoreCase("wildperm")) {
                if (split.length < 2) {
                    globalWorld.setUsingDefault();
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_usedefault", globalWorld.getName()));
                } else {
                    try {
                        List<String> perms = Arrays.asList(String.join((CharSequence)",", StringMgmt.remFirstArg(split)).toLowerCase(Locale.ROOT).split(","));
                        globalWorld.setUnclaimedZoneBuild(perms.contains("build"));
                        globalWorld.setUnclaimedZoneDestroy(perms.contains("destroy"));
                        globalWorld.setUnclaimedZoneSwitch(perms.contains("switch"));
                        globalWorld.setUnclaimedZoneItemUse(perms.contains("itemuse") || perms.contains("item_use"));
                        plugin.resetCache();
                        TownyMessaging.sendMsg(sender, Translatable.of("msg_set_wild_perms", globalWorld.getName(), perms.toString()));
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg((Object)sender, "Eg: /townyworld set wildperm build destroy <world>");
                    }
                }
            } else if (split[0].equalsIgnoreCase("wildignore")) {
                if (split.length < 2) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_input", "/townyworld set wildignore OAK_SAPLING GOLD_ORE IRON_ORE"));
                } else {
                    try {
                        List<String> mats = Arrays.asList(StringMgmt.remFirstArg(split));
                        globalWorld.setUnclaimedZoneIgnore(mats);
                        plugin.resetCache();
                        TownyMessaging.sendMsg(sender, Translatable.of("msg_set_wild_ignore", globalWorld.getName(), globalWorld.getUnclaimedZoneIgnoreMaterials()));
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_input", "/townyworld set wildignore OAK_SAPLING GOLD_ORE IRON_ORE"));
                    }
                }
            } else if (split[0].equalsIgnoreCase("wildregen")) {
                if (split.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)sender, "Eg: /townyworld set wildregen Creeper,EnderCrystal,EnderDragon,Fireball,SmallFireball,LargeFireball,TNTPrimed,ExplosiveMinecart");
                } else {
                    String[] entities = String.join((CharSequence)",", StringMgmt.remFirstArg(split)).split(",");
                    ArrayList<String> entityList = new ArrayList<String>(Arrays.asList(entities));
                    globalWorld.setPlotManagementWildRevertEntities(entityList);
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_set_wild_regen", globalWorld.getName(), globalWorld.getPlotManagementWildRevertEntities()));
                }
            } else if (split[0].equalsIgnoreCase("wildname")) {
                if (split.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)sender, "Eg: /townyworld set wildname Wildy");
                } else {
                    globalWorld.setUnclaimedZoneName(split[1]);
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_set_wild_name", globalWorld.getName(), split[1]));
                }
            } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, split[0])) {
                try {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, split[0]).execute(sender, "townyworld", split);
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
                }
            } else {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", "world"));
                return;
            }
            globalWorld.save();
        }
    }

    private Translatable formatBool(boolean bool) {
        return bool ? Translatable.of("enabled") : Translatable.of("disabled");
    }

    private Translatable formatBool(boolean bool, String ifTrue, String ifFalse) {
        return bool ? Translatable.of(ifTrue) : Translatable.of(ifFalse);
    }

    static {
        townyWorldTabCompletes = Arrays.asList("list", "toggle", "set");
        townyWorldToggleTabCompletes = Arrays.asList("claimable", "usingtowny", "pvp", "forcepvp", "explosion", "forceexplosion", "friendlyfire", "fire", "forcefire", "townmobs", "worldmobs", "wildernessmobs", "revertunclaim", "revertentityexpl", "revertblockexpl", "warallowed", "unclaimblockdelete", "unclaimentitydelete", "plotcleardelete", "wildernessuse");
        townySetTabCompletes = Arrays.asList("usedefault", "wildperm", "wildignore", "wildregen", "wildname");
    }
}

