/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NoPermissionException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class ResidentCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> residentTabCompletes;
    private static final List<String> residentFriendTabCompletes;
    private static final List<String> residentToggleTabCompletes;
    private static final List<String> residentModeTabCompletes;
    private static final List<String> residentConsoleTabCompletes;
    private static final List<String> residentSetTabCompletes;
    private static final List<String> residentToggleChoices;
    private static final List<String> residentToggleModes;
    private static final List<String> residentToggleModesUnionToggles;

    public ResidentCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            if (plugin.isError()) {
                TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
                return false;
            }
            Player player = (Player)sender;
            if (args == null) {
                HelpMenu.RESIDENT_HELP.send((CommandSender)player);
                this.parseResidentCommand(player, args);
            } else {
                this.parseResidentCommand(player, args);
            }
        } else {
            try {
                this.parseResidentCommandForConsole(sender, args);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        block41: {
            block40: {
                if (!(sender instanceof Player)) break block40;
                switch (args[0].toLowerCase()) {
                    case "tax": {
                        if (args.length == 2) {
                            return ResidentCommand.getTownyStartingWith(args[1], "r");
                        }
                        break block41;
                    }
                    case "jail": {
                        if (args.length == 2) {
                            return Collections.singletonList("paybail");
                        }
                        break block41;
                    }
                    case "toggle": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.RESIDENT_TOGGLE, residentToggleTabCompletes), args[1]);
                        }
                        if (args.length == 3 && residentToggleChoices.contains(args[1].toLowerCase())) {
                            return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                        }
                        if (args.length >= 3) {
                            String prevArg = args[args.length - 2].toLowerCase();
                            if (residentToggleModes.contains(prevArg)) {
                                return NameUtil.filterByStart(residentToggleModesUnionToggles, args[args.length - 1]);
                            }
                            if (BaseCommand.setOnOffCompletes.contains(prevArg)) {
                                return NameUtil.filterByStart(residentToggleModes, args[args.length - 1]);
                            }
                        }
                        break block41;
                    }
                    case "set": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.RESIDENT_SET, residentSetTabCompletes), args[1]);
                        }
                        if (args.length > 2) {
                            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT_SET, args[1])) {
                                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT_SET, args[1]).getTabCompletion(sender, StringMgmt.remFirstArg(args)), args[args.length - 1]);
                            }
                            switch (args[1].toLowerCase()) {
                                case "mode": {
                                    return NameUtil.filterByStart(residentModeTabCompletes, args[args.length - 1]);
                                }
                                case "perm": {
                                    return ResidentCommand.permTabComplete(StringMgmt.remArgs(args, 2));
                                }
                            }
                            return Collections.emptyList();
                        }
                        break block41;
                    }
                    case "friend": {
                        switch (args.length) {
                            case 2: {
                                return NameUtil.filterByStart(residentFriendTabCompletes, args[1]);
                            }
                            case 3: {
                                if (args[1].equalsIgnoreCase("remove")) {
                                    Resident res = TownyUniverse.getInstance().getResident(((Player)sender).getUniqueId());
                                    if (res == null) break;
                                    return NameUtil.filterByStart(NameUtil.getNames(res.getFriends()), args[2]);
                                }
                                return ResidentCommand.getTownyStartingWith(args[2], "r");
                            }
                        }
                        return Collections.emptyList();
                    }
                    default: {
                        if (args.length == 1) {
                            return ResidentCommand.filterByStartOrGetTownyStartingWith(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.RESIDENT, residentTabCompletes), args[0], "r");
                        }
                        if (args.length > 1 && TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT, args[0])) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
                        }
                        break block41;
                    }
                }
            }
            if (args.length == 1) {
                return ResidentCommand.filterByStartOrGetTownyStartingWith(residentConsoleTabCompletes, args[0], "r");
            }
        }
        return Collections.emptyList();
    }

    private void parseResidentCommandForConsole(CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.RESIDENT_HELP_CONSOLE.send(sender);
        } else if (split[0].equalsIgnoreCase("list")) {
            this.listResidents(sender);
        } else {
            Optional<Resident> resOpt = Optional.ofNullable(TownyUniverse.getInstance().getResident(split[0]));
            if (resOpt.isPresent()) {
                plugin.getScheduler().runAsync(() -> TownyMessaging.sendStatusScreen(sender, TownyFormatter.getStatus((Resident)resOpt.get(), sender)));
            } else {
                throw new TownyException(Translatable.of("msg_err_not_registered_1", split[0]));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseResidentCommand(Player player, String[] split) {
        try {
            if (split.length == 0) {
                Resident res = ResidentCommand.getResidentOrThrow(player);
                plugin.getScheduler().runAsync(() -> TownyMessaging.sendStatusScreen((CommandSender)player, TownyFormatter.getStatus(res, (CommandSender)player)));
                return;
            }
            if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
                HelpMenu.RESIDENT_HELP.send((CommandSender)player);
                return;
            }
            if (split[0].equalsIgnoreCase("list")) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_LIST.getNode());
                this.listResidents((CommandSender)player);
                return;
            }
            if (split[0].equalsIgnoreCase("tax")) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TAX.getNode());
                if (!TownyEconomyHandler.isActive()) {
                    throw new TownyException(Translatable.of("msg_err_no_economy"));
                }
                Resident res = split.length > 1 ? ResidentCommand.getResidentOrThrow(split[1]) : ResidentCommand.getResidentOrThrow(player);
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getTaxStatus(res, Translator.locale((CommandSender)player)));
                return;
            }
            if (split[0].equalsIgnoreCase("jail")) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_JAIL.getNode());
                if (!TownySettings.isAllowingBail()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_bail_not_enabled"));
                    return;
                }
                if (split.length == 1) {
                    HelpMenu.RESIDENT_JAIL_HELP.send((CommandSender)player);
                    return;
                }
                Resident resident = ResidentCommand.getResidentOrThrow(player);
                if (!resident.isJailed()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_you_aren't currently jailed"));
                    return;
                }
                if (!split[1].equalsIgnoreCase("paybail")) {
                    HelpMenu.RESIDENT_JAIL_HELP.send((CommandSender)player);
                    return;
                }
                if (!TownyEconomyHandler.isActive()) {
                    throw new TownyException(Translatable.of("msg_err_no_economy"));
                }
                Town jailTown = resident.getJailTown();
                double cost = resident.getJailBailCost();
                if (cost > 0.0) {
                    if (!resident.getAccount().canPayFromHoldings(cost)) throw new TownyException(Translatable.of("msg_err_unable_to_pay_bail"));
                    double finalCost = cost;
                    Confirmation.runOnAccept(() -> {
                        if (resident.getAccount().canPayFromHoldings(finalCost)) {
                            resident.getAccount().payTo(finalCost, jailTown, "Bail paid to " + jailTown.getName());
                            JailUtil.unJailResident(resident, UnJailReason.BAIL);
                        } else {
                            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_unable_to_pay_bail"));
                        }
                    }).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(finalCost))).sendTo((CommandSender)player);
                    return;
                }
                JailUtil.unJailResident(resident, UnJailReason.BAIL);
                return;
            }
            if (split[0].equalsIgnoreCase("set")) {
                this.residentSet(player, StringMgmt.remFirstArg(split));
                return;
            }
            if (split[0].equalsIgnoreCase("toggle")) {
                this.residentToggle(player, StringMgmt.remFirstArg(split));
                return;
            }
            if (split[0].equalsIgnoreCase("friend")) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_FRIEND.getNode());
                ResidentCommand.residentFriend(player, StringMgmt.remFirstArg(split), false, null);
                return;
            }
            if (split[0].equalsIgnoreCase("spawn")) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SPAWN.getNode());
                SpawnUtil.sendToTownySpawn(player, split, ResidentCommand.getResidentOrThrow(player), Translatable.of("msg_err_cant_afford_tp").forLocale((CommandSender)player), false, false, SpawnType.RESIDENT);
                return;
            }
            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT, split[0])) {
                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT, split[0]).execute((CommandSender)player, "resident", split);
                return;
            }
            Resident resident = TownyUniverse.getInstance().getResidentOpt(split[0]).orElseThrow(() -> new TownyException(Translatable.of("msg_err_not_registered_1", split[0])));
            if (!resident.getName().equals(player.getName())) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_OTHERRESIDENT.getNode());
            }
            plugin.getScheduler().runAsync(() -> TownyMessaging.sendStatusScreen((CommandSender)player, TownyFormatter.getStatus(resident, (CommandSender)player)));
            return;
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg(player, x.getMessage((CommandSender)player));
            return;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage());
        }
    }

    private void residentToggle(Player player, String[] newSplit) throws TownyException {
        Resident resident = TownyUniverse.getInstance().getResidentOpt(player.getUniqueId()).orElseThrow(() -> new TownyException(Translatable.of("msg_err_not_registered_1", player.getName())));
        if (newSplit.length == 0) {
            HelpMenu.RESIDENT_TOGGLE.send((CommandSender)player);
            TownyMessaging.sendMsg(resident, Translatable.of("msg_modes_set").append(StringMgmt.join(resident.getModes(), ",")));
            return;
        }
        if (newSplit[0].equalsIgnoreCase("reset") || newSplit[0].equalsIgnoreCase("clear")) {
            plugin.removePlayerMode(player);
            return;
        }
        TownyPermission perm = resident.getPermissions();
        Optional<Object> choice = Optional.empty();
        if (newSplit.length == 2 && residentToggleChoices.contains(newSplit[0].toLowerCase())) {
            choice = BaseCommand.parseToggleChoice(newSplit[1]);
        }
        if (StringMgmt.containsIgnoreCase(Arrays.asList(newSplit), "spy")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_CHAT_SPY.getNode());
            resident.toggleMode(newSplit, true);
            return;
        }
        if (newSplit[0].equalsIgnoreCase("pvp")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_PVP.getNode());
            if (TownySettings.getPVPCoolDownTime() > 0 && resident.hasTown() && !resident.isAdmin()) {
                if (CooldownTimerTask.hasCooldown(resident.getTownOrNull().getUUID().toString(), CooldownTimerTask.CooldownType.PVP)) {
                    throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(resident.getTownOrNull().getUUID().toString(), CooldownTimerTask.CooldownType.PVP)));
                }
                if (CooldownTimerTask.hasCooldown(resident.getName(), CooldownTimerTask.CooldownType.PVP)) {
                    throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(resident.getName(), CooldownTimerTask.CooldownType.PVP)));
                }
            }
            perm.pvp = choice.orElse(!perm.pvp);
            if (TownySettings.getPVPCoolDownTime() > 0 && !resident.isAdmin()) {
                CooldownTimerTask.addCooldownTimer(resident.getName(), CooldownTimerTask.CooldownType.PVP);
            }
        } else if (newSplit[0].equalsIgnoreCase("fire")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_FIRE.getNode());
            perm.fire = (Boolean)choice.orElse(!perm.fire);
        } else if (newSplit[0].equalsIgnoreCase("explosion")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_EXPLOSION.getNode());
            perm.explosion = (Boolean)choice.orElse(!perm.explosion);
        } else if (newSplit[0].equalsIgnoreCase("mobs")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_MOBS.getNode());
            perm.mobs = (Boolean)choice.orElse(!perm.mobs);
        } else {
            if (newSplit[0].equalsIgnoreCase("bordertitles")) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_BORDERTITLES.getNode());
                ResidentUtil.toggleResidentBorderTitles(resident, choice);
                return;
            }
            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT_TOGGLE, newSplit[0])) {
                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT_TOGGLE, newSplit[0]).execute((CommandSender)player, "resident", newSplit);
            } else {
                resident.toggleMode(newSplit, true);
                return;
            }
        }
        this.notifyPerms(player, perm);
        resident.save();
    }

    private void notifyPerms(Player player, TownyPermission perm) {
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_perms"));
        TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (perm.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
    }

    public void listResidents(CommandSender sender) {
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(Translatable.of("res_list").forLocale(sender)));
        ArrayList<String> formattedList = new ArrayList<String>();
        for (Player player : BukkitTools.getVisibleOnlinePlayers(sender)) {
            Resident resident = TownyAPI.getInstance().getResident(player);
            if (resident == null) {
                formattedList.add("\u00a7f" + player.getName() + "\u00a7f");
                continue;
            }
            String colour = resident.isKing() ? "\u00a76" : (resident.isMayor() ? "\u00a7b" : "\u00a7f");
            formattedList.add(colour + resident.getName() + "\u00a7f");
        }
        TownyMessaging.sendMessage((Object)sender, ChatTools.list(formattedList));
    }

    public void residentSet(Player player, String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/resident set", "perm ...", "'/resident set perm' " + Translatable.of("res_5").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/resident set", "mode ...", "'/resident set mode' " + Translatable.of("res_5").forLocale((CommandSender)player)));
        } else {
            Optional<Resident> resOpt = townyUniverse.getResidentOpt(player.getUniqueId());
            if (!resOpt.isPresent()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", player.getName()));
                return;
            }
            Resident resident = resOpt.get();
            if (split[0].equalsIgnoreCase("perm")) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SET_PERM.getNode());
                TownCommand.setTownBlockPermissions((CommandSender)player, resident, resident.getPermissions(), StringMgmt.remFirstArg(split), true);
            } else if (split[0].equalsIgnoreCase("mode")) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SET_MODE.getNode());
                this.setMode(player, StringMgmt.remFirstArg(split));
            } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT_SET, split[0])) {
                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT_SET, split[0]).execute((CommandSender)player, "resident", split);
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", "resident"));
                return;
            }
            resident.save();
        }
    }

    private void setMode(Player player, String[] split) throws NoPermissionException {
        if (split.length == 0) {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/resident set mode", "clear", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/resident set mode", "[mode] ...[mode]", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Mode", "map", "", Translatable.of("mode_1").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Mode", "townclaim", "", Translatable.of("mode_2").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Mode", "townunclaim", "", Translatable.of("mode_3").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Mode", "tc", "", Translatable.of("mode_4").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Mode", "nc", "", Translatable.of("mode_5").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Mode", "ignoreplots", "", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Mode", "constantplotborder", "", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Mode", "plotborder", "", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Eg", "/resident set mode", "map townclaim town nation general", ""));
            return;
        }
        if (split[0].equalsIgnoreCase("reset") || split[0].equalsIgnoreCase("clear")) {
            plugin.removePlayerMode(player);
            return;
        }
        List<String> list = Arrays.asList(split);
        if (list.contains("spy")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_CHAT_SPY.getNode());
        }
        plugin.setPlayerMode(player, split, true);
    }

    public static void residentFriend(Player player, String[] split, boolean admin, Resident resident) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/resident friend", "add " + Translatable.of("res_2").forLocale((CommandSender)player), ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/resident friend", "remove " + Translatable.of("res_2").forLocale((CommandSender)player), ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/resident friend", "list", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/resident friend", "clear", ""));
        } else {
            String[] names;
            if (!admin) {
                Optional<Resident> resOpt = townyUniverse.getResidentOpt(player.getUniqueId());
                if (!resOpt.isPresent()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", player.getName()));
                    return;
                }
                resident = resOpt.get();
            }
            if (split[0].equalsIgnoreCase("add")) {
                names = StringMgmt.remFirstArg(split);
                ArrayList<Resident> invited = new ArrayList<Resident>();
                for (String name : names) {
                    Resident target = townyUniverse.getResident(name);
                    if (target == null) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", name));
                        continue;
                    }
                    invited.add(target);
                }
                ResidentCommand.residentFriendAdd(player, resident, invited);
            } else if (split[0].equalsIgnoreCase("remove")) {
                names = StringMgmt.remFirstArg(split);
                ArrayList<Resident> invited = new ArrayList<Resident>();
                for (String name : names) {
                    Resident target = townyUniverse.getResident(name);
                    if (target == null) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", name));
                        continue;
                    }
                    invited.add(target);
                }
                ResidentCommand.residentFriendRemove(player, resident, invited);
            } else if (split[0].equalsIgnoreCase("list")) {
                ResidentCommand.residentFriendList(player, resident);
            } else if (split[0].equalsIgnoreCase("clearlist") || split[0].equalsIgnoreCase("clear")) {
                ResidentCommand.residentFriendRemove(player, resident, resident.getFriends());
            }
        }
    }

    private static void residentFriendList(Player player, Resident resident) {
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(Translatable.of("friend_list").forLocale((CommandSender)player)));
        ArrayList<String> formatedList = new ArrayList<String>();
        for (Resident friends : resident.getFriends()) {
            String colour = friends.isKing() ? "\u00a76" : (friends.isMayor() ? "\u00a7b" : "\u00a7f");
            formatedList.add(colour + friends.getName() + "\u00a7f");
        }
        TownyMessaging.sendMessage((Object)player, ChatTools.list(formatedList));
    }

    public static void residentFriendAdd(Player player, Resident resident, List<Resident> invited) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        for (Resident newFriend : invited) {
            try {
                resident.addFriend(newFriend);
                plugin.deleteCache(newFriend);
            }
            catch (AlreadyRegisteredException e) {
                remove.add(newFriend);
            }
        }
        for (Resident newFriend : remove) {
            invited.remove(newFriend);
        }
        if (invited.size() > 0) {
            for (Resident newFriend : invited) {
                TownyMessaging.sendMsg(newFriend, Translatable.of("msg_friend_add", player.getName()));
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_res_friend_added_to_list", StringMgmt.join(invited, ", ")));
            resident.save();
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
        }
    }

    public static void residentFriendRemove(Player player, Resident resident, List<Resident> kicking) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        ArrayList<Resident> toKick = new ArrayList<Resident>(kicking);
        for (Resident friend : toKick) {
            if (!resident.hasFriend(friend)) {
                remove.add(friend);
                continue;
            }
            resident.removeFriend(friend);
            plugin.deleteCache(friend);
        }
        if (remove.size() > 0) {
            for (Resident friend : remove) {
                toKick.remove(friend);
            }
        }
        if (toKick.size() > 0) {
            for (Resident member : toKick) {
                TownyMessaging.sendMsg(member, Translatable.of("msg_friend_remove", player.getName()));
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_res_friend_removed_from_list", StringMgmt.join(toKick, ", ")));
            resident.save();
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
        }
    }

    static {
        residentTabCompletes = Arrays.asList("friend", "list", "jail", "spawn", "toggle", "set", "tax");
        residentFriendTabCompletes = Arrays.asList("add", "remove", "clear", "list");
        residentToggleTabCompletes = Arrays.asList("pvp", "fire", "mobs", "explosion", "adminbypass", "plotborder", "constantplotborder", "townborder", "ignoreplots", "bordertitles", "townclaim", "map", "spy", "reset", "clear", "infotool");
        residentModeTabCompletes = Arrays.asList("map", "townclaim", "townunclaim", "plotborder", "constantplotborder", "townborder", "ignoreplots", "reset", "clear", "infotool");
        residentConsoleTabCompletes = Arrays.asList("?", "help", "list");
        residentSetTabCompletes = Arrays.asList("perm", "mode");
        residentToggleChoices = Arrays.asList("pvp", "fire", "mobs", "explosion");
        residentToggleModes = new ArrayList<String>(residentToggleTabCompletes).stream().filter(str -> !residentToggleChoices.contains(str)).collect(Collectors.toList());
        residentToggleModesUnionToggles = Stream.concat(new ArrayList<String>(residentToggleModes).stream(), BaseCommand.setOnOffCompletes.stream()).collect(Collectors.toList());
    }
}

