/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.economy.TownyPreTransactionEvent;
import com.palmergames.bukkit.towny.event.economy.TownyTransactionEvent;
import com.palmergames.bukkit.towny.object.Transaction;
import com.palmergames.bukkit.towny.object.TransactionType;
import com.palmergames.bukkit.towny.object.economy.adapter.EconomyAdapter;
import com.palmergames.bukkit.towny.object.economy.adapter.ReserveEconomyAdapter;
import com.palmergames.bukkit.towny.object.economy.adapter.VaultEconomyAdapter;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import java.util.concurrent.Executor;
import net.milkbowl.vault.economy.Economy;
import net.tnemc.core.Reserve;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class TownyEconomyHandler {
    private static Towny plugin = null;
    private static EconomyAdapter economy = null;
    private static EcoType Type = EcoType.NONE;
    private static String version = "";
    private static final Executor ECONOMY_EXECUTOR = runnable -> {
        if (TownySettings.isEconomyAsync() && plugin.getScheduler().isTickThread()) {
            plugin.getScheduler().runAsync(runnable);
        } else if (!TownySettings.isEconomyAsync() && !plugin.getScheduler().isTickThread()) {
            plugin.getScheduler().run(runnable);
        } else {
            runnable.run();
        }
    };

    public static String getServerAccount() {
        return TownySettings.getString(ConfigNodes.ECO_CLOSED_ECONOMY_SERVER_ACCOUNT);
    }

    public static void initialize(Towny plugin) {
        TownyEconomyHandler.plugin = plugin;
    }

    public static EcoType getType() {
        return Type;
    }

    public static boolean isActive() {
        return Type != EcoType.NONE && TownySettings.isUsingEconomy();
    }

    public static String getVersion() {
        return version;
    }

    private static void setVersion(String version) {
        TownyEconomyHandler.version = version;
    }

    public static boolean setupEconomy() {
        try {
            RegisteredServiceProvider vaultEcoProvider = plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (vaultEcoProvider != null) {
                economy = new VaultEconomyAdapter((Economy)vaultEcoProvider.getProvider());
                TownyEconomyHandler.setVersion(String.format("%s %s", ((Economy)vaultEcoProvider.getProvider()).getName(), "via Vault"));
                Type = EcoType.VAULT;
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        Plugin economyProvider = plugin.getServer().getPluginManager().getPlugin("Reserve");
        if (economyProvider != null && ((Reserve)economyProvider).economyProvided()) {
            economy = new ReserveEconomyAdapter(((Reserve)economyProvider).economy());
            TownyEconomyHandler.setVersion(String.format("%s %s", ((Reserve)economyProvider).economy().name(), "via Reserve"));
            Type = EcoType.RESERVE;
            return true;
        }
        return false;
    }

    public static void removeAccount(String accountName) {
        economy.deleteAccount(accountName);
    }

    public static double getBalance(String accountName, World world) {
        TownyEconomyHandler.checkNewAccount(accountName);
        return economy.getBalance(accountName, world);
    }

    public static boolean hasEnough(String accountName, double amount, World world) {
        return TownyEconomyHandler.getBalance(accountName, world) >= amount;
    }

    private static boolean runPreChecks(Transaction transaction, String accountName) {
        TownyPreTransactionEvent preEvent = new TownyPreTransactionEvent(transaction);
        if (BukkitTools.isEventCancelled(preEvent)) {
            TownyMessaging.sendErrorMsg(transaction.getPlayer(), preEvent.getCancelMessage());
            return false;
        }
        TownyEconomyHandler.checkNewAccount(accountName);
        return true;
    }

    public static boolean subtract(String accountName, double amount, World world) {
        Player player = Bukkit.getServer().getPlayerExact(accountName);
        Transaction transaction = new Transaction(TransactionType.SUBTRACT, player, amount);
        TownyTransactionEvent event = new TownyTransactionEvent(transaction);
        if (!TownyEconomyHandler.runPreChecks(transaction, accountName)) {
            return false;
        }
        if (economy.subtract(accountName, amount, world)) {
            BukkitTools.fireEvent(event);
            return true;
        }
        return false;
    }

    public static boolean add(String accountName, double amount, World world) {
        Player player = Bukkit.getServer().getPlayerExact(accountName);
        Transaction transaction = new Transaction(TransactionType.ADD, player, amount);
        TownyTransactionEvent event = new TownyTransactionEvent(transaction);
        if (!TownyEconomyHandler.runPreChecks(transaction, accountName)) {
            return false;
        }
        if (economy.add(accountName, amount, world)) {
            BukkitTools.fireEvent(event);
            return true;
        }
        return false;
    }

    public static boolean setBalance(String accountName, double amount, World world) {
        TownyEconomyHandler.checkNewAccount(accountName);
        return economy.setBalance(accountName, amount, world);
    }

    public static String getFormattedBalance(double balance) {
        String formattedBalance = economy.getFormattedBalance(balance);
        if (formattedBalance != null) {
            return Colors.translateColorCodes(formattedBalance);
        }
        return Colors.translateColorCodes(String.format("%.2f", balance));
    }

    public static boolean addToServer(double amount, World world) {
        return TownyEconomyHandler.add(TownyEconomyHandler.getServerAccount(), amount, world);
    }

    public static boolean subtractFromServer(double amount, World world) {
        return TownyEconomyHandler.subtract(TownyEconomyHandler.getServerAccount(), amount, world);
    }

    private static void checkNewAccount(String accountName) {
        if (!economy.hasAccount(accountName)) {
            economy.newAccount(accountName);
        }
    }

    public static boolean hasAccount(String accountName) {
        return economy.hasAccount(accountName);
    }

    public static boolean isEssentials() {
        return TownyEconomyHandler.getVersion().startsWith("EssentialsX Economy") || TownyEconomyHandler.getVersion().startsWith("Essentials Economy");
    }

    public static Executor economyExecutor() {
        return ECONOMY_EXECUTOR;
    }

    public static enum EcoType {
        NONE,
        VAULT,
        RESERVE;

    }
}

