/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.adventure.text.format.NamedTextColor;
import com.palmergames.adventure.text.format.TextColor;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.asciimap.WildernessMapEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.map.TownyMapData;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Compass;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyAsciiMap {
    public static final int lineWidth = 27;
    public static final int halfLineWidth = 13;
    private static final int townBlockSize = TownySettings.getTownBlockSize();
    public static String forSaleSymbol = ConfigNodes.ASCII_MAP_SYMBOLS_FORSALE.getDefault();
    public static String homeSymbol = ConfigNodes.ASCII_MAP_SYMBOLS_HOME.getDefault();
    public static String outpostSymbol = ConfigNodes.ASCII_MAP_SYMBOLS_OUTPOST.getDefault();
    public static String wildernessSymbol = ConfigNodes.ASCII_MAP_SYMBOLS_WILDERNESS.getDefault();

    public static Component[] generateHelp(Player player) {
        Translator translator = Translator.locale((CommandSender)player);
        return new Component[]{((TextComponent)((TextComponent)Component.text("  ").append(Component.text("-", (TextColor)NamedTextColor.DARK_GRAY))).append(Component.text(" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_unclaimed").color(NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text("  ").append(Component.text("+", (TextColor)NamedTextColor.WHITE))).append(Component.text(" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_claimed").color(NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text("  ").append(Component.text("$", (TextColor)NamedTextColor.WHITE))).append(Component.text(" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_forsale").color(NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text("  ").append(Component.text("+", (TextColor)NamedTextColor.GREEN))).append(Component.text(" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_yourtown").color(NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text("  ").append(Component.text("+", (TextColor)NamedTextColor.YELLOW))).append(Component.text(" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_yourplot").color(NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text("  ").append(Component.text("+", (TextColor)NamedTextColor.DARK_GREEN))).append(Component.text(" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_ally").color(NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text("  ").append(Component.text("+", (TextColor)NamedTextColor.DARK_RED))).append(Component.text(" = ", (TextColor)NamedTextColor.GRAY))).append(translator.component("towny_map_enemy").color(NamedTextColor.GRAY))};
    }

    public static Component[] generateCompass(Player player) {
        Compass.Point dir = Compass.getCompassPointForDirection(player.getLocation().getYaw());
        return new Component[]{Component.text("  -----  ", (TextColor)NamedTextColor.BLACK), ((TextComponent)((TextComponent)((TextComponent)Component.text("  -", (TextColor)NamedTextColor.BLACK).append(Component.text(dir == Compass.Point.NW ? "\\" : "-", (TextColor)(dir == Compass.Point.NW ? NamedTextColor.GOLD : NamedTextColor.BLACK)))).append(Component.text("N", (TextColor)(dir == Compass.Point.N ? NamedTextColor.GOLD : NamedTextColor.WHITE)))).append(Component.text(dir == Compass.Point.NE ? "/" : "-", (TextColor)(dir == Compass.Point.NE ? NamedTextColor.GOLD : NamedTextColor.BLACK)))).append(Component.text("-  ", (TextColor)NamedTextColor.BLACK)), ((TextComponent)((TextComponent)((TextComponent)Component.text("  -", (TextColor)NamedTextColor.BLACK).append(Component.text("W", (TextColor)(dir == Compass.Point.W ? NamedTextColor.GOLD : NamedTextColor.WHITE)))).append(Component.text("+", (TextColor)NamedTextColor.GRAY))).append(Component.text("E", (TextColor)(dir == Compass.Point.E ? NamedTextColor.GOLD : NamedTextColor.WHITE)))).append(Component.text("-  ", (TextColor)NamedTextColor.BLACK)), ((TextComponent)((TextComponent)((TextComponent)Component.text("  -", (TextColor)NamedTextColor.BLACK).append(Component.text(dir == Compass.Point.SW ? "/" : "-", (TextColor)(dir == Compass.Point.SW ? NamedTextColor.GOLD : NamedTextColor.BLACK)))).append(Component.text("S", (TextColor)(dir == Compass.Point.S ? NamedTextColor.GOLD : NamedTextColor.WHITE)))).append(Component.text(dir == Compass.Point.SE ? "\\" : "-", (TextColor)(dir == Compass.Point.SE ? NamedTextColor.GOLD : NamedTextColor.BLACK)))).append(Component.text("-  ", (TextColor)NamedTextColor.BLACK))};
    }

    public static void generateAndSend(Towny plugin, Player player, int lineHeight) {
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered"));
            return;
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        World bukkitWorld = player.getWorld();
        if (world == null || bukkitWorld == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_configured"));
            return;
        }
        if (!world.isUsingTowny()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_set_use_towny_off"));
            return;
        }
        Coord pos = Coord.parseCoord(plugin.getCache(player).getLastLocation());
        Translator translator = Translator.locale((CommandSender)player);
        int halfLineHeight = lineHeight / 2;
        TextComponent[][] townyMap = new TextComponent[27][lineHeight];
        int y = 0;
        for (int tby = pos.getX() + 13; tby >= pos.getX() - 13; --tby) {
            int x = 0;
            for (int tbx = pos.getZ() - halfLineHeight; tbx <= pos.getZ() + (lineHeight - halfLineHeight - 1); ++tbx) {
                try {
                    townyMap[y][x] = (TextComponent)Component.empty().color(NamedTextColor.WHITE);
                    WorldCoord wc = new WorldCoord(bukkitWorld, new Coord(tby, tbx));
                    if (wc.isWilderness()) {
                        throw new TownyException();
                    }
                    TownBlock townblock = wc.getTownBlockOrNull();
                    Town town = townblock.getTownOrNull();
                    if (x == halfLineHeight && y == 13) {
                        townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.GOLD);
                    } else if (townblock.hasResident(resident)) {
                        townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.YELLOW);
                    } else if (resident.hasTown()) {
                        if (town.hasResident(resident)) {
                            townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.GREEN);
                        } else if (resident.hasNation()) {
                            Nation resNation = resident.getNationOrNull();
                            if (resNation.hasTown(town)) {
                                townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.DARK_GREEN);
                            } else if (town.hasNation()) {
                                Nation townBlockNation = town.getNationOrNull();
                                if (resNation.hasAlly(townBlockNation)) {
                                    townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.GREEN);
                                } else if (resNation.hasEnemy(townBlockNation)) {
                                    townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.DARK_RED);
                                }
                            }
                        }
                    }
                    if (townblock.getPlotPrice() != -1.0 || townblock.hasPlotObjectGroup() && townblock.getPlotObjectGroup().getPrice() != -1.0) {
                        if (townblock.getType().equals(TownBlockType.COMMERCIAL)) {
                            townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.BLUE);
                        }
                        townyMap[y][x] = townyMap[y][x].content(forSaleSymbol);
                    } else {
                        townyMap[y][x] = townblock.isHomeBlock() ? townyMap[y][x].content(homeSymbol) : (townblock.isOutpost() ? townyMap[y][x].content(outpostSymbol) : townyMap[y][x].content(townblock.getType().getAsciiMapKey()));
                    }
                    TextComponent residentComponent = Component.empty();
                    Component forSaleComponent = Component.empty();
                    Component claimedAtComponent = Component.empty();
                    Component groupComponent = Component.empty();
                    if (TownyEconomyHandler.isActive()) {
                        double cost;
                        double d = cost = townblock.hasPlotObjectGroup() ? townblock.getPlotObjectGroup().getPrice() : townblock.getPlotPrice();
                        if (cost > -1.0) {
                            forSaleComponent = TownyComponents.miniMessage(String.format(ChunkNotification.forSaleNotificationFormat, TownyEconomyHandler.getFormattedBalance(cost)).replaceAll("[\\[\\]]", "") + " " + translator.of("msg_click_purchase")).color(NamedTextColor.YELLOW).append(Component.newline());
                        }
                    }
                    if (townblock.getClaimedAt() > 0L) {
                        claimedAtComponent = translator.component("msg_plot_perm_claimed_at").color(NamedTextColor.DARK_GREEN).append(Component.space()).append(Component.text(TownyFormatter.registeredFormat.format(townblock.getClaimedAt()), (TextColor)NamedTextColor.GREEN)).append(Component.newline());
                    }
                    if (townblock.hasPlotObjectGroup()) {
                        groupComponent = translator.component("map_hover_plot_group").color(NamedTextColor.DARK_GREEN).append(Component.text(townblock.getPlotObjectGroup().getFormattedName(), (TextColor)NamedTextColor.GREEN).append(translator.component("map_hover_plot_group_size").color(NamedTextColor.DARK_GREEN).append(translator.component("map_hover_plots", townblock.getPlotObjectGroup().getTownBlocks().size()).color(NamedTextColor.GREEN).append(Component.newline()))));
                    }
                    if (townblock.hasResident()) {
                        residentComponent = Component.text(" (" + townblock.getResidentOrNull().getName() + ")", (TextColor)NamedTextColor.GREEN);
                    }
                    Component townComponent = translator.component("status_town").color(NamedTextColor.DARK_GREEN).append(Component.space()).append(Component.text(town.getName(), (TextColor)NamedTextColor.GREEN)).append(residentComponent).append(Component.text(" (" + tby + ", " + tbx + ")", (TextColor)NamedTextColor.WHITE)).append(Component.newline());
                    Component plotTypeComponent = translator.component("status_plot_type").color(NamedTextColor.DARK_GREEN).append(Component.space()).append(Component.text(townblock.getType().getName(), (TextColor)NamedTextColor.GREEN)).append(Component.newline());
                    Component hoverComponent = townComponent.append(plotTypeComponent).append(groupComponent).append(forSaleComponent).append(claimedAtComponent).append(translator.component("towny_map_detailed_information").color(NamedTextColor.DARK_GREEN));
                    ClickEvent clickEvent = forSaleComponent.equals(Component.empty()) ? ClickEvent.runCommand("/towny:plot info " + tby + " " + tbx) : ClickEvent.runCommand("/towny:plot claim " + world.getName() + " x" + tby + " z" + tbx);
                    townyMap[y][x] = (TextComponent)((TextComponent)townyMap[y][x].hoverEvent(HoverEvent.showText(hoverComponent))).clickEvent(clickEvent);
                }
                catch (TownyException e) {
                    String clickCommand;
                    TextComponent hoverText;
                    String symbol;
                    townyMap[y][x] = x == halfLineHeight && y == 13 ? (TextComponent)townyMap[y][x].color(NamedTextColor.GOLD) : (TextComponent)townyMap[y][x].color(NamedTextColor.DARK_GRAY);
                    WorldCoord wc = WorldCoord.parseWorldCoord(world.getName(), tby * townBlockSize, tbx * townBlockSize);
                    if (TownyAsciiMap.getWildernessMapDataMap().containsKey(wc) && !TownyAsciiMap.getWildernessMapDataMap().get(wc).isOld()) {
                        TownyMapData mapData = TownyAsciiMap.getWildernessMapDataMap().get(wc);
                        symbol = mapData.getSymbol();
                        hoverText = mapData.getHoverText();
                        clickCommand = mapData.getClickCommand();
                    } else {
                        TownyAsciiMap.getWildernessMapDataMap().remove(wc);
                        WildernessMapEvent wildMapEvent = new WildernessMapEvent(wc);
                        BukkitTools.fireEvent(wildMapEvent);
                        symbol = wildMapEvent.getMapSymbol();
                        hoverText = wildMapEvent.getHoverText();
                        clickCommand = wildMapEvent.getClickCommand();
                        TownyAsciiMap.getWildernessMapDataMap().put(wc, new TownyMapData(wc, symbol, hoverText, clickCommand));
                        plugin.getScheduler().runAsyncLater(() -> {
                            if (TownyAsciiMap.getWildernessMapDataMap().containsKey(wc) && TownyAsciiMap.getWildernessMapDataMap().get(wc).isOld()) {
                                TownyAsciiMap.getWildernessMapDataMap().remove(wc);
                            }
                        }, 700L);
                    }
                    townyMap[y][x] = (TextComponent)((TextComponent)townyMap[y][x].content(symbol).clickEvent(ClickEvent.runCommand(clickCommand))).hoverEvent(HoverEvent.showText(hoverText));
                }
                ++x;
            }
            ++y;
        }
        Component[] compass = TownyAsciiMap.generateCompass(player);
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(translator.of("towny_map_header") + "\u00a7f" + "(" + pos + ")"));
        Component[] map = new Component[lineHeight];
        Component[] help = TownyAsciiMap.generateHelp(player);
        int lineCount = 0;
        for (int my = 0; my < lineHeight; ++my) {
            map[lineCount] = Component.empty().append(compass[lineCount < compass.length ? lineCount : 0]);
            for (int mx = 26; mx >= 0; --mx) {
                map[lineCount] = map[lineCount].append(townyMap[mx][my]);
            }
            if (lineCount < help.length) {
                map[lineCount] = map[lineCount].append(help[lineCount]);
            }
            ++lineCount;
        }
        for (Component component : map) {
            Towny.getAdventure().player(player).sendMessage(component);
        }
        TownBlock townblock = TownyAPI.getInstance().getTownBlock(plugin.getCache(player).getLastLocation());
        TownyMessaging.sendMsg((CommandSender)player, translator.of("status_towny_map_town_line", townblock != null && townblock.hasTown() ? townblock.getTownOrNull() : translator.of("status_no_town"), townblock != null && townblock.hasResident() ? townblock.getResidentOrNull() : translator.of("status_no_town")));
    }

    private static Map<WorldCoord, TownyMapData> getWildernessMapDataMap() {
        return TownyUniverse.getInstance().getWildernessMapDataMap();
    }

    public static String parseSymbol(String symbol) {
        if (symbol.startsWith("\\u")) {
            return TownyAsciiMap.parseUnicode(symbol);
        }
        return symbol.substring(0, 1);
    }

    private static String parseUnicode(String symbol) {
        return String.valueOf(Character.toChars(Integer.parseInt(symbol.substring(2))));
    }

    static {
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"towny:ascii-map-symbols"), config -> {
            forSaleSymbol = TownyAsciiMap.parseSymbol(TownySettings.forSaleMapSymbol());
            homeSymbol = TownyAsciiMap.parseSymbol(TownySettings.homeBlockMapSymbol());
            outpostSymbol = TownyAsciiMap.parseSymbol(TownySettings.outpostMapSymbol());
            wildernessSymbol = TownyAsciiMap.parseSymbol(TownySettings.wildernessMapSymbol());
        });
    }
}

