/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.earth2me.essentials.Essentials;
import com.palmergames.adventure.platform.bukkit.BukkitAudiences;
import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.config.migration.ConfigMigrator;
import com.palmergames.bukkit.metrics.bukkit.Metrics;
import com.palmergames.bukkit.metrics.charts.SimplePie;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.TownyUpdateChecker;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.PlotCommand;
import com.palmergames.bukkit.towny.command.ResidentCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyAdminCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.command.TownyWorldCommand;
import com.palmergames.bukkit.towny.command.commandobjects.AcceptCommand;
import com.palmergames.bukkit.towny.command.commandobjects.CancelCommand;
import com.palmergames.bukkit.towny.command.commandobjects.ConfirmCommand;
import com.palmergames.bukkit.towny.command.commandobjects.DenyCommand;
import com.palmergames.bukkit.towny.db.DatabaseConfig;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.listeners.TownyBlockListener;
import com.palmergames.bukkit.towny.listeners.TownyCustomListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityMonitorListener;
import com.palmergames.bukkit.towny.listeners.TownyInventoryListener;
import com.palmergames.bukkit.towny.listeners.TownyLoginListener;
import com.palmergames.bukkit.towny.listeners.TownyPaperEvents;
import com.palmergames.bukkit.towny.listeners.TownyPlayerListener;
import com.palmergames.bukkit.towny.listeners.TownyServerListener;
import com.palmergames.bukkit.towny.listeners.TownyVehicleListener;
import com.palmergames.bukkit.towny.listeners.TownyWorldListener;
import com.palmergames.bukkit.towny.object.ChangelogResult;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.MetadataLoader;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.scheduling.TaskScheduler;
import com.palmergames.bukkit.towny.scheduling.impl.BukkitTaskScheduler;
import com.palmergames.bukkit.towny.scheduling.impl.FoliaTaskScheduler;
import com.palmergames.bukkit.towny.scheduling.impl.PaperTaskScheduler;
import com.palmergames.bukkit.towny.tasks.OnPlayerLogin;
import com.palmergames.bukkit.towny.utils.ChangelogReader;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Version;
import com.palmergames.paperlib.PaperLib;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.JavaUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class Towny
extends JavaPlugin {
    private static Towny plugin;
    private final String version = this.getDescription().getVersion();
    private TownyUniverse townyUniverse;
    private final boolean isFolia = JavaUtil.classExists("io.papermc.paper.threadedregions.RegionizedServer");
    private final TaskScheduler scheduler;
    private static BukkitAudiences adventure;
    private final Map<UUID, PlayerCache> playerCache = Collections.synchronizedMap(new HashMap());
    private final List<TownyInitException.TownyError> errors = new ArrayList<TownyInitException.TownyError>();

    public Towny() {
        plugin = this;
        this.scheduler = this.isFolia() ? new FoliaTaskScheduler((Plugin)this) : (this.expandedSchedulingAvailable() ? new PaperTaskScheduler((Plugin)this) : new BukkitTaskScheduler((Plugin)this));
    }

    public void onEnable() {
        Bukkit.getLogger().info("====================      Towny      ========================");
        this.townyUniverse = TownyUniverse.getInstance();
        BukkitTools.initialize(this);
        TownyTimerHandler.initialize(this);
        TownyEconomyHandler.initialize(this);
        TownyFormatter.initialize();
        PlayerCacheUtil.initialize(this);
        TownyPerms.initialize(this);
        InviteHandler.initialize(this);
        try {
            this.loadFoundation(false);
            PluginIntegrations.getInstance().checkForPlugins(this);
            this.cycleTimers();
            this.resetCache();
            if (Towny.isMinecraftVersionStillSupported()) {
                TownyUpdateChecker.checkForUpdates(this);
            }
            SpawnUtil.initialize(this);
            this.registerSpecialCommands();
            this.registerCommands();
            this.addMetricsCharts();
        }
        catch (TownyInitException tie) {
            this.addError(tie.getError());
            this.getLogger().log(Level.SEVERE, tie.getMessage(), tie);
        }
        adventure = BukkitAudiences.create((Plugin)this);
        if (!this.isError()) {
            if (TownySettings.isTownyUpdating(this.getVersion())) {
                this.printChangelogToConsole();
                this.townyUniverse.getDataSource().saveAll();
                this.townyUniverse.getDataSource().cleanup();
            }
            if (!TownySettings.getLastRunVersion().equals(this.getVersion())) {
                TownySettings.setLastRunVersion(this.getVersion());
            }
        }
        if (!this.isError(TownyInitException.TownyError.MAIN_CONFIG) && !this.isError(TownyInitException.TownyError.PERMISSIONS)) {
            TownyPerms.registerPermissionNodes();
        }
        this.registerEvents();
        Bukkit.getLogger().info("=============================================================");
        if (this.isError()) {
            plugin.getLogger().warning("[WARNING] - ***** SAFE MODE ***** " + this.version);
        } else {
            plugin.getLogger().info("Version: " + this.version + " - Plugin Enabled");
        }
        Bukkit.getLogger().info("=============================================================");
        if (!this.isError()) {
            for (Player player : BukkitTools.getOnlinePlayers()) {
                if (player == null) continue;
                if (player.getName().contains(" ")) {
                    player.kickPlayer("Invalid name!");
                    return;
                }
                this.scheduler.run(new OnPlayerLogin(this, player));
            }
        }
    }

    public void loadFoundation(boolean reload) {
        this.handleLegacyConfigs();
        this.loadDatabaseConfig(reload);
        this.loadConfig(reload);
        this.loadLocalization(reload);
        this.loadPermissions(reload);
        PluginIntegrations.getInstance().unloadPAPIExpansion(reload);
        TownBlockTypeHandler.initialize();
        TownyLogger.getInstance();
        this.townyUniverse.clearAllObjects();
        this.townyUniverse.loadAndSaveDatabase(TownySettings.getLoadDatabase(), TownySettings.getSaveDatabase());
        MetadataLoader.getInstance().scheduleDeserialization();
        if (!TownySettings.getLastRunVersion().equals(this.getVersion())) {
            ConfigMigrator migrator = new ConfigMigrator(TownySettings.getConfig(), "config-migration.json", false);
            migrator.migrate();
        }
        this.loadTownAndNationLevels();
        PluginIntegrations.getInstance().loadPAPIExpansion(reload);
        this.townyUniverse.performCleanupAndBackup();
    }

    private void loadConfig(boolean reload) {
        TownySettings.loadConfig(this.getDataFolder().toPath().resolve("settings").resolve("config.yml"), this.getVersion());
        if (reload) {
            if (this.isError(TownyInitException.TownyError.MAIN_CONFIG)) {
                this.removeError(TownyInitException.TownyError.MAIN_CONFIG);
            }
            TownyMessaging.sendMsg(Translatable.of("msg_reloaded_config"));
        }
    }

    private void loadLocalization(boolean reload) {
        Translation.loadTranslationRegistry();
        if (reload) {
            if (this.isError(TownyInitException.TownyError.LOCALIZATION)) {
                this.removeError(TownyInitException.TownyError.LOCALIZATION);
            }
            TownyMessaging.sendMsg(Translatable.of("msg_reloaded_lang"));
        }
    }

    private void loadDatabaseConfig(boolean reload) {
        if (!this.checkForLegacyDatabaseConfig()) {
            throw new TownyInitException("Unable to migrate old database settings to Towny\\data\\settings\\database.yml", TownyInitException.TownyError.DATABASE_CONFIG);
        }
        DatabaseConfig.loadDatabaseConfig(this.getDataFolder().toPath().resolve("settings").resolve("database.yml"));
        if (reload && this.isError(TownyInitException.TownyError.DATABASE_CONFIG)) {
            this.removeError(TownyInitException.TownyError.DATABASE_CONFIG);
        }
    }

    public void loadPermissions(boolean reload) {
        TownyPerms.loadPerms(this.getDataFolder().toPath().resolve("settings").resolve("townyperms.yml"));
        if (reload) {
            if (this.isError(TownyInitException.TownyError.PERMISSIONS)) {
                this.removeError(TownyInitException.TownyError.PERMISSIONS);
            }
            TownyPerms.updateOnlinePerms();
        }
    }

    private void loadTownAndNationLevels() throws TownyInitException {
        try {
            TownySettings.loadTownLevelConfig();
        }
        catch (TownyException e) {
            throw new TownyInitException("Failed to load town level config", TownyInitException.TownyError.MAIN_CONFIG, e);
        }
        try {
            TownySettings.loadNationLevelConfig();
        }
        catch (TownyException e) {
            throw new TownyInitException("Failed to load nation level config", TownyInitException.TownyError.MAIN_CONFIG, e);
        }
    }

    private void handleLegacyConfigs() {
        Path configPath = Towny.getPlugin().getDataFolder().toPath().resolve("settings").resolve("config.yml");
        if (!Files.exists(configPath, new LinkOption[0])) {
            return;
        }
        CommentedConfiguration config = new CommentedConfiguration(configPath);
        if (!config.load() || config.getString(ConfigNodes.LAST_RUN_VERSION.getRoot(), "0.0.0.0").equals(this.getVersion())) {
            return;
        }
        TownBlockTypeHandler.Migrator.checkForLegacyOptions(config);
        ConfigMigrator earlyMigrator = new ConfigMigrator(config, "config-migration.json", true);
        earlyMigrator.migrate();
    }

    private boolean checkForLegacyDatabaseConfig() {
        Path configYMLPath = this.getDataFolder().toPath().resolve("settings").resolve("config.yml");
        if (!Files.exists(configYMLPath, new LinkOption[0])) {
            return true;
        }
        CommentedConfiguration config = new CommentedConfiguration(configYMLPath);
        if (!config.load()) {
            return false;
        }
        if (config.contains("plugin.database.database_load")) {
            String dbload = config.getString("plugin.database.database_load");
            String dbsave = config.getString("plugin.database.database_save");
            String hostname = config.getString("plugin.database.sql.hostname");
            String port = config.getString("plugin.database.sql.port");
            String dbname = config.getString("plugin.database.sql.dbname");
            String tableprefix = config.getString("plugin.database.sql.table_prefix");
            String username = config.getString("plugin.database.sql.username");
            String password = config.getString("plugin.database.sql.password");
            String flags = config.getString("plugin.database.sql.flags");
            String max_pool = config.getString("plugin.database.sql.pooling.max_pool_size");
            String max_lifetime = config.getString("plugin.database.sql.pooling.max_lifetime");
            String connection_timeout = config.getString("plugin.database.sql.pooling.connection_timeout");
            Path databaseYMLPath = this.getDataFolder().toPath().resolve("settings").resolve("database.yml");
            if (FileMgmt.checkOrCreateFile(databaseYMLPath.toString())) {
                CommentedConfiguration databaseConfig = new CommentedConfiguration(databaseYMLPath);
                databaseConfig.set("database.database_load", dbload);
                databaseConfig.set("database.database_save", dbsave);
                databaseConfig.set("database.sql.hostname", hostname);
                databaseConfig.set("database.sql.port", port);
                databaseConfig.set("database.sql.dbname", dbname);
                databaseConfig.set("database.sql.table_prefix", tableprefix);
                databaseConfig.set("database.sql.username", username);
                databaseConfig.set("database.sql.password", password);
                databaseConfig.set("database.sql.flags", flags);
                databaseConfig.set("database.sql.pooling.max_pool_size", max_pool);
                databaseConfig.set("database.sql.pooling.max_lifetime", max_lifetime);
                databaseConfig.set("database.sql.pooling.connection_timeout", connection_timeout);
                databaseConfig.save();
                this.getLogger().info("Database settings migrated to towny\\data\\settings\\database.yml");
            } else {
                this.getLogger().severe("Unable to migrate old database settings to towny\\data\\settings\\database.yml");
                return false;
            }
        }
        return true;
    }

    public void onDisable() {
        Bukkit.getLogger().info("==============================================================");
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (townyUniverse.getDataSource() != null && !this.isError(TownyInitException.TownyError.DATABASE)) {
            townyUniverse.getDataSource().saveQueues();
            townyUniverse.getDataSource().saveCooldowns();
            plugin.getLogger().info("Finishing File IO Tasks...");
            townyUniverse.getDataSource().finishTasks();
        }
        this.toggleTimersOff();
        TownyRegenAPI.cancelProtectionRegenTasks();
        this.playerCache.clear();
        plugin.getLogger().info("Finishing Universe Tasks...");
        townyUniverse.finishTasks();
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
        PluginIntegrations.getInstance().disable3rdPartyPluginIntegrations();
        this.townyUniverse = null;
        plugin.getLogger().info("Version: " + this.version + " - Plugin Disabled");
        Bukkit.getLogger().info("=============================================================");
    }

    private void cycleTimers() {
        this.toggleTimersOff();
        TownyTimerHandler.toggleTownyRepeatingTimer(true);
        TownyTimerHandler.toggleDailyTimer(true);
        TownyTimerHandler.toggleHourlyTimer(true);
        TownyTimerHandler.toggleShortTimer(true);
        TownyTimerHandler.toggleMobRemoval(true);
        TownyTimerHandler.toggleHealthRegen(TownySettings.hasHealthRegen());
        TownyTimerHandler.toggleTeleportWarmup(TownySettings.getTeleportWarmupTime() > 0);
        TownyTimerHandler.toggleCooldownTimer(true);
        TownyTimerHandler.toggleDrawSmokeTask(true);
        TownyTimerHandler.toggleDrawSpointsTask(TownySettings.getVisualizedSpawnPointsEnabled());
    }

    private void toggleTimersOff() {
        TownyTimerHandler.toggleTownyRepeatingTimer(false);
        TownyTimerHandler.toggleDailyTimer(false);
        TownyTimerHandler.toggleHourlyTimer(false);
        TownyTimerHandler.toggleShortTimer(false);
        TownyTimerHandler.toggleMobRemoval(false);
        TownyTimerHandler.toggleHealthRegen(false);
        TownyTimerHandler.toggleTeleportWarmup(false);
        TownyTimerHandler.toggleCooldownTimer(false);
        TownyTimerHandler.toggleDrawSmokeTask(false);
        TownyTimerHandler.toggleDrawSpointsTask(false);
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (!this.isError()) {
            pluginManager.registerEvents((Listener)new HUDManager(this), (Plugin)this);
            pluginManager.registerEvents((Listener)new TownyEntityMonitorListener(this), (Plugin)this);
            pluginManager.registerEvents((Listener)new TownyVehicleListener(this), (Plugin)this);
            pluginManager.registerEvents((Listener)new TownyServerListener(this), (Plugin)this);
            pluginManager.registerEvents((Listener)new TownyCustomListener(this), (Plugin)this);
            pluginManager.registerEvents((Listener)new TownyWorldListener(this), (Plugin)this);
            pluginManager.registerEvents((Listener)new TownyLoginListener(), (Plugin)this);
        }
        pluginManager.registerEvents((Listener)new TownyPlayerListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new TownyBlockListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new TownyEntityListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new TownyInventoryListener(this), (Plugin)this);
        new TownyPaperEvents(this).register();
    }

    private void printChangelogToConsole() {
        try (InputStream is = JavaUtil.readResource("/ChangeLog.txt");){
            String lastVersion = Version.fromString(TownySettings.getLastRunVersion()).toString();
            ChangelogReader reader = ChangelogReader.reader(lastVersion, is, 100);
            ChangelogResult result = reader.read();
            if (!result.successful()) {
                plugin.getLogger().warning("Could not find starting index for the changelog.");
                return;
            }
            plugin.getLogger().info("------------------------------------");
            plugin.getLogger().info("ChangeLog since v" + lastVersion + ":");
            for (String line : result.lines()) {
                if (line.trim().replaceAll("\t", "").isEmpty()) continue;
                Bukkit.getConsoleSender().sendMessage(line.trim().startsWith("-") ? line : "\u00a7e" + line);
            }
            if (result.limitReached()) {
                plugin.getLogger().info("<snip>");
                plugin.getLogger().info("Changelog continues for another " + (result.totalSize() - (result.nextVersionIndex() + 99)) + " lines.");
                plugin.getLogger().info("To read the full changelog since " + lastVersion + ", go to https://github.com/TownyAdvanced/Towny/blob/master/resources/ChangeLog.txt#L" + (result.nextVersionIndex() + 1));
            }
            plugin.getLogger().info("------------------------------------");
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Could not read ChangeLog.txt", e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isError() {
        return !this.errors.isEmpty();
    }

    private boolean isError(@NotNull TownyInitException.TownyError error) {
        return this.errors.contains((Object)error);
    }

    public void addError(@NotNull TownyInitException.TownyError error) {
        this.errors.add(error);
    }

    private void removeError(@NotNull TownyInitException.TownyError error) {
        this.errors.remove((Object)error);
    }

    @NotNull
    public List<TownyInitException.TownyError> getErrors() {
        return this.errors;
    }

    @Deprecated
    public boolean isEssentials() {
        return false;
    }

    @Deprecated
    public boolean isCitizens2() {
        return false;
    }

    @Deprecated
    public Essentials getEssentials() {
        return (Essentials)this.getServer().getPluginManager().getPlugin("Essentials");
    }

    @Deprecated
    public boolean isPAPI() {
        return false;
    }

    public World getServerWorld(String name) throws NotRegisteredException {
        World world = BukkitTools.getWorld(name);
        if (world == null) {
            throw new NotRegisteredException(String.format("A world called '$%s' has not been registered.", name));
        }
        return world;
    }

    public boolean hasCache(Player player) {
        return this.playerCache.containsKey(player.getUniqueId());
    }

    public PlayerCache newCache(Player player) {
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (world == null) {
            TownyMessaging.sendErrorMsg(player, "Could not create permission cache for this world (" + player.getWorld().getName() + ".");
            return null;
        }
        PlayerCache cache = new PlayerCache(world, player);
        this.playerCache.put(player.getUniqueId(), cache);
        return cache;
    }

    public void deleteCache(Resident resident) {
        Player player = resident.getPlayer();
        if (player != null) {
            this.deleteCache(player);
        }
    }

    public void deleteCache(Player player) {
        this.deleteCache(player.getUniqueId());
    }

    public void deleteCache(UUID uuid) {
        this.playerCache.remove(uuid);
    }

    public PlayerCache getCache(Player player) {
        PlayerCache cache = this.playerCache.get(player.getUniqueId());
        if (cache == null && (cache = this.newCache(player)) != null) {
            cache.setLastTownBlock(WorldCoord.parseWorldCoord((Entity)player));
        }
        return cache;
    }

    public PlayerCache getCacheOrNull(@NotNull UUID uuid) {
        return this.playerCache.get(uuid);
    }

    public void resetCache() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            this.getCache(player).resetAndUpdate(WorldCoord.parseWorldCoord((Entity)player));
        }
    }

    public void updateCache(WorldCoord worldCoord) {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !WorldCoord.parseWorldCoord((Entity)player).equals(worldCoord)) continue;
            this.getCache(player).resetAndUpdate(worldCoord);
        }
    }

    public void updateCache() {
        WorldCoord worldCoord = null;
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            worldCoord = WorldCoord.parseWorldCoord((Entity)player);
            PlayerCache cache = this.getCache(player);
            if (cache.getLastTownBlock() == worldCoord) continue;
            cache.resetAndUpdate(worldCoord);
        }
    }

    public void updateCache(Player player) {
        WorldCoord worldCoord = WorldCoord.parseWorldCoord((Entity)player);
        PlayerCache cache = this.getCache(player);
        if (!cache.getLastTownBlock().equals(worldCoord)) {
            cache.resetAndUpdate(worldCoord);
        }
    }

    public void resetCache(Player player) {
        this.getCache(player).resetAndUpdate(WorldCoord.parseWorldCoord((Entity)player));
    }

    public void setPlayerMode(Player player, String[] modes, boolean notify) {
        if (player == null) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(player.getName());
        if (resident != null) {
            resident.setModes(modes, notify);
        }
    }

    public void removePlayerMode(Player player) {
        Resident resident = TownyUniverse.getInstance().getResident(player.getName());
        if (resident != null) {
            resident.clearModes();
        }
    }

    public List<String> getPlayerMode(Player player) {
        return this.getPlayerMode(player.getName());
    }

    public List<String> getPlayerMode(String name) {
        Resident resident = TownyUniverse.getInstance().getResident(name);
        return resident != null ? resident.getModes() : null;
    }

    public boolean hasPlayerMode(Player player, String mode) {
        return this.hasPlayerMode(player.getUniqueId(), mode);
    }

    public boolean hasPlayerMode(UUID uuid, String mode) {
        Resident resident = TownyUniverse.getInstance().getResident(uuid);
        return resident != null && resident.hasMode(mode);
    }

    public boolean hasPlayerMode(String name, String mode) {
        Resident resident = TownyUniverse.getInstance().getResident(name);
        return resident != null && resident.hasMode(mode);
    }

    public String getConfigPath() {
        return this.getDataFolder().getPath() + File.separator + "settings" + File.separator + "config.yml";
    }

    public Object getSetting(String root) {
        return TownySettings.getProperty(root);
    }

    @NotNull
    public static Towny getPlugin() {
        if (plugin == null) {
            throw new IllegalStateException("Attempted to use getPlugin() while the plugin is null, are you shading Towny? If you do not understand this message, join the Towny discord using https://discord.com/invite/gnpVs5m and ask for support.");
        }
        return plugin;
    }

    public static BukkitAudiences getAdventure() {
        return adventure;
    }

    private void registerSpecialCommands() {
        ArrayList<BukkitCommand> commands = new ArrayList<BukkitCommand>(4);
        commands.add(new AcceptCommand(TownySettings.getAcceptCommand()));
        commands.add(new DenyCommand(TownySettings.getDenyCommand()));
        commands.add(new ConfirmCommand(TownySettings.getConfirmCommand()));
        commands.add(new CancelCommand(TownySettings.getCancelCommand()));
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            commandMap.registerAll("towny", commands);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new TownyInitException("An issue has occured while registering custom commands.", TownyInitException.TownyError.OTHER, e);
        }
    }

    private void registerCommands() {
        this.getCommand("townyadmin").setExecutor((CommandExecutor)new TownyAdminCommand(this));
        this.getCommand("townyworld").setExecutor((CommandExecutor)new TownyWorldCommand(this));
        this.getCommand("resident").setExecutor((CommandExecutor)new ResidentCommand(this));
        this.getCommand("towny").setExecutor((CommandExecutor)new TownyCommand(this));
        TownCommand townCommandExecutor = new TownCommand(this);
        this.getCommand("town").setExecutor((CommandExecutor)townCommandExecutor);
        this.getCommand("t").setTabCompleter((TabCompleter)townCommandExecutor);
        this.getCommand("nation").setExecutor((CommandExecutor)new NationCommand(this));
        this.getCommand("plot").setExecutor((CommandExecutor)new PlotCommand(this));
        this.getCommand("invite").setExecutor((CommandExecutor)new InviteCommand(this));
    }

    private void addMetricsCharts() {
        Metrics metrics = new Metrics(this, 2244);
        metrics.addCustomChart(new SimplePie("language", () -> TownySettings.getString(ConfigNodes.LANGUAGE)));
        metrics.addCustomChart(new SimplePie("server_type", () -> {
            if (this.isFolia) {
                return "Folia";
            }
            if (PaperLib.isPaper()) {
                return "Paper";
            }
            if (PaperLib.isSpigot()) {
                return "Spigot";
            }
            if (this.getServer().getName().equalsIgnoreCase("craftbukkit")) {
                return "CraftBukkit";
            }
            return "Unknown";
        }));
        metrics.addCustomChart(new SimplePie("nation_zones_enabled", () -> TownySettings.getNationZonesEnabled() ? "true" : "false"));
        metrics.addCustomChart(new SimplePie("database_type", () -> TownySettings.getSaveDatabase().toLowerCase()));
        metrics.addCustomChart(new SimplePie("town_block_size", () -> String.valueOf(TownySettings.getTownBlockSize())));
        metrics.addCustomChart(new SimplePie("closed_economy_enabled", () -> String.valueOf(TownySettings.isEcoClosedEconomyEnabled())));
        metrics.addCustomChart(new SimplePie("resident_uuids_stored", TownySettings::getUUIDPercent));
    }

    public static boolean isTownyVersionSupported(String version) {
        return Version.fromString(Towny.getPlugin().getVersion()).isNewerThanOrEquals(Version.fromString(version));
    }

    public static boolean isMinecraftVersionStillSupported() {
        return MinecraftVersion.CURRENT_VERSION.isNewerThanOrEquals(MinecraftVersion.OLDEST_VERSION_SUPPORTED);
    }

    @Deprecated
    public static boolean is116Plus() {
        return true;
    }

    @ApiStatus.Internal
    public boolean isFolia() {
        return this.isFolia;
    }

    private boolean expandedSchedulingAvailable() {
        return JavaUtil.classExists("io.papermc.paper.threadedregions.scheduler.ScheduledTask");
    }

    @NotNull
    public TaskScheduler getScheduler() {
        return this.scheduler;
    }
}

