/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.config;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.util.StringMgmt;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class CommentedConfiguration
extends YamlConfiguration {
    private final HashMap<String, String> comments = new HashMap();
    private final Path path;
    private final Logger logger;
    private final String newLine = System.getProperty("line.separator");
    private int depth;

    public CommentedConfiguration(Path path) {
        this.path = path;
        this.logger = Towny.getPlugin().getLogger();
        this.setWidth();
    }

    public CommentedConfiguration(Path path, Plugin plugin) {
        this.path = path;
        this.logger = plugin.getLogger();
        this.setWidth();
    }

    public CommentedConfiguration(File file) {
        this.path = file.toPath();
        this.logger = Towny.getPlugin().getLogger();
        this.setWidth();
    }

    public boolean load() {
        return this.loadFile();
    }

    private boolean loadFile() {
        try {
            this.load(this.path.toFile());
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            this.logger.warning(String.format("Loading error: Failed to load file %s (does it pass a yaml parser?).", this.path));
            this.logger.warning("https://jsonformatter.org/yaml-parser");
            this.logger.warning(e.getMessage());
            return false;
        }
    }

    public void save() {
        boolean saved = this.saveFile();
        if (!this.comments.isEmpty() && saved) {
            List<String> yamlContents = this.readYaml();
            StringBuilder newContents = this.readConfigToString(yamlContents);
            this.writeYaml(newContents);
        }
    }

    private List<String> readYaml() {
        ArrayList<String> yamlContents = new ArrayList();
        try {
            yamlContents = Files.readAllLines(this.path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.warning(String.format("Failed to read file %s.", this.path));
            this.logger.warning(e.getMessage());
        }
        return yamlContents;
    }

    private void writeYaml(StringBuilder newContents) {
        try {
            Files.write(this.path, newContents.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            this.logger.warning(String.format("Saving error: Failed to write to file %s.", this.path));
            this.logger.warning(e.getMessage());
        }
    }

    private boolean saveFile() {
        try {
            this.save(this.path.toFile());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private StringBuilder readConfigToString(List<String> oldContents) {
        StringBuilder newContents = new StringBuilder();
        String currentPath = "";
        this.depth = 0;
        for (String line : oldContents) {
            String comment;
            if (line.trim().startsWith("#") || line.isEmpty() || line.trim().isEmpty()) continue;
            if ((line.contains(": ") || line.length() > 1 && line.charAt(line.length() - 1) == ':') && (comment = this.comments.get(currentPath = this.getCurrentPath(line, currentPath))) != null) {
                line = comment + this.newLine + line;
            }
            newContents.append(line).append(this.newLine);
        }
        return newContents;
    }

    private String getCurrentPath(String line, String currentPath) {
        int index = line.indexOf(": ");
        if (index < 0) {
            index = line.length() - 1;
        }
        if (currentPath.isEmpty()) {
            currentPath = line.substring(0, index);
        } else {
            int whiteSpace = this.getWhiteSpaceFromLine(line);
            String nodeName = line.substring(whiteSpace, index);
            if (whiteSpace / 2 > this.depth) {
                currentPath = currentPath + "." + nodeName;
                ++this.depth;
            } else if (whiteSpace / 2 < this.depth) {
                int newDepth = whiteSpace / 2;
                currentPath = this.shrinkCurrentPath(currentPath, newDepth);
                currentPath = this.addNodeNameToCurrentPath(currentPath, nodeName);
                this.depth = newDepth;
            } else {
                currentPath = this.addNodeNameToCurrentPath(currentPath, nodeName);
            }
        }
        return currentPath;
    }

    private int getWhiteSpaceFromLine(String line) {
        int whiteSpace = 0;
        for (int n = 0; n < line.length() && line.charAt(n) == ' '; ++n) {
            ++whiteSpace;
        }
        return whiteSpace;
    }

    private String shrinkCurrentPath(String currentPath, int newDepth) {
        for (int i = 0; i < this.depth - newDepth; ++i) {
            currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
        }
        return currentPath;
    }

    private String addNodeNameToCurrentPath(String currentPath, String nodeName) {
        int lastIndex = currentPath.lastIndexOf(".");
        if (lastIndex < 0) {
            currentPath = "";
        } else {
            currentPath = currentPath.replace(currentPath.substring(lastIndex), "");
            currentPath = currentPath + ".";
        }
        currentPath = currentPath + nodeName;
        return currentPath;
    }

    public void addComment(String path, String ... commentLines) {
        StringBuilder commentBlock = new StringBuilder();
        String leadingSpaces = StringMgmt.repeat("  ", (int)path.chars().filter(ch -> ch == 46).count());
        for (String commentLine : commentLines) {
            String string = commentLine = !commentLine.isEmpty() ? leadingSpaces + commentLine : "  ";
            if (commentBlock.length() > 0) {
                commentBlock.append(this.newLine);
            }
            commentBlock.append(commentLine);
        }
        this.comments.put(path, commentBlock.toString());
    }

    private void setWidth() {
        try {
            this.options().width(10000);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }
}

