/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.eventwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.EventWarEndEvent;
import com.palmergames.bukkit.towny.event.EventWarPreStartEvent;
import com.palmergames.bukkit.towny.event.EventWarStartEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.war.eventwar.PlotAttackedEvent;
import com.palmergames.bukkit.towny.war.eventwar.StartWarTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.TownScoredEvent;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import com.palmergames.bukkit.towny.war.eventwar.WarTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.WarZoneData;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.ServerBroadCastTimerTask;
import com.palmergames.util.KeyValue;
import com.palmergames.util.KeyValueTable;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;

public class War {
    private static Hashtable<WorldCoord, Integer> warZone = new Hashtable();
    private Hashtable<Town, Integer> townScores = new Hashtable();
    public static List<Town> warringTowns = new ArrayList<Town>();
    public static List<Nation> warringNations = new ArrayList<Nation>();
    private WarSpoils warSpoils = new WarSpoils();
    private Towny plugin;
    private boolean warTime = false;
    private List<Integer> warTaskIds = new ArrayList<Integer>();

    public War(Towny plugin, int startDelay) {
        this.plugin = plugin;
        TownyUniverse.getInstance();
        this.setupDelay(startDelay);
    }

    public void addTaskId(int id) {
        this.warTaskIds.add(id);
    }

    public void clearTaskIds() {
        this.warTaskIds.clear();
    }

    public void cancelTasks(BukkitScheduler scheduler) {
        for (Integer id : this.getTaskIds()) {
            scheduler.cancelTask(id.intValue());
        }
        this.clearTaskIds();
    }

    public void setPlugin(Towny plugin) {
        this.plugin = plugin;
    }

    public List<Integer> getTaskIds() {
        return new ArrayList<Integer>(this.warTaskIds);
    }

    public Towny getPlugin() {
        return this.plugin;
    }

    public boolean isWarTime() {
        return this.warTime;
    }

    public WarSpoils getWarSpoils() {
        return this.warSpoils;
    }

    public Hashtable<Town, Integer> getTownScores() {
        return this.townScores;
    }

    public Hashtable<WorldCoord, Integer> getWarZone() {
        return warZone;
    }

    public List<Town> getWarringTowns() {
        return warringTowns;
    }

    public static boolean isWarZone(WorldCoord worldCoord) {
        return warZone.containsKey(worldCoord);
    }

    public boolean isWarringNation(Nation nation) {
        return warringNations.contains(nation);
    }

    public static boolean isWarringTown(Town town) {
        return warringTowns.contains(town);
    }

    public void toggleEnd() {
        this.warTime = false;
    }

    public void setupDelay(int delay) {
        if (delay <= 0) {
            this.start();
        } else {
            for (Long t : TimeMgmt.getCountdownDelays(delay, TimeMgmt.defaultCountdownDelays)) {
                int id = BukkitTools.scheduleAsyncDelayedTask(new ServerBroadCastTimerTask(this.plugin, Translation.of("war_starts_in_x", TimeMgmt.formatCountdownTime(t))), TimeTools.convertToTicks((long)delay - t));
                if (id == -1) {
                    TownyMessaging.sendErrorMsg("Could not schedule a countdown message for war event.");
                    this.end();
                    continue;
                }
                this.addTaskId(id);
            }
            int id = BukkitTools.scheduleAsyncDelayedTask(new StartWarTimerTask(this.plugin), TimeTools.convertToTicks(delay));
            if (id == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule setup delay for war event.");
                this.end();
            } else {
                this.addTaskId(id);
            }
        }
    }

    public void start() {
        warZone.clear();
        warringNations.clear();
        warringTowns.clear();
        this.townScores.clear();
        this.warTaskIds.clear();
        EventWarPreStartEvent preEvent = new EventWarPreStartEvent();
        Bukkit.getServer().getPluginManager().callEvent((Event)preEvent);
        if (preEvent.getWarSpoils() != 0.0) {
            this.warSpoils.deposit(preEvent.getWarSpoils(), "WarSpoils EventWarPreStartEvent Added");
        }
        for (Nation nation : TownyUniverse.getInstance().getNations()) {
            if (!nation.isNeutral()) {
                this.add(nation);
                if (!warringNations.contains(nation)) continue;
                TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_war_join_nation", nation.getName()));
                continue;
            }
            if (TownySettings.isDeclaringNeutral()) continue;
            nation.setNeutral(false);
            this.add(nation);
            if (!warringNations.contains(nation)) continue;
            TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_war_join_forced", nation.getName()));
        }
        if (warringNations.size() < 2) {
            TownyMessaging.sendGlobalMessage(Translation.of("msg_war_not_enough_nations"));
            warringNations.clear();
            warringTowns.clear();
            return;
        }
        boolean enemy = false;
        block1: for (Nation nation : warringNations) {
            for (Nation nation2 : warringNations) {
                if (!nation.hasEnemy(nation2) || !nation2.hasEnemy(nation)) continue;
                enemy = true;
                continue block1;
            }
        }
        if (!enemy) {
            TownyMessaging.sendGlobalMessage(Translation.of("msg_war_no_enemies_for_war"));
            return;
        }
        this.outputParticipants();
        this.warTime = true;
        this.warSpoils.deposit(TownySettings.getBaseSpoilsOfWar(), "Start of War - Base Spoils");
        TownyMessaging.sendGlobalMessage(Translation.of("msg_war_seeding_spoils_with", TownySettings.getBaseSpoilsOfWar()));
        TownyMessaging.sendGlobalMessage(Translation.of("msg_war_total_seeding_spoils", this.warSpoils.getHoldingBalance()));
        TownyMessaging.sendGlobalMessage(Translation.of("msg_war_activate_war_hud_tip"));
        EventWarStartEvent eventWarStartEvent = new EventWarStartEvent(warringTowns, warringNations, this.warSpoils.getHoldingBalance());
        Bukkit.getServer().getPluginManager().callEvent((Event)eventWarStartEvent);
        int id = BukkitTools.scheduleAsyncRepeatingTask(new WarTimerTask(this.plugin, this), 0L, TimeTools.convertToTicks(5L));
        if (id == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule war event loop.");
            this.end();
        } else {
            this.addTaskId(id);
        }
        this.checkEnd();
    }

    private void outputParticipants() {
        ArrayList<String> warParticipants = new ArrayList<String>();
        for (Nation nation : warringNations) {
            int towns = 0;
            for (Town town : nation.getTowns()) {
                if (!warringTowns.contains(town)) continue;
                ++towns;
            }
            warParticipants.add(Translation.of("msg_war_participants", nation.getName(), towns));
        }
        TownyMessaging.sendPlainGlobalMessage(ChatTools.formatTitle("War Participants"));
        TownyMessaging.sendPlainGlobalMessage(Translation.of("msg_war_participants_header"));
        for (String string : warParticipants) {
            TownyMessaging.sendPlainGlobalMessage(string);
        }
        TownyMessaging.sendPlainGlobalMessage(ChatTools.formatTitle("----------------"));
    }

    public void end() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            this.sendStats(player);
        }
        new BukkitRunnable(){

            public void run() {
                HUDManager.toggleAllWarHUD();
            }
        }.runTask((Plugin)this.plugin);
        warringNations.clear();
        warringTowns.clear();
        warZone.clear();
        double nationWinnings = 0.0;
        double halfWinnings = this.getWarSpoils().getHoldingBalance() / 2.0;
        try {
            nationWinnings = halfWinnings / (double)warringNations.size();
            for (Nation winningNation : warringNations) {
                this.getWarSpoils().payTo(nationWinnings, winningNation, "War - Nation Winnings");
                TownyMessaging.sendGlobalMessage(Translation.of("MSG_WAR_WINNING_NATION_SPOILS", winningNation.getName(), TownyEconomyHandler.getFormattedBalance(nationWinnings)));
            }
        }
        catch (ArithmeticException e) {
            TownyMessaging.sendDebugMsg("[War]   War ended with 0 nations.");
        }
        try {
            KeyValue<Town, Integer> winningTownScore = this.getWinningTownScore();
            this.getWarSpoils().payTo(halfWinnings, (EconomyHandler)winningTownScore.key, "War - Town Winnings");
            TownyMessaging.sendGlobalMessage(Translation.of("MSG_WAR_WINNING_TOWN_SPOILS", ((Town)winningTownScore.key).getName(), TownyEconomyHandler.getFormattedBalance(halfWinnings), winningTownScore.value));
            EventWarEndEvent event = new EventWarEndEvent(warringTowns, (Town)winningTownScore.key, halfWinnings, warringNations, nationWinnings);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
        }
        catch (TownyException townyException) {
            // empty catch block
        }
    }

    private void add(Nation nation) {
        int numTowns = 0;
        for (Town town : nation.getTowns()) {
            if (!town.hasHomeBlock()) continue;
            try {
                if (town.getTownBlocks().size() > 0 && town.getHomeBlock().getWorld().isWarAllowed()) {
                    this.add(town);
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            if (!warringTowns.contains(town)) continue;
            ++numTowns;
        }
        if (numTowns > 0 && warringTowns.contains(nation.getCapital())) {
            warringNations.add(nation);
        }
    }

    private void add(Town town) {
        int numTownBlocks = 0;
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!townBlock.getWorld().isWarAllowed()) continue;
            ++numTownBlocks;
            if (town.isHomeBlock(townBlock)) {
                warZone.put(townBlock.getWorldCoord(), TownySettings.getWarzoneHomeBlockHealth());
                continue;
            }
            warZone.put(townBlock.getWorldCoord(), TownySettings.getWarzoneTownBlockHealth());
        }
        if (numTownBlocks > 0) {
            TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_war_join", town.getName()));
            this.townScores.put(town, 0);
            warringTowns.add(town);
        }
    }

    public void townScored(Town town, int n, Object fallenObject, int townBlocksFallen) {
        String pointMessage = "";
        if (fallenObject instanceof Nation) {
            pointMessage = Translation.of("MSG_WAR_SCORE_NATION_ELIM", town.getName(), n, ((Nation)fallenObject).getName());
        } else if (fallenObject instanceof Town) {
            pointMessage = Translation.of("MSG_WAR_SCORE_TOWN_ELIM", town.getName(), n, ((Town)fallenObject).getName(), townBlocksFallen);
        } else if (fallenObject instanceof TownBlock) {
            String townBlockName = "";
            try {
                townBlockName = "[" + ((TownBlock)fallenObject).getTown().getName() + "](" + ((TownBlock)fallenObject).getCoord().toString() + ")";
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            pointMessage = Translation.of("MSG_WAR_SCORE_TOWNBLOCK_ELIM", town.getName(), n, townBlockName);
        }
        this.townScores.put(town, this.townScores.get(town) + n);
        TownyMessaging.sendGlobalMessage(pointMessage);
        TownScoredEvent event = new TownScoredEvent(town, this.townScores.get(town));
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    public void townScored(Town defenderTown, Town attackerTown, Player defenderPlayer, Player attackerPlayer, int n) {
        TownBlock deathLoc = TownyAPI.getInstance().getTownBlock(defenderPlayer.getLocation());
        String pointMessage = deathLoc == null ? Translation.of("MSG_WAR_SCORE_PLAYER_KILL", attackerPlayer.getName(), defenderPlayer.getName(), n, attackerTown.getName()) : (warZone.containsKey(deathLoc.getWorldCoord()) && attackerTown.getTownBlocks().contains(deathLoc) ? Translation.of("MSG_WAR_SCORE_PLAYER_KILL_DEFENDING", attackerPlayer.getName(), defenderPlayer.getName(), attackerPlayer.getName(), n, attackerTown.getName()) : (warZone.containsKey(deathLoc.getWorldCoord()) && defenderTown.getTownBlocks().contains(deathLoc) ? Translation.of("MSG_WAR_SCORE_PLAYER_KILL_DEFENDING", attackerPlayer.getName(), defenderPlayer.getName(), defenderPlayer.getName(), n, attackerTown.getName()) : Translation.of("MSG_WAR_SCORE_PLAYER_KILL", attackerPlayer.getName(), defenderPlayer.getName(), n, attackerTown.getName())));
        this.townScores.put(attackerTown, this.townScores.get(attackerTown) + n);
        TownyMessaging.sendGlobalMessage(pointMessage);
        TownScoredEvent event = new TownScoredEvent(attackerTown, this.townScores.get(attackerTown));
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    public void updateWarZone(TownBlock townBlock, WarZoneData wzd) throws NotRegisteredException {
        if (!wzd.hasAttackers()) {
            this.healPlot(townBlock, wzd);
        } else {
            this.attackPlot(townBlock, wzd);
        }
    }

    private void healPlot(TownBlock townBlock, WarZoneData wzd) throws NotRegisteredException {
        int hp;
        WorldCoord worldCoord = townBlock.getWorldCoord();
        int healthChange = wzd.getHealthChange();
        int oldHP = warZone.get(worldCoord);
        if (oldHP == (hp = this.getHealth(townBlock, healthChange))) {
            return;
        }
        warZone.put(worldCoord, hp);
        String healString = "\u00a78[Heal](" + townBlock.getCoord().toString() + ") HP: " + hp + " (" + "\u00a7a" + "+" + healthChange + "\u00a78" + ")";
        TownyMessaging.sendPrefixedTownMessage(townBlock.getTown(), healString);
        for (Player p : wzd.getDefenders()) {
            Resident res = TownyUniverse.getInstance().getResident(p.getUniqueId());
            if (res == null || !res.hasTown() || !res.getTown().equals(townBlock.getTown())) continue;
            TownyMessaging.sendMessage((Object)p, healString);
        }
        this.launchFireworkAtPlot(townBlock, wzd.getRandomDefender(), FireworkEffect.Type.BALL, Color.LIME);
        PlotAttackedEvent event = new PlotAttackedEvent(townBlock, wzd.getAllPlayers(), hp);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    private void attackPlot(TownBlock townBlock, WarZoneData wzd) throws NotRegisteredException {
        Color fwc;
        Player attackerPlayer = wzd.getRandomAttacker();
        Resident attackerResident = TownyUniverse.getInstance().getResident(attackerPlayer.getUniqueId());
        if (attackerResident == null) {
            throw new NotRegisteredException(Translation.of("msg_err_not_registered_1", attackerPlayer.getName()));
        }
        Town attacker = attackerResident.getTown();
        WorldCoord worldCoord = townBlock.getWorldCoord();
        int healthChange = wzd.getHealthChange();
        int hp = this.getHealth(townBlock, healthChange);
        Color color = healthChange < 0 ? Color.RED : (fwc = healthChange > 0 ? Color.LIME : Color.GRAY);
        if (hp > 0) {
            String healthChangeStringAtk;
            String healthChangeStringDef;
            warZone.put(worldCoord, hp);
            if (healthChange > 0) {
                healthChangeStringDef = "(\u00a7a+" + healthChange + "\u00a78" + ")";
                healthChangeStringAtk = "(\u00a74+" + healthChange + "\u00a78" + ")";
            } else if (healthChange < 0) {
                healthChangeStringDef = "(\u00a74" + healthChange + "\u00a78" + ")";
                healthChangeStringAtk = "(\u00a7a" + healthChange + "\u00a78" + ")";
            } else {
                healthChangeStringDef = "(+0)";
                healthChangeStringAtk = "(+0)";
            }
            if (!townBlock.isHomeBlock()) {
                TownyMessaging.sendPrefixedTownMessage(townBlock.getTown(), "\u00a78" + Translation.of("msg_war_town_under_attack") + " (" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef);
                if (hp >= 10 && hp % 10 == 0 || hp <= 5) {
                    this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.BALL_LARGE, fwc);
                    for (Town town : townBlock.getTown().getNation().getTowns()) {
                        if (town == townBlock.getTown()) continue;
                        TownyMessaging.sendPrefixedTownMessage(town, "\u00a78" + Translation.of("msg_war_nation_under_attack") + " [" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef);
                    }
                    for (Nation nation : townBlock.getTown().getNation().getAllies()) {
                        if (nation == townBlock.getTown().getNation()) continue;
                        TownyMessaging.sendPrefixedNationMessage(nation, "\u00a78" + Translation.of("msg_war_nations_ally_under_attack", townBlock.getTown().getName()) + " [" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef);
                    }
                } else {
                    this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.BALL, fwc);
                }
                for (Town attackingTown : wzd.getAttackerTowns()) {
                    TownyMessaging.sendPrefixedTownMessage(attackingTown, "\u00a78[" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringAtk);
                }
            } else {
                TownyMessaging.sendPrefixedTownMessage(townBlock.getTown(), "\u00a78" + Translation.of("msg_war_homeblock_under_attack") + " (" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef);
                if (hp >= 10 && hp % 10 == 0 || hp <= 5) {
                    this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.BALL_LARGE, fwc);
                    for (Town town : townBlock.getTown().getNation().getTowns()) {
                        if (town == townBlock.getTown()) continue;
                        TownyMessaging.sendPrefixedTownMessage(town, "\u00a78" + Translation.of("msg_war_nation_member_homeblock_under_attack", townBlock.getTown().getName()) + " [" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef);
                    }
                    for (Nation nation : townBlock.getTown().getNation().getAllies()) {
                        if (nation == townBlock.getTown().getNation()) continue;
                        TownyMessaging.sendPrefixedNationMessage(nation, "\u00a78" + Translation.of("msg_war_nation_ally_homeblock_under_attack", townBlock.getTown().getName()) + " [" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringDef);
                    }
                } else {
                    this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.BALL, fwc);
                }
                for (Town attackingTown : wzd.getAttackerTowns()) {
                    TownyMessaging.sendPrefixedTownMessage(attackingTown, "\u00a78[" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp + " " + healthChangeStringAtk);
                }
            }
        } else {
            this.launchFireworkAtPlot(townBlock, attackerPlayer, FireworkEffect.Type.CREEPER, fwc);
            if (wzd.getAttackerTowns().size() > 1) {
                Hashtable<Town, Integer> attackerCount = new Hashtable<Town, Integer>();
                for (Town town : wzd.getAttackerTowns()) {
                    for (Player player : wzd.getAttackers()) {
                        Resident playerRes = TownyUniverse.getInstance().getResident(player.getUniqueId());
                        if (playerRes == null || !playerRes.hasTown() || !town.hasResident(playerRes)) continue;
                        int i = 0;
                        if (attackerCount.contains(town)) {
                            i = (Integer)attackerCount.get(town);
                        }
                        attackerCount.put(town, i + 1);
                    }
                }
                KeyValueTable kvTable = new KeyValueTable(attackerCount);
                kvTable.sortByValue();
                kvTable.reverse();
                attacker = (Town)kvTable.getKeyValues().get((int)0).key;
            }
            this.remove(attacker, townBlock);
        }
        PlotAttackedEvent event = new PlotAttackedEvent(townBlock, wzd.getAllPlayers(), hp);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    private int getHealth(TownBlock townBlock, int healthChange) {
        WorldCoord worldCoord = townBlock.getWorldCoord();
        int hp = warZone.get(worldCoord) + healthChange;
        boolean isHomeBlock = townBlock.isHomeBlock();
        if (isHomeBlock && hp > TownySettings.getWarzoneHomeBlockHealth()) {
            return TownySettings.getWarzoneHomeBlockHealth();
        }
        if (!isHomeBlock && hp > TownySettings.getWarzoneTownBlockHealth()) {
            return TownySettings.getWarzoneTownBlockHealth();
        }
        return hp;
    }

    private void launchFireworkAtPlot(TownBlock townblock, Player atPlayer, FireworkEffect.Type type, Color c) {
        if (!TownySettings.getPlotsFireworkOnAttacked()) {
            return;
        }
        BukkitTools.scheduleSyncDelayedTask(() -> {
            double x = (double)townblock.getX() * (double)Coord.getCellSize() + (double)Coord.getCellSize() / 2.0;
            double z = (double)townblock.getZ() * (double)Coord.getCellSize() + (double)Coord.getCellSize() / 2.0;
            double y = atPlayer.getLocation().getY() + 20.0;
            Firework firework = (Firework)atPlayer.getWorld().spawn(new Location(atPlayer.getWorld(), x, y, z), Firework.class);
            FireworkMeta data = firework.getFireworkMeta();
            data.addEffects(new FireworkEffect[]{FireworkEffect.builder().withColor(c).with(type).trail(false).build()});
            firework.setFireworkMeta(data);
            firework.detonate();
        }, 0L);
    }

    private void remove(Town attacker, TownBlock townBlock) throws NotRegisteredException {
        Town defenderTown = townBlock.getTown();
        boolean defenderHomeblock = townBlock.isHomeBlock();
        if (TownySettings.getWarEventCostsTownblocks() || TownySettings.getWarEventWinnerTakesOwnershipOfTownblocks()) {
            defenderTown.addBonusBlocks(-1);
            attacker.addBonusBlocks(1);
        }
        if (!TownySettings.getWarEventWinnerTakesOwnershipOfTown() && TownySettings.getWarEventWinnerTakesOwnershipOfTownblocks()) {
            townBlock.setTown(attacker);
            townBlock.save();
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (TownyEconomyHandler.isActive() && !defenderTown.getAccount().payTo(TownySettings.getWartimeTownBlockLossPrice(), attacker, "War - TownBlock Loss")) {
            TownyMessaging.sendPrefixedTownMessage(defenderTown, Translation.of("msg_war_town_ran_out_of_money"));
            TownyMessaging.sendTitleMessageToTown(defenderTown, Translation.of("msg_war_town_removed_from_war_titlemsg"), "");
            if (defenderTown.isCapital()) {
                this.remove(attacker, defenderTown.getNation());
            } else {
                this.remove(attacker, defenderTown);
            }
            defenderTown.save();
            attacker.save();
            return;
        }
        TownyMessaging.sendPrefixedTownMessage(defenderTown, Translation.of("msg_war_town_lost_money_townblock", TownyEconomyHandler.getFormattedBalance(TownySettings.getWartimeTownBlockLossPrice())));
        if (defenderHomeblock && defenderTown.isCapital()) {
            this.remove(attacker, defenderTown.getNation());
        } else if (defenderHomeblock) {
            this.remove(attacker, defenderTown);
        } else {
            this.townScored(attacker, TownySettings.getWarPointsForTownBlock(), townBlock, 0);
            this.remove(townBlock.getWorldCoord());
            if (townBlock.isJail()) {
                int count = 0;
                for (Resident resident : new ArrayList<Resident>(townyUniverse.getJailedResidentMap())) {
                    if (!resident.isJailed() || !resident.getJail().getTown().getUUID().equals(defenderTown.getUUID()) || !resident.getJail().getTownBlock().getWorldCoord().equals(townBlock.getWorldCoord())) continue;
                    JailUtil.unJailResident(resident, UnJailReason.JAILBREAK);
                    ++count;
                }
                if (count > 0) {
                    TownyMessaging.sendGlobalMessage(Translation.of("msg_war_jailbreak", defenderTown, count));
                }
            }
        }
        defenderTown.save();
        attacker.save();
    }

    public void remove(Town attacker, Nation nation) throws NotRegisteredException {
        this.townScored(attacker, TownySettings.getWarPointsForNation(), nation, 0);
        warringNations.remove(nation);
        TownyMessaging.sendGlobalMessage(Translation.of("msg_war_eliminated", nation));
        for (Town town : nation.getTowns()) {
            if (!warringTowns.contains(town)) continue;
            this.remove(attacker, town);
        }
        this.checkEnd();
    }

    public void remove(Town attacker, Town town) throws NotRegisteredException {
        Nation losingNation = town.getNation();
        int towns = 0;
        for (Town townsToCheck : warringTowns) {
            if (!townsToCheck.getNation().equals(losingNation)) continue;
            ++towns;
        }
        int fallenTownBlocks = 0;
        warringTowns.remove(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!warZone.containsKey(townBlock.getWorldCoord())) continue;
            ++fallenTownBlocks;
            this.remove(townBlock.getWorldCoord());
        }
        this.townScored(attacker, TownySettings.getWarPointsForTown(), town, fallenTownBlocks);
        if (TownySettings.getWarEventWinnerTakesOwnershipOfTown()) {
            town.setConquered(true);
            town.setConqueredDays(TownySettings.getWarEventConquerTime());
            town.removeNation();
            try {
                town.setNation(attacker.getNation());
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
            town.save();
            attacker.getNation().save();
            losingNation.save();
            TownyMessaging.sendGlobalMessage(Translation.of("msg_war_town_has_been_conquered_by_nation_x_for_x_days", town.getName(), attacker.getNation(), TownySettings.getWarEventConquerTime()));
        }
        if (towns == 1) {
            this.remove(losingNation);
        }
        this.checkEnd();
    }

    private void remove(Nation nation) {
        warringNations.remove(nation);
        this.sendEliminateMessage(nation.getFormattedName());
        TownyMessaging.sendTitleMessageToNation(nation, Translation.of("msg_war_nation_removed_from_war_titlemsg"), "");
        for (Town town : nation.getTowns()) {
            this.remove(town);
        }
        this.checkEnd();
    }

    public void remove(Town town) {
        try {
            if (town.isCapital() && warringNations.contains(town.getNation())) {
                this.remove(town.getNation());
                return;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        int fallenTownBlocks = 0;
        warringTowns.remove(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!warZone.containsKey(townBlock.getWorldCoord())) continue;
            ++fallenTownBlocks;
            this.remove(townBlock.getWorldCoord());
        }
        this.sendEliminateMessage(town.getFormattedName() + " (" + fallenTownBlocks + Translation.of("msg_war_append_townblocks_fallen"));
    }

    private void remove(WorldCoord worldCoord) {
        warZone.remove(worldCoord);
    }

    private void sendEliminateMessage(String name) {
        TownyMessaging.sendGlobalMessage(Translation.of("msg_war_eliminated", name));
    }

    public void nationLeave(Nation nation) {
        this.remove(nation);
        TownyMessaging.sendGlobalMessage(Translation.of("MSG_WAR_FORFEITED", nation.getName()));
        this.checkEnd();
    }

    public void townLeave(Town town) {
        this.remove(town);
        TownyMessaging.sendGlobalMessage(Translation.of("MSG_WAR_FORFEITED", town.getName()));
        this.checkEnd();
    }

    public boolean townsLeft(Nation nation) {
        return this.countActiveTowns(nation) > 0;
    }

    public void checkEnd() {
        if (warringNations.size() <= 1) {
            this.toggleEnd();
        } else if (CombatUtil.areAllAllies(warringNations)) {
            this.toggleEnd();
        }
    }

    public int countActiveWarBlocks(Town town) {
        int n = 0;
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!warZone.containsKey(townBlock.getWorldCoord())) continue;
            ++n;
        }
        return n;
    }

    public int countActiveTowns(Nation nation) {
        int n = 0;
        for (Town town : nation.getTowns()) {
            if (!warringTowns.contains(town)) continue;
            ++n;
        }
        return n;
    }

    public List<String> getStats() {
        ArrayList<String> output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("War Stats"));
        output.add("\u00a72" + Translation.of("war_stats_nations") + "\u00a7a" + warringNations.size());
        output.add("\u00a72" + Translation.of("war_stats_towns") + "\u00a7a" + warringTowns.size() + " / " + this.townScores.size());
        output.add("\u00a72" + Translation.of("war_stats_warzone") + "\u00a7a" + warZone.size() + " Town blocks");
        output.add("\u00a72" + Translation.of("war_stats_spoils_of_war") + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(this.warSpoils.getHoldingBalance()));
        return output;
    }

    public void sendStats(Player player) {
        for (String line : this.getStats()) {
            TownyMessaging.sendMessage((Object)player, line);
        }
    }

    public List<String> getScores(int maxListing) {
        ArrayList<String> output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("War - Top Scores"));
        KeyValueTable<Town, Integer> kvTable = new KeyValueTable<Town, Integer>(this.townScores);
        kvTable.sortByValue();
        kvTable.reverse();
        int n = 0;
        for (KeyValue<Town, Integer> kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            Town town = (Town)kv.key;
            int score = (Integer)kv.value;
            if (score <= 0) continue;
            output.add(String.format("\u00a73%40s \u00a76|\u00a77 %4d", town.getFormattedName(), score));
        }
        return output;
    }

    public String[] getTopThree() {
        KeyValueTable<Town, Integer> kvTable = new KeyValueTable<Town, Integer>(this.townScores);
        kvTable.sortByValue();
        kvTable.reverse();
        String[] top = new String[]{kvTable.getKeyValues().size() >= 1 ? kvTable.getKeyValues().get((int)0).value + "-" + kvTable.getKeyValues().get((int)0).key : "", kvTable.getKeyValues().size() >= 2 ? kvTable.getKeyValues().get((int)1).value + "-" + kvTable.getKeyValues().get((int)1).key : "", kvTable.getKeyValues().size() >= 3 ? kvTable.getKeyValues().get((int)2).value + "-" + kvTable.getKeyValues().get((int)2).key : ""};
        return top;
    }

    public KeyValue<Town, Integer> getWinningTownScore() throws TownyException {
        KeyValueTable<Town, Integer> kvTable = new KeyValueTable<Town, Integer>(this.townScores);
        kvTable.sortByValue();
        kvTable.reverse();
        if (kvTable.getKeyValues().size() > 0) {
            return kvTable.getKeyValues().get(0);
        }
        throw new TownyException();
    }

    public void sendScores(Player player) {
        this.sendScores(player, 10);
    }

    public void sendScores(Player player, int maxListing) {
        for (String line : this.getScores(maxListing)) {
            TownyMessaging.sendMessage((Object)player, line);
        }
    }
}

