/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.common;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.actions.TownyBuildEvent;
import com.palmergames.bukkit.towny.event.actions.TownyBurnEvent;
import com.palmergames.bukkit.towny.event.actions.TownyDestroyEvent;
import com.palmergames.bukkit.towny.event.actions.TownyExplodingBlocksEvent;
import com.palmergames.bukkit.towny.event.actions.TownyItemuseEvent;
import com.palmergames.bukkit.towny.event.actions.TownySwitchEvent;
import com.palmergames.bukkit.towny.event.damage.TownBlockPVPTestEvent;
import com.palmergames.bukkit.towny.event.damage.TownyExplosionDamagesEntityEvent;
import com.palmergames.bukkit.towny.event.damage.TownyPlayerDamagePlayerEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationToggleNeutralEvent;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.war.common.WarZoneConfig;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.towny.war.eventwar.WarUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class WarZoneListener
implements Listener {
    private final Towny plugin;

    public WarZoneListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onDestroy(TownyDestroyEvent event) {
        if (event.isInWilderness()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.hasCache(player)) {
            this.plugin.newCache(player);
        }
        Material mat = event.getMaterial();
        PlayerCache.TownBlockStatus status = this.plugin.getCache(player).getStatus();
        if (TownyAPI.getInstance().isWarTime() && status == PlayerCache.TownBlockStatus.WARZONE && !WarUtil.isPlayerNeutral(player)) {
            if (!WarZoneConfig.isEditableMaterialInWarZone(mat)) {
                event.setCancelled(true);
                event.setMessage(Translatable.of("msg_err_warzone_cannot_edit_material", "destroy", mat.toString().toLowerCase()).forLocale((CommandSender)player));
                return;
            }
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onBuild(TownyBuildEvent event) {
        if (event.isInWilderness()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.hasCache(player)) {
            this.plugin.newCache(player);
        }
        Material mat = event.getMaterial();
        PlayerCache.TownBlockStatus status = this.plugin.getCache(player).getStatus();
        if (TownyAPI.getInstance().isWarTime() && status == PlayerCache.TownBlockStatus.WARZONE && !WarUtil.isPlayerNeutral(player)) {
            if (!WarZoneConfig.isEditableMaterialInWarZone(mat)) {
                event.setCancelled(true);
                event.setMessage(Translatable.of("msg_err_warzone_cannot_edit_material", "build", mat.toString().toLowerCase()).forLocale((CommandSender)player));
                return;
            }
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onItemUse(TownyItemuseEvent event) {
        if (event.isInWilderness()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.hasCache(player)) {
            this.plugin.newCache(player);
        }
        PlayerCache.TownBlockStatus status = this.plugin.getCache(event.getPlayer()).getStatus();
        if (TownyAPI.getInstance().isWarTime() && status == PlayerCache.TownBlockStatus.WARZONE && !WarUtil.isPlayerNeutral(player)) {
            if (!WarZoneConfig.isAllowingItemUseInWarZone()) {
                event.setCancelled(true);
                event.setMessage(Translatable.of("msg_err_warzone_cannot_use_item").forLocale((CommandSender)player));
                return;
            }
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onSwitchUse(TownySwitchEvent event) {
        if (event.isInWilderness()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.hasCache(player)) {
            this.plugin.newCache(player);
        }
        PlayerCache.TownBlockStatus status = this.plugin.getCache(player).getStatus();
        if (TownyAPI.getInstance().isWarTime() && status == PlayerCache.TownBlockStatus.WARZONE && !WarUtil.isPlayerNeutral(player)) {
            if (!WarZoneConfig.isAllowingSwitchesInWarZone()) {
                event.setCancelled(true);
                event.setMessage(Translatable.of("msg_err_warzone_cannot_use_switches").forLocale((CommandSender)player));
                return;
            }
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onExplosionDamagingBlocks(TownyExplodingBlocksEvent event) {
        if (!TownyAPI.getInstance().isWarTime()) {
            return;
        }
        List<Block> alreadyAllowed = event.getTownyFilteredBlockList();
        ArrayList<Block> toAllow = new ArrayList<Block>();
        int count = 0;
        for (Block block : event.getVanillaBlockList()) {
            if (TownyAPI.getInstance().isWilderness(block) || !War.isWarZone(TownyAPI.getInstance().getTownBlock(block.getLocation()).getWorldCoord())) continue;
            if (!WarZoneConfig.isAllowingExplosionsInWarZone()) {
                if (!alreadyAllowed.contains(block)) continue;
                alreadyAllowed.remove(block);
                continue;
            }
            if (WarZoneConfig.regenBlocksAfterExplosionInWarZone()) {
                if (WarZoneConfig.getExplosionsIgnoreList().contains(block.getType().name()) || WarZoneConfig.getExplosionsIgnoreList().contains(block.getRelative(BlockFace.UP).getType().name())) {
                    if (!alreadyAllowed.contains(block)) continue;
                    alreadyAllowed.remove(block);
                    continue;
                }
                TownyRegenAPI.beginProtectionRegenTask(block, ++count, TownyAPI.getInstance().getTownyWorld(block.getLocation().getWorld().getName()), event);
            }
            toAllow.add(block);
        }
        toAllow.addAll(alreadyAllowed);
        event.setBlockList(toAllow);
    }

    @EventHandler
    public void onExplosionDamagingEntity(TownyExplosionDamagesEntityEvent event) {
        if (!TownyAPI.getInstance().isWarTime()) {
            return;
        }
        if (event.isInWilderness()) {
            return;
        }
        if (!War.isWarZone(TownyAPI.getInstance().getTownBlock(event.getLocation()).getWorldCoord())) {
            return;
        }
        if (!WarZoneConfig.isAllowingExplosionsInWarZone()) {
            event.setCancelled(true);
            return;
        }
        if (WarZoneConfig.getExplosionsIgnoreList().contains(event.getEntity().getType().name())) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(false);
    }

    @EventHandler
    public void onBurn(TownyBurnEvent event) {
        boolean inEventWarTown;
        if (event.isInWilderness()) {
            return;
        }
        boolean inFlagWarTown = TownyAPI.getInstance().getTownyWorld(event.getBlock().getWorld().getName()).isWarZone(Coord.parseCoord(event.getLocation()));
        boolean bl = inEventWarTown = TownyAPI.getInstance().isWarTime() && War.isWarringTown(TownyAPI.getInstance().getTown(event.getLocation()));
        if (inFlagWarTown || inEventWarTown) {
            if (WarZoneConfig.isAllowingFireInWarZone()) {
                event.setCancelled(false);
            } else if (inEventWarTown && TownySettings.isAllowWarBlockGriefing()) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onNationToggleNeutral(NationToggleNeutralEvent event) {
        if (!TownySettings.isDeclaringNeutral() && event.getFutureState()) {
            event.setCancelled(true);
            event.setCancelMessage(Translatable.of("msg_err_fight_like_king").forLocale((CommandSender)event.getPlayer()));
        }
    }

    @EventHandler
    public void onPlayerDamagePlayer(TownyPlayerDamagePlayerEvent event) {
        if (!TownyAPI.getInstance().isWarTime()) {
            return;
        }
        Town attackerTown = event.getAttackerTown();
        Town defenderTown = event.getVictimTown();
        if (TownySettings.isWarTimeTownsNeutral() && (event.getAttackerTown() == null || event.getVictimTown() == null)) {
            event.setMessage(Translatable.of("msg_war_a_player_has_no_town").forLocale((CommandSender)event.getAttackingPlayer()));
            event.setCancelled(true);
            return;
        }
        if (!(!TownySettings.isWarTimeTownsNeutral() || attackerTown.hasNation() && defenderTown.hasNation())) {
            event.setMessage(Translatable.of("msg_war_a_player_has_no_nation").forLocale((CommandSender)event.getAttackingPlayer()));
            event.setCancelled(true);
            return;
        }
        if (attackerTown.hasNation() && attackerTown.getNationOrNull().isNeutral() || defenderTown.hasNation() && defenderTown.getNationOrNull().isNeutral()) {
            event.setMessage(Translatable.of("msg_war_a_player_has_a_neutral_nation").forLocale((CommandSender)event.getAttackingPlayer()));
            event.setCancelled(true);
            return;
        }
        if (!War.isWarringTown(defenderTown) || !War.isWarringTown(attackerTown)) {
            event.setMessage(Translatable.of("msg_war_a_player_has_been_removed_from_war").forLocale((CommandSender)event.getAttackingPlayer()));
            event.setCancelled(true);
            return;
        }
        if (CombatUtil.isAlly(attackerTown, defenderTown)) {
            event.setMessage(Translatable.of("msg_war_a_player_is_an_ally").forLocale((CommandSender)event.getAttackingPlayer()));
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onTownBlockPVPTest(TownBlockPVPTestEvent event) {
        if (!TownyAPI.getInstance().isWarTime()) {
            return;
        }
        if (War.isWarZone(event.getTownBlock().getWorldCoord())) {
            event.setPvp(true);
        }
    }
}

