/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyInventory;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ResidentUtil {
    public static List<Resident> getOnlineResidentsViewable(Player viewer, ResidentList residentList) {
        ArrayList<Resident> onlineResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (Resident resident : residentList.getResidents()) {
                if (!resident.getName().equalsIgnoreCase(player.getName()) || viewer != null && !viewer.canSee(BukkitTools.getPlayerExact(resident.getName()))) continue;
                onlineResidents.add(resident);
            }
        }
        return onlineResidents;
    }

    public static List<Resident> getValidatedResidents(CommandSender sender, String[] names) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Resident> residents = new ArrayList<Resident>();
        for (String name : names) {
            List<Player> matches = BukkitTools.matchPlayer(name);
            if (matches.size() > 1) {
                StringBuilder line = new StringBuilder("Multiple players selected: ");
                for (Player p : matches) {
                    line.append(", ").append(p.getName());
                }
                TownyMessaging.sendErrorMsg((Object)sender, line.toString());
                continue;
            }
            String targetName = !matches.isEmpty() ? matches.get(0).getName() : name;
            Resident target = townyUniverse.getResident(targetName);
            if (target != null) {
                residents.add(target);
                continue;
            }
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_registered_1", targetName));
        }
        return residents;
    }

    public static void openGUIInventory(Resident resident, List<String> list, String name) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String item : list) {
            Material mat = Material.getMaterial((String)item);
            if (mat == null) continue;
            items.add(new ItemStack(mat));
        }
        ResidentUtil.createTownyGUI(resident, items, name);
    }

    private static void createTownyGUI(Resident resident, ArrayList<ItemStack> items, String name) {
        Inventory page = ResidentUtil.getBlankPage(name);
        ArrayList<Inventory> pages = new ArrayList<Inventory>();
        for (int i = 0; i < items.size(); ++i) {
            if (page.firstEmpty() == 46) {
                pages.add(page);
                page = ResidentUtil.getBlankPage(name);
                page.addItem(new ItemStack[]{items.get(i)});
                continue;
            }
            page.addItem(new ItemStack[]{items.get(i)});
        }
        pages.add(page);
        resident.setGUIPages(pages);
        resident.setGUIPageNum(0);
        new TownyInventory(resident, pages.get(0), name);
    }

    public static Inventory getBlankPage(String name) {
        Inventory page = Bukkit.createInventory(null, (int)54, (String)name);
        ItemStack nextpage = new ItemStack(Material.ARROW);
        ItemMeta meta = nextpage.getItemMeta();
        meta.setDisplayName("\u00a76Next");
        nextpage.setItemMeta(meta);
        ItemStack prevpage = new ItemStack(Material.ARROW);
        meta = prevpage.getItemMeta();
        meta.setDisplayName("\u00a76Back");
        prevpage.setItemMeta(meta);
        page.setItem(53, nextpage);
        page.setItem(45, prevpage);
        return page;
    }

    public static Resident createAndGetNPCResident() {
        Resident npc = null;
        try {
            String name = ResidentUtil.nextNpcName();
            UUID npcUUID = UUID.randomUUID();
            TownyUniverse.getInstance().getDataSource().newResident(name, npcUUID);
            npc = TownyUniverse.getInstance().getResident(npcUUID);
            npc.setRegistered(System.currentTimeMillis());
            npc.setLastOnline(0L);
            npc.setNPC(true);
            npc.save();
        }
        catch (TownyException e) {
            e.printStackTrace();
        }
        return npc;
    }

    public static String nextNpcName() throws TownyException {
        int i = 0;
        do {
            String name = TownySettings.getNPCPrefix() + ++i;
            if (TownyUniverse.getInstance().hasResident(name)) continue;
            return name;
        } while (i <= 100000);
        throw new TownyException(Translatable.of("msg_err_too_many_npc"));
    }

    public static void reduceResidentCountToFitTownMaxPop(Town town) {
        if (TownySettings.getMaxResidentsPerTown() == 0) {
            return;
        }
        int max = TownySettings.getMaxResidentsForTown(town);
        if (town.getNumResidents() <= max) {
            return;
        }
        int i = 1;
        ArrayList<Resident> toRemove = new ArrayList<Resident>(town.getNumResidents() - max);
        for (Resident res2 : town.getResidents()) {
            if (i > max) {
                toRemove.add(res2);
            }
            ++i;
        }
        if (!toRemove.isEmpty()) {
            toRemove.stream().forEach(res -> res.removeTown());
        }
    }
}

