/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.object.metadata.DecimalDataField;
import com.palmergames.bukkit.towny.object.metadata.IntegerDataField;
import com.palmergames.bukkit.towny.object.metadata.LongDataField;
import com.palmergames.bukkit.towny.object.metadata.StringDataField;

public class MetaDataUtil {
    public static String getString(TownyObject townyObject, StringDataField sdf) {
        CustomDataField<?> cdf = townyObject.getMetadata(sdf.getKey());
        if (cdf instanceof StringDataField) {
            return (String)((StringDataField)cdf).getValue();
        }
        return "";
    }

    public static boolean getBoolean(TownyObject townyObject, BooleanDataField bdf) {
        CustomDataField<?> cdf = townyObject.getMetadata(bdf.getKey());
        if (cdf instanceof BooleanDataField) {
            return (Boolean)((BooleanDataField)cdf).getValue();
        }
        return false;
    }

    public static long getLong(TownyObject townyObject, LongDataField ldf) {
        CustomDataField<?> cdf = townyObject.getMetadata(ldf.getKey());
        if (cdf instanceof LongDataField) {
            return (Long)((LongDataField)cdf).getValue();
        }
        return 0L;
    }

    public static int getInt(TownyObject townyObject, IntegerDataField idf) {
        CustomDataField<?> cdf = townyObject.getMetadata(idf.getKey());
        if (cdf instanceof IntegerDataField) {
            return (Integer)((IntegerDataField)cdf).getValue();
        }
        return 0;
    }

    public static double getDouble(TownyObject townyObject, DecimalDataField ddf) {
        CustomDataField<?> cdf = townyObject.getMetadata(ddf.getKey());
        if (cdf instanceof DecimalDataField) {
            return (Double)((DecimalDataField)cdf).getValue();
        }
        return 0.0;
    }

    public static void setString(TownyObject townyObject, StringDataField sdf, String string, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(sdf.getKey());
        if (cdf instanceof StringDataField) {
            StringDataField value = (StringDataField)cdf;
            value.setValue(string);
            if (save) {
                townyObject.save();
            }
        }
    }

    public static void setBoolean(TownyObject townyObject, BooleanDataField bdf, boolean bool, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(bdf.getKey());
        if (cdf instanceof BooleanDataField) {
            BooleanDataField value = (BooleanDataField)cdf;
            value.setValue(bool);
            if (save) {
                townyObject.save();
            }
        }
    }

    public static void setLong(TownyObject townyObject, LongDataField ldf, long num, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(ldf.getKey());
        if (cdf instanceof LongDataField) {
            LongDataField value = (LongDataField)cdf;
            value.setValue(num);
            if (save) {
                townyObject.save();
            }
        }
    }

    public static void setInt(TownyObject townyObject, IntegerDataField idf, int num, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(idf.getKey());
        if (cdf instanceof IntegerDataField) {
            IntegerDataField value = (IntegerDataField)cdf;
            value.setValue(num);
            if (save) {
                townyObject.save();
            }
        }
    }

    public static void setDouble(TownyObject townyObject, DecimalDataField ddf, double num, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(ddf.getKey());
        if (cdf instanceof DecimalDataField) {
            DecimalDataField value = (DecimalDataField)cdf;
            value.setValue(num);
            if (save) {
                townyObject.save();
            }
        }
    }
}

