/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.resident.ResidentJailEvent;
import com.palmergames.bukkit.towny.event.resident.ResidentPreJailEvent;
import com.palmergames.bukkit.towny.event.resident.ResidentUnjailEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.jail.JailReason;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.util.BookFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class JailUtil {
    private static List<Resident> queuedJailedResidents = new ArrayList<Resident>();

    public static void jailResident(Resident resident, Jail jail, int cell, int hours, JailReason reason, CommandSender jailer) {
        String senderName = "Admin";
        if (jailer instanceof Player) {
            senderName = ((Player)jailer).getName();
        }
        if (hours > 10000) {
            hours = 10000;
        }
        ResidentPreJailEvent event = new ResidentPreJailEvent(resident, jail, cell, hours, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)jailer, event.getCancelMessage());
            return;
        }
        JailUtil.sendJailedBookToResident(resident.getPlayer(), reason);
        switch (reason) {
            case MAYOR: {
                Object jailName = jail.hasName() ? jail.getName() : Translatable.of("jail_sing");
                TownyMessaging.sendPrefixedTownMessage(jail.getTown(), Translatable.of("msg_player_has_been_sent_to_jail_into_cell_number_x_for_x_hours_by_x", resident.getName(), jailName, cell + 1, hours, senderName));
                if (!TownySettings.doesJailingPreventLoggingOut()) break;
                JailUtil.addJailedPlayerToLogOutMap(resident);
                break;
            }
            case OUTLAW_DEATH: 
            case PRISONER_OF_WAR: {
                TownyMessaging.sendTitleMessageToResident(resident, Translatable.of("msg_you_have_been_jailed").forLocale(resident), Translatable.of("msg_run_to_the_wilderness_or_wait_for_a_jailbreak").forLocale(resident));
            }
        }
        resident.setJail(jail);
        resident.setJailCell(cell);
        resident.setJailHours(hours);
        resident.save();
        TownyUniverse.getInstance().getJailedResidentMap().add(resident);
        TownyMessaging.sendMsg(resident, Translatable.of("msg_you've_been_jailed_for_x_hours", hours));
        JailUtil.teleportToJail(resident);
        Bukkit.getPluginManager().callEvent((Event)new ResidentJailEvent(resident));
    }

    public static void unJailResident(Resident resident, UnJailReason reason) {
        Jail jail = resident.getJail();
        String jailName = jail.hasName() ? jail.getName() : ", cell unknown.";
        Town town = null;
        switch (reason) {
            case ESCAPE: {
                town = resident.getTownOrNull();
                if (town != null) {
                    TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_player_escaped_jail_into_wilderness", resident.getName(), jail.getWildName()));
                } else {
                    TownyMessaging.sendMsg(resident, Translatable.of("msg_you_have_been_freed_from_jail"));
                }
                if (town == null || town.getUUID().equals(jail.getTown().getUUID())) break;
                TownyMessaging.sendPrefixedTownMessage(jail.getTown(), Translatable.of("msg_player_escaped_jail_into_wilderness", resident.getName(), jail.getWildName()));
                break;
            }
            case BAIL: {
                JailUtil.teleportAwayFromJail(resident);
                TownyMessaging.sendMsg(resident, Translatable.of("msg_you_have_paid_bail"));
                TownyMessaging.sendPrefixedTownMessage(jail.getTown(), resident.getName() + Translatable.of("msg_has_paid_bail"));
                break;
            }
            case SENTENCE_SERVED: {
                JailUtil.teleportAwayFromJail(resident);
                TownyMessaging.sendMsg(resident, Translatable.of("msg_you_have_served_your_sentence_and_are_free"));
                TownyMessaging.sendPrefixedTownMessage(jail.getTown(), Translatable.of("msg_x_has_served_their_sentence_and_is_free", resident.getName()));
                break;
            }
            case LEFT_TOWN: {
                town = resident.getTownOrNull();
                TownyMessaging.sendMsg(resident, Translatable.of("msg_you_have_been_freed_from_jail"));
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_player_escaped_jail_by_leaving_town", resident.getName()));
                break;
            }
            case PARDONED: 
            case JAIL_DELETED: 
            case ADMIN: {
                JailUtil.teleportAwayFromJail(resident);
                TownyMessaging.sendMsg(resident, Translatable.of("msg_you_have_been_freed_from_jail"));
                TownyMessaging.sendPrefixedTownMessage(jail.getTown(), Translatable.of("msg_x_has_been_freed_from_x", resident.getName(), jailName));
                break;
            }
            case JAILBREAK: {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_you_have_been_freed_via_jailbreak"));
            }
        }
        TownyUniverse.getInstance().getJailedResidentMap().remove(resident);
        resident.setJailCell(0);
        resident.setJailHours(0);
        resident.setJail(null);
        resident.save();
        Bukkit.getPluginManager().callEvent((Event)new ResidentUnjailEvent(resident));
    }

    private static void sendJailedBookToResident(Player player, JailReason reason) {
        String pages = "Looks like you've been jailed, for the reason " + reason.getCause();
        pages = pages + "That's too bad huh. Well what can you do about it? Here's some helpful tips for you while you serve your sentence.\n\n";
        pages = pages + "You have been jailed for " + reason.getHours() + " hours. By serving your sentence you will become free.\n\n";
        pages = TownySettings.JailDeniesTownLeave() ? pages + "While you're jailed you won't be able to leave your town to escape jail.\n" : pages + "You can escape from jail by leaving your town using '/town leave'.\n";
        if (TownySettings.isAllowingBail() && TownyEconomyHandler.isActive()) {
            pages = pages + "You can be freed from jail by paying your bail using '/res jail paybail'.";
            double cost = TownySettings.getBailAmount();
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident.isMayor()) {
                cost = TownySettings.getBailAmountMayor();
            }
            if (resident.isKing()) {
                cost = TownySettings.getBailAmountKing();
            }
            pages = pages + "Bail will cost: " + TownyEconomyHandler.getFormattedBalance(cost) + "\n\n";
        }
        pages = pages + "If you must persist and make efforts to escape, if you make it to the wilderness you will also earn your freedom.";
        pages = pages + "But don't die before you reach the wilderness or you'll end up right back in jail.";
        if (TownySettings.JailAllowsTeleportItems()) {
            pages = pages + "Luckily, enderpearls and chorus fruit are allowed to be used to help you escape, now you've just got to get a hold of some.";
        }
        pages = pages + "\n\n";
        if (reason.equals((Object)JailReason.PRISONER_OF_WAR)) {
            pages = pages + "As a prisoner of war you will be freed if your countrymen can reduce the jail plot's HP to 0, or if the town you are jailed in is removed from the war.";
        }
        player.getInventory().addItem(new ItemStack[]{new ItemStack(BookFactory.makeBook("So you've been jailed :(", "Towny Jailco.", pages))});
    }

    public static void createJailPlot(TownBlock townBlock, Town town, Location location) throws TownyException {
        UUID uuid = UUID.randomUUID();
        ArrayList<Location> jailSpawns = new ArrayList<Location>(1);
        jailSpawns.add(location);
        Jail jail = new Jail(uuid, town, townBlock, jailSpawns);
        TownyUniverse.getInstance().registerJail(jail);
        jail.save();
        town.addJail(jail);
        townBlock.setJail(jail);
    }

    private static void teleportAwayFromJail(Resident resident) {
        if (resident.getPlayer() == null) {
            return;
        }
        Location loc = Bukkit.getWorld((String)resident.getPlayer().getWorld().getName()).getSpawnLocation();
        try {
            loc = resident.getTown().getSpawn();
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        TownyMessaging.sendMsg(resident, Translatable.of("msg_town_spawn_warmup", TownySettings.getTeleportWarmupTime()));
        TownyAPI.getInstance().jailTeleport(resident.getPlayer(), loc);
    }

    private static void teleportToJail(Resident resident) {
        TownyMessaging.sendMsg(resident, Translatable.of("msg_you_are_being_sent_to_jail"));
        TownyMessaging.sendMsg(resident, Translatable.of("msg_town_spawn_warmup", TownySettings.getTeleportWarmupTime()));
        TownyAPI.getInstance().jailTeleport(resident.getPlayer(), resident.getJailSpawn());
    }

    private static void addJailedPlayerToLogOutMap(Resident resident) {
        queuedJailedResidents.add(resident);
        TownyMessaging.sendMsg(resident, Translatable.of("msg_do_not_log_out_while_waiting_to_be_teleported"));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Towny.getPlugin(), () -> queuedJailedResidents.remove(resident), (long)(TownySettings.getTeleportWarmupTime() + 20));
    }

    public static boolean isQueuedToBeJailed(Resident resident) {
        return queuedJailedResidents.contains(resident);
    }
}

