/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.damage.TownBlockPVPTestEvent;
import com.palmergames.bukkit.towny.event.damage.TownyDispenserDamageEntityEvent;
import com.palmergames.bukkit.towny.event.damage.TownyFriendlyFireTestEvent;
import com.palmergames.bukkit.towny.event.damage.TownyPlayerDamagePlayerEvent;
import com.palmergames.bukkit.towny.event.damage.WildernessPVPTestEvent;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class CombatUtil {
    public static boolean preventDamageCall(Towny plugin, Entity attacker, Entity defender, EntityDamageEvent.DamageCause cause) {
        Player player;
        Entity entity;
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(defender.getWorld().getName());
        if (!world.isUsingTowny()) {
            return false;
        }
        Player a = null;
        Player b = null;
        if (attacker instanceof Projectile) {
            Projectile projectile = (Projectile)attacker;
            ProjectileSource source = projectile.getShooter();
            ProjectileSource projectileSource = source;
            if (projectileSource instanceof Entity) {
                Entity entity2;
                attacker = entity2 = (Entity)projectileSource;
            } else if (source != null && CombatUtil.preventDispenserDamage(((BlockProjectileSource)source).getBlock(), defender, cause)) {
                return true;
            }
        }
        if ((entity = attacker) instanceof Player) {
            a = player = (Player)entity;
        }
        if ((entity = defender) instanceof Player) {
            b = player = (Player)entity;
        }
        if (a == b && a != null && b != null) {
            return false;
        }
        return CombatUtil.preventDamageCall(plugin, world, attacker, defender, a, b, cause);
    }

    private static boolean preventDamageCall(Towny plugin, TownyWorld world, Entity attackingEntity, Entity defendingEntity, Player attackingPlayer, Player defendingPlayer, EntityDamageEvent.DamageCause cause) {
        TownBlock defenderTB = TownyAPI.getInstance().getTownBlock(defendingEntity.getLocation());
        TownBlock attackerTB = TownyAPI.getInstance().getTownBlock(attackingEntity.getLocation());
        if (attackingPlayer != null) {
            boolean cancelled = false;
            if (defendingPlayer != null) {
                if (!CombatUtil.isArenaPlot(attackerTB, defenderTB)) {
                    cancelled = CombatUtil.preventFriendlyFire(attackingPlayer, defendingPlayer, world) || CombatUtil.preventPvP(world, attackerTB) || CombatUtil.preventPvP(world, defenderTB) || CombatUtil.preventJailedPVP(defendingPlayer, attackingPlayer);
                }
                TownyPlayerDamagePlayerEvent event = new TownyPlayerDamagePlayerEvent(defendingPlayer.getLocation(), (Entity)defendingPlayer, cause, defenderTB, cancelled, attackingPlayer);
                BukkitTools.getPluginManager().callEvent((Event)event);
                if (event.isCancelled() && event.getMessage() != null) {
                    TownyMessaging.sendErrorMsg((Object)attackingPlayer, event.getMessage());
                }
                return event.isCancelled();
            }
            if (defenderTB != null) {
                if (defendingEntity instanceof Wolf && CombatUtil.isNotTheAttackersPetDog((Wolf)defendingEntity, attackingPlayer)) {
                    return !defenderTB.getPermissions().pvp;
                }
                if (defenderTB.getType() == TownBlockType.FARM && TownySettings.getFarmAnimals().contains(defendingEntity.getType().toString())) {
                    return !TownyActionEventExecutor.canDestroy(attackingPlayer, defendingEntity.getLocation(), Material.WHEAT);
                }
                if (EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defendingEntity)) {
                    return !TownyActionEventExecutor.canDestroy(attackingPlayer, defendingEntity.getLocation(), Material.DIRT);
                }
            }
            Material material = null;
            switch (defendingEntity.getType()) {
                case ITEM_FRAME: 
                case GLOW_ITEM_FRAME: 
                case PAINTING: 
                case ARMOR_STAND: 
                case ENDER_CRYSTAL: 
                case MINECART: 
                case MINECART_CHEST: 
                case MINECART_FURNACE: 
                case MINECART_COMMAND: 
                case MINECART_HOPPER: {
                    material = EntityTypeUtil.parseEntityToMaterial(defendingEntity.getType());
                    break;
                }
            }
            if (material != null) {
                return !TownyActionEventExecutor.canDestroy(attackingPlayer, defendingEntity.getLocation(), material);
            }
        } else if (defendingPlayer != null) {
            if (attackingEntity instanceof Wolf && (CombatUtil.preventPvP(world, attackerTB) || CombatUtil.preventPvP(world, defenderTB))) {
                ((Wolf)attackingEntity).setTarget(null);
                ((Wolf)attackingEntity).setAngry(false);
                return true;
            }
            if (attackingEntity instanceof LightningStrike && world.hasTridentStrike(attackingEntity.getEntityId()) && CombatUtil.preventPvP(world, defenderTB)) {
                return true;
            }
        } else {
            if (defenderTB == null) {
                return false;
            }
            if (attackingEntity instanceof Projectile) {
                return true;
            }
            Entity material = attackingEntity;
            if (material instanceof Wolf) {
                Wolf wolf = (Wolf)material;
                if (EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defendingEntity)) {
                    if (CombatUtil.isATamedWolfWithAOnlinePlayer(wolf)) {
                        Player owner = BukkitTools.getPlayer(wolf.getOwner().getName());
                        return !PlayerCacheUtil.getCachePermission(owner, defendingEntity.getLocation(), Material.AIR, TownyPermission.ActionType.DESTROY);
                    }
                    wolf.setTarget(null);
                    wolf.setAngry(false);
                    return true;
                }
            }
            if (attackingEntity.getType().name().equals("AXOLOTL") && EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defendingEntity)) {
                ((Axolotl)attackingEntity).setTarget(null);
                return true;
            }
        }
        return false;
    }

    private static boolean preventJailedPVP(Player defendingPlayer, Player attackingPlayer) {
        if (TownySettings.doJailPlotsPreventPVP()) {
            Resident defendingResident = TownyAPI.getInstance().getResident(defendingPlayer.getUniqueId());
            Resident attackingResident = TownyAPI.getInstance().getResident(attackingPlayer.getUniqueId());
            TownBlock defTB = TownyAPI.getInstance().getTownBlock(defendingPlayer.getLocation());
            TownBlock atkTB = TownyAPI.getInstance().getTownBlock(attackingPlayer.getLocation());
            if (defendingResident == null || attackingResident == null) {
                return false;
            }
            if (defendingResident.isJailed() && defTB != null && defTB.isJail() || attackingResident.isJailed() && atkTB != null && atkTB.isJail()) {
                return true;
            }
        }
        return false;
    }

    public static boolean preventPvP(TownyWorld world, TownBlock townBlock) {
        if (townBlock != null) {
            TownBlockPVPTestEvent event = new TownBlockPVPTestEvent(townBlock, CombatUtil.isPvP(townBlock));
            Bukkit.getPluginManager().callEvent((Event)event);
            return !event.isPvp();
        }
        WildernessPVPTestEvent event = new WildernessPVPTestEvent(world, CombatUtil.isWorldPvP(world));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isPvp();
    }

    private static boolean isPvP(@NotNull TownBlock townBlock) {
        if (townBlock.getTownOrNull().isAdminDisabledPVP()) {
            return false;
        }
        if (!(townBlock.getPermissions().pvp || townBlock.getTownOrNull().isPVP() || townBlock.getWorld().isForcePVP())) {
            return false;
        }
        return !townBlock.isHomeBlock() || !townBlock.getWorld().isForcePVP() || !TownySettings.isForcePvpNotAffectingHomeblocks();
    }

    public static boolean isWorldPvP(TownyWorld world) {
        return world.isForcePVP() || world.isPVP();
    }

    @Deprecated
    public static boolean preventFriendlyFire(Player attacker, Player defender) {
        return CombatUtil.preventFriendlyFire(attacker, defender, TownyAPI.getInstance().getTownyWorld(attacker.getWorld().getName()));
    }

    public static boolean preventFriendlyFire(Player attacker, Player defender, TownyWorld world) {
        if (attacker == defender) {
            return false;
        }
        if (attacker != null && defender != null && !world.isFriendlyFireEnabled() && CombatUtil.isAlly(attacker.getName(), defender.getName())) {
            if (CombatUtil.isArenaPlot(attacker, defender)) {
                return false;
            }
            TownyFriendlyFireTestEvent event = new TownyFriendlyFireTestEvent(attacker, defender, world);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isPVP() && !event.getCancelledMessage().isEmpty()) {
                TownyMessaging.sendErrorMsg((Object)attacker, event.getCancelledMessage());
            }
            return !event.isPVP();
        }
        return false;
    }

    public static boolean isArenaPlot(Player attacker, Player defender) {
        TownBlock attackerTB = TownyAPI.getInstance().getTownBlock(attacker.getLocation());
        TownBlock defenderTB = TownyAPI.getInstance().getTownBlock(defender.getLocation());
        return CombatUtil.isArenaPlot(attackerTB, defenderTB);
    }

    public static boolean isArenaPlot(TownBlock attackerTB, TownBlock defenderTB) {
        return defenderTB != null && attackerTB != null && defenderTB.getType() == TownBlockType.ARENA && attackerTB.getType() == TownBlockType.ARENA;
    }

    @Deprecated
    public static boolean isPvPPlot(Player attacker, Player defender) {
        return CombatUtil.isArenaPlot(attacker, defender);
    }

    public static boolean isAlly(String attackingResident, String defendingResident) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident residentA = townyUniverse.getResident(attackingResident);
        Resident residentB = townyUniverse.getResident(defendingResident);
        if (residentA == null || residentB == null || !residentA.hasTown() || !residentB.hasTown()) {
            return false;
        }
        return CombatUtil.isAlly(residentA.getTownOrNull(), residentB.getTownOrNull());
    }

    public static boolean isAlly(Town a, Town b) {
        if (CombatUtil.isSameTown(a, b)) {
            return true;
        }
        if (CombatUtil.isSameNation(a, b)) {
            return true;
        }
        return a.hasNation() && b.hasNation() && a.getNationOrNull().hasAlly(b.getNationOrNull());
    }

    public static boolean isSameNation(Town a, Town b) {
        if (CombatUtil.isSameTown(a, b)) {
            return true;
        }
        return a.hasNation() && b.hasNation() && a.getNationOrNull().equals(b.getNationOrNull());
    }

    public static boolean isSameTown(Town a, Town b) {
        return a == b;
    }

    public static boolean isSameNation(Resident a, Resident b) {
        if (!a.hasTown() || !b.hasTown()) {
            return false;
        }
        return CombatUtil.isSameNation(a.getTownOrNull(), b.getTownOrNull());
    }

    public static boolean isSameTown(Resident a, Resident b) {
        if (!a.hasTown() || !b.hasTown()) {
            return false;
        }
        return CombatUtil.isSameTown(a.getTownOrNull(), b.getTownOrNull());
    }

    public static boolean canAttackEnemy(String a, String b) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident residentA = townyUniverse.getResident(a);
        Resident residentB = townyUniverse.getResident(b);
        if (residentA == null || residentB == null || !residentA.hasNation() || !residentB.hasNation()) {
            return false;
        }
        if (CombatUtil.isSameTown(residentA, residentB)) {
            return false;
        }
        if (CombatUtil.isSameNation(residentA, residentB)) {
            return false;
        }
        Nation nationA = residentA.getNationOrNull();
        Nation nationB = residentB.getNationOrNull();
        if (nationA.isNeutral() || nationB.isNeutral()) {
            return false;
        }
        return nationA.hasEnemy(nationB);
    }

    public static boolean areAllAllies(List<Nation> possibleAllies) {
        if (possibleAllies.size() <= 1) {
            return true;
        }
        for (int i = 0; i < possibleAllies.size() - 1; ++i) {
            if (possibleAllies.get(i).hasAlly(possibleAllies.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnemy(String a, String b) {
        Resident residentA = TownyUniverse.getInstance().getResident(a);
        Resident residentB = TownyUniverse.getInstance().getResident(b);
        if (residentA == null || residentB == null || !residentA.hasNation() || !residentB.hasNation()) {
            return false;
        }
        return CombatUtil.isEnemy(residentA.getTownOrNull(), residentB.getTownOrNull());
    }

    public static boolean isEnemy(Town a, Town b) {
        if (!a.hasNation() || !b.hasNation()) {
            return false;
        }
        if (CombatUtil.isSameTown(a, b)) {
            return false;
        }
        if (CombatUtil.isSameNation(a, b)) {
            return false;
        }
        return a.getNationOrNull().hasEnemy(b.getNationOrNull());
    }

    public static boolean isEnemyTownBlock(Player player, WorldCoord worldCoord) {
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident != null && resident.hasTown() && worldCoord.hasTownBlock()) {
            return CombatUtil.isEnemy(resident.getTownOrNull(), worldCoord.getTownOrNull());
        }
        return false;
    }

    private static boolean isNotTheAttackersPetDog(Wolf wolf, Player attackingPlayer) {
        return wolf.isTamed() && !wolf.getOwner().equals(attackingPlayer);
    }

    private static boolean isATamedWolfWithAOnlinePlayer(Wolf wolf) {
        return wolf.isTamed() && wolf.getOwner().getName() != null && BukkitTools.isOnline(wolf.getOwner().getName());
    }

    public static boolean preventDispenserDamage(Block dispenser, Entity entity, EntityDamageEvent.DamageCause cause) {
        TownBlock dispenserTB = WorldCoord.parseWorldCoord(dispenser).getTownBlockOrNull();
        TownBlock defenderTB = WorldCoord.parseWorldCoord(entity).getTownBlockOrNull();
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(dispenser.getWorld().getName());
        if (world == null || !world.isUsingTowny()) {
            return false;
        }
        boolean preventDamage = false;
        if (!CombatUtil.isArenaPlot(dispenserTB, defenderTB)) {
            preventDamage = CombatUtil.preventPvP(world, dispenserTB) || CombatUtil.preventPvP(world, defenderTB);
        }
        TownyDispenserDamageEntityEvent event = new TownyDispenserDamageEntityEvent(entity.getLocation(), entity, cause, defenderTB, preventDamage, dispenser);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }
}

