/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.MojangException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.util.BukkitTools;
import java.io.IOException;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GatherResidentUUIDTask
implements Runnable {
    private Towny plugin;
    private static final Queue<Resident> queue = new ConcurrentLinkedQueue<Resident>();
    private static boolean offlineModeDetected = false;

    public GatherResidentUUIDTask(Towny plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        UUID uuid;
        if (queue.isEmpty()) {
            TownyTimerHandler.toggleGatherResidentUUIDTask(false);
            return;
        }
        Resident resident = queue.poll();
        if (resident.hasUUID()) {
            if (!offlineModeDetected && resident.getUUID().version() == 3) {
                offlineModeDetected = true;
            }
            return;
        }
        if (resident.isNPC()) {
            this.applyUUID(resident, UUID.randomUUID(), "Towny");
        }
        if ((uuid = BukkitTools.getUUIDSafely(resident.getName())) != null) {
            if (!offlineModeDetected && uuid.version() == 3) {
                offlineModeDetected = true;
            }
            this.applyUUID(resident, uuid, "cache");
        } else if (!offlineModeDetected) {
            try {
                uuid = BukkitTools.getUUIDFromResident(resident);
            }
            catch (MojangException e) {
                TownyMessaging.sendErrorMsg("HTTP Response Code 204 - Mojang says " + resident.getName() + " no longer has an account, this could be in error. Unable to gather UUID.");
                return;
            }
            catch (IOException e) {
                TownyMessaging.sendErrorMsg("Resident: " + resident.getName() + " caused an IOException in the GatheringResidentUUID task. Unable to gather UUID.");
                return;
            }
            if (uuid != null) {
                this.applyUUID(resident, uuid, "Mojang");
            } else {
                TownyMessaging.sendDebugMsg("Could not resolve UUID for resident: " + resident.getName() + ", sorry! Gather task will try again in a minute.");
                queue.add(resident);
                TownyTimerHandler.toggleGatherResidentUUIDTask(false);
                TownyTimerHandler.toggleGatherResidentUUIDTask(true);
            }
        }
    }

    public static void addResident(Resident resident) {
        queue.add(resident);
    }

    private void applyUUID(Resident resident, UUID uuid, String source) {
        resident.setUUID(uuid);
        try {
            TownyUniverse.getInstance().registerResidentUUID(resident);
        }
        catch (AlreadyRegisteredException e) {
            TownyMessaging.sendErrorMsg(String.format("Error registering resident UUID. Resident '%s' already has a UUID registered!", resident.getName()));
        }
        resident.save();
        TownySettings.incrementUUIDCount();
        TownyMessaging.sendDebugMsg("UUID stored for " + resident.getName() + " received from " + source + ". Progress: " + TownySettings.getUUIDPercent() + ".");
    }

    public static void markOfflineMode() {
        offlineModeDetected = true;
    }
}

