/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.jail;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Savable;
import com.palmergames.bukkit.towny.object.SpawnPoint;
import com.palmergames.bukkit.towny.object.SpawnPointLocation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;

public class Jail
implements Savable {
    private UUID uuid;
    private Town town;
    private TownBlock townBlock;
    private Map<String, Location> jailCellMap = new ConcurrentHashMap<String, Location>();
    private List<Location> jailCells = new ArrayList<Location>();

    public Jail(UUID uuid, Town town, TownBlock townBlock, List<Location> jailCells) {
        this.uuid = uuid;
        this.town = town;
        this.townBlock = townBlock;
        if (jailCells != null) {
            jailCells.stream().forEach(loc -> this.addJailCell((Location)loc));
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public Town getTown() {
        return this.town;
    }

    public void setTown(Town town) {
        this.town = town;
    }

    public TownBlock getTownBlock() {
        return this.townBlock;
    }

    public void setTownBlock(TownBlock townBlock) {
        this.townBlock = townBlock;
    }

    public List<Location> getJailCellLocations() {
        return Collections.unmodifiableList(this.jailCells);
    }

    public void setJailCells(List<Location> jailCells) {
        this.jailCells = jailCells;
    }

    public void addJailCell(Location location) {
        this.jailCells.add(location);
        this.jailCellMap.put(SpawnPointLocation.parseSpawnPointLocation(location).toString(), location);
        TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(location, SpawnPoint.SpawnPointType.JAIL_SPAWN));
    }

    public void removeJailCell(Location loc) {
        TownyUniverse.getInstance().removeSpawnPoint(loc);
        String spawn = SpawnPointLocation.parseSpawnPointLocation(loc).toString();
        this.jailCells.remove(this.jailCellMap.get(spawn));
        this.jailCellMap.remove(spawn);
    }

    public void removeAllCells() {
        for (Location loc : new ArrayList<Location>(this.jailCells)) {
            this.removeJailCell(loc);
        }
    }

    public boolean hasJailCell(SpawnPointLocation loc) {
        return this.jailCellMap.keySet().stream().anyMatch(spawn -> spawn.equals(loc.toString()));
    }

    public boolean hasJailCell(int index) {
        return this.jailCells != null && this.jailCells.size() >= index;
    }

    public Map<String, Location> getCellMap() {
        return this.jailCellMap;
    }

    public String getWildName() {
        return this.getTownBlock().getWorld().getUnclaimedZoneName();
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveJail(this);
    }

    public boolean hasCells() {
        return !this.jailCells.isEmpty();
    }

    public boolean hasName() {
        return !this.getTownBlock().getName().isEmpty();
    }

    public String getName() {
        if (this.hasName()) {
            return this.getTownBlock().getName();
        }
        return "";
    }
}

