/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy.adapter;

import com.palmergames.bukkit.towny.object.economy.adapter.EconomyAdapter;
import java.math.BigDecimal;
import net.tnemc.core.economy.EconomyAPI;
import org.bukkit.World;

public class ReserveEconomyAdapter
implements EconomyAdapter {
    final EconomyAPI economy;

    public ReserveEconomyAdapter(EconomyAPI economy) {
        this.economy = economy;
    }

    @Override
    public boolean add(String accountName, double amount, World world) {
        BigDecimal bd = BigDecimal.valueOf(amount);
        return this.economy.addHoldingsDetail(accountName, bd, world.getName()).success();
    }

    @Override
    public boolean subtract(String accountName, double amount, World world) {
        BigDecimal bd = BigDecimal.valueOf(amount);
        return this.economy.removeHoldingsDetail(accountName, bd, world.getName()).success();
    }

    @Override
    public boolean hasAccount(String accountName) {
        return this.economy.hasAccountDetail(accountName).success();
    }

    @Override
    public double getBalance(String accountName, World world) {
        return this.economy.getHoldings(accountName, world.getName()).doubleValue();
    }

    @Override
    public void newAccount(String accountName) {
        this.economy.createAccountDetail(accountName).success();
    }

    @Override
    public void deleteAccount(String accountName) {
        this.economy.deleteAccountDetail(accountName);
    }

    @Override
    public boolean setBalance(String accountName, double amount, World world) {
        BigDecimal bd = BigDecimal.valueOf(amount);
        return this.economy.setHoldingsDetail(accountName, bd, world.getName()).success();
    }

    @Override
    public String getFormattedBalance(double balance) {
        BigDecimal bd = BigDecimal.valueOf(balance);
        return this.economy.format(bd);
    }
}

