/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.comparators;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.adventure.text.format.NamedTextColor;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.nation.DisplayedNationsListSortEvent;
import com.palmergames.bukkit.towny.event.nation.NationListDisplayedNumOnlinePlayersCalculationEvent;
import com.palmergames.bukkit.towny.event.nation.NationListDisplayedNumResidentsCalculationEvent;
import com.palmergames.bukkit.towny.event.nation.NationListDisplayedNumTownBlocksCalculationEvent;
import com.palmergames.bukkit.towny.event.nation.NationListDisplayedNumTownsCalculationEvent;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class ComparatorCaches {
    private static LoadingCache<ComparatorType, List<TextComponent>> townCompCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ComparatorType, List<TextComponent>>(){

        public List<TextComponent> load(ComparatorType compType) throws Exception {
            return ComparatorCaches.gatherTownLines(compType);
        }
    });
    private static LoadingCache<ComparatorType, List<TextComponent>> nationCompCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ComparatorType, List<TextComponent>>(){

        public List<TextComponent> load(ComparatorType compType) throws Exception {
            return ComparatorCaches.gatherNationLines(compType);
        }
    });

    public static List<TextComponent> getTownListCache(ComparatorType compType) {
        try {
            return (List)townCompCache.get((Object)compType);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return new ArrayList<TextComponent>();
        }
    }

    public static List<TextComponent> getNationListCache(ComparatorType compType) {
        try {
            return (List)nationCompCache.get((Object)compType);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return new ArrayList<TextComponent>();
        }
    }

    private static List<TextComponent> gatherTownLines(ComparatorType compType) {
        ArrayList<TextComponent> output = new ArrayList<TextComponent>();
        List<Town> towns = TownyUniverse.getInstance().getDataSource().getTowns();
        towns.sort(compType.getComparator());
        for (Town town : towns) {
            TextComponent townName = (TextComponent)Component.text("\u00a7b" + StringMgmt.remUnderscore(town.getName())).clickEvent(ClickEvent.runCommand("/towny:town spawn " + town + " -ignore"));
            String slug = "";
            switch (compType) {
                case BALANCE: {
                    slug = "\u00a7b(" + TownyEconomyHandler.getFormattedBalance(town.getAccount().getCachedBalance()) + ")";
                    break;
                }
                case TOWNBLOCKS: {
                    slug = "\u00a7b(" + town.getTownBlocks().size() + ")";
                    break;
                }
                case RUINED: {
                    slug = "\u00a7b(" + town.getResidents().size() + ") " + (town.isRuined() ? Translation.of("msg_ruined") : "");
                    break;
                }
                case BANKRUPT: {
                    slug = "\u00a7b(" + town.getResidents().size() + ") " + (town.isBankrupt() ? Translation.of("msg_bankrupt") : "");
                    break;
                }
                case ONLINE: {
                    slug = "\u00a7b(" + TownyAPI.getInstance().getOnlinePlayersInTown(town).size() + ")";
                    break;
                }
                case FOUNDED: {
                    if (town.getRegistered() == 0L) break;
                    slug = "\u00a7b(" + TownyFormatter.registeredFormat.format(town.getRegistered()) + ")";
                    break;
                }
                default: {
                    slug = "\u00a7b(" + town.getResidents().size() + ")";
                }
            }
            townName = (TextComponent)townName.append(Component.text("\u00a78 - " + slug));
            if (town.isOpen()) {
                townName = (TextComponent)townName.append(Component.text(" \u00a7b" + Translation.of("status_title_open")));
            }
            String spawnCost = "Free";
            if (TownyEconomyHandler.isActive()) {
                spawnCost = ChatColor.RESET + Translation.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(town.getSpawnCost()));
            }
            townName = (TextComponent)townName.hoverEvent(HoverEvent.showText(Component.text(Translation.of("msg_click_spawn", town) + "\n" + spawnCost).color(NamedTextColor.GOLD)));
            output.add(townName);
        }
        return output;
    }

    private static List<TextComponent> gatherNationLines(ComparatorType compType) {
        ArrayList<TextComponent> output = new ArrayList<TextComponent>();
        List<Nation> nations = TownyUniverse.getInstance().getDataSource().getNations();
        nations.sort(compType.getComparator());
        DisplayedNationsListSortEvent nationListSortEvent = new DisplayedNationsListSortEvent(nations, compType);
        Bukkit.getPluginManager().callEvent((Event)nationListSortEvent);
        nations = nationListSortEvent.getNations();
        for (Nation nation : nations) {
            TextComponent nationName = (TextComponent)Component.text("\u00a7b" + StringMgmt.remUnderscore(nation.getName())).clickEvent(ClickEvent.runCommand("/towny:nation spawn " + nation + " -ignore"));
            String slug = "";
            switch (compType) {
                case BALANCE: {
                    slug = TownyEconomyHandler.getFormattedBalance(nation.getAccount().getCachedBalance());
                    break;
                }
                case TOWNBLOCKS: {
                    int rawNumTownsBlocks = nation.getTownBlocks().size();
                    NationListDisplayedNumTownBlocksCalculationEvent tbEvent = new NationListDisplayedNumTownBlocksCalculationEvent(nation, rawNumTownsBlocks);
                    Bukkit.getPluginManager().callEvent((Event)tbEvent);
                    slug = tbEvent.getDisplayedValue() + "";
                    break;
                }
                case TOWNS: {
                    int rawNumTowns = nation.getTowns().size();
                    NationListDisplayedNumTownsCalculationEvent tEvent = new NationListDisplayedNumTownsCalculationEvent(nation, rawNumTowns);
                    Bukkit.getPluginManager().callEvent((Event)tEvent);
                    slug = tEvent.getDisplayedValue() + "";
                    break;
                }
                case ONLINE: {
                    int rawNumOnlinePlayers = TownyAPI.getInstance().getOnlinePlayersInNation(nation).size();
                    NationListDisplayedNumOnlinePlayersCalculationEvent opEvent = new NationListDisplayedNumOnlinePlayersCalculationEvent(nation, rawNumOnlinePlayers);
                    Bukkit.getPluginManager().callEvent((Event)opEvent);
                    slug = opEvent.getDisplayedValue() + "";
                    break;
                }
                case FOUNDED: {
                    if (nation.getRegistered() == 0L) break;
                    slug = TownyFormatter.registeredFormat.format(nation.getRegistered());
                    break;
                }
                default: {
                    int rawNumResidents = nation.getResidents().size();
                    NationListDisplayedNumResidentsCalculationEvent rEvent = new NationListDisplayedNumResidentsCalculationEvent(nation, rawNumResidents);
                    Bukkit.getPluginManager().callEvent((Event)rEvent);
                    slug = rEvent.getDisplayedValue() + "";
                }
            }
            nationName = (TextComponent)nationName.append(Component.text("\u00a78 - \u00a7b(" + slug + ")"));
            if (nation.isOpen()) {
                nationName = (TextComponent)nationName.append(Component.text(" \u00a7b" + Translation.of("status_title_open")));
            }
            String spawnCost = "Free";
            if (TownyEconomyHandler.isActive()) {
                spawnCost = ChatColor.RESET + Translation.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(nation.getSpawnCost()));
            }
            nationName = (TextComponent)nationName.hoverEvent(HoverEvent.showText(Component.text("\u00a76" + Translation.of("msg_click_spawn", nation) + "\n" + spawnCost)));
            output.add(nationName);
        }
        return output;
    }
}

