/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.util.Colors;
import java.util.Locale;
import org.bukkit.command.CommandSender;

public class Translatable {
    private String key;
    private Object[] args;
    private boolean stripColors;
    private String appended = "";

    private Translatable(String key) {
        this.key = key;
    }

    private Translatable(String key, Object ... args) {
        this.key = key;
        this.args = args;
    }

    public static Translatable of(String key) {
        return new Translatable(key);
    }

    public static Translatable of(String key, Object ... args) {
        return new Translatable(key, args);
    }

    public String key() {
        return this.key;
    }

    public Object[] args() {
        return this.args;
    }

    public boolean stripColors() {
        return this.stripColors;
    }

    public String appended() {
        return this.appended;
    }

    public Translatable key(String key) {
        this.key = key;
        return this;
    }

    public Translatable args(Object ... args) {
        this.args = args;
        return this;
    }

    public Translatable stripColors(boolean strip) {
        this.stripColors = strip;
        return this;
    }

    public Translatable append(String append) {
        this.appended = this.appended + append;
        return this;
    }

    public String translate(Locale locale) {
        this.checkArgs(locale);
        String translated = this.args == null ? Translation.of(this.key, locale) : Translation.of(this.key, locale, this.args);
        translated = translated + this.appended;
        return this.stripColors ? Colors.strip(translated) : translated;
    }

    public String translate() {
        this.checkArgs();
        String translated = this.args == null ? Translation.of(this.key) : Translation.of(this.key, this.args);
        translated = translated + this.appended;
        return this.stripColors ? Colors.strip(translated) : translated;
    }

    public String forLocale(Resident resident) {
        return this.translate(Translation.getLocale(resident));
    }

    public String forLocale(CommandSender sender) {
        return this.translate(Translation.getLocale(sender));
    }

    public String defaultLocale() {
        return this.translate(Translation.getDefaultLocale());
    }

    private void checkArgs() {
        if (this.args == null) {
            return;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (!(this.args[i] instanceof Translatable)) continue;
            this.args[i] = ((Translatable)this.args[i]).translate();
        }
    }

    private void checkArgs(Locale locale) {
        if (this.args == null) {
            return;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (!(this.args[i] instanceof Translatable)) continue;
            this.args[i] = ((Translatable)this.args[i]).translate(locale);
        }
    }

    public String toString() {
        return this.translate();
    }
}

