/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerCache {
    private final HashMap<Material, Boolean> buildMatPermission = new HashMap();
    private final HashMap<Material, Boolean> destroyMatPermission = new HashMap();
    private final HashMap<Material, Boolean> switchMatPermission = new HashMap();
    private final HashMap<Material, Boolean> itemUseMatPermission = new HashMap();
    private WorldCoord lastWorldCoord;
    private String blockErrMsg;
    private Location lastLocation;
    private TownBlockStatus townBlockStatus = TownBlockStatus.UNKNOWN;

    public PlayerCache(TownyWorld world, Player player) {
        this(new WorldCoord(world.getName(), Coord.parseCoord((Entity)player)));
        this.setLastLocation(player.getLocation());
    }

    public PlayerCache(WorldCoord worldCoord) {
        this.setLastTownBlock(worldCoord);
    }

    public void setLastTownBlock(WorldCoord worldCoord) {
        this.lastWorldCoord = worldCoord;
    }

    public void resetAndUpdate(WorldCoord worldCoord) {
        this.reset();
        this.setLastTownBlock(worldCoord);
    }

    public WorldCoord getLastTownBlock() {
        return this.lastWorldCoord;
    }

    public boolean updateCoord(WorldCoord pos) {
        if (!this.getLastTownBlock().equals(pos)) {
            this.reset();
            this.setLastTownBlock(pos);
            return true;
        }
        return false;
    }

    public boolean getCachePermission(Material material, TownyPermission.ActionType action) throws NullPointerException {
        switch (action) {
            case BUILD: {
                return this.getBuildPermission(material);
            }
            case DESTROY: {
                return this.getDestroyPermission(material);
            }
            case SWITCH: {
                return this.getSwitchPermission(material);
            }
            case ITEM_USE: {
                return this.getItemUsePermission(material);
            }
        }
        throw new NullPointerException();
    }

    public void setBuildPermission(Material material, Boolean value) {
        this.updateMaps(this.buildMatPermission, material, value);
    }

    public void setDestroyPermission(Material material, Boolean value) {
        this.updateMaps(this.destroyMatPermission, material, value);
    }

    public void setSwitchPermission(Material material, Boolean value) {
        this.updateMaps(this.switchMatPermission, material, value);
    }

    public void setItemUsePermission(Material material, Boolean value) {
        this.updateMaps(this.itemUseMatPermission, material, value);
    }

    public boolean getBuildPermission(Material material) throws NullPointerException {
        return this.getBlockPermission(this.buildMatPermission, material);
    }

    public boolean getDestroyPermission(Material material) throws NullPointerException {
        return this.getBlockPermission(this.destroyMatPermission, material);
    }

    public boolean getSwitchPermission(Material material) throws NullPointerException {
        return this.getBlockPermission(this.switchMatPermission, material);
    }

    public Boolean getItemUsePermission(Material material) throws NullPointerException {
        return this.getBlockPermission(this.itemUseMatPermission, material);
    }

    private void updateMaps(HashMap<Material, Boolean> blockMap, Material material, Boolean value) {
        if (!blockMap.containsKey(material)) {
            blockMap.put(material, value);
        } else {
            blockMap.get(material);
        }
    }

    private boolean getBlockPermission(HashMap<Material, Boolean> blockMap, Material material) throws NullPointerException {
        if (!blockMap.containsKey(material)) {
            throw new NullPointerException();
        }
        return blockMap.get(material);
    }

    private void reset() {
        this.lastWorldCoord = null;
        this.townBlockStatus = null;
        this.blockErrMsg = null;
        this.buildMatPermission.clear();
        this.destroyMatPermission.clear();
        this.switchMatPermission.clear();
        this.itemUseMatPermission.clear();
    }

    public void setStatus(TownBlockStatus townBlockStatus) {
        this.townBlockStatus = townBlockStatus;
    }

    public TownBlockStatus getStatus() throws NullPointerException {
        if (this.townBlockStatus == null) {
            throw new NullPointerException();
        }
        return this.townBlockStatus;
    }

    public void setBlockErrMsg(String blockErrMsg) {
        this.blockErrMsg = blockErrMsg;
    }

    public String getBlockErrMsg() {
        String temp = this.blockErrMsg;
        this.setBlockErrMsg(null);
        return temp;
    }

    public boolean hasBlockErrMsg() {
        return this.blockErrMsg != null;
    }

    public void setLastLocation(Location lastLocation) {
        this.lastLocation = lastLocation.clone();
    }

    public Location getLastLocation() throws NullPointerException {
        if (this.lastLocation == null) {
            throw new NullPointerException();
        }
        return this.lastLocation;
    }

    public static enum TownBlockStatus {
        UNKNOWN,
        NOT_REGISTERED,
        OFF_WORLD,
        ADMIN,
        UNCLAIMED_ZONE,
        NATION_ZONE,
        LOCKED,
        WARZONE,
        OUTSIDER,
        PLOT_OWNER,
        PLOT_FRIEND,
        PLOT_TOWN,
        PLOT_ALLY,
        TOWN_OWNER,
        TOWN_RESIDENT,
        TOWN_ALLY,
        TOWN_NATION,
        ENEMY,
        TOWN_TRUSTED,
        PLOT_TRUSTED,
        UNKOWN;

    }
}

