/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import java.util.Arrays;
import java.util.stream.Collectors;

public class PermissionData {
    private PermissionGUIUtil.SetPermissionType[] permissionTypes;
    private long lastChangedAt;
    private String lastChangedBy;

    public PermissionData(PermissionGUIUtil.SetPermissionType[] permissionTypes, String changedBy) {
        this.permissionTypes = permissionTypes;
        this.lastChangedBy = changedBy;
        this.lastChangedAt = System.currentTimeMillis();
    }

    public PermissionData(String string) {
        String[] data = string.split(",");
        long lastChanged = Long.parseLong(data[1]);
        PermissionGUIUtil.SetPermissionType[] types = new PermissionGUIUtil.SetPermissionType[4];
        for (int i = 0; i < 4; ++i) {
            types[i] = PermissionGUIUtil.SetPermissionType.valueOf(data[i + 2]);
        }
        this.permissionTypes = types;
        this.lastChangedAt = lastChanged;
        this.lastChangedBy = data[0];
    }

    public PermissionGUIUtil.SetPermissionType[] getPermissionTypes() {
        return this.permissionTypes;
    }

    public String getLastChangedBy() {
        return this.lastChangedBy;
    }

    public long getLastChangedAt() {
        return this.lastChangedAt;
    }

    public void setLastChangedBy(String changedBy) {
        this.lastChangedBy = changedBy;
    }

    public void setLastChangedAt(long lastChangedAt) {
        this.lastChangedAt = lastChangedAt;
    }

    public void setPermissionTypes(PermissionGUIUtil.SetPermissionType[] permissionTypes) {
        this.permissionTypes = permissionTypes;
    }

    public String toString() {
        return this.lastChangedBy + "," + this.lastChangedAt + "," + Arrays.stream(this.permissionTypes).map(Enum::name).collect(Collectors.joining(","));
    }
}

