/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;

public class TownyWorldListener
implements Listener {
    private final Towny plugin;
    public static List<String> playersMap = new ArrayList<String>();

    public TownyWorldListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldLoadEvent event) {
        this.newWorld(event.getWorld().getName());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldInit(WorldInitEvent event) {
        this.newWorld(event.getWorld().getName());
    }

    private void newWorld(String worldName) {
        boolean dungeonWorld = Bukkit.getServer().getPluginManager().getPlugin("DungeonsXL") != null && worldName.startsWith("DXL_");
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            TownyUniverse.getInstance().getDataSource().newWorld(worldName);
            TownyWorld world = TownyAPI.getInstance().getTownyWorld(worldName);
            if (world == null) {
                TownyMessaging.sendErrorMsg("Could not create data for " + worldName);
            } else if (dungeonWorld) {
                world.setUsingTowny(false);
            } else if (!townyUniverse.getDataSource().loadWorld(world)) {
                world.save();
            }
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onLightningStrike(LightningStrikeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getWorld())) {
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getWorld().getName());
        if (event.getCause().equals((Object)LightningStrikeEvent.Cause.TRIDENT)) {
            townyWorld.addTridentStrike(event.getLightning().getEntityId());
            TownyWorld finalWorld = townyWorld;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> finalWorld.removeTridentStrike(event.getLightning().getEntityId()), 20L);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onStructureGrow(StructureGrowEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getWorld())) {
            return;
        }
        List<BlockState> disallowed = BorderUtil.disallowedBlocks(event.getBlocks(), event.getLocation().getBlock());
        if (!disallowed.isEmpty()) {
            event.getBlocks().removeAll(disallowed);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPortalCreate(PortalCreateEvent event) {
        if (event.getReason() != PortalCreateEvent.CreateReason.NETHER_PAIR) {
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getWorld())) {
            return;
        }
        if (!event.getEntity().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        for (BlockState block : event.getBlocks()) {
            if (TownyActionEventExecutor.canBuild((Player)event.getEntity(), block.getLocation(), Material.NETHER_PORTAL)) continue;
            TownyMessaging.sendErrorMsg((CommandSender)event.getEntity(), Translatable.of("msg_err_you_are_not_allowed_to_create_the_other_side_of_this_portal"));
            event.setCancelled(true);
            break;
        }
    }
}

