/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.adventure.audience.Audience;
import com.palmergames.adventure.bossbar.BossBar;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.event.BedExplodeEvent;
import com.palmergames.bukkit.towny.event.NewTownEvent;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownLeaveEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.CellBorder;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.util.DrawSmokeTaskFactory;
import com.palmergames.util.TimeMgmt;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TownyCustomListener
implements Listener {
    private final Towny plugin;
    private final Map<Player, Integer> playerActionTasks = new HashMap<Player, Integer>();
    private final Map<Player, BossBar> playerBossBarMap = new HashMap<Player, BossBar>();

    public TownyCustomListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent event) {
        WorldCoord to;
        Player player;
        block18: {
            player = event.getPlayer();
            WorldCoord from = event.getFrom();
            to = event.getTo();
            if (this.plugin.hasPlayerMode(player, "townclaim")) {
                TownCommand.parseTownClaimCommand(player, new String[0]);
            }
            if (this.plugin.hasPlayerMode(player, "townunclaim")) {
                TownCommand.parseTownUnclaimCommand(player, new String[0]);
            }
            if (this.plugin.hasPlayerMode(player, "map")) {
                TownyCommand.showMap(player);
            }
            try {
                if (!to.getTownyWorld().isUsingTowny() || !TownySettings.getShowTownNotifications()) break block18;
                Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                String msg = null;
                try {
                    if (resident != null) {
                        ChunkNotification chunkNotifier = new ChunkNotification(from, to);
                        msg = chunkNotifier.getNotificationString(resident);
                    }
                }
                catch (NullPointerException e) {
                    this.plugin.getLogger().info("ChunkNotifier generated an NPE, this is harmless but if you'd like to report it the following information will be useful:");
                    this.plugin.getLogger().info("  Player: " + player.getName() + "  To: " + to.getWorldName() + "," + to.getX() + "," + to.getZ() + "  From: " + from.getWorldName() + "," + from.getX() + "," + from.getZ());
                    e.printStackTrace();
                }
                if (msg != null) {
                    TextComponent msgComponent = LegacyComponentSerializer.builder().build().deserialize(msg);
                    Audience playerAudience = Towny.getAdventure().player(player);
                    if (TownySettings.isNotificationsAppearingInActionBar() && !TownySettings.isNotificationsAppearingOnBossbar()) {
                        int seconds = TownySettings.getInt(ConfigNodes.NOTIFICATION_DURATION);
                        if (seconds > 3) {
                            if (this.playerActionTasks.get(player) != null) {
                                Bukkit.getScheduler().cancelTask(this.playerActionTasks.get(player).intValue());
                                this.playerActionTasks.remove(player);
                            }
                            TextComponent messageComponent = msgComponent;
                            AtomicInteger remainingSeconds = new AtomicInteger(seconds);
                            int taskID = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                                playerAudience.sendActionBar(messageComponent);
                                remainingSeconds.getAndDecrement();
                                if (remainingSeconds.get() == 0 && this.playerActionTasks.containsKey(player)) {
                                    Bukkit.getScheduler().cancelTask(this.playerActionTasks.get(player).intValue());
                                    this.playerActionTasks.remove(player);
                                }
                            }, 0L, 20L).getTaskId();
                            this.playerActionTasks.put(player, taskID);
                        } else {
                            playerAudience.sendActionBar(msgComponent);
                        }
                    } else if (TownySettings.isNotificationsAppearingOnBossbar()) {
                        int seconds = TownySettings.getInt(ConfigNodes.NOTIFICATION_DURATION);
                        BossBar bossBar = BossBar.bossBar(msgComponent, 1.0f, BossBar.Color.WHITE, BossBar.Overlay.PROGRESS);
                        if (this.playerBossBarMap.containsKey(player)) {
                            Bukkit.getScheduler().cancelTask(this.playerActionTasks.get(player).intValue());
                            playerAudience.hideBossBar(this.playerBossBarMap.get(player));
                            this.playerActionTasks.remove(player);
                            this.playerBossBarMap.remove(player);
                        }
                        playerAudience.showBossBar(bossBar);
                        this.playerBossBarMap.put(player, bossBar);
                        int taskID = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                            playerAudience.hideBossBar(bossBar);
                            this.playerActionTasks.remove(player);
                            this.playerBossBarMap.remove(player);
                        }, (long)(seconds * 20)).getTaskId();
                        this.playerActionTasks.put(player, taskID);
                    } else {
                        TownyMessaging.sendMessage((Object)player, msg);
                    }
                }
            }
            catch (NotRegisteredException resident) {
                // empty catch block
            }
        }
        if (this.plugin.hasPlayerMode(player, "plotborder")) {
            CellBorder cellBorder = BorderUtil.getPlotBorder(to);
            cellBorder.runBorderedOnSurface(1, 2, DrawSmokeTaskFactory.sendToPlayer(player));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerCreateTown(NewTownEvent event) {
        Town town = event.getTown();
        double upkeep = TownySettings.getTownUpkeepCost(town);
        if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily() && upkeep > 0.0) {
            String cost = TownyEconomyHandler.getFormattedBalance(upkeep);
            String time = TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime());
            TownyMessaging.sendTownMessagePrefixed(town, Translatable.of("msg_new_town_advice", cost, time));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBedExplodeEvent(final BedExplodeEvent event) {
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(event.getLocation().getWorld().getName());
        world.addBedExplosionAtBlock(event.getLocation(), event.getMaterial());
        if (event.getLocation2() != null) {
            // empty if block
        }
        world.addBedExplosionAtBlock(event.getLocation2(), event.getMaterial());
        final TownyWorld finalWorld = world;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                finalWorld.removeBedExplosionAtBlock(event.getLocation());
                finalWorld.removeBedExplosionAtBlock(event.getLocation2());
            }
        }, 20L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTownLeaveNation(NationPreTownLeaveEvent event) {
        if (event.getTown().isConquered()) {
            event.setCancelMessage(Translation.of("msg_err_your_conquered_town_cannot_leave_the_nation_yet"));
            event.setCancelled(true);
        }
    }
}

