/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.google.gson.Gson;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.FlatFileSaveTask;
import com.palmergames.bukkit.towny.db.TownyDatabaseHandler;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.MetadataLoader;
import com.palmergames.bukkit.towny.tasks.DeleteFileTask;
import com.palmergames.bukkit.towny.utils.MapUtil;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;

public final class TownyFlatFileSource
extends TownyDatabaseHandler {
    private final String newLine = System.getProperty("line.separator");

    public TownyFlatFileSource(Towny plugin, TownyUniverse universe) {
        super(plugin, universe);
        if (!FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.dataFolderPath, this.dataFolderPath + File.separator + "residents", this.dataFolderPath + File.separator + "residents" + File.separator + "deleted", this.dataFolderPath + File.separator + "residents" + File.separator + "hibernated", this.dataFolderPath + File.separator + "towns", this.dataFolderPath + File.separator + "towns" + File.separator + "deleted", this.dataFolderPath + File.separator + "nations", this.dataFolderPath + File.separator + "nations" + File.separator + "deleted", this.dataFolderPath + File.separator + "worlds", this.dataFolderPath + File.separator + "worlds" + File.separator + "deleted", this.dataFolderPath + File.separator + "townblocks", this.dataFolderPath + File.separator + "plotgroups", this.dataFolderPath + File.separator + "plotgroups" + File.separator + "deleted", this.dataFolderPath + File.separator + "jails", this.dataFolderPath + File.separator + "jails" + File.separator + "deleted") || !FileMgmt.checkOrCreateFiles(this.dataFolderPath + File.separator + "worlds.txt")) {
            TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_cannot_create_defaults"));
        }
    }

    public String getResidentFilename(Resident resident) {
        return this.dataFolderPath + File.separator + "residents" + File.separator + resident.getName() + ".txt";
    }

    public String getHibernatedResidentFilename(UUID uuid) {
        return this.dataFolderPath + File.separator + "residents" + File.separator + "hibernated" + File.separator + uuid + ".txt";
    }

    public String getTownFilename(Town town) {
        return this.dataFolderPath + File.separator + "towns" + File.separator + town.getName() + ".txt";
    }

    public String getNationFilename(Nation nation) {
        return this.dataFolderPath + File.separator + "nations" + File.separator + nation.getName() + ".txt";
    }

    public String getWorldFilename(TownyWorld world) {
        return this.dataFolderPath + File.separator + "worlds" + File.separator + world.getName() + ".txt";
    }

    public String getTownBlockFilename(TownBlock townBlock) {
        return this.dataFolderPath + File.separator + "townblocks" + File.separator + townBlock.getWorld().getName() + File.separator + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    public String getPlotGroupFilename(PlotGroup group) {
        return this.dataFolderPath + File.separator + "plotgroups" + File.separator + group.getID() + ".data";
    }

    public String getJailFilename(Jail jail) {
        return this.dataFolderPath + File.separator + "jails" + File.separator + jail.getUUID() + ".txt";
    }

    @Override
    public boolean loadTownBlockList() {
        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_townblock_list"));
        File townblocksFolder = new File(this.dataFolderPath + File.separator + "townblocks");
        File[] worldFolders = townblocksFolder.listFiles(File::isDirectory);
        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_folders_found", worldFolders.length));
        boolean mismatched = false;
        int mismatchedCount = 0;
        try {
            for (File worldfolder : worldFolders) {
                TownyWorld world;
                String worldName = worldfolder.getName();
                try {
                    world = this.getWorld(worldName);
                }
                catch (NotRegisteredException e) {
                    this.newWorld(worldName);
                    world = this.getWorld(worldName);
                }
                File worldFolder = new File(this.dataFolderPath + File.separator + "townblocks" + File.separator + worldName);
                File[] townBlockFiles = worldFolder.listFiles(file -> file.getName().endsWith(".data"));
                int total = 0;
                for (File townBlockFile : townBlockFiles) {
                    String[] coords = townBlockFile.getName().split("_");
                    String[] size = coords[2].split("\\.");
                    if (Integer.parseInt(size[0]) != TownySettings.getTownBlockSize()) {
                        mismatched = true;
                        ++mismatchedCount;
                        continue;
                    }
                    int x = Integer.parseInt(coords[0]);
                    int z = Integer.parseInt(coords[1]);
                    TownBlock townBlock = new TownBlock(x, z, world);
                    TownyUniverse.getInstance().addTownBlock(townBlock);
                    ++total;
                }
                TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_world_loaded_townblocks", worldName, total));
            }
            if (mismatched) {
                TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_mismatched_townblock_size", mismatchedCount));
            }
            return true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadPlotGroupList() {
        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_group_list"));
        File[] plotGroupFiles = this.receiveObjectFiles("plotgroups", ".data");
        if (plotGroupFiles == null) {
            return true;
        }
        for (File plotGroup : plotGroupFiles) {
            TownyUniverse.getInstance().newPlotGroupInternal(plotGroup.getName().replace(".data", ""));
        }
        return true;
    }

    @Override
    public boolean loadResidentList() {
        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_resident_list"));
        List<String> residents = this.receiveListFromLegacyFile("residents.txt");
        File[] residentFiles = this.receiveObjectFiles("residents", ".txt");
        assert (residentFiles != null);
        for (File resident : residentFiles) {
            String name = resident.getName().replace(".txt", "");
            if (!residents.isEmpty() && !residents.contains(name)) {
                TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_removing_resident_not_found", resident.getName()));
                this.deleteFile(resident.getAbsolutePath());
                continue;
            }
            try {
                this.newResident(name);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
                return false;
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
        }
        if (!residents.isEmpty()) {
            this.deleteFile(this.dataFolderPath + File.separator + "residents.txt");
        }
        return true;
    }

    @Override
    public boolean loadHibernatedResidents() {
        TownyMessaging.sendDebugMsg("Loading hibernated residents.");
        File[] residentFiles = this.receiveObjectFiles("residents" + File.separator + "hibernated", ".txt");
        assert (residentFiles != null);
        for (File resident : residentFiles) {
            UUID uuid = UUID.fromString(resident.getName().replace(".txt", ""));
            HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(resident);
            long registered = 0L;
            String line = keys.get("registered");
            if (line != null) {
                registered = Long.parseLong(line);
            }
            if (registered <= 0L) continue;
            TownyUniverse.getInstance().registerHibernatedResident(uuid, registered);
        }
        return true;
    }

    @Override
    public boolean loadTownList() {
        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_town_list"));
        List<String> towns = this.receiveListFromLegacyFile("towns.txt");
        File[] townFiles = this.receiveObjectFiles("towns", ".txt");
        assert (townFiles != null);
        for (File town : townFiles) {
            String name = town.getName().replace(".txt", "");
            if (!towns.isEmpty() && !towns.contains(name)) {
                TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_removing_town_not_found", town.getName()));
                this.deleteFile(town.getAbsolutePath());
                continue;
            }
            try {
                TownyUniverse.getInstance().newTownInternal(name);
            }
            catch (AlreadyRegisteredException | InvalidNameException e) {
                String newName = this.generateReplacementName(true);
                TownyUniverse.getInstance().getReplacementNameMap().put(name, newName);
                TownyMessaging.sendErrorMsg(String.format("The town %s tried to load an invalid name, attempting to rename it to %s.", name, newName));
                try {
                    TownyUniverse.getInstance().newTownInternal(newName);
                }
                catch (AlreadyRegisteredException | InvalidNameException e1) {
                    e1.printStackTrace();
                    return false;
                }
                File newFile = new File(town.getParent(), newName + ".txt");
                town.renameTo(newFile);
            }
        }
        if (!towns.isEmpty()) {
            this.deleteFile(this.dataFolderPath + File.separator + "towns.txt");
        }
        return true;
    }

    @Override
    public boolean loadNationList() {
        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_nation_list"));
        List<String> nations = this.receiveListFromLegacyFile("nations.txt");
        File[] nationFiles = this.receiveObjectFiles("nations", ".txt");
        assert (nationFiles != null);
        for (File nation : nationFiles) {
            String name = nation.getName().replace(".txt", "");
            if (!nations.isEmpty() && !nations.contains(name)) {
                TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_removing_nation_not_found", nation.getName()));
                this.deleteFile(nation.getAbsolutePath());
                continue;
            }
            try {
                this.newNation(name);
            }
            catch (AlreadyRegisteredException | NotRegisteredException e) {
                String newName = this.generateReplacementName(false);
                TownyUniverse.getInstance().getReplacementNameMap().put(name, newName);
                TownyMessaging.sendErrorMsg(String.format("The nation %s tried to load an invalid name, attempting to rename it to %s.", name, newName));
                try {
                    this.newNation(newName);
                }
                catch (AlreadyRegisteredException | NotRegisteredException e1) {
                    e1.printStackTrace();
                    return false;
                }
                File newFile = new File(nation.getParent(), newName + ".txt");
                nation.renameTo(newFile);
            }
        }
        if (!nations.isEmpty()) {
            this.deleteFile(this.dataFolderPath + File.separator + "nations.txt");
        }
        return true;
    }

    @Override
    public boolean loadWorldList() {
        boolean bl;
        if (this.plugin != null) {
            TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_server_world_list"));
            for (World world : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(world.getName());
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
        }
        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_world_list"));
        String line = null;
        BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "worlds.txt"), StandardCharsets.UTF_8));
        try {
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                this.newWorld(line);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (AlreadyRegisteredException e) {
                return true;
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_loading_world_list_at_line", line));
                e.printStackTrace();
                return false;
            }
        }
        fin.close();
        return bl;
    }

    @Override
    public boolean loadJailList() {
        TownyMessaging.sendDebugMsg("Loading Jail List");
        File[] jailFiles = this.receiveObjectFiles("jails", ".txt");
        if (jailFiles == null) {
            return true;
        }
        for (File jail : jailFiles) {
            String uuid = jail.getName().replace(".txt", "");
            TownyUniverse.getInstance().newJailInternal(uuid);
        }
        return true;
    }

    private List<String> receiveListFromLegacyFile(String listFile) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + listFile), StandardCharsets.UTF_8));){
            String line;
            while ((line = fin.readLine()) != null && !line.equals("")) {
                list.add(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private File[] receiveObjectFiles(String folder, String extension) {
        return new File(this.dataFolderPath + File.separator + folder).listFiles(file -> file.getName().toLowerCase().endsWith(extension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadResident(Resident resident) {
        boolean save = true;
        String line = null;
        String path = this.getResidentFilename(resident);
        File fileResident = new File(path);
        if (fileResident.exists() && fileResident.isFile()) {
            block46: {
                TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_resident", resident.getName()));
                try {
                    HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileResident);
                    line = keys.get("lastOnline");
                    if (line != null) {
                        resident.setLastOnline(Long.parseLong(line));
                    }
                    if ((line = keys.get("uuid")) != null) {
                        UUID uuid = UUID.fromString(line);
                        if (TownyUniverse.getInstance().hasResident(uuid)) {
                            Resident olderRes = TownyUniverse.getInstance().getResident(uuid);
                            if (resident.getLastOnline() > olderRes.getLastOnline()) {
                                TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_deleting_duplicate", olderRes.getName(), resident.getName()));
                                try {
                                    TownyUniverse.getInstance().unregisterResident(olderRes);
                                }
                                catch (NotRegisteredException notRegisteredException) {
                                    // empty catch block
                                }
                                if (olderRes.hasTown()) {
                                    try {
                                        olderRes.getTown().removeResident(olderRes);
                                    }
                                    catch (NotRegisteredException notRegisteredException) {
                                        // empty catch block
                                    }
                                }
                                this.deleteResident(olderRes);
                            } else {
                                TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_deleting_duplicate", resident.getName(), olderRes.getName()));
                                try {
                                    TownyUniverse.getInstance().unregisterResident(resident);
                                }
                                catch (NotRegisteredException notRegisteredException) {
                                    // empty catch block
                                }
                                this.deleteResident(resident);
                                save = false;
                                boolean bl = true;
                                return bl;
                            }
                        }
                        resident.setUUID(uuid);
                        this.universe.registerResidentUUID(resident);
                    }
                    if ((line = keys.get("registered")) != null) {
                        resident.setRegistered(Long.parseLong(line));
                    } else {
                        resident.setRegistered(resident.getLastOnline());
                    }
                    line = keys.get("isNPC");
                    if (line != null) {
                        resident.setNPC(Boolean.parseBoolean(line));
                    }
                    if ((line = keys.get("jail")) != null && this.universe.hasJail(UUID.fromString(line))) {
                        resident.setJail(this.universe.getJail(UUID.fromString(line)));
                    }
                    if (resident.isJailed()) {
                        line = keys.get("jailCell");
                        if (line != null) {
                            resident.setJailCell(Integer.parseInt(line));
                        }
                        if ((line = keys.get("jailHours")) != null) {
                            resident.setJailHours(Integer.parseInt(line));
                        }
                    }
                    if ((line = keys.get("friends")) != null) {
                        List<Resident> friends = this.getResidents(line.split(","));
                        for (Resident friend : friends) {
                            try {
                                resident.addFriend(friend);
                            }
                            catch (AlreadyRegisteredException alreadyRegisteredException) {}
                        }
                    }
                    if ((line = keys.get("protectionStatus")) != null) {
                        resident.setPermissions(line);
                    }
                    if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                        MetadataLoader.getInstance().deserializeMetadata(resident, line.trim());
                    }
                    if ((line = keys.get("town")) == null) break block46;
                    Town town = null;
                    if (this.universe.hasTown(line)) {
                        town = this.universe.getTown(line);
                    } else if (this.universe.getReplacementNameMap().containsKey(line)) {
                        town = this.universe.getTown(this.universe.getReplacementNameMap().get(line));
                    } else {
                        TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_resident_tried_load_invalid_town", resident.getName(), line));
                    }
                    if (town == null) break block46;
                    resident.setTown(town, false);
                    line = keys.get("title");
                    if (line != null) {
                        resident.setTitle(line);
                    }
                    if ((line = keys.get("surname")) != null) {
                        resident.setSurname(line);
                    }
                    try {
                        line = keys.get("town-ranks");
                        if (line != null) {
                            resident.setTownRanks(Arrays.asList(line.split(",")));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        line = keys.get("nation-ranks");
                        if (line != null) {
                            resident.setNationRanks(Arrays.asList(line.split(",")));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    line = keys.get("joinedTownAt");
                    if (line != null) {
                        resident.setJoinedTownAt(Long.parseLong(line));
                    }
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_reading_resident_at_line", resident.getName(), line, resident.getName()));
                    e.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (save) {
                        this.saveResident(resident);
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadTown(Town town) {
        String line = null;
        String path = this.getTownFilename(town);
        File fileTown = new File(path);
        if (fileTown.exists() && fileTown.isFile()) {
            TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_town", town.getName()));
            try {
                Location loc;
                double z;
                double y;
                double x;
                TownyWorld world;
                String[] tokens;
                HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileTown);
                line = keys.get("mayor");
                if (line != null) {
                    try {
                        Resident res = this.universe.getResident(line);
                        if (res == null) {
                            throw new TownyException();
                        }
                        town.forceSetMayor(res);
                    }
                    catch (TownyException e1) {
                        if (town.getResidents().isEmpty()) {
                            this.deleteTown(town);
                        } else {
                            town.findNewMayor();
                        }
                        boolean bl = true;
                        this.saveTown(town);
                        return bl;
                    }
                }
                if ((line = keys.get("outlaws")) != null) {
                    for (String token : tokens = line.split(",")) {
                        if (token.isEmpty()) continue;
                        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_town_fetch_outlaw", token));
                        Resident outlaw = this.universe.getResident(token);
                        if (outlaw != null) {
                            try {
                                town.addOutlaw(outlaw);
                            }
                            catch (AlreadyRegisteredException ex) {
                                TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_reading_outlaw_of_town_duplicate", town.getName(), token));
                            }
                            continue;
                        }
                        TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_reading_outlaw_of_town_not_exist", town.getName(), token));
                    }
                }
                if ((line = keys.get("townBoard")) != null) {
                    town.setBoard(line);
                }
                if ((line = keys.get("tag")) != null) {
                    town.setTag(line);
                }
                if ((line = keys.get("protectionStatus")) != null) {
                    town.setPermissions(line);
                }
                if ((line = keys.get("bonusBlocks")) != null) {
                    try {
                        town.setBonusBlocks(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setBonusBlocks(0);
                    }
                }
                if ((line = keys.get("purchasedBlocks")) != null) {
                    try {
                        town.setPurchasedBlocks(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setPurchasedBlocks(0);
                    }
                }
                if ((line = keys.get("plotPrice")) != null) {
                    try {
                        town.setPlotPrice(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setPlotPrice(0.0);
                    }
                }
                if ((line = keys.get("hasUpkeep")) != null) {
                    try {
                        town.setHasUpkeep(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("taxpercent")) != null) {
                    try {
                        town.setTaxPercentage(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("maxPercentTaxAmount")) != null) {
                    town.setMaxPercentTaxAmount(Double.parseDouble(line));
                } else {
                    town.setMaxPercentTaxAmount(TownySettings.getMaxTownTaxPercentAmount());
                }
                line = keys.get("taxes");
                if (line != null) {
                    try {
                        town.setTaxes(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setTaxes(0.0);
                    }
                }
                if ((line = keys.get("plotTax")) != null) {
                    try {
                        town.setPlotTax(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setPlotTax(0.0);
                    }
                }
                if ((line = keys.get("commercialPlotPrice")) != null) {
                    try {
                        town.setCommercialPlotPrice(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setCommercialPlotPrice(0.0);
                    }
                }
                if ((line = keys.get("commercialPlotTax")) != null) {
                    try {
                        town.setCommercialPlotTax(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setCommercialPlotTax(0.0);
                    }
                }
                if ((line = keys.get("embassyPlotPrice")) != null) {
                    try {
                        town.setEmbassyPlotPrice(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setEmbassyPlotPrice(0.0);
                    }
                }
                if ((line = keys.get("embassyPlotTax")) != null) {
                    try {
                        town.setEmbassyPlotTax(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setEmbassyPlotTax(0.0);
                    }
                }
                if ((line = keys.get("spawnCost")) != null) {
                    try {
                        town.setSpawnCost(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setSpawnCost(TownySettings.getSpawnTravelCost());
                    }
                }
                if ((line = keys.get("adminDisabledPvP")) != null) {
                    try {
                        town.setAdminDisabledPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("adminEnabledPvP")) != null) {
                    try {
                        town.setAdminEnabledPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("open")) != null) {
                    try {
                        town.setOpen(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("public")) != null) {
                    try {
                        town.setPublic(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("conquered")) != null) {
                    try {
                        town.setConquered(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("conqueredDays")) != null) {
                    town.setConqueredDays(Integer.parseInt(line));
                }
                if ((line = keys.get("joinedNationAt")) != null) {
                    try {
                        town.setJoinedNationAt(Long.parseLong(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("movedHomeBlockAt")) != null) {
                    try {
                        town.setMovedHomeBlockAt(Long.parseLong(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("homeBlock")) != null && (tokens = line.split(",")).length == 3) {
                    try {
                        world = this.getWorld(tokens[0]);
                        try {
                            int x2 = Integer.parseInt(tokens[1]);
                            int z2 = Integer.parseInt(tokens[2]);
                            TownBlock homeBlock = TownyUniverse.getInstance().getTownBlock(new WorldCoord(world.getName(), x2, z2));
                            town.forceSetHomeBlock(homeBlock);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_homeblock_load_invalid_location", town.getName()));
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_homeblock_load_invalid_townblock", town.getName()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_town_homeblock_not_exist", town.getName()));
                        }
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_homeblock_load_invalid_world", town.getName()));
                    }
                }
                if ((line = keys.get("spawn")) != null && (tokens = line.split(",")).length >= 4) {
                    try {
                        world = this.plugin.getServerWorld(tokens[0]);
                        double x3 = Double.parseDouble(tokens[1]);
                        double y2 = Double.parseDouble(tokens[2]);
                        double z3 = Double.parseDouble(tokens[3]);
                        Location loc2 = new Location((World)world, x3, y2, z3);
                        if (tokens.length == 6) {
                            loc2.setPitch(Float.parseFloat(tokens[4]));
                            loc2.setYaw(Float.parseFloat(tokens[5]));
                        }
                        town.setSpawn(loc2);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException world2) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("outpostspawns")) != null) {
                    String[] outposts;
                    for (String spawn : outposts = line.split(";")) {
                        tokens = spawn.split(",");
                        if (tokens.length < 4) continue;
                        try {
                            World world3 = this.plugin.getServerWorld(tokens[0]);
                            x = Double.parseDouble(tokens[1]);
                            y = Double.parseDouble(tokens[2]);
                            z = Double.parseDouble(tokens[3]);
                            loc = new Location(world3, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            town.forceAddOutpostSpawn(loc);
                        }
                        catch (NotRegisteredException | NullPointerException | NumberFormatException world3) {
                            // empty catch block
                        }
                    }
                }
                if ((line = keys.get("jailspawns")) != null) {
                    String[] jails;
                    for (String spawn : jails = line.split(";")) {
                        tokens = spawn.split(",");
                        if (tokens.length < 4) continue;
                        try {
                            TownBlock tb;
                            World world4 = this.plugin.getServerWorld(tokens[0]);
                            x = Double.parseDouble(tokens[1]);
                            y = Double.parseDouble(tokens[2]);
                            z = Double.parseDouble(tokens[3]);
                            loc = new Location(world4, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            if ((tb = TownyUniverse.getInstance().getTownBlock(WorldCoord.parseWorldCoord(loc))) == null) continue;
                            Jail jail = new Jail(UUID.randomUUID(), town, tb, new ArrayList<Location>(Collections.singleton(loc)));
                            TownyUniverse.getInstance().registerJail(jail);
                            town.addJail(jail);
                            tb.setJail(jail);
                            jail.save();
                        }
                        catch (NotRegisteredException | NullPointerException | NumberFormatException exception) {
                            // empty catch block
                        }
                    }
                }
                if ((line = keys.get("uuid")) != null) {
                    UUID townUUID = null;
                    try {
                        townUUID = UUID.fromString(line);
                    }
                    catch (IllegalArgumentException ee) {
                        townUUID = UUID.randomUUID();
                    }
                    town.setUUID(townUUID);
                    TownyUniverse.getInstance().registerTownUUID(town);
                }
                if ((line = keys.get("registered")) != null) {
                    try {
                        town.setRegistered(Long.parseLong(line));
                    }
                    catch (Exception ee) {
                        town.setRegistered(0L);
                    }
                }
                if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(town, line.trim());
                }
                if ((line = keys.get("nation")) != null && !line.isEmpty()) {
                    Nation nation = null;
                    if (this.universe.hasNation(line)) {
                        nation = this.universe.getNation(line);
                    } else if (this.universe.getReplacementNameMap().containsKey(line)) {
                        nation = this.universe.getNation(this.universe.getReplacementNameMap().get(line));
                    }
                    if (nation != null) {
                        town.setNation(nation, false);
                    }
                }
                if ((line = keys.get("ruined")) != null) {
                    try {
                        town.setRuined(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        town.setRuined(false);
                    }
                }
                if ((line = keys.get("ruinedTime")) != null) {
                    try {
                        town.setRuinedTime(Long.parseLong(line));
                    }
                    catch (Exception ee) {
                        town.setRuinedTime(0L);
                    }
                }
                if ((line = keys.get("neutral")) != null) {
                    town.setNeutral(Boolean.parseBoolean(line));
                }
                if ((line = keys.get("debtBalance")) != null) {
                    try {
                        town.setDebtBalance(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setDebtBalance(0.0);
                    }
                }
                if ((line = keys.get("primaryJail")) != null) {
                    UUID uuid = UUID.fromString(line);
                    if (TownyUniverse.getInstance().hasJail(uuid)) {
                        town.setPrimaryJail(TownyUniverse.getInstance().getJail(uuid));
                    }
                }
                if ((line = keys.get("trustedResidents")) != null && !line.isEmpty()) {
                    for (Resident resident : this.getResidents(this.toUUIDArray(line.split(",")))) {
                        town.addTrustedResident(resident);
                    }
                }
                if ((line = keys.get("mapColorHexCode")) != null) {
                    try {
                        town.setMapColorHexCode(line);
                    }
                    catch (Exception e) {
                        town.setMapColorHexCode(MapUtil.generateRandomTownColourAsHexCode());
                    }
                } else {
                    town.setMapColorHexCode(MapUtil.generateRandomTownColourAsHexCode());
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_reading_town_file_at_line", town.getName(), line, town.getName()));
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.saveTown(town);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadNation(Nation nation) {
        String line = "";
        String path = this.getNationFilename(nation);
        File fileNation = new File(path);
        if (fileNation.exists() && fileNation.isFile()) {
            TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_nation", nation.getName()));
            try {
                String[] tokens;
                HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileNation);
                line = keys.get("capital");
                String cantLoadCapital = Translation.of("flatfile_err_nation_could_not_load_capital_disband", nation.getName());
                if (line != null) {
                    Town town = this.universe.getTown(line);
                    if (town != null) {
                        try {
                            nation.forceSetCapital(town);
                        }
                        catch (EmptyNationException e1) {
                            this.plugin.getLogger().warning(cantLoadCapital);
                            this.removeNation(nation);
                            boolean bl = true;
                            this.saveNation(nation);
                            return bl;
                        }
                    } else {
                        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_cannot_set_capital_try_next", nation.getName(), line));
                        if (!nation.findNewCapital()) {
                            this.plugin.getLogger().warning(cantLoadCapital);
                            this.removeNation(nation);
                            boolean e1 = true;
                            return e1;
                        }
                    }
                } else {
                    TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_undefined_capital_select_new", nation.getName()));
                    if (!nation.findNewCapital()) {
                        this.plugin.getLogger().warning(cantLoadCapital);
                        this.removeNation(nation);
                        boolean town = true;
                        return town;
                    }
                }
                line = keys.get("nationBoard");
                if (line != null) {
                    try {
                        nation.setBoard(line);
                    }
                    catch (Exception e) {
                        nation.setBoard("");
                    }
                }
                if ((line = keys.get("mapColorHexCode")) != null) {
                    try {
                        nation.setMapColorHexCode(line);
                    }
                    catch (Exception e) {
                        nation.setMapColorHexCode(MapUtil.generateRandomNationColourAsHexCode());
                    }
                } else {
                    nation.setMapColorHexCode(MapUtil.generateRandomNationColourAsHexCode());
                }
                line = keys.get("tag");
                if (line != null) {
                    nation.setTag(line);
                }
                if ((line = keys.get("allies")) != null) {
                    List<Nation> allies = this.getNations(line.split(","));
                    for (Nation ally : allies) {
                        nation.addAlly(ally);
                    }
                }
                if ((line = keys.get("enemies")) != null) {
                    List<Nation> enemies = this.getNations(line.split(","));
                    for (Nation enemy : enemies) {
                        nation.addEnemy(enemy);
                    }
                }
                if ((line = keys.get("taxes")) != null) {
                    try {
                        nation.setTaxes(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        nation.setTaxes(0.0);
                    }
                }
                if ((line = keys.get("spawnCost")) != null) {
                    try {
                        nation.setSpawnCost(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        nation.setSpawnCost(TownySettings.getSpawnTravelCost());
                    }
                }
                if ((line = keys.get("neutral")) != null) {
                    nation.setNeutral(Boolean.parseBoolean(line));
                }
                if ((line = keys.get("uuid")) != null) {
                    try {
                        nation.setUUID(UUID.fromString(line));
                    }
                    catch (IllegalArgumentException ee) {
                        nation.setUUID(UUID.randomUUID());
                    }
                    this.universe.registerNationUUID(nation);
                }
                if ((line = keys.get("registered")) != null) {
                    try {
                        nation.setRegistered(Long.parseLong(line));
                    }
                    catch (Exception ee) {
                        nation.setRegistered(0L);
                    }
                }
                if ((line = keys.get("nationSpawn")) != null && (tokens = line.split(",")).length >= 4) {
                    try {
                        World world = this.plugin.getServerWorld(tokens[0]);
                        double x = Double.parseDouble(tokens[1]);
                        double y = Double.parseDouble(tokens[2]);
                        double z = Double.parseDouble(tokens[3]);
                        Location loc = new Location(world, x, y, z);
                        if (tokens.length == 6) {
                            loc.setPitch(Float.parseFloat(tokens[4]));
                            loc.setYaw(Float.parseFloat(tokens[5]));
                        }
                        nation.setSpawn(loc);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("isPublic")) != null) {
                    try {
                        nation.setPublic(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("isOpen")) != null) {
                    try {
                        nation.setOpen(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(nation, line.trim());
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_reading_nation_file_at_line", nation.getName(), line, nation.getName()));
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.saveNation(nation);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadWorld(TownyWorld world) {
        File fileWorld;
        String line = "";
        String path = this.getWorldFilename(world);
        if (!FileMgmt.checkOrCreateFile(path)) {
            TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_exception_reading_file", path));
        }
        if ((fileWorld = new File(path)).exists() && fileWorld.isFile()) {
            TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_loading_world", world.getName()));
            try {
                ArrayList<String> mats2;
                HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileWorld);
                line = keys.get("claimable");
                if (line != null) {
                    try {
                        world.setClaimable(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("pvp")) != null) {
                    try {
                        world.setPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("forcepvp")) != null) {
                    try {
                        world.setForcePVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("friendlyFire")) != null) {
                    try {
                        world.setFriendlyFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("forcetownmobs")) != null) {
                    try {
                        world.setForceTownMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("wildernessmobs")) != null) {
                    try {
                        world.setWildernessMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("worldmobs")) != null) {
                    try {
                        world.setWorldMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("firespread")) != null) {
                    try {
                        world.setFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("forcefirespread")) != null) {
                    try {
                        world.setForceFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("explosions")) != null) {
                    try {
                        world.setExpl(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("forceexplosions")) != null) {
                    try {
                        world.setForceExpl(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("endermanprotect")) != null) {
                    try {
                        world.setEndermanProtect(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("disableplayertrample")) != null) {
                    try {
                        world.setDisablePlayerTrample(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("disablecreaturetrample")) != null) {
                    try {
                        world.setDisableCreatureTrample(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneBuild")) != null) {
                    try {
                        world.setUnclaimedZoneBuild(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneDestroy")) != null) {
                    try {
                        world.setUnclaimedZoneDestroy(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneSwitch")) != null) {
                    try {
                        world.setUnclaimedZoneSwitch(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneItemUse")) != null) {
                    try {
                        world.setUnclaimedZoneItemUse(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneName")) != null) {
                    try {
                        world.setUnclaimedZoneName(line);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneIgnoreIds")) != null) {
                    try {
                        mats2 = new ArrayList<String>();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            mats2.add(s);
                        }
                        world.setUnclaimedZoneIgnore(mats2);
                    }
                    catch (Exception mats2) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementDelete")) != null) {
                    try {
                        world.setUsingPlotManagementDelete(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats2) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("plotManagementDeleteIds")) != null) {
                    try {
                        mats2 = new ArrayList();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            mats2.add(s);
                        }
                        world.setPlotManagementDeleteIds(mats2);
                    }
                    catch (Exception mats3) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementMayorDelete")) != null) {
                    try {
                        world.setUsingPlotManagementMayorDelete(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats3) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("plotManagementMayorDelete")) != null) {
                    try {
                        ArrayList<String> materials = new ArrayList<String>();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            try {
                                materials.add(s.toUpperCase().trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementMayorDelete(materials);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementRevert")) != null) {
                    try {
                        world.setUsingPlotManagementRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("plotManagementIgnoreIds")) != null) {
                    try {
                        mats2 = new ArrayList();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            mats2.add(s);
                        }
                        world.setPlotManagementIgnoreIds(mats2);
                    }
                    catch (Exception mats4) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementWildRegen")) != null) {
                    try {
                        world.setUsingPlotManagementWildEntityRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats4) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("PlotManagementWildRegenEntities")) != null) {
                    try {
                        ArrayList<String> entities = new ArrayList<String>();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            try {
                                entities.add(s.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementWildRevertEntities(entities);
                    }
                    catch (Exception entities) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("PlotManagementWildRegenBlockWhitelist")) != null) {
                    try {
                        mats2 = new ArrayList();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            try {
                                mats2.add(s.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementWildRevertBlockWhitelist(mats2);
                    }
                    catch (Exception mats5) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementWildRegenDelay")) != null) {
                    try {
                        world.setPlotManagementWildRevertDelay(Long.parseLong(line));
                    }
                    catch (Exception mats5) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementWildRegenBlocks")) != null) {
                    try {
                        world.setUsingPlotManagementWildBlockRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats5) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("PlotManagementWildRegenBlocks")) != null) {
                    try {
                        mats2 = new ArrayList();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            try {
                                mats2.add(s.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementWildRevertMaterials(mats2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingTowny")) != null) {
                    try {
                        world.setUsingTowny(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("warAllowed")) != null) {
                    try {
                        world.setWarAllowed(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(world, line.trim());
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_exception_reading_world_file_at_line", path, line, world.getName()));
                boolean bl = false;
                return bl;
            }
            finally {
                this.saveWorld(world);
            }
            return true;
        }
        TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_file_error_reading_world_file_at_line", world.getName(), line, world.getName()));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadPlotGroup(PlotGroup group) {
        String line = "";
        String path = this.getPlotGroupFilename(group);
        File groupFile = new File(path);
        if (groupFile.exists() && groupFile.isFile()) {
            try {
                HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(groupFile);
                line = keys.get("groupName");
                if (line != null) {
                    group.setName(line.trim());
                }
                if ((line = keys.get("town")) != null && !line.isEmpty()) {
                    Town town = this.universe.getTown(line.trim());
                    if (town == null) {
                        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_group_file_missing_town_delete", path));
                        this.deletePlotGroup(group);
                        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_missing_file_delete_group_entry", path));
                        return true;
                    }
                    group.setTown(town);
                } else {
                    TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_could_not_add_to_town"));
                    this.deletePlotGroup(group);
                }
                line = keys.get("groupPrice");
                if (line == null) return true;
                if (line.isEmpty()) return true;
                group.setPrice(Double.parseDouble(line.trim()));
                return true;
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_exception_reading_group_file_at_line", path, line));
                return false;
            }
        }
        TownyMessaging.sendDebugMsg(Translation.of("flatfile_dbg_missing_file_delete_groups_entry", path));
        return true;
    }

    @Override
    public boolean loadTownBlocks() {
        String line = "";
        for (TownBlock townBlock : this.getAllTownBlocks()) {
            String path = this.getTownBlockFilename(townBlock);
            File fileTownBlock = new File(path);
            if (fileTownBlock.exists() && fileTownBlock.isFile()) {
                try {
                    HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileTownBlock);
                    line = keys.get("town");
                    if (line != null) {
                        if (line.isEmpty()) {
                            TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_townblock_file_missing_town_delete", path));
                            TownyUniverse.getInstance().removeTownBlock(townBlock);
                            this.deleteTownBlock(townBlock);
                            continue;
                        }
                        Town town = null;
                        if (this.universe.hasTown(line.trim())) {
                            town = this.universe.getTown(line.trim());
                        } else if (this.universe.getReplacementNameMap().containsKey(line.trim())) {
                            town = this.universe.getTown(this.universe.getReplacementNameMap().get(line).trim());
                        }
                        if (town == null) {
                            TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_townblock_file_contains_unregistered_town_delete", line, path));
                            TownyUniverse.getInstance().removeTownBlock(townBlock);
                            this.deleteTownBlock(townBlock);
                            continue;
                        }
                        townBlock.setTown(town, false);
                        try {
                            town.addTownBlock(townBlock);
                            TownyWorld townyWorld = townBlock.getWorld();
                            if (townyWorld != null && !townyWorld.hasTown(town)) {
                                townyWorld.addTown(town);
                            }
                        }
                        catch (AlreadyRegisteredException townyWorld) {}
                    } else {
                        TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_townblock_file_missing_town_delete", path));
                        TownyUniverse.getInstance().removeTownBlock(townBlock);
                        this.deleteTownBlock(townBlock);
                        continue;
                    }
                    if ((line = keys.get("name")) != null) {
                        try {
                            townBlock.setName(line.trim());
                        }
                        catch (Exception town) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("price")) != null) {
                        try {
                            townBlock.setPlotPrice(Double.parseDouble(line.trim()));
                        }
                        catch (Exception town) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("resident")) != null && !line.isEmpty()) {
                        Resident res = this.universe.getResident(line.trim());
                        if (res != null) {
                            townBlock.setResident(res);
                        } else {
                            TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_invalid_townblock_resident", townBlock.toString()));
                        }
                    }
                    if ((line = keys.get("type")) != null) {
                        try {
                            townBlock.setType(Integer.parseInt(line));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("outpost")) != null) {
                        try {
                            townBlock.setOutpost(Boolean.parseBoolean(line));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("permissions")) != null && !line.isEmpty()) {
                        try {
                            townBlock.setPermissions(line.trim());
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("changed")) != null) {
                        try {
                            townBlock.setChanged(Boolean.parseBoolean(line.trim()));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("locked")) != null) {
                        try {
                            townBlock.setLocked(Boolean.parseBoolean(line.trim()));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("claimedAt")) != null) {
                        try {
                            townBlock.setClaimedAt(Long.parseLong(line));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                        MetadataLoader.getInstance().deserializeMetadata(townBlock, line.trim());
                    }
                    line = keys.get("groupID");
                    UUID groupID = null;
                    if (line != null && !line.isEmpty()) {
                        groupID = UUID.fromString(line.trim());
                    }
                    if (groupID != null) {
                        PlotGroup group = this.getPlotObjectGroup(groupID);
                        if (group != null) {
                            townBlock.setPlotObjectGroup(group);
                            if (group.getPermissions() == null && townBlock.getPermissions() != null) {
                                group.setPermissions(townBlock.getPermissions());
                            }
                            if (townBlock.hasResident()) {
                                group.setResident(townBlock.getResidentOrNull());
                            }
                        } else {
                            townBlock.removePlotObjectGroup();
                        }
                    }
                    if ((line = keys.get("trustedResidents")) != null && !line.isEmpty() && townBlock.getTrustedResidents().isEmpty()) {
                        for (Resident resident : this.getResidents(this.toUUIDArray(line.split(",")))) {
                            townBlock.addTrustedResident(resident);
                        }
                        if (townBlock.hasPlotObjectGroup() && townBlock.getPlotObjectGroup().getTrustedResidents().isEmpty() && townBlock.getTrustedResidents().size() > 0) {
                            townBlock.getPlotObjectGroup().setTrustedResidents(townBlock.getTrustedResidents());
                        }
                    }
                    if ((line = keys.get("customPermissionData")) == null || line.isEmpty() || !townBlock.getPermissionOverrides().isEmpty()) continue;
                    Map map = (Map)new Gson().fromJson(line, Map.class);
                    for (Map.Entry entry : map.entrySet()) {
                        Resident resident;
                        try {
                            resident = TownyAPI.getInstance().getResident(UUID.fromString((String)entry.getKey()));
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                        if (resident == null) continue;
                        townBlock.getPermissionOverrides().put(resident, new PermissionData((String)entry.getValue()));
                    }
                    if (!townBlock.hasPlotObjectGroup() || !townBlock.getPlotObjectGroup().getPermissionOverrides().isEmpty() || townBlock.getPermissionOverrides().size() <= 0) continue;
                    townBlock.getPlotObjectGroup().setPermissionOverrides(townBlock.getPermissionOverrides());
                    continue;
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_exception_reading_townblock_file_at_line", path, line));
                    return false;
                }
            }
            TownyMessaging.sendErrorMsg(Translation.of("flatfile_err_townblock_file_unknown_err", path));
            TownyUniverse.getInstance().removeTownBlock(townBlock);
            this.deleteTownBlock(townBlock);
        }
        return true;
    }

    @Override
    public boolean loadJail(Jail jail) {
        String line = "";
        String path = this.getJailFilename(jail);
        File jailFile = new File(path);
        if (jailFile.exists() && jailFile.isFile()) {
            String[] tokens;
            HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(jailFile);
            line = keys.get("townblock");
            if (line != null) {
                tokens = line.split(",");
                TownBlock tb = null;
                try {
                    tb = TownyUniverse.getInstance().getTownBlock(new WorldCoord(tokens[0], Integer.parseInt(tokens[1].trim()), Integer.parseInt(tokens[2].trim())));
                    jail.setTownBlock(tb);
                    jail.setTown(tb.getTown());
                    tb.setJail(jail);
                    tb.getTown().addJail(jail);
                }
                catch (NotRegisteredException | NumberFormatException e) {
                    TownyMessaging.sendErrorMsg("Jail " + jail.getUUID() + " tried to load invalid townblock " + line + " deleting jail.");
                    this.removeJail(jail);
                    this.deleteJail(jail);
                    return true;
                }
            }
            if ((line = keys.get("spawns")) != null) {
                String[] jails;
                for (String spawn : jails = line.split(";")) {
                    tokens = spawn.split(",");
                    if (tokens.length < 4) continue;
                    try {
                        World world = this.plugin.getServerWorld(tokens[0]);
                        double x = Double.parseDouble(tokens[1]);
                        double y = Double.parseDouble(tokens[2]);
                        double z = Double.parseDouble(tokens[3]);
                        Location loc = new Location(world, x, y, z);
                        if (tokens.length == 6) {
                            loc.setPitch(Float.parseFloat(tokens[4]));
                            loc.setYaw(Float.parseFloat(tokens[5]));
                        }
                        jail.addJailCell(loc);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException e) {
                        TownyMessaging.sendErrorMsg("Jail " + jail.getUUID() + " tried to load invalid spawn " + line + " skipping.");
                    }
                }
                if (jail.getJailCellLocations().isEmpty()) {
                    TownyMessaging.sendErrorMsg("Jail " + jail.getUUID() + " loaded with zero spawns " + line + " deleting jail.");
                    this.removeJail(jail);
                    this.deleteJail(jail);
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean saveWorldList() {
        ArrayList<String> list = new ArrayList<String>();
        for (TownyWorld world : this.getWorlds()) {
            list.add(world.getName());
        }
        this.queryQueue.add(new FlatFileSaveTask(list, this.dataFolderPath + File.separator + "worlds.txt"));
        return true;
    }

    @Override
    public boolean saveResident(Resident resident) {
        ArrayList<String> list = new ArrayList<String>();
        if (resident.hasUUID()) {
            list.add("uuid=" + resident.getUUID());
        }
        list.add("lastOnline=" + resident.getLastOnline());
        list.add("registered=" + resident.getRegistered());
        list.add("joinedTownAt=" + resident.getJoinedTownAt());
        list.add("isNPC=" + resident.isNPC());
        if (resident.isJailed()) {
            list.add("jail=" + resident.getJail().getUUID());
            list.add("jailCell=" + resident.getJailCell());
            list.add("jailHours=" + resident.getJailHours());
        }
        list.add("title=" + resident.getTitle());
        list.add("surname=" + resident.getSurname());
        if (resident.hasTown()) {
            try {
                list.add("town=" + resident.getTown().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            list.add("town-ranks=" + StringMgmt.join(resident.getTownRanks(), ","));
            list.add("nation-ranks=" + StringMgmt.join(resident.getNationRanks(), ","));
        }
        list.add("friends=" + StringMgmt.join(resident.getFriends(), ","));
        list.add("");
        list.add("protectionStatus=" + resident.getPermissions().toString());
        list.add("metadata=" + this.serializeMetadata(resident));
        this.queryQueue.add(new FlatFileSaveTask(list, this.getResidentFilename(resident)));
        return true;
    }

    @Override
    public boolean saveHibernatedResident(UUID uuid) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("registered=" + this.universe.getHibernatedResidentRegistered(uuid));
        this.queryQueue.add(new FlatFileSaveTask(list, this.getHibernatedResidentFilename(uuid)));
        return true;
    }

    @Override
    public boolean saveTown(Town town) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("name=" + town.getName());
        if (town.hasMayor()) {
            list.add("mayor=" + town.getMayor().getName());
        }
        if (town.hasNation()) {
            try {
                list.add("nation=" + town.getNation().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        list.add("assistants=" + StringMgmt.join(town.getRank("assistant"), ","));
        list.add(this.newLine);
        list.add("townBoard=" + town.getBoard());
        list.add("tag=" + town.getTag());
        list.add("protectionStatus=" + town.getPermissions().toString());
        list.add("bonusBlocks=" + town.getBonusBlocks());
        list.add("purchasedBlocks=" + town.getPurchasedBlocks());
        list.add("taxpercent=" + town.isTaxPercentage());
        list.add("maxPercentTaxAmount=" + town.getMaxPercentTaxAmount());
        list.add("taxes=" + town.getTaxes());
        list.add("plotPrice=" + town.getPlotPrice());
        list.add("plotTax=" + town.getPlotTax());
        list.add("commercialPlotPrice=" + town.getCommercialPlotPrice());
        list.add("commercialPlotTax=" + town.getCommercialPlotTax());
        list.add("embassyPlotPrice=" + town.getEmbassyPlotPrice());
        list.add("embassyPlotTax=" + town.getEmbassyPlotTax());
        list.add("spawnCost=" + town.getSpawnCost());
        list.add("hasUpkeep=" + town.hasUpkeep());
        list.add("open=" + town.isOpen());
        list.add("adminDisabledPvP=" + town.isAdminDisabledPVP());
        list.add("adminEnabledPvP=" + town.isAdminEnabledPVP());
        list.add("public=" + town.isPublic());
        list.add("conquered=" + town.isConquered());
        list.add("conqueredDays " + town.getConqueredDays());
        if (town.hasValidUUID()) {
            list.add("uuid=" + town.getUUID());
        } else {
            list.add("uuid=" + UUID.randomUUID());
        }
        list.add("registered=" + town.getRegistered());
        list.add("joinedNationAt=" + town.getJoinedNationAt());
        list.add("movedHomeBlockAt=" + town.getMovedHomeBlockAt());
        if (town.hasHomeBlock()) {
            try {
                list.add("homeBlock=" + town.getHomeBlock().getWorld().getName() + "," + town.getHomeBlock().getX() + "," + town.getHomeBlock().getZ());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        if (town.hasSpawn()) {
            try {
                list.add("spawn=" + town.getSpawn().getWorld().getName() + "," + town.getSpawn().getX() + "," + town.getSpawn().getY() + "," + town.getSpawn().getZ() + "," + town.getSpawn().getPitch() + "," + town.getSpawn().getYaw());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        StringBuilder outpostArray = new StringBuilder("outpostspawns=");
        if (town.hasOutpostSpawn()) {
            for (Location spawn : new ArrayList<Location>(town.getAllOutpostSpawns())) {
                outpostArray.append(spawn.getWorld().getName()).append(",").append(spawn.getX()).append(",").append(spawn.getY()).append(",").append(spawn.getZ()).append(",").append(spawn.getPitch()).append(",").append(spawn.getYaw()).append(";");
            }
        }
        list.add(outpostArray.toString());
        list.add("outlaws=" + StringMgmt.join(town.getOutlaws(), ","));
        list.add("metadata=" + this.serializeMetadata(town));
        list.add("ruined=" + town.isRuined());
        list.add("ruinedTime=" + town.getRuinedTime());
        list.add("neutral=" + town.isNeutral());
        list.add("debtBalance=" + town.getDebtBalance());
        if (town.getPrimaryJail() != null) {
            list.add("primaryJail=" + town.getPrimaryJail().getUUID());
        }
        list.add("trustedResidents=" + StringMgmt.join(this.toUUIDList(town.getTrustedResidents()), ","));
        list.add("mapColorHexCode=" + town.getMapColorHexCode());
        this.queryQueue.add(new FlatFileSaveTask(list, this.getTownFilename(town)));
        return true;
    }

    @Override
    public boolean savePlotGroup(PlotGroup group) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("groupName=" + group.getName());
        list.add("groupPrice=" + group.getPrice());
        list.add("town=" + group.getTown().toString());
        this.queryQueue.add(new FlatFileSaveTask(list, this.getPlotGroupFilename(group)));
        return true;
    }

    @Override
    public boolean saveNation(Nation nation) {
        ArrayList<String> list = new ArrayList<String>();
        if (nation.hasCapital()) {
            list.add("capital=" + nation.getCapital().getName());
        }
        list.add("nationBoard=" + nation.getBoard());
        list.add("mapColorHexCode=" + nation.getMapColorHexCode());
        if (nation.hasTag()) {
            list.add("tag=" + nation.getTag());
        }
        list.add("allies=" + StringMgmt.join(nation.getAllies(), ","));
        list.add("enemies=" + StringMgmt.join(nation.getEnemies(), ","));
        list.add("taxes=" + nation.getTaxes());
        list.add("spawnCost=" + nation.getSpawnCost());
        list.add("neutral=" + nation.isNeutral());
        if (nation.hasValidUUID()) {
            list.add("uuid=" + nation.getUUID());
        } else {
            list.add("uuid=" + UUID.randomUUID());
        }
        list.add("registered=" + nation.getRegistered());
        if (nation.hasSpawn()) {
            try {
                list.add("nationSpawn=" + nation.getSpawn().getWorld().getName() + "," + nation.getSpawn().getX() + "," + nation.getSpawn().getY() + "," + nation.getSpawn().getZ() + "," + nation.getSpawn().getPitch() + "," + nation.getSpawn().getYaw());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        list.add("isPublic=" + nation.isPublic());
        list.add("isOpen=" + nation.isOpen());
        list.add("metadata=" + this.serializeMetadata(nation));
        this.queryQueue.add(new FlatFileSaveTask(list, this.getNationFilename(nation)));
        return true;
    }

    @Override
    public boolean saveWorld(TownyWorld world) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("pvp=" + world.isPVP());
        list.add("forcepvp=" + world.isForcePVP());
        list.add("friendlyFire=" + world.isFriendlyFireEnabled());
        list.add("# Can players found towns and claim plots in this world?");
        list.add("claimable=" + world.isClaimable());
        list.add("worldmobs=" + world.hasWorldMobs());
        list.add("wildernessmobs=" + world.hasWildernessMobs());
        list.add("forcetownmobs=" + world.isForceTownMobs());
        list.add("firespread=" + world.isFire());
        list.add("forcefirespread=" + world.isForceFire());
        list.add("explosions=" + world.isExpl());
        list.add("forceexplosions=" + world.isForceExpl());
        list.add("endermanprotect=" + world.isEndermanProtect());
        list.add("disableplayertrample=" + world.isDisablePlayerTrample());
        list.add("disablecreaturetrample=" + world.isDisableCreatureTrample());
        list.add("");
        list.add("# Unclaimed Zone settings.");
        if (world.getUnclaimedZoneBuild() != null) {
            list.add("unclaimedZoneBuild=" + world.getUnclaimedZoneBuild());
        }
        if (world.getUnclaimedZoneDestroy() != null) {
            list.add("unclaimedZoneDestroy=" + world.getUnclaimedZoneDestroy());
        }
        if (world.getUnclaimedZoneSwitch() != null) {
            list.add("unclaimedZoneSwitch=" + world.getUnclaimedZoneSwitch());
        }
        if (world.getUnclaimedZoneItemUse() != null) {
            list.add("unclaimedZoneItemUse=" + world.getUnclaimedZoneItemUse());
        }
        if (world.getUnclaimedZoneName() != null) {
            list.add("unclaimedZoneName=" + world.getUnclaimedZoneName());
        }
        list.add("");
        list.add("# The following are blocks that will bypass the above build, destroy, switch and itemuse settings.");
        if (world.getUnclaimedZoneIgnoreMaterials() != null) {
            list.add("unclaimedZoneIgnoreIds=" + StringMgmt.join(world.getUnclaimedZoneIgnoreMaterials(), ","));
        }
        list.add("");
        list.add("# The following settings control what blocks are deleted upon a townblock being unclaimed");
        list.add("usingPlotManagementDelete=" + world.isUsingPlotManagementDelete());
        if (world.getPlotManagementDeleteIds() != null) {
            list.add("plotManagementDeleteIds=" + StringMgmt.join(world.getPlotManagementDeleteIds(), ","));
        }
        list.add("");
        list.add("# The following settings control what blocks are deleted upon a mayor issuing a '/plot clear' command");
        list.add("usingPlotManagementMayorDelete=" + world.isUsingPlotManagementMayorDelete());
        if (world.getPlotManagementMayorDelete() != null) {
            list.add("plotManagementMayorDelete=" + StringMgmt.join(world.getPlotManagementMayorDelete(), ","));
        }
        list.add("");
        list.add("# If enabled when a town claims a townblock a snapshot will be taken at the time it is claimed.");
        list.add("# When the townblock is unclaimed its blocks will begin to revert to the original snapshot.");
        list.add("usingPlotManagementRevert=" + world.isUsingPlotManagementRevert());
        list.add("# Any block Id's listed here will not be respawned. Instead it will revert to air. This list also world on the WildRegen settings below.");
        if (world.getPlotManagementIgnoreIds() != null) {
            list.add("plotManagementIgnoreIds=" + StringMgmt.join(world.getPlotManagementIgnoreIds(), ","));
        }
        list.add("");
        list.add("# The following settings control which entities/blocks' explosions are reverted in the wilderness.");
        list.add("# If enabled any damage caused by entity explosions will repair itself.");
        list.add("usingPlotManagementWildRegen=" + world.isUsingPlotManagementWildEntityRevert());
        list.add("# The list of entities whose explosions would be reverted.");
        if (world.getPlotManagementWildRevertEntities() != null) {
            list.add("PlotManagementWildRegenEntities=" + StringMgmt.join(world.getPlotManagementWildRevertEntities(), ","));
        }
        list.add("# If enabled any damage caused by block explosions will repair itself.");
        list.add("usingPlotManagementWildRegenBlocks=" + world.isUsingPlotManagementWildBlockRevert());
        list.add("# The list of blocks whose explosions would be reverted.");
        if (world.getPlotManagementWildRevertBlocks() != null) {
            list.add("PlotManagementWildRegenBlocks=" + StringMgmt.join(world.getPlotManagementWildRevertBlocks(), ","));
        }
        list.add("# The list of blocks to regenerate. (if empty all blocks will regenerate)");
        if (world.getPlotManagementWildRevertBlockWhitelist() != null) {
            list.add("PlotManagementWildRegenBlockWhitelist=" + StringMgmt.join(world.getPlotManagementWildRevertBlockWhitelist(), ","));
        }
        list.add("# The delay after which the explosion reverts will begin.");
        list.add("usingPlotManagementWildRegenDelay=" + world.getPlotManagementWildRevertDelay());
        list.add("");
        list.add("# This setting is used to enable or disable Towny in this world.");
        list.add("usingTowny=" + world.isUsingTowny());
        list.add("");
        list.add("# This setting is used to enable or disable Event war in this world.");
        list.add("warAllowed=" + world.isWarAllowed());
        list.add("");
        list.add("metadata=" + this.serializeMetadata(world));
        this.queryQueue.add(new FlatFileSaveTask(list, this.getWorldFilename(world)));
        return true;
    }

    @Override
    public boolean saveTownBlock(TownBlock townBlock) {
        FileMgmt.checkOrCreateFolder(this.dataFolderPath + File.separator + "townblocks" + File.separator + townBlock.getWorld().getName());
        ArrayList<String> list = new ArrayList<String>();
        list.add("name=" + townBlock.getName());
        list.add("price=" + townBlock.getPlotPrice());
        try {
            list.add("town=" + townBlock.getTown().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (townBlock.hasResident()) {
            list.add("resident=" + townBlock.getResidentOrNull().getName());
        }
        list.add("type=" + townBlock.getType().getId());
        list.add("outpost=" + townBlock.isOutpost());
        if (townBlock.isChanged()) {
            list.add("permissions=" + townBlock.getPermissions().toString());
        }
        list.add("changed=" + townBlock.isChanged());
        list.add("locked=" + townBlock.isLocked());
        list.add("claimedAt=" + townBlock.getClaimedAt());
        list.add("metadata=" + this.serializeMetadata(townBlock));
        StringBuilder groupID = new StringBuilder();
        if (townBlock.hasPlotObjectGroup()) {
            groupID.append(townBlock.getPlotObjectGroup().getID());
        }
        list.add("groupID=" + groupID);
        list.add("trustedResidents=" + StringMgmt.join(this.toUUIDList(townBlock.getTrustedResidents()), ","));
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<Resident, PermissionData> entry : townBlock.getPermissionOverrides().entrySet()) {
            stringMap.put(entry.getKey().getUUID().toString(), entry.getValue().toString());
        }
        list.add("customPermissionData=" + new Gson().toJson(stringMap));
        this.queryQueue.add(new FlatFileSaveTask(list, this.getTownBlockFilename(townBlock)));
        return true;
    }

    @Override
    public boolean saveJail(Jail jail) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("townblock=" + jail.getTownBlock().getWorldCoord().toString());
        StringBuilder jailArray = new StringBuilder("spawns=");
        for (Location spawn : new ArrayList<Location>(jail.getJailCellLocations())) {
            jailArray.append(spawn.getWorld().getName()).append(",").append(spawn.getX()).append(",").append(spawn.getY()).append(",").append(spawn.getZ()).append(",").append(spawn.getPitch()).append(",").append(spawn.getYaw()).append(";");
        }
        list.add(jailArray.toString());
        this.queryQueue.add(new FlatFileSaveTask(list, this.getJailFilename(jail)));
        return true;
    }

    @Override
    public void deleteResident(Resident resident) {
        File file = new File(this.getResidentFilename(resident));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    @Override
    public void deleteHibernatedResident(UUID uuid) {
        File file = new File(this.getHibernatedResidentFilename(uuid));
        this.queryQueue.add(new DeleteFileTask(file, true));
    }

    @Override
    public void deleteTown(Town town) {
        File file = new File(this.getTownFilename(town));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    @Override
    public void deleteNation(Nation nation) {
        File file = new File(this.getNationFilename(nation));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    @Override
    public void deleteWorld(TownyWorld world) {
        File file = new File(this.getWorldFilename(world));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        File file = new File(this.getTownBlockFilename(townBlock));
        this.queryQueue.add(() -> {
            if (file.exists()) {
                String name = null;
                try {
                    name = townBlock.getTown().getName();
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                if (name != null) {
                    FileMgmt.moveTownBlockFile(file, "deleted", name);
                } else {
                    FileMgmt.moveTownBlockFile(file, "deleted", "");
                }
            }
        });
    }

    @Override
    public void deletePlotGroup(PlotGroup group) {
        File file = new File(this.getPlotGroupFilename(group));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    @Override
    public void deleteJail(Jail jail) {
        File file = new File(this.getJailFilename(jail));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    public static enum elements {
        VER,
        NOVALUE;


        public static elements fromString(String str) {
            try {
                return elements.valueOf(str);
            }
            catch (Exception ex) {
                return NOVALUE;
            }
        }
    }
}

