/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.conversation;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.conversation.TownyConversation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translatable;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResidentConversation
extends TownyConversation {
    public ResidentConversation(Player player) {
        new ConversationFactory((Plugin)Towny.getPlugin()).withPrefix((ConversationPrefix)this).addConversationAbandonedListener((ConversationAbandonedListener)this).withFirstPrompt((Prompt)new ResidentPrompt()).withEscapeSequence("q").withTimeout(30).withLocalEcho(false).withModality(false).buildConversation((Conversable)player).begin();
    }

    private class ResidentPrompt
    extends StringPrompt {
        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            return Translatable.of("msg_resident_prompt").forLocale((CommandSender)ResidentConversation.this.getPlayer(context));
        }

        @Nullable
        public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String string) {
            if (string != null) {
                Resident resident = TownyAPI.getInstance().getResident(string);
                if (resident == null) {
                    TownyMessaging.sendErrorMsg((CommandSender)ResidentConversation.this.getPlayer(context), Translatable.of("msg_err_not_registered_1", string));
                } else if (ResidentConversation.this.consumer != null) {
                    ResidentConversation.this.consumer.accept(resident);
                }
            }
            return Prompt.END_OF_CONVERSATION;
        }
    }
}

