/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.confirmations;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.confirmations.ConfirmationHandler;
import com.palmergames.bukkit.towny.object.Translatable;
import org.bukkit.command.CommandSender;

public class ConfirmationBuilder {
    Runnable acceptHandler;
    Runnable cancelHandler;
    Object title;
    int duration = TownySettings.getConfirmationTimeoutSeconds();
    boolean runAsync;

    public ConfirmationBuilder runOnCancel(Runnable cancelHandler) {
        this.cancelHandler = cancelHandler;
        return this;
    }

    public ConfirmationBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public ConfirmationBuilder setTitle(Translatable title) {
        this.title = title;
        return this;
    }

    public ConfirmationBuilder setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public ConfirmationBuilder setAsync(boolean runAsync) {
        this.runAsync = runAsync;
        return this;
    }

    public Confirmation build() {
        return new Confirmation(this);
    }

    public void sendTo(CommandSender sender) {
        Confirmation confirmation = this.build();
        ConfirmationHandler.sendConfirmation(sender, confirmation);
    }
}

