/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.confirmations;

import com.palmergames.bukkit.towny.confirmations.ConfirmationBuilder;
import com.palmergames.bukkit.towny.object.Translatable;
import java.util.Locale;

public class Confirmation {
    private final Runnable acceptHandler;
    private final Runnable cancelHandler;
    private final Object title;
    private final int duration;
    private final boolean isAsync;

    public static ConfirmationBuilder runOnAccept(Runnable acceptHandler) {
        ConfirmationBuilder builder = new ConfirmationBuilder();
        builder.acceptHandler = acceptHandler;
        return builder;
    }

    public static ConfirmationBuilder runOnAcceptAsync(Runnable acceptHandler) {
        ConfirmationBuilder builder = new ConfirmationBuilder();
        builder.acceptHandler = acceptHandler;
        builder.runAsync = true;
        return builder;
    }

    protected Confirmation(ConfirmationBuilder builder) {
        this.acceptHandler = builder.acceptHandler;
        this.cancelHandler = builder.cancelHandler;
        this.title = builder.title;
        this.duration = builder.duration;
        this.isAsync = builder.runAsync;
    }

    public Runnable getAcceptHandler() {
        return this.acceptHandler;
    }

    public Runnable getCancelHandler() {
        return this.cancelHandler;
    }

    public String getTitle() {
        if (this.title instanceof Translatable) {
            return ((Translatable)this.title).translate();
        }
        return (String)this.title;
    }

    public String getTitle(Locale locale) {
        if (this.title instanceof Translatable) {
            return ((Translatable)this.title).translate(locale);
        }
        return (String)this.title;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isAsync() {
        return this.isAsync;
    }
}

