/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.PlotCommand;
import com.palmergames.bukkit.towny.command.ResidentCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.conversation.SetupConversation;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.event.NationPreRenameEvent;
import com.palmergames.bukkit.towny.event.TownPreRenameEvent;
import com.palmergames.bukkit.towny.event.TownyLoadedDatabaseEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.InvalidMetadataTypeException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.BackupTask;
import com.palmergames.bukkit.towny.tasks.PlotClaim;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TownyAdminCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> adminTabCompletes;
    private static final List<String> adminTownTabCompletes;
    private static final List<String> adminNationTabCompletes;
    private static final List<String> adminToggleTabCompletes;
    private static final List<String> adminPlotTabCompletes;
    private static final List<String> adminMetaTabCompletes;
    private static final List<String> adminDatabaseTabCompletes;
    private static final List<String> adminResidentTabCompletes;
    private static final List<String> adminResidentFriendTabCompletes;
    private static final List<String> adminSetCompletes;
    private static final List<String> adminTownyPermsCompletes;
    private boolean isConsole;
    private Player player;
    private CommandSender sender;

    public TownyAdminCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        this.sender = sender;
        if (sender instanceof Player) {
            this.player = (Player)sender;
            this.isConsole = false;
        } else {
            this.isConsole = true;
            this.player = null;
        }
        try {
            return this.parseTownyAdminCommand(args);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (args.length > 1) {
                    return NameUtil.filterByStart(Arrays.asList("database", "db", "config", "perms", "permissions", "language", "lang", "townyperms", "all"), args[1]);
                }
            }
            case "purge": {
                if (args.length != 3) return Collections.emptyList();
                return TownyAdminCommand.filterByStartOrGetTownyStartingWith(Collections.singletonList("townless"), args[2], "+t");
            }
            case "set": {
                if (args.length <= 1) return Collections.emptyList();
                switch (args[1].toLowerCase()) {
                    case "mayor": {
                        switch (args.length) {
                            case 3: {
                                return TownyAdminCommand.getTownyStartingWith(args[2], "t");
                            }
                            case 4: {
                                return TownyAdminCommand.filterByStartOrGetTownyStartingWith(Collections.singletonList("npc"), args[3], "+r");
                            }
                        }
                    }
                    case "capital": 
                    case "plot": {
                        if (args.length == 3) {
                            return TownyAdminCommand.getTownyStartingWith(args[2], "t");
                        }
                    }
                    case "title": 
                    case "surname": {
                        if (args.length != 3) break;
                        return TownyAdminCommand.getTownyStartingWith(args[2], "r");
                    }
                }
                if (args.length == 2) {
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNYADMIN_SET, adminSetCompletes), args[1]);
                }
                if (args.length <= 2) return Collections.emptyList();
                if (!TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN_SET, args[1])) return Collections.emptyList();
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN_SET, args[1]).getTabCompletion(args.length - 1), args[args.length - 1]);
            }
            case "plot": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(adminPlotTabCompletes, args[1]);
                }
                if (args.length <= 2) return Collections.emptyList();
                switch (args[1].toLowerCase()) {
                    case "claim": {
                        return TownyAdminCommand.getTownyStartingWith(args[2], "r");
                    }
                    case "meta": {
                        if (args.length == 3) {
                            return NameUtil.filterByStart(adminMetaTabCompletes, args[2]);
                        }
                    }
                    case "trust": {
                        if (args.length == 3) {
                            return NameUtil.filterByStart(Arrays.asList("add", "remove"), args[2]);
                        }
                        if (args.length != 4) return Collections.emptyList();
                        return TownyAdminCommand.getTownyStartingWith(args[3], "r");
                    }
                }
                return Collections.emptyList();
            }
            case "givebonus": {
                if (args.length != 2) return Collections.emptyList();
                return TownyAdminCommand.getTownyStartingWith(args[1], "rt");
            }
            case "toggle": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNYADMIN_TOGGLE, adminToggleTabCompletes), args[1]);
                }
                if (args.length >= 3 && args[1].equalsIgnoreCase("npc")) {
                    if (args.length == 3) {
                        return TownyAdminCommand.getTownyStartingWith(args[2], "r");
                    }
                    if (args.length != 4) return Collections.emptyList();
                    return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[3]);
                }
                if (args.length != 3) return Collections.emptyList();
                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
            }
            case "tpplot": {
                if (args.length != 2) return Collections.emptyList();
                return NameUtil.filterByStart(TownyUniverse.getInstance().getDataSource().getWorlds().stream().map(TownyObject::getName).collect(Collectors.toList()), args[1]);
            }
            case "checkperm": 
            case "delete": {
                if (args.length != 2) return Collections.emptyList();
                return TownyAdminCommand.getTownyStartingWith(args[1], "r");
            }
            case "database": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(adminDatabaseTabCompletes, args[1]);
                }
                if (args.length != 3) return Collections.emptyList();
                if (!args[1].equalsIgnoreCase("remove")) return Collections.emptyList();
                return Collections.singletonList("titles");
            }
            case "resident": {
                switch (args.length) {
                    case 2: {
                        return TownyAdminCommand.getTownyStartingWith(args[1], "r");
                    }
                    case 3: {
                        return NameUtil.filterByStart(adminResidentTabCompletes, args[2]);
                    }
                    case 4: {
                        if (!args[2].equalsIgnoreCase("friend")) return Collections.emptyList();
                        return NameUtil.filterByStart(adminResidentFriendTabCompletes, args[3]);
                    }
                }
                return Collections.emptyList();
            }
            case "town": {
                if (args.length == 2) {
                    return TownyAdminCommand.filterByStartOrGetTownyStartingWith(Collections.singletonList("new"), args[1], "+t");
                }
                if (args.length > 2 && !args[1].equalsIgnoreCase("new")) {
                    switch (args[2].toLowerCase()) {
                        case "add": {
                            if (args.length == 4) {
                                return null;
                            }
                        }
                        case "kick": {
                            if (args.length == 4) {
                                return TownyAdminCommand.getResidentsOfTownStartingWith(args[1], args[3]);
                            }
                        }
                        case "rank": {
                            switch (args.length) {
                                case 4: {
                                    return NameUtil.filterByStart(TownCommand.townAddRemoveTabCompletes, args[3]);
                                }
                                case 5: {
                                    return TownyAdminCommand.getResidentsOfTownStartingWith(args[1], args[4]);
                                }
                                case 6: {
                                    switch (args[3].toLowerCase()) {
                                        case "add": {
                                            return NameUtil.filterByStart(TownyPerms.getTownRanks(), args[5]);
                                        }
                                        case "remove": {
                                            Resident res = TownyUniverse.getInstance().getResident(args[4]);
                                            if (res == null) return Collections.emptyList();
                                            return NameUtil.filterByStart(res.getTownRanks(), args[5]);
                                        }
                                    }
                                    return Collections.emptyList();
                                }
                            }
                            return Collections.emptyList();
                        }
                        case "set": {
                            Town town = TownyUniverse.getInstance().getTown(args[1]);
                            if (town == null) return Collections.emptyList();
                            return TownCommand.townSetTabComplete(town, StringMgmt.remArgs(args, 2));
                        }
                        case "toggle": {
                            if (args.length == 4) {
                                return NameUtil.filterByStart(TownCommand.townToggleTabCompletes, args[3]);
                            }
                            if (args.length == 5 && !args[3].equalsIgnoreCase("jail")) {
                                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[4]);
                            }
                        }
                        case "outlaw": {
                            switch (args.length) {
                                case 4: {
                                    return NameUtil.filterByStart(TownCommand.townAddRemoveTabCompletes, args[3]);
                                }
                                case 5: {
                                    switch (args[3].toLowerCase()) {
                                        case "add": {
                                            return TownyAdminCommand.getTownyStartingWith(args[4], "r");
                                        }
                                        case "remove": {
                                            Town town = TownyUniverse.getInstance().getTown(args[1]);
                                            if (town == null) break;
                                            return NameUtil.filterByStart(NameUtil.getNames(town.getOutlaws()), args[4]);
                                        }
                                    }
                                    break;
                                }
                            }
                        }
                        case "invite": {
                            if (args.length == 4) {
                                return TownyAdminCommand.getTownyStartingWith(args[3], "r");
                            }
                        }
                        case "meta": {
                            if (args.length != 4) return Collections.emptyList();
                            return NameUtil.filterByStart(adminMetaTabCompletes, args[3]);
                        }
                        case "trust": {
                            if (args.length == 4) {
                                return NameUtil.filterByStart(Arrays.asList("add", "remove"), args[3]);
                            }
                            if (args.length != 5) break;
                            return TownyAdminCommand.getTownyStartingWith(args[4], "r");
                        }
                    }
                    if (args.length != 3) return Collections.emptyList();
                    return NameUtil.filterByStart(adminTownTabCompletes, args[2]);
                }
                if (args.length != 4) return Collections.emptyList();
                if (!args[1].equalsIgnoreCase("new")) return Collections.emptyList();
                return TownyAdminCommand.getTownyStartingWith(args[3], "r");
            }
            case "nation": {
                if (args.length == 2) {
                    return TownyAdminCommand.filterByStartOrGetTownyStartingWith(Collections.singletonList("new"), args[1], "+n");
                }
                if (args.length > 2 && !args[1].equalsIgnoreCase("new")) {
                    switch (args[2].toLowerCase()) {
                        case "add": {
                            if (args.length == 4) {
                                return TownyAdminCommand.getTownyStartingWith(args[3], "t");
                            }
                        }
                        case "toggle": {
                            if (args.length == 4) {
                                return NameUtil.filterByStart(NationCommand.nationToggleTabCompletes, args[3]);
                            }
                            if (args.length == 5) {
                                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[4]);
                            }
                        }
                        case "set": {
                            Nation nation = TownyUniverse.getInstance().getNation(args[1]);
                            if (nation == null) return Collections.emptyList();
                            return NationCommand.nationSetTabComplete(nation, StringMgmt.remArgs(args, 2));
                        }
                        case "merge": {
                            if (args.length == 4) {
                                return TownyAdminCommand.getTownyStartingWith(args[3], "n");
                            }
                        }
                        case "rank": {
                            if (args.length == 4) {
                                return NameUtil.filterByStart(Arrays.asList("add", "remove"), args[3]);
                            }
                            if (args.length == 5) {
                                return TownyAdminCommand.getTownyStartingWith(args[4], "r");
                            }
                            if (args.length == 6) {
                                return NameUtil.filterByStart(TownyPerms.getNationRanks(), args[5]);
                            }
                        }
                        case "enemy": 
                        case "ally": {
                            if (args.length == 4) {
                                return Arrays.asList("add", "remove");
                            }
                            if (args.length != 5) break;
                            return TownyAdminCommand.getTownyStartingWith(args[4], "n");
                        }
                    }
                    if (args.length != 3) return Collections.emptyList();
                    return NameUtil.filterByStart(adminNationTabCompletes, args[2]);
                }
                if (args.length != 4) return Collections.emptyList();
                if (!args[1].equalsIgnoreCase("new")) return Collections.emptyList();
                return TownyAdminCommand.getTownyStartingWith(args[3], "t");
            }
            case "unclaim": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(TownCommand.townUnclaimTabCompletes, args[1]);
                }
            }
            case "townyperms": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(adminTownyPermsCompletes, args[1]);
                }
                if (args.length <= 2) return Collections.emptyList();
                switch (args[1].toLowerCase()) {
                    case "group": {
                        if (args.length == 3) {
                            return NameUtil.filterByStart(TownyPerms.getGroupList(), args[2]);
                        }
                        if (args.length != 4) return Collections.emptyList();
                        return NameUtil.filterByStart(Arrays.asList("addperm", "removeperm"), args[3]);
                    }
                    case "townrank": 
                    case "nationrank": {
                        if (args.length == 3) {
                            return NameUtil.filterByStart(Arrays.asList("addrank", "removerank"), args[2]);
                        }
                        if (args.length <= 3) return Collections.emptyList();
                        if (!args[2].equalsIgnoreCase("remove")) return Collections.emptyList();
                        if (args[1].equalsIgnoreCase("nationrank")) {
                            return NameUtil.filterByStart(TownyPerms.getNationRanks(), args[3]);
                        }
                        if (!args[1].equalsIgnoreCase("townrank")) return Collections.emptyList();
                        return NameUtil.filterByStart(TownyPerms.getTownRanks(), args[3]);
                    }
                }
                return Collections.emptyList();
            }
        }
        if (args.length == 1) {
            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNYADMIN, adminTabCompletes), args[0]);
        }
        if (args.length <= 1) return Collections.emptyList();
        if (!TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN, args[0])) return Collections.emptyList();
        return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN, args[0]).getTabCompletion(args.length), args[args.length - 1]);
    }

    private CommandSender getSender() {
        return this.sender;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parseTownyAdminCommand(String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (this.getSender() == this.player && !townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SCREEN.getNode())) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TA_HELP.send(this.sender);
            return true;
        }
        if (split[0].equalsIgnoreCase("set")) {
            this.adminSet(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("resident")) {
            this.parseAdminResidentCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("town")) {
            this.parseAdminTownCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("nation")) {
            this.parseAdminNationCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("toggle")) {
            this.parseToggleCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("plot")) {
            this.parseAdminPlotCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (!this.isConsole && !townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN.getNode(split[0].toLowerCase()))) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        if (split[0].equalsIgnoreCase("givebonus") || split[0].equalsIgnoreCase("giveplots")) {
            this.giveBonus(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("reload")) {
            if (split.length != 2) {
                HelpMenu.TA_RELOAD.send(this.sender);
                return false;
            }
            switch (split[1]) {
                case "db": 
                case "database": {
                    this.reloadDatabase();
                    return true;
                }
                case "config": {
                    this.reloadConfig(false);
                    return true;
                }
                case "perms": 
                case "townyperms": 
                case "permissions": {
                    this.reloadPerms();
                    return true;
                }
                case "language": 
                case "lang": {
                    this.reloadLangs();
                    return true;
                }
                case "all": {
                    this.reloadConfig(false);
                    this.reloadLangs();
                    this.reloadPerms();
                    this.reloadDatabase();
                    return true;
                }
            }
            HelpMenu.TA_RELOAD.send(this.sender);
            return true;
        }
        if (split[0].equalsIgnoreCase("reset")) {
            this.reloadConfig(true);
            return true;
        }
        if (split[0].equalsIgnoreCase("backup")) {
            CompletableFuture.runAsync(new BackupTask()).thenRun(() -> TownyMessaging.sendMsg(this.getSender(), Translatable.of("mag_backup_success")));
            return true;
        }
        if (split[0].equalsIgnoreCase("database")) {
            this.parseAdminDatabaseCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("mysqldump")) {
            if (!TownySettings.getSaveDatabase().equalsIgnoreCase("mysql")) throw new TownyException(Translatable.of("msg_err_mysql_not_being_used"));
            if (!TownySettings.getLoadDatabase().equalsIgnoreCase("mysql")) throw new TownyException(Translatable.of("msg_err_mysql_not_being_used"));
            TownyFlatFileSource dataSource = new TownyFlatFileSource(plugin, townyUniverse);
            dataSource.saveAll();
            TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_mysql_dump_success"));
            return true;
        }
        if (split[0].equalsIgnoreCase("newday")) {
            TownyTimerHandler.newDay();
            return true;
        }
        if (split[0].equalsIgnoreCase("newhour")) {
            TownyTimerHandler.newHour();
            TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_newhour_success"));
            return true;
        }
        if (split[0].equalsIgnoreCase("purge")) {
            this.purge(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("delete")) {
            String[] newSplit = StringMgmt.remFirstArg(split);
            this.residentDelete(this.player, newSplit);
            return true;
        }
        if (split[0].equalsIgnoreCase("unclaim")) {
            this.parseAdminUnclaimCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("checkperm")) {
            this.parseAdminCheckPermCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("townyperms")) {
            this.parseAdminTownyPermsCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("tpplot")) {
            this.parseAdminTpPlotCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("depositall")) {
            if (!TownyEconomyHandler.isActive()) {
                throw new TownyException(Translatable.of("msg_err_no_economy"));
            }
            this.parseAdminDepositAllCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("install")) {
            Towny.getAdventure().sender(this.getSender()).sendMessage(Component.text(Translatable.of("msg_setup_full_guide_link").forLocale(this.getSender())).clickEvent(ClickEvent.openUrl("https://github.com/TownyAdvanced/Towny/wiki/Installation")));
            new SetupConversation(this.getSender()).runOnResponse(response -> {
                ConversationContext context = (ConversationContext)response;
                this.toggleWildernessUsage(this.parseBoolean(context.getSessionData((Object)0)));
                this.toggleRevertUnclaim(this.parseBoolean(context.getSessionData((Object)1)));
                TownySettings.setProperty(ConfigNodes.TOWN_TOWN_BLOCK_RATIO.getRoot(), Integer.parseInt((String)context.getSessionData((Object)2)));
                if (TownyEconomyHandler.isActive()) {
                    TownySettings.setProperty(ConfigNodes.ECO_PRICE_NEW_TOWN.getRoot(), Integer.parseInt((String)context.getSessionData((Object)3)));
                    TownySettings.setProperty(ConfigNodes.ECO_PRICE_NEW_NATION.getRoot(), Integer.parseInt((String)context.getSessionData((Object)4)));
                    TownySettings.setProperty(ConfigNodes.ECO_PRICE_CLAIM_TOWNBLOCK.getRoot(), Integer.parseInt((String)context.getSessionData((Object)5)));
                }
                TownySettings.saveConfig();
                TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_setup_success"));
            });
            return true;
        }
        if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN, split[0]).execute(this.getSender(), "townyadmin", split);
            return true;
        }
        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_sub"));
        return false;
    }

    private boolean parseBoolean(Object object) {
        boolean bl;
        Object object2 = object;
        if (!(object2 instanceof String)) {
            return false;
        }
        String string = (String)object2;
        switch (string.toLowerCase()) {
            case "y": 
            case "yes": 
            case "true": {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private void parseAdminTownyPermsCommand(String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("?") || args.length > 0 && !adminTownyPermsCompletes.contains(args[0])) {
            HelpMenu.TA_TOWNYPERMS.send(this.sender);
            return;
        }
        try {
            switch (args[0]) {
                case "listgroups": {
                    TownyMessaging.sendMessage((Object)this.sender, ChatTools.formatTitle("Groups"));
                    TownyMessaging.sendMessage((Object)this.sender, ChatTools.list(TownyPerms.getGroupList().stream().sorted().collect(Collectors.toList())));
                    break;
                }
                case "group": {
                    this.parseAdminTownypermsGroupCommand(StringMgmt.remFirstArg(args));
                    break;
                }
                case "townrank": 
                case "nationrank": {
                    this.parseAdminTownypermsRankCommand(args);
                }
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)this.sender, e.getMessage());
        }
    }

    private void parseAdminTownypermsGroupCommand(String[] args) throws TownyException {
        if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
            HelpMenu.TA_TOWNYPERMS.send(this.sender);
            return;
        }
        if (!TownyPerms.getGroupList().contains(args[0].toLowerCase())) {
            throw new TownyException(Translatable.of("msg_err_group_not_found", args[0]));
        }
        String group = args[0];
        List<String> groupNodes = TownyPerms.getPermsOfGroup(group);
        if (args.length == 1) {
            this.displayNodesHelpByGroup(group, groupNodes);
            return;
        }
        if (!args[1].equalsIgnoreCase("addperm") && !args[1].equalsIgnoreCase("removeperm") || args.length != 3) {
            throw new TownyException(Translatable.of("msg_err_expected_command_format", "/ta townyperms group add|remove node"));
        }
        boolean add = args[1].equalsIgnoreCase("addperm");
        String node = args[2];
        boolean changed = false;
        switch (args[1].toLowerCase()) {
            case "addperm": {
                if (groupNodes.contains(node)) {
                    throw new TownyException(Translatable.of("msg_err_group_already_has_node", group, node));
                }
                changed = groupNodes.add(node);
                break;
            }
            case "removeperm": {
                if (!groupNodes.contains(node)) {
                    throw new TownyException(Translatable.of("msg_err_group_doesnt_have_node", group, node));
                }
                changed = groupNodes.remove(node);
            }
        }
        if (!changed) {
            return;
        }
        TownyPerms.getTownyPermsFile().set(group, groupNodes);
        TownyPerms.getTownyPermsFile().save();
        if (add) {
            TownyMessaging.sendMsg(this.sender, Translatable.of("msg_successfully_added_node_to_group", node, group));
        } else {
            TownyMessaging.sendMsg(this.sender, Translatable.of("msg_successfully_removed_node_from_group", node, group));
        }
        this.reloadPerms();
    }

    private void displayNodesHelpByGroup(String group, List<String> groupNodes) {
        if (groupNodes.size() > 0) {
            TownyMessaging.sendMessage((Object)this.sender, ChatTools.formatTitle(Translatable.of("msg_title_group_permissions", StringMgmt.capitalize(group)).forLocale(this.sender)));
            for (String node : groupNodes) {
                TownyMessaging.sendMessage((Object)this.sender, " - " + node);
            }
        } else {
            TownyMessaging.sendErrorMsg(Translatable.of("msg_err_group_has_no_nodes", group));
        }
    }

    private void parseAdminTownypermsRankCommand(String[] args) throws TownyException {
        if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
            HelpMenu.TA_TOWNYPERMS.send(this.sender);
            return;
        }
        if (!args[1].equalsIgnoreCase("addrank") && !args[1].equalsIgnoreCase("removerank") || args.length != 3) {
            throw new TownyException(Translatable.of("msg_err_expected_command_format", "/ta townyperms townrank|nationrank add|remove [rank]"));
        }
        boolean town = args[0].equalsIgnoreCase("townrank");
        boolean add = args[1].equalsIgnoreCase("addrank");
        String rank = args[2];
        boolean changed = false;
        switch (args[1].toLowerCase()) {
            case "addrank": {
                if (town) {
                    if (TownyPerms.getTownRanks().contains(rank)) {
                        throw new TownyException(Translatable.of("msg_err_there_is_already_a_town_or_nationrank_called_x", args[0], rank));
                    }
                    TownyPerms.getTownyPermsFile().createSection("towns.ranks." + rank);
                    changed = true;
                    break;
                }
                if (TownyPerms.getNationRanks().contains(rank)) {
                    throw new TownyException(Translatable.of("msg_err_there_is_already_a_town_or_nationrank_called_x", args[0], rank));
                }
                TownyPerms.getTownyPermsFile().createSection("nations.ranks." + rank);
                changed = true;
                break;
            }
            case "removerank": {
                if (town) {
                    if (!TownyPerms.getTownRanks().contains(rank)) {
                        throw new TownyException(Translatable.of("msg_err_there_is_no_town_or_nationrank_called_x", args[0], rank));
                    }
                    TownyPerms.getTownyPermsFile().set("towns.ranks." + rank, null);
                    changed = true;
                    break;
                }
                if (!TownyPerms.getNationRanks().contains(rank)) {
                    throw new TownyException(Translatable.of("msg_err_there_is_no_town_or_nationrank_called_x", args[0], rank));
                }
                TownyPerms.getTownyPermsFile().set("nations.ranks." + rank, null);
                changed = true;
            }
        }
        if (!changed) {
            return;
        }
        TownyPerms.getTownyPermsFile().save();
        if (add) {
            TownyMessaging.sendMsg(this.sender, Translatable.of("msg_successfully_add_rank_to_the_town_or_nation_rank", rank, args[0]));
        } else {
            TownyMessaging.sendMsg(this.sender, Translatable.of("msg_successfully_removed_rank_from_the_town_or_nation_rank", rank, args[0]));
        }
        this.reloadPerms();
    }

    private void parseAdminDatabaseCommand(String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.TA_DATABASE.send(this.sender);
            return;
        }
        if (split[0].equalsIgnoreCase("save")) {
            if (TownyUniverse.getInstance().getDataSource().saveAll()) {
                TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_save_success"));
            }
        } else if (split[0].equalsIgnoreCase("load")) {
            TownyUniverse.getInstance().clearAllObjects();
            if (TownyUniverse.getInstance().getDataSource().loadAll()) {
                TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_load_success"));
                Bukkit.getPluginManager().callEvent((Event)new TownyLoadedDatabaseEvent());
            }
        } else if (split[0].equalsIgnoreCase("remove")) {
            this.parseAdminDatabaseRemoveCommand(StringMgmt.remFirstArg(split));
        }
    }

    private void parseAdminDatabaseRemoveCommand(String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            TownyMessaging.sendMessage((Object)this.sender, ChatTools.formatTitle("/townyadmin database remove"));
            TownyMessaging.sendMessage((Object)this.sender, ChatTools.formatCommand(Translatable.of("admin_sing").forLocale(this.sender), "/townyadmin database remove", "titles", "Removes all titles and surnames from every resident."));
            return;
        }
        if (split[0].equalsIgnoreCase("titles")) {
            TownyUniverse.getInstance().getResidents().stream().forEach(resident -> {
                resident.setTitle("");
                resident.setSurname("");
                resident.save();
            });
            TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_ta_removed_all_titles_and_surnames_removed"));
        }
    }

    private void parseAdminPlotCommand(String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (this.isConsole) {
            TownyMessaging.sendMessage((Object)this.sender, "[Towny] InputError: This command was designed for use in game only.");
            return;
        }
        if (split.length == 0 || split.length < 1 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.TA_PLOT.send(this.sender);
            return;
        }
        if (split[0].equalsIgnoreCase("meta")) {
            TownyAdminCommand.handlePlotMetaCommand(this.player, split);
            return;
        }
        if (split[0].equalsIgnoreCase("claim")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PLOT_CLAIM.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (split.length == 1) {
                TownyMessaging.sendErrorMsg(this.sender, Translatable.of("msg_error_ta_plot_claim"));
                return;
            }
            Optional<Resident> resOpt = townyUniverse.getResidentOpt(split[1]);
            if (!resOpt.isPresent()) {
                TownyMessaging.sendErrorMsg(this.sender, Translatable.of("msg_error_no_player_with_that_name", split[1]));
                return;
            }
            Player player = BukkitTools.getPlayer(this.sender.getName());
            String world = player.getWorld().getName();
            ArrayList<WorldCoord> selection = new ArrayList<WorldCoord>();
            selection.add(new WorldCoord(world, Coord.parseCoord((Entity)player)));
            new PlotClaim(plugin, player, resOpt.get(), selection, true, true, false).start();
        } else if (split[0].equalsIgnoreCase("claimedat")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PLOT_CLAIMEDAT.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            WorldCoord wc = WorldCoord.parseWorldCoord((Entity)((Player)this.getSender()));
            if (!wc.hasTownBlock() || wc.getTownBlock().getClaimedAt() == 0L) {
                throw new NotRegisteredException();
            }
            TownyMessaging.sendMsg(this.sender, Translatable.of("msg_plot_perm_claimed_at", TownyFormatter.fullDateFormat.format(wc.getTownBlock().getClaimedAt())));
        } else if (split[0].equalsIgnoreCase("trust")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PLOT_TRUST.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            PlotCommand.parsePlotTrustCommand(this.player, StringMgmt.remFirstArg(split));
        }
    }

    private void parseAdminCheckPermCommand(String[] split) throws TownyException {
        if (split.length != 2) {
            throw new TownyException(Translatable.of("msg_err_invalid_input", "Eg: /ta checkperm {name} {node}"));
        }
        Player player = BukkitTools.getPlayer(split[0]);
        if (player == null) {
            throw new TownyException("Player couldn't be found");
        }
        String node = split[1];
        if (player.hasPermission(node)) {
            TownyMessaging.sendMessage((Object)this.sender, "Permission true");
        } else {
            TownyMessaging.sendErrorMsg((Object)this.sender, "Permission false");
        }
    }

    private void parseAdminTpPlotCommand(String[] split) throws TownyException {
        if (split.length != 3) {
            throw new TownyException(Translatable.of("msg_err_invalid_input", "Eg: /ta tpplot world x z"));
        }
        Player player = (Player)this.sender;
        double y = 1.0;
        if (Bukkit.getServer().getWorld(split[0]) == null) {
            throw new TownyException(Translatable.of("msg_err_invalid_input", "Eg: /ta tpplot world x z"));
        }
        World world = Bukkit.getServer().getWorld(split[0]);
        double x = Double.parseDouble(split[1]) * (double)TownySettings.getTownBlockSize();
        double z = Double.parseDouble(split[2]) * (double)TownySettings.getTownBlockSize();
        y = Bukkit.getWorld((String)world.getName()).getHighestBlockYAt(new Location(world, x, y, z));
        Location loc = new Location(world, x, y, z);
        player.teleport(loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    private void giveBonus(String[] split) throws TownyException {
        int extraBlocks;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        boolean isTown = false;
        if (split.length != 2) {
            throw new TownyException(Translatable.of("msg_err_invalid_input", "Eg: givebonus [town/player] [n]"));
        }
        Town town = townyUniverse.getTown(split[0]);
        if (town != null) {
            isTown = true;
        } else {
            Resident target = TownyAdminCommand.getResidentOrThrow(split[0]);
            if (!target.hasTown()) {
                throw new TownyException(Translatable.of("msg_err_resident_doesnt_belong_to_any_town"));
            }
            town = target.getTownOrNull();
        }
        try {
            extraBlocks = Integer.parseInt(split[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new TownyException(Translatable.of("msg_error_must_be_int"));
        }
        town.setBonusBlocks(town.getBonusBlocks() + extraBlocks);
        TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_give_total", town.getName(), split[1], town.getBonusBlocks()));
        if (!this.isConsole || isTown) {
            TownyMessaging.sendTownMessagePrefixed(town, "You have been given " + extraBlocks + " bonus townblocks.");
        }
        if (this.isConsole && !isTown) {
            TownyMessaging.sendMessage((Object)town, "You have been given " + extraBlocks + " bonus townblocks.");
            TownyMessaging.sendMessage((Object)town, "If you have paid any real-life money for these townblocks please understand: the creators of Towny do not condone this transaction, the server you play on breaks the Minecraft EULA and, worse, is selling a part of Towny which the developers did not intend to be sold.");
            TownyMessaging.sendMessage((Object)town, "If you did pay real money you should consider playing on a Towny server that respects the wishes of the Towny Team.");
        }
        town.save();
    }

    public void parseAdminUnclaimCommand(String[] split) {
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            HelpMenu.TA_UNCLAIM.send(this.getSender());
        } else {
            if (this.isConsole) {
                TownyMessaging.sendMessage((Object)this.sender, "[Towny] InputError: This command was designed for use in game only.");
                return;
            }
            try {
                if (TownyAPI.getInstance().isWarTime()) {
                    throw new TownyException(Translatable.of("msg_war_cannot_do"));
                }
                List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(null, new WorldCoord(this.player.getWorld().getName(), Coord.parseCoord((Entity)this.player)), split);
                selection = AreaSelectionUtil.filterOutWildernessBlocks(selection);
                new TownClaim(plugin, this.player, null, selection, false, false, true).start();
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)this.player, x.getMessage());
                return;
            }
        }
    }

    public void parseAdminResidentCommand(String[] split) throws TownyException {
        block11: {
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
                HelpMenu.TA_RESIDENT.send(this.sender);
                return;
            }
            try {
                Resident resident = TownyAdminCommand.getResidentOrThrow(split[0]);
                if (split.length == 1) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TownyMessaging.sendStatusScreen(this.sender, TownyFormatter.getStatus(resident, this.player, Translation.getLocale(this.sender))));
                    return;
                }
                if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_RESIDENT.getNode(split[1].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                if (split[1].equalsIgnoreCase("rename")) {
                    if (!NameValidation.isBlacklistName(split[2])) {
                        townyUniverse.getDataSource().renamePlayer(resident, split[2]);
                        break block11;
                    }
                    throw new TownyException(Translatable.of("msg_invalid_name"));
                }
                if (split[1].equalsIgnoreCase("friend")) {
                    if (split.length == 2) {
                        HelpMenu.TA_RESIDENT_FRIEND.send(this.sender);
                        return;
                    }
                    if (this.isConsole) {
                        throw new TownyException("/ta resident {resident} friend cannot be run from console.");
                    }
                    ResidentCommand.residentFriend(BukkitTools.getPlayer(this.sender.getName()), StringMgmt.remArgs(split, 2), true, resident);
                    break block11;
                }
                if (!split[1].equalsIgnoreCase("unjail")) break block11;
                if (resident.isJailed()) {
                    JailUtil.unJailResident(resident, UnJailReason.ADMIN);
                    break block11;
                }
                throw new TownyException(Translatable.of("msg_err_player_is_not_jailed"));
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), e.getMessage());
            }
        }
    }

    public void parseAdminTownCommand(String[] split) throws TownyException {
        block52: {
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
                HelpMenu.TA_TOWN.send(this.sender);
                return;
            }
            try {
                if (split[0].equalsIgnoreCase("new")) {
                    if (split.length != 3) {
                        throw new TownyException(Translatable.of("msg_err_not_enough_variables") + "/ta town new [name] [mayor]");
                    }
                    if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_NEW.getNode())) {
                        throw new TownyException(Translatable.of("msg_err_command_disable"));
                    }
                    Optional<Resident> resOpt = TownyUniverse.getInstance().getResidentOpt(split[2]);
                    if (!resOpt.isPresent()) {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_not_registered_1", split[2]));
                        return;
                    }
                    TownCommand.newTown(this.player, split[1], resOpt.get(), true);
                    return;
                }
                Town town = townyUniverse.getTown(split[0]);
                if (town == null) {
                    TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_not_registered_1", split[0]));
                    return;
                }
                if (split.length == 1) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TownyMessaging.sendStatusScreen(this.sender, TownyFormatter.getStatus(town, Translation.getLocale(this.sender))));
                    return;
                }
                if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN.getNode(split[1].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                if (split[1].equalsIgnoreCase("invite")) {
                    TownCommand.townAdd(this.getSender(), town, StringMgmt.remArgs(split, 2));
                    break block52;
                }
                if (split[1].equalsIgnoreCase("add")) {
                    Resident resident = townyUniverse.getResident(split[2]);
                    if (resident == null) {
                        TownyMessaging.sendMessage((Object)this.sender, Translatable.of("msg_error_no_player_with_that_name", split[2]));
                        return;
                    }
                    TownCommand.townAddResident(town, resident);
                    TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_join_town", resident.getName()));
                    TownyMessaging.sendMessage((Object)this.sender, Translatable.of("msg_join_town", resident.getName()));
                    break block52;
                }
                if (split[1].equalsIgnoreCase("kick")) {
                    TownCommand.townKickResidents(this.getSender(), town.getMayor(), town, ResidentUtil.getValidatedResidents(this.getSender(), StringMgmt.remArgs(split, 2)));
                    break block52;
                }
                if (split[1].equalsIgnoreCase("delete")) {
                    Confirmation.runOnAccept(() -> {
                        TownyMessaging.sendMsg(this.sender, Translatable.of("town_deleted_by_admin", town.getName()));
                        TownyUniverse.getInstance().getDataSource().removeTown(town);
                    }).sendTo(this.sender);
                    break block52;
                }
                if (split[1].equalsIgnoreCase("rename")) {
                    TownPreRenameEvent event = new TownPreRenameEvent(town, split[2]);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        TownyMessaging.sendErrorMsg(this.sender, Translatable.of("msg_err_rename_cancelled"));
                        return;
                    }
                    if (!NameValidation.isBlacklistName(split[2])) {
                        townyUniverse.getDataSource().renameTown(town, split[2]);
                        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_name", this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", town.getName()));
                        TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_town_set_name", this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", town.getName()));
                    } else {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_invalid_name"));
                    }
                    break block52;
                }
                if (split[1].equalsIgnoreCase("spawn")) {
                    SpawnUtil.sendToTownySpawn(this.player, StringMgmt.remArgs(split, 2), town, "", false, false, SpawnType.TOWN);
                    break block52;
                }
                if (split[1].equalsIgnoreCase("outpost")) {
                    SpawnUtil.sendToTownySpawn(this.player, StringMgmt.remArgs(split, 2), town, "", true, false, SpawnType.TOWN);
                    break block52;
                }
                if (split[1].equalsIgnoreCase("rank")) {
                    this.parseAdminTownRankCommand(this.player, town, StringMgmt.remArgs(split, 2));
                    break block52;
                }
                if (split[1].equalsIgnoreCase("toggle")) {
                    if (split.length == 2 || split[2].equalsIgnoreCase("?")) {
                        HelpMenu.TA_TOWN_TOGGLE.send(this.sender);
                        return;
                    }
                    Optional<Object> choice = Optional.empty();
                    if (split.length == 4) {
                        choice = BaseCommand.parseToggleChoice(split[3]);
                    }
                    if (split[2].equalsIgnoreCase("forcepvp")) {
                        town.setAdminEnabledPVP(choice.orElse(!town.isAdminEnabledPVP()));
                        town.save();
                        TownyMessaging.sendMessage((Object)this.sender, Translatable.of("msg_town_forcepvp_setting_set_to", town.getName(), town.isAdminEnabledPVP()));
                    } else {
                        TownCommand.townToggle(this.sender, StringMgmt.remArgs(split, 2), true, town);
                    }
                    break block52;
                }
                if (split[1].equalsIgnoreCase("set")) {
                    TownCommand.townSet(this.player, StringMgmt.remArgs(split, 2), true, town);
                    break block52;
                }
                if (split[1].equalsIgnoreCase("meta")) {
                    TownyAdminCommand.handleTownMetaCommand(this.player, town, split);
                    break block52;
                }
                if (split[1].equalsIgnoreCase("bankhistory")) {
                    int pages = 10;
                    if (split.length > 2) {
                        try {
                            pages = Integer.parseInt(split[2]);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_error_must_be_int"));
                            return;
                        }
                    }
                    town.generateBankHistoryBook(this.player, pages);
                    break block52;
                }
                if (split[1].equalsIgnoreCase("deposit")) {
                    int amount;
                    if (!TownyEconomyHandler.isActive()) {
                        throw new TownyException(Translatable.of("msg_err_no_economy"));
                    }
                    if (split.length != 3) {
                        throw new TownyException(Translatable.of("msg_err_invalid_input", "deposit [amount]"));
                    }
                    try {
                        amount = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException ex) {
                        TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_error_must_be_int"));
                        return;
                    }
                    if (town.getAccount().deposit(amount, "Admin Deposit")) {
                        Translatable depositMessage = Translatable.of("msg_xx_deposited_xx", this.isConsole ? "Console" : this.player.getName(), amount, Translatable.of("town_sing"));
                        TownyMessaging.sendMessage((Object)this.sender, depositMessage);
                        TownyMessaging.sendPrefixedTownMessage(town, depositMessage);
                    } else {
                        TownyMessaging.sendErrorMsg(this.sender, Translatable.of("msg_unable_to_deposit_x", amount));
                    }
                    break block52;
                }
                if (split[1].equalsIgnoreCase("withdraw")) {
                    int amount;
                    if (!TownyEconomyHandler.isActive()) {
                        throw new TownyException(Translatable.of("msg_err_no_economy"));
                    }
                    if (split.length != 3) {
                        throw new TownyException(Translatable.of("msg_err_invalid_input", "withdraw [amount]"));
                    }
                    try {
                        amount = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException ex) {
                        TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_error_must_be_int"));
                        return;
                    }
                    if (town.getAccount().withdraw(amount, "Admin Withdraw")) {
                        Translatable withdrawMessage = Translatable.of("msg_xx_withdrew_xx", this.isConsole ? "Console" : this.player.getName(), amount, Translatable.of("town_sing"));
                        TownyMessaging.sendMessage((Object)this.sender, withdrawMessage);
                        TownyMessaging.sendPrefixedTownMessage(town, withdrawMessage);
                    } else {
                        TownyMessaging.sendErrorMsg(this.sender, Translatable.of("msg_unable_to_withdraw_x", amount));
                    }
                    break block52;
                }
                if (split[1].equalsIgnoreCase("outlaw")) {
                    TownCommand.parseTownOutlawCommand(this.sender, StringMgmt.remArgs(split, 2), true, town);
                    break block52;
                }
                if (split[1].equalsIgnoreCase("leavenation")) {
                    Nation nation = null;
                    if (!town.hasNation()) {
                        throw new TownyException(Translatable.of("That town does not belong to a nation."));
                    }
                    nation = town.getNation();
                    town.removeNation();
                    plugin.resetCache();
                    TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_town_left", StringMgmt.remUnderscore(town.getName())));
                    TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_left_nation", StringMgmt.remUnderscore(nation.getName())));
                    break block52;
                }
                if (split[1].equalsIgnoreCase("unruin")) {
                    TownRuinUtil.reclaimTown(town.getMayor(), town);
                    town.save();
                    break block52;
                }
                if (split[1].equalsIgnoreCase("trust")) {
                    TownCommand.parseTownTrustCommand(this.player, StringMgmt.remArgs(split, 2), town);
                    break block52;
                }
                HelpMenu.TA_TOWN.send(this.sender);
                return;
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseAdminTownRankCommand(Player player, Town town, String[] split) throws TownyException {
        if (split.length < 3) {
            throw new TownyException("Eg: /townyadmin town [townname] rank add/remove [resident] [rank]");
        }
        Resident target = TownyAdminCommand.getResidentOrThrow(split[1]);
        if (!target.hasTown()) {
            throw new TownyException(Translatable.of("msg_err_resident_doesnt_belong_to_any_town"));
        }
        if (target.getTown() != town) {
            throw new TownyException(Translatable.of("msg_err_townadmintownrank_wrong_town"));
        }
        String rank = TownyPerms.matchTownRank(split[2]);
        if (rank == null) {
            throw new TownyException(Translatable.of("msg_unknown_rank_available_ranks", split[2], StringMgmt.join(TownyPerms.getTownRanks(), ", ")));
        }
        if (split[0].equalsIgnoreCase("add")) {
            if (!target.addTownRank(rank)) {
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_resident_already_has_rank", target.getName(), "Town"));
                return;
            }
            TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_been_given_rank", "Town", rank));
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_given_rank", "Town", rank, target.getName()));
        } else {
            if (!split[0].equalsIgnoreCase("remove")) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", split[0]));
                return;
            }
            if (!target.removeTownRank(rank)) {
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_resident_doesnt_have_rank", target.getName(), "Town"));
                return;
            }
            TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_had_rank_taken", "Town", rank));
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_taken_rank_from", "Town", rank, target.getName()));
        }
        target.save();
    }

    public void parseAdminNationCommand(String[] split) throws TownyException {
        block84: {
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
                HelpMenu.TA_NATION.send(this.sender);
                return;
            }
            try {
                if (split[0].equalsIgnoreCase("new")) {
                    if (split.length != 3) {
                        throw new TownyException(Translatable.of("msg_err_not_enough_variables") + "/ta nation new [name] [capital]");
                    }
                    if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION_NEW.getNode())) {
                        throw new TownyException(Translatable.of("msg_err_command_disable"));
                    }
                    Town capitalTown = townyUniverse.getTown(split[2]);
                    if (capitalTown == null) {
                        throw new TownyException(Translatable.of("msg_err_invalid_name", split[2]));
                    }
                    NationCommand.newNation(this.player, split[1], capitalTown, true);
                    return;
                }
                Nation nation = townyUniverse.getNation(split[0]);
                if (nation == null) {
                    throw new TownyException(Translatable.of("msg_err_no_nation_with_that_name", split[0]));
                }
                if (split.length == 1) {
                    TownyMessaging.sendStatusScreen(this.getSender(), TownyFormatter.getStatus(nation, Translation.getLocale(this.sender)));
                    return;
                }
                if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION.getNode(split[1].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                if (split[1].equalsIgnoreCase("add")) {
                    if (split.length != 3) {
                        throw new TownyException(Translatable.of("msg_err_not_enough_variables") + "/ta nation [nationname] add [townname]");
                    }
                    this.townyAdminNationAddTown(this.sender, nation, StringMgmt.remArgs(split, 2));
                    break block84;
                }
                if (split[1].equalsIgnoreCase("kick")) {
                    NationCommand.nationKick(this.sender, nation, townyUniverse.getDataSource().getTowns(StringMgmt.remArgs(split, 2)));
                    break block84;
                }
                if (split[1].equalsIgnoreCase("delete")) {
                    if (!this.isConsole) {
                        TownyMessaging.sendMessage((Object)this.sender, Translatable.of("nation_deleted_by_admin", nation.getName()));
                        TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_nation", nation.getName()));
                        townyUniverse.getDataSource().removeNation(nation);
                    } else {
                        Confirmation.runOnAccept(() -> {
                            TownyUniverse.getInstance().getDataSource().removeNation(nation);
                            TownyMessaging.sendGlobalMessage(Translatable.of("MSG_DEL_NATION", nation.getName()));
                        }).sendTo(this.sender);
                    }
                    break block84;
                }
                if (split[1].equalsIgnoreCase("recheck")) {
                    nation.removeOutOfRangeTowns();
                    TownyMessaging.sendMessage((Object)this.sender, Translatable.of("nation_rechecked_by_admin", nation.getName()));
                    break block84;
                }
                if (split[1].equalsIgnoreCase("rename")) {
                    NationPreRenameEvent event = new NationPreRenameEvent(nation, split[2]);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        TownyMessaging.sendErrorMsg(this.sender, Translatable.of("msg_err_rename_cancelled"));
                        return;
                    }
                    if (!NameValidation.isBlacklistName(split[2])) {
                        townyUniverse.getDataSource().renameNation(nation, split[2]);
                        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_set_name", this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", nation.getName()));
                    } else {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_invalid_name"));
                    }
                    break block84;
                }
                if (split[1].equalsIgnoreCase("merge")) {
                    Nation remainingNation = townyUniverse.getNation(split[2]);
                    if (remainingNation == null || remainingNation.equals(nation)) {
                        throw new TownyException(Translatable.of("msg_err_invalid_name", split[2]));
                    }
                    townyUniverse.getDataSource().mergeNation(nation, remainingNation);
                    TownyMessaging.sendGlobalMessage(Translatable.of("nation1_has_merged_with_nation2", nation, remainingNation));
                    break block84;
                }
                if (split[1].equalsIgnoreCase("set")) {
                    NationCommand.nationSet(this.player, StringMgmt.remArgs(split, 2), true, nation);
                    break block84;
                }
                if (split[1].equalsIgnoreCase("toggle")) {
                    NationCommand.nationToggle(this.sender, StringMgmt.remArgs(split, 2), true, nation);
                    break block84;
                }
                if (split[1].equalsIgnoreCase("bankhistory")) {
                    int pages = 10;
                    if (split.length > 2) {
                        try {
                            pages = Integer.parseInt(split[2]);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_error_must_be_int"));
                            return;
                        }
                    }
                    nation.generateBankHistoryBook(this.player, pages);
                    break block84;
                }
                if (split[1].equalsIgnoreCase("deposit")) {
                    int amount;
                    if (!TownyEconomyHandler.isActive()) {
                        throw new TownyException(Translatable.of("msg_err_no_economy"));
                    }
                    if (split.length != 3) {
                        throw new TownyException(Translatable.of("msg_err_invalid_input", "deposit [amount]"));
                    }
                    try {
                        amount = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException ex) {
                        TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_error_must_be_int"));
                        return;
                    }
                    nation.getAccount().deposit(amount, "Admin Deposit");
                    Translatable depositMessage = Translatable.of("msg_xx_deposited_xx", this.isConsole ? "Console" : this.player.getName(), amount, Translatable.of("nation_sing"));
                    TownyMessaging.sendMessage((Object)this.sender, depositMessage);
                    TownyMessaging.sendPrefixedNationMessage(nation, depositMessage);
                    break block84;
                }
                if (split[1].equalsIgnoreCase("withdraw")) {
                    int amount;
                    if (!TownyEconomyHandler.isActive()) {
                        throw new TownyException(Translatable.of("msg_err_no_economy"));
                    }
                    if (split.length != 3) {
                        throw new TownyException(Translatable.of("msg_err_invalid_input", "withdraw [amount]"));
                    }
                    try {
                        amount = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException ex) {
                        TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_error_must_be_int"));
                        return;
                    }
                    nation.getAccount().withdraw(amount, "Admin Withdraw");
                    Translatable withdrawMessage = Translatable.of("msg_xx_withdrew_xx", this.isConsole ? "Console" : this.player.getName(), amount, Translatable.of("nation_sing"));
                    TownyMessaging.sendMessage((Object)this.sender, withdrawMessage);
                    TownyMessaging.sendPrefixedNationMessage(nation, withdrawMessage);
                    break block84;
                }
                if (split[1].equalsIgnoreCase("rank")) {
                    Resident target;
                    if (split.length < 5) {
                        HelpMenu.TA_NATION_RANK.send(this.sender);
                        return;
                    }
                    try {
                        target = TownyAdminCommand.getResidentOrThrow(split[3]);
                    }
                    catch (TownyException exception) {
                        TownyMessaging.sendMessage((Object)this.sender, exception.getMessage());
                        return;
                    }
                    if (!(target.hasTown() && target.getTownOrNull().hasNation() && target.getTownOrNull().getNationOrNull().getUUID().equals(nation.getUUID()))) {
                        throw new TownyException(Translatable.of("msg_err_that_resident_doesnt_belong_to_that_nation"));
                    }
                    String rank = TownyPerms.matchNationRank(split[4]);
                    if (rank == null) {
                        TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_unknown_rank_available_ranks", split[4], StringMgmt.join(TownyPerms.getNationRanks(), ", ")));
                        return;
                    }
                    switch (split[2].toLowerCase()) {
                        case "add": {
                            if (target.addNationRank(rank)) {
                                if (BukkitTools.isOnline(target.getName())) {
                                    TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_been_given_rank", "Nation", rank));
                                    plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
                                }
                            } else {
                                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_resident_already_has_rank", target.getName(), "Nation"));
                                return;
                            }
                            TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_you_have_given_rank", "Nation", rank, target.getName()));
                            target.save();
                            return;
                        }
                        case "remove": {
                            if (target.removeNationRank(rank)) {
                                if (BukkitTools.isOnline(target.getName())) {
                                    TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_had_rank_taken", "Nation", rank));
                                    plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
                                }
                                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_you_have_taken_rank_from", "Nation", rank, target.getName()));
                                target.save();
                                return;
                            }
                            TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_resident_doesnt_have_rank", target.getName(), "Nation"));
                            return;
                        }
                    }
                    HelpMenu.TA_NATION_RANK.send(this.sender);
                    return;
                }
                if (split[1].equalsIgnoreCase("ally")) {
                    if (split.length < 4) {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_input", "/ta nation [nation] ally [add/remove] [nation]"));
                        return;
                    }
                    Nation ally = townyUniverse.getNation(split[3]);
                    if (ally == null || ally.equals(nation)) {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_name", split[3]));
                        return;
                    }
                    if (split[2].equalsIgnoreCase("add")) {
                        if (!nation.hasAlly(ally)) {
                            if (nation.hasEnemy(ally)) {
                                nation.removeEnemy(ally);
                            }
                            if (ally.hasEnemy(nation)) {
                                ally.removeEnemy(nation);
                            }
                            nation.addAlly(ally);
                            nation.save();
                            ally.addAlly(nation);
                            ally.save();
                            plugin.resetCache();
                            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_added_ally", ally.getName()));
                            TownyMessaging.sendPrefixedNationMessage(ally, Translatable.of("msg_added_ally", nation.getName()));
                            TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_ta_allies_enemies_updated", nation.getName()));
                        } else {
                            TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_nation_already_allied_with_2", nation.getName(), ally.getName()));
                        }
                    } else if (split[2].equalsIgnoreCase("remove")) {
                        if (nation.hasAlly(ally)) {
                            nation.removeAlly(ally);
                            nation.save();
                            ally.removeAlly(nation);
                            ally.save();
                            plugin.resetCache();
                            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_removed_ally", ally.getName()));
                            TownyMessaging.sendPrefixedNationMessage(ally, Translatable.of("msg_removed_ally", nation.getName()));
                            TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_ta_allies_enemies_updated", nation.getName()));
                        } else {
                            TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_nation_not_allied_with_2", nation.getName(), ally.getName()));
                        }
                    } else {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_input", "/ta nation [nation] ally [add/remove] [nation]"));
                    }
                } else if (split[1].equalsIgnoreCase("enemy")) {
                    if (split.length < 4) {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_input", "/ta nation [nation] enemy [add/remove] [nation]"));
                        return;
                    }
                    Nation enemy = townyUniverse.getNation(split[3]);
                    if (enemy == null || enemy.equals(nation)) {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_name", split[3]));
                        return;
                    }
                    if (split[2].equalsIgnoreCase("add")) {
                        if (!nation.hasEnemy(enemy)) {
                            if (nation.hasAlly(enemy)) {
                                nation.removeAlly(enemy);
                                enemy.removeAlly(nation);
                                plugin.resetCache();
                            }
                            nation.addEnemy(enemy);
                            nation.save();
                            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_enemy_nations", this.getSenderFormatted(), enemy.getName()));
                            TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_ta_allies_enemies_updated", nation.getName()));
                        } else {
                            TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_nation_already_enemies_with_2", nation.getName(), enemy.getName()));
                        }
                    } else if (split[2].equalsIgnoreCase("remove")) {
                        if (nation.hasEnemy(enemy)) {
                            nation.removeEnemy(enemy);
                            nation.save();
                            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_enemy_to_neutral", this.getSenderFormatted(), enemy.getName()));
                            TownyMessaging.sendPrefixedNationMessage(enemy, Translatable.of("msg_removed_enemy", nation.getName()));
                            TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_ta_allies_enemies_updated", nation.getName()));
                        } else {
                            TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_nation_not_enemies_with_2", nation.getName(), enemy.getName()));
                        }
                    } else {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_input", "/ta nation [nation] enemy [add/remove] [nation]"));
                    }
                }
            }
            catch (AlreadyRegisteredException | InvalidNameException | NotRegisteredException e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), e.getMessage());
            }
        }
    }

    private String getSenderFormatted() {
        return this.isConsole ? "CONSOLE" : ((Player)this.getSender()).getName();
    }

    private void townyAdminNationAddTown(CommandSender sender, Nation nation, String[] townName) {
        Town town = TownyUniverse.getInstance().getTown(townName[0]);
        if (town == null) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_name", townName[0]));
            return;
        }
        if (town.hasNation()) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_already_nation"));
            TownyMessaging.sendMessage((Object)sender, "Suggestion: /townyadmin town " + town.getName() + "leavenation");
        } else {
            try {
                town.setNation(nation);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
            town.save();
            TownyMessaging.sendNationMessagePrefixed(nation, Translatable.of("msg_join_nation", town.getName()));
            TownyMessaging.sendMessage((Object)sender, Translatable.of("msg_join_nation", town.getName()));
        }
    }

    private void adminSet(String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET.getNode())) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        if (split.length == 0) {
            HelpMenu.TA_SET.send(this.sender);
            return;
        }
        if (split[0].equalsIgnoreCase("mayor")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_MAYOR.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (split.length < 3) {
                HelpMenu.TA_SET_MAYOR.send(this.sender);
            } else {
                try {
                    Resident newMayor;
                    Town town = townyUniverse.getTown(split[1]);
                    if (town == null) {
                        TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_not_registered_1", split[1]));
                        return;
                    }
                    if (split[2].equalsIgnoreCase("npc")) {
                        newMayor = ResidentUtil.createAndGetNPCResident();
                        town.setHasUpkeep(false);
                    } else {
                        newMayor = TownyAdminCommand.getResidentOrThrow(split[2]);
                    }
                    if (!town.hasResident(newMayor)) {
                        TownCommand.townAddResident(town, newMayor);
                    }
                    Resident oldMayor = town.getMayor();
                    town.setMayor(newMayor);
                    if (oldMayor.isNPC()) {
                        oldMayor.removeTown();
                        townyUniverse.getDataSource().removeResident(oldMayor);
                        town.setHasUpkeep(true);
                    }
                    town.save();
                    TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_new_mayor", newMayor.getName()));
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg((Object)this.getSender(), e.getMessage());
                }
            }
        } else if (split[0].equalsIgnoreCase("capital")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_CAPITAL.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (split.length < 2) {
                HelpMenu.TA_SET_CAPITAL.send(this.sender);
            } else {
                Town newCapital = townyUniverse.getTown(split[1]);
                if (newCapital == null) {
                    TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_not_registered_1", split[1]));
                    return;
                }
                try {
                    Nation nation = newCapital.getNation();
                    NationCommand.nationSet(this.player, split, true, nation);
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)this.player, e.getMessage());
                }
            }
        } else if (split[0].equalsIgnoreCase("title")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_TITLE.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            Resident resident = null;
            if (split.length < 2) {
                TownyMessaging.sendErrorMsg((Object)this.player, "Eg: /townyadmin set title bilbo Jester");
            } else {
                resident = TownyAdminCommand.getResidentOrThrow(split[1]);
            }
            split = StringMgmt.remArgs(split, 2);
            if (StringMgmt.join(split).length() > TownySettings.getMaxTitleLength()) {
                TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_input_too_long"));
                return;
            }
            String title = StringMgmt.join(NameValidation.checkAndFilterArray(split));
            resident.setTitle(title + " ");
            resident.save();
            if (resident.hasTitle()) {
                TownyMessaging.sendMessage((Object)this.sender, Translatable.of("msg_set_title", resident.getName(), Colors.translateColorCodes(resident.getTitle())));
                TownyMessaging.sendMessage((Object)resident, Translatable.of("msg_set_title", resident.getName(), Colors.translateColorCodes(resident.getTitle())));
            } else {
                TownyMessaging.sendMessage((Object)this.sender, Translatable.of("msg_clear_title_surname", "Title", resident.getName()));
                TownyMessaging.sendMessage((Object)resident, Translatable.of("msg_clear_title_surname", "Title", resident.getName()));
            }
        } else if (split[0].equalsIgnoreCase("surname")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_SURNAME.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            Resident resident = null;
            if (split.length < 2) {
                TownyMessaging.sendErrorMsg((Object)this.player, "Eg: /townyadmin set surname bilbo Jester");
            } else {
                resident = TownyAdminCommand.getResidentOrThrow(split[1]);
            }
            split = StringMgmt.remArgs(split, 2);
            if (StringMgmt.join(split).length() > TownySettings.getMaxTitleLength()) {
                TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_input_too_long"));
                return;
            }
            String surname = StringMgmt.join(NameValidation.checkAndFilterArray(split));
            resident.setSurname(surname + " ");
            resident.save();
            if (resident.hasSurname()) {
                TownyMessaging.sendMessage((Object)this.sender, Translatable.of("msg_set_surname", resident.getName(), Colors.translateColorCodes(resident.getSurname())));
                TownyMessaging.sendMessage((Object)resident, Translatable.of("msg_set_surname", resident.getName(), Colors.translateColorCodes(resident.getSurname())));
            } else {
                TownyMessaging.sendMessage((Object)this.sender, Translatable.of("msg_clear_title_surname", "Surname", resident.getName()));
                TownyMessaging.sendMessage((Object)resident, Translatable.of("msg_clear_title_surname", "Surname", resident.getName()));
            }
        } else if (split[0].equalsIgnoreCase("plot")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_PLOT.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            TownBlock tb = TownyAPI.getInstance().getTownBlock(this.player.getLocation());
            if (split.length < 2) {
                HelpMenu.TA_SET_PLOT.send(this.sender);
                return;
            }
            if (tb != null) {
                Town newTown = townyUniverse.getTown(split[1]);
                if (newTown != null) {
                    tb.setResident(null);
                    tb.setTown(newTown);
                    tb.setType(TownBlockType.RESIDENTIAL);
                    tb.setName("");
                    TownyMessaging.sendMessage((Object)this.player, Translatable.of("changed_plot_town", newTown.getName()));
                } else {
                    TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_not_registered_1", split[1]));
                }
            } else {
                List<WorldCoord> selection;
                Town town = townyUniverse.getTown(split[1]);
                if (town == null) {
                    TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_not_registered_1", split[1]));
                    return;
                }
                TownyWorld world = TownyAPI.getInstance().getTownyWorld(this.player.getWorld().getName());
                Coord key = Coord.parseCoord(plugin.getCache(this.player).getLastLocation());
                if (split.length == 2) {
                    selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), key), new String[0]);
                } else {
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    newSplit = StringMgmt.remFirstArg(newSplit);
                    selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), key), newSplit);
                }
                TownyMessaging.sendDebugMsg("Admin Initiated townClaim: Pre-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
                selection = AreaSelectionUtil.filterOutTownOwnedBlocks(selection);
                TownyMessaging.sendDebugMsg("Admin Initiated townClaim: Post-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
                new TownClaim(plugin, this.player, town, selection, false, true, false).start();
            }
        } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN_SET, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN_SET, split[0]).execute(this.getSender(), "townyadmin", split);
        } else {
            TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_property", "administrative"));
        }
    }

    public void reloadLangs() {
        Translation.loadTranslationRegistry();
        TownyMessaging.sendMsg(this.sender, Translatable.of("msg_reloaded_lang"));
    }

    public void reloadPerms() {
        String rootFolder = TownyUniverse.getInstance().getRootFolder();
        try {
            TownyPerms.loadPerms(rootFolder + File.separator + "settings", "townyperms.yml");
        }
        catch (TownyException e) {
            plugin.setError(true);
            TownyMessaging.sendErrorMsg((Object)this.sender, "Error Loading townyperms.yml!");
            return;
        }
        if (plugin.isError()) {
            plugin.setError(false);
        }
        TownyPerms.updateOnlinePerms();
        TownyMessaging.sendMsg(this.sender, Translatable.of("msg_reloaded_perms"));
    }

    public void reloadConfig(boolean reset) {
        if (reset) {
            TownyUniverse.getInstance().getDataSource().deleteFile(plugin.getConfigPath());
            TownyMessaging.sendMsg(this.sender, Translatable.of("msg_reset_config"));
        }
        try {
            String rootFolder = TownyUniverse.getInstance().getRootFolder();
            TownySettings.loadConfig(rootFolder + File.separator + "settings" + File.separator + "config.yml", plugin.getVersion());
            TownySettings.loadTownLevelConfig();
            TownySettings.loadNationLevelConfig();
            Translation.loadTranslationRegistry();
        }
        catch (IOException e) {
            TownyMessaging.sendErrorMsg(this.sender, Translatable.of("msg_reload_error"));
            e.printStackTrace();
            return;
        }
        TownyMessaging.sendMsg(this.sender, Translatable.of("msg_reloaded_config"));
    }

    public void reloadDatabase() {
        TownyUniverse.getInstance().getDataSource().finishTasks();
        if (plugin.load()) {
            TownyPerms.registerPermissionNodes();
            TownyPerms.updateOnlinePerms();
        }
        TownyMessaging.sendMsg(this.sender, Translatable.of("msg_reloaded_db"));
    }

    public void purge(String[] split) {
        if (split.length == 0) {
            HelpMenu.TA_PURGE.send(this.sender);
            return;
        }
        boolean townless = false;
        Town town = null;
        int days = 0;
        try {
            days = Integer.parseInt(split[0]);
        }
        catch (NumberFormatException e) {
            TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_error_must_be_int"));
            return;
        }
        if (split.length == 2 && split[1].equalsIgnoreCase("townless")) {
            townless = true;
        }
        if (!townless && split.length == 2 && (town = TownyUniverse.getInstance().getTown(split[1])) == null) {
            TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_not_registered_1", split[1]));
            return;
        }
        int numDays = days;
        boolean finalTownless = townless;
        Town finalTown = town;
        if (!this.isConsole) {
            Confirmation.runOnAccept(() -> {
                if (!TownyUniverse.getInstance().getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PURGE.getNode())) {
                    TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_admin_only"));
                    return;
                }
                new ResidentPurge(plugin, (CommandSender)this.player, TimeTools.getMillis(numDays + "d"), finalTownless, finalTown).start();
            }).sendTo((CommandSender)this.player);
        } else {
            Confirmation.runOnAccept(() -> new ResidentPurge(plugin, null, TimeTools.getMillis(numDays + "d"), finalTownless, finalTown).start()).sendTo(this.sender);
        }
    }

    public void residentDelete(Player player, String[] split) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
        } else {
            try {
                if (!townyUniverse.getPermissionSource().isTownyAdmin(player)) {
                    throw new TownyException(Translatable.of("msg_err_admin_only_delete"));
                }
                for (String name : split) {
                    Resident resident = townyUniverse.getResident(name);
                    if (resident != null) {
                        if (!resident.isNPC() && !BukkitTools.isOnline(resident.getName())) {
                            townyUniverse.getDataSource().removeResident(resident);
                            TownyMessaging.sendGlobalMessage(Translatable.of("MSG_DEL_RESIDENT", resident.getName()));
                            continue;
                        }
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_online_or_npc", name));
                        continue;
                    }
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_name", name));
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    public void parseToggleCommand(String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Optional<Object> choice = Optional.empty();
        if (split.length == 2) {
            choice = BaseCommand.parseToggleChoice(split[1]);
        } else if (split.length == 3 && split[1].equalsIgnoreCase("npc")) {
            choice = BaseCommand.parseToggleChoice(split[2]);
        }
        if (split.length == 0) {
            HelpMenu.TA_TOGGLE.send(this.getSender());
            return;
        }
        if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOGGLE.getNode(split[0].toLowerCase()))) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        if (split[0].equalsIgnoreCase("wildernessuse")) {
            this.toggleWildernessUsage(choice.orElse(true));
            TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_wilderness_use_x_in_all_worlds", choice.orElse(true)));
        } else if (split[0].equalsIgnoreCase("regenerations")) {
            this.toggleRegenerations((Boolean)choice.orElse(false));
            TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_regenerations_use_x_in_all_worlds", choice.orElse(false)));
        } else if (split[0].equalsIgnoreCase("war")) {
            if (!((Boolean)choice.orElse(TownyAPI.getInstance().isWarTime())).booleanValue()) {
                townyUniverse.startWarEvent();
                TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_war_started"));
            } else {
                townyUniverse.endWarEvent();
                TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_war_ended"));
            }
        } else if (split[0].equalsIgnoreCase("peaceful") || split[0].equalsIgnoreCase("neutral")) {
            try {
                TownySettings.setDeclaringNeutral((Boolean)choice.orElse(!TownySettings.isDeclaringNeutral()));
                TownyMessaging.sendMsg(this.getSender(), Translatable.of("msg_nation_allow_peaceful", TownySettings.isDeclaringNeutral() ? Translatable.of("enabled") : Translatable.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("devmode")) {
            try {
                TownySettings.setDevMode((Boolean)choice.orElse(!TownySettings.isDevMode()));
                TownyMessaging.sendMsg(this.getSender(), "Dev Mode " + (TownySettings.isDevMode() ? "\u00a72" + Translatable.of("enabled") : "\u00a74" + Translatable.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("debug")) {
            try {
                TownySettings.setDebug((Boolean)choice.orElse(!TownySettings.getDebug()));
                TownyLogger.getInstance().refreshDebugLogger();
                TownyMessaging.sendMsg(this.getSender(), "Debug Mode " + (TownySettings.getDebug() ? "\u00a72" + Translatable.of("enabled") : "\u00a74" + Translatable.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("townwithdraw")) {
            try {
                TownySettings.SetTownBankAllowWithdrawls((Boolean)choice.orElse(!TownySettings.getTownBankAllowWithdrawls()));
                TownyMessaging.sendMsg(this.getSender(), "Town Withdrawls " + (TownySettings.getTownBankAllowWithdrawls() ? "\u00a72" + Translatable.of("enabled") : "\u00a74" + Translatable.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("nationwithdraw")) {
            try {
                TownySettings.SetNationBankAllowWithdrawls((Boolean)choice.orElse(!TownySettings.getNationBankAllowWithdrawls()));
                TownyMessaging.sendMsg(this.getSender(), "Nation Withdrawls " + (TownySettings.getNationBankAllowWithdrawls() ? "\u00a72" + Translatable.of("enabled") : "\u00a74" + Translatable.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("npc")) {
            if (split.length != 2) {
                throw new TownyException(Translatable.of("msg_err_invalid_input", "Eg: toggle npc [resident]"));
            }
            Resident resident = townyUniverse.getResident(split[1]);
            if (resident == null) {
                throw new TownyException(Translatable.of("msg_err_not_registered_1", split[1]));
            }
            resident.setNPC(!resident.isNPC());
            resident.save();
            TownyMessaging.sendMessage((Object)this.sender, Translatable.of("msg_npc_flag", resident.isNPC(), resident.getName()));
        } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN_TOGGLE, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYADMIN_TOGGLE, split[0]).execute(this.getSender(), "townyadmin", split);
        } else {
            TownyMessaging.sendErrorMsg(this.getSender(), Translatable.of("msg_err_invalid_choice"));
        }
    }

    private void toggleRegenerations(boolean choice) {
        for (TownyWorld world : new ArrayList<TownyWorld>(TownyUniverse.getInstance().getWorldMap().values())) {
            world.setUsingPlotManagementRevert(choice);
            world.setUsingPlotManagementWildBlockRevert(choice);
            world.setUsingPlotManagementWildEntityRevert(choice);
            world.save();
        }
    }

    private void toggleRevertUnclaim(boolean choice) {
        for (TownyWorld world : new ArrayList<TownyWorld>(TownyUniverse.getInstance().getWorldMap().values())) {
            world.setUsingPlotManagementRevert(choice);
            world.save();
        }
    }

    private void toggleWildernessUsage(boolean choice) {
        for (TownyWorld world : new ArrayList<TownyWorld>(TownyUniverse.getInstance().getWorldMap().values())) {
            world.setUnclaimedZoneBuild(choice);
            world.setUnclaimedZoneDestroy(choice);
            world.setUnclaimedZoneSwitch(choice);
            world.setUnclaimedZoneItemUse(choice);
            world.save();
        }
    }

    public static void handleTownMetaCommand(Player player, Town town, String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_META.getNode())) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        if (split.length == 2) {
            if (town.hasMeta()) {
                TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle("Custom Meta Data"));
                for (CustomDataField<?> field : town.getMetadata()) {
                    TownyMessaging.sendMessage((Object)player, field.getKey() + " = " + field.getValue());
                }
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_this_town_doesnt_have_any_associated_metadata"));
            }
            return;
        }
        if (split.length < 4) {
            HelpMenu.TA_TOWN_META.send((CommandSender)player);
            return;
        }
        String mdKey = split[3];
        if (split[2].equalsIgnoreCase("set")) {
            String val;
            String string = val = split.length == 5 ? split[4] : null;
            if (town.hasMeta() && town.hasMeta(mdKey)) {
                CustomDataField<?> cdf = town.getMetadata(mdKey);
                try {
                    if (val == null) {
                        throw new InvalidMetadataTypeException(cdf);
                    }
                    cdf.isValidType(val);
                }
                catch (InvalidMetadataTypeException e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                    return;
                }
                cdf.setValueFromString(val);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_key_x_was_successfully_updated_to_x", mdKey, cdf.getValue()));
                town.save();
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_key_x_is_not_part_of_this_town", mdKey));
            }
        } else if (split[2].equalsIgnoreCase("add")) {
            if (!townyUniverse.getRegisteredMetadataMap().containsKey(mdKey)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_the_metadata_for_key_is_not_registered", mdKey));
                return;
            }
            CustomDataField<?> md = townyUniverse.getRegisteredMetadataMap().get(mdKey);
            if (town.hasMeta() && town.hasMeta(md.getKey())) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_key_x_already_exists", mdKey));
                return;
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_custom_data_was_successfully_added_to_town"));
            town.addMetaData((CustomDataField<?>)md.clone());
        } else if (split[2].equalsIgnoreCase("remove")) {
            if (town.hasMeta() && town.hasMeta(mdKey)) {
                CustomDataField<?> cdf = town.getMetadata(mdKey);
                town.removeMetaData(cdf);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_data_successfully_deleted"));
                return;
            }
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_key_cannot_be_deleted"));
        }
    }

    public static boolean handlePlotMetaCommand(Player player, String[] split) throws TownyException {
        String world = player.getWorld().getName();
        TownBlock townBlock = null;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            return false;
        }
        if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PLOT_META.getNode())) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        if (split.length == 1) {
            if (townBlock.hasMeta()) {
                TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle("Custom Meta Data"));
                for (CustomDataField<?> field : townBlock.getMetadata()) {
                    TownyMessaging.sendMessage((Object)player, field.getKey() + " = " + field.getValue());
                }
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_this_plot_doesnt_have_any_associated_metadata"));
            }
            return true;
        }
        if (split.length < 3) {
            HelpMenu.TA_PLOT_META.send((CommandSender)player);
            return false;
        }
        String mdKey = split[2];
        if (split[1].equalsIgnoreCase("set")) {
            String val;
            String string = val = split.length == 4 ? split[3] : null;
            if (townBlock.hasMeta() && townBlock.hasMeta(mdKey)) {
                CustomDataField<?> cdf = townBlock.getMetadata(mdKey);
                try {
                    if (val == null) {
                        throw new InvalidMetadataTypeException(cdf);
                    }
                    cdf.isValidType(val);
                }
                catch (InvalidMetadataTypeException e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                    return false;
                }
                cdf.setValueFromString(val);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_key_x_was_successfully_updated_to_x", mdKey, cdf.getValue()));
                townBlock.save();
                return true;
            }
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_key_x_is_not_part_of_this_plot", mdKey));
            return false;
        }
        if (split[1].equalsIgnoreCase("add")) {
            if (!townyUniverse.getRegisteredMetadataMap().containsKey(mdKey)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_the_metadata_for_key_is_not_registered", mdKey));
                return false;
            }
            CustomDataField<?> md = townyUniverse.getRegisteredMetadataMap().get(mdKey);
            if (townBlock.hasMeta() && townBlock.hasMeta(md.getKey())) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_key_x_already_exists", mdKey));
                return false;
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_custom_data_was_successfully_added_to_townblock"));
            townBlock.addMetaData((CustomDataField<?>)md.clone());
        } else if (split[1].equalsIgnoreCase("remove")) {
            if (townBlock.hasMeta() && townBlock.hasMeta(mdKey)) {
                CustomDataField<?> cdf = townBlock.getMetadata(mdKey);
                townBlock.removeMetaData(cdf);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_data_successfully_deleted"));
                return true;
            }
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_key_cannot_be_deleted"));
            return false;
        }
        return true;
    }

    private void parseAdminDepositAllCommand(String[] split) {
        if (split.length != 1) {
            HelpMenu.TA_DEPOSITALL.send(this.sender);
            return;
        }
        String reason = "townyadmin depositall";
        double amount = 0.0;
        try {
            amount = Double.parseDouble(split[0]);
        }
        catch (NumberFormatException e) {
            TownyMessaging.sendErrorMsg(this.sender, Translatable.of("msg_error_must_be_num"));
            return;
        }
        for (Nation nation : TownyUniverse.getInstance().getNations()) {
            nation.getAccount().deposit(amount, reason);
        }
        for (Town town : TownyUniverse.getInstance().getTowns()) {
            town.getAccount().deposit(amount, reason);
        }
        TownyMessaging.sendMsg(this.sender, Translatable.of("msg_ta_deposit_all_success", TownyEconomyHandler.getFormattedBalance(amount)));
    }

    static {
        adminTabCompletes = Arrays.asList("delete", "plot", "resident", "town", "nation", "reset", "toggle", "set", "givebonus", "reload", "backup", "checkperm", "newday", "newhour", "unclaim", "purge", "mysqldump", "tpplot", "database", "townyperms", "depositall", "install");
        adminTownTabCompletes = Arrays.asList("new", "add", "kick", "rename", "spawn", "tpplot", "outpost", "delete", "rank", "toggle", "set", "meta", "deposit", "withdraw", "bankhistory", "outlaw", "leavenation", "invite", "unruin", "trust");
        adminNationTabCompletes = Arrays.asList("add", "kick", "rename", "delete", "toggle", "set", "meta", "deposit", "withdraw", "bankhistory", "rank", "enemy", "ally");
        adminToggleTabCompletes = Arrays.asList("wildernessuse", "regenerations", "war", "neutral", "npc", "debug", "devmode", "townwithdraw", "nationwithdraw");
        adminPlotTabCompletes = Arrays.asList("claim", "meta", "claimedat", "trust");
        adminMetaTabCompletes = Arrays.asList("set", "add", "remove");
        adminDatabaseTabCompletes = Arrays.asList("save", "load", "remove");
        adminResidentTabCompletes = Arrays.asList("rename", "friend", "unjail");
        adminResidentFriendTabCompletes = Arrays.asList("add", "remove", "list", "clear");
        adminSetCompletes = Arrays.asList("mayor", "capital", "title", "surname", "plot");
        adminTownyPermsCompletes = Arrays.asList("listgroups", "group", "townrank", "nationrank");
    }
}

