/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.PlotClearEvent;
import com.palmergames.bukkit.towny.event.PlotPreChangeTypeEvent;
import com.palmergames.bukkit.towny.event.PlotPreClearEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.event.plot.PlotNotForSaleEvent;
import com.palmergames.bukkit.towny.event.plot.PlotSetForSaleEvent;
import com.palmergames.bukkit.towny.event.plot.PlotTrustAddEvent;
import com.palmergames.bukkit.towny.event.plot.PlotTrustRemoveEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleExplosionEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleFireEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleMobsEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotTogglePvpEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnPointLocation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyPermissionChange;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.PlotClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.OutpostUtil;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlotCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> plotTabCompletes;
    private static final List<String> plotGroupTabCompletes;
    private static final List<String> plotSetTabCompletes;
    private static final List<String> plotRectCircleCompletes;
    private static final List<String> plotToggleTabCompletes;
    private static final List<String> plotPermTabCompletes;

    public PlotCommand(Towny instance) {
        plugin = instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            if (plugin.isError()) {
                TownyMessaging.sendMessage((Object)sender, "\u00a7c[Towny Error] Locked in Safe mode!");
                return false;
            }
            Player player = (Player)sender;
            if (!TownyAPI.getInstance().isTownyWorld(player.getWorld())) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_set_use_towny_off"));
                return false;
            }
            if (args != null) return this.parsePlotCommand(player, args);
            HelpMenu.PLOT_HELP.send((CommandSender)player);
            return true;
        } else {
            HelpMenu.PLOT_HELP.send(sender);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (sender instanceof Player) {
            switch (args[0].toLowerCase()) {
                case "set": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.PLOT_SET, plotSetTabCompletes), args[1]);
                    }
                    if (args.length > 2 && args[1].equalsIgnoreCase("perm")) {
                        return PlotCommand.permTabComplete(StringMgmt.remArgs(args, 2));
                    }
                    if (args.length <= 2 || !TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT_SET, args[1])) break;
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT_SET, args[1]).getTabCompletion(args.length - 1), args[args.length - 1]);
                }
                case "toggle": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.PLOT_TOGGLE, plotToggleTabCompletes), args[1]);
                    }
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                }
                case "claim": 
                case "unclaim": 
                case "notforsale": 
                case "nfs": {
                    if (args.length != 2) break;
                    return NameUtil.filterByStart(plotRectCircleCompletes, args[1]);
                }
                case "forsale": 
                case "fs": {
                    switch (args.length) {
                        case 2: {
                            return NameUtil.filterByStart(Collections.singletonList("within"), args[1]);
                        }
                        case 3: {
                            return NameUtil.filterByStart(plotRectCircleCompletes, args[2]);
                        }
                    }
                    break;
                }
                case "group": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(plotGroupTabCompletes, args[1]);
                    }
                    if (args.length < 2) break;
                    switch (args[1].toLowerCase()) {
                        case "trust": {
                            if (args.length == 3) {
                                return NameUtil.filterByStart(Arrays.asList("add", "remove"), args[2]);
                            }
                            if (args.length == 4) {
                                return NameUtil.filterByStart(PlotCommand.getTownyStartingWith(args[3], "r"), args[3]);
                            }
                        }
                        case "perm": {
                            if (args.length == 3) {
                                return NameUtil.filterByStart(Arrays.asList("add", "remove", "gui"), args[2]);
                            }
                            if (args.length != 4) break;
                            return NameUtil.filterByStart(PlotCommand.getTownyStartingWith(args[3], "r"), args[3]);
                        }
                    }
                    return PlotCommand.permTabComplete(StringMgmt.remFirstArg(args));
                }
                case "jailcell": {
                    if (args.length != 2) break;
                    return NameUtil.filterByStart(TownCommand.townAddRemoveTabCompletes, args[1]);
                }
                case "perm": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(plotPermTabCompletes, args[1]);
                    }
                    if (args.length != 3 || !args[1].equalsIgnoreCase("remove") && !args[1].equalsIgnoreCase("add")) break;
                    return NameUtil.filterByStart(PlotCommand.getTownyStartingWith(args[2], "r"), args[2]);
                }
                case "trust": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(Arrays.asList("add", "remove"), args[1]);
                    }
                    if (args.length == 3) {
                        return PlotCommand.getTownyStartingWith(args[2], "r");
                    }
                }
                default: {
                    if (args.length == 1) {
                        return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.PLOT, plotTabCompletes), args[0]);
                    }
                    if (args.length <= 1 || !TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT, args[0])) break;
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT, args[0]).getTabCompletion(args.length), args[args.length - 1]);
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean parsePlotCommand(Player player, String[] split) {
        block97: {
            TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
            if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
                HelpMenu.PLOT_HELP.send((CommandSender)player);
            } else {
                Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                if (resident == null) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered"));
                    return true;
                }
                String world = player.getWorld().getName();
                try {
                    TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player.getLocation());
                    if (townBlock == null && !split[0].equalsIgnoreCase("perm") && !split[0].equalsIgnoreCase("claim")) {
                        throw new TownyException(Translatable.of("msg_not_claimed_1"));
                    }
                    if (!TownyAPI.getInstance().isWilderness(player.getLocation()) && townBlock.getTownOrNull().isRuined()) {
                        throw new TownyException(Translatable.of("msg_err_cannot_use_command_because_town_ruined"));
                    }
                    if (split[0].equalsIgnoreCase("claim")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_CLAIM.getNode())) {
                            throw new TownyException(Translatable.of("msg_err_command_disable"));
                        }
                        if (TownyAPI.getInstance().isWarTime()) {
                            throw new TownyException(Translatable.of("msg_war_cannot_do"));
                        }
                        List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                        if (selection.size() == 1 && selection.get(0).hasTownBlock() && selection.get(0).getTownBlock().hasResident() && !selection.get(0).getTownBlock().isForSale()) {
                            throw new TownyException(Translatable.of("msg_already_claimed", selection.get(0).getTownBlock().getResidentOrNull()));
                        }
                        selection = AreaSelectionUtil.filterPlotsForSale(selection);
                        if ((selection = AreaSelectionUtil.filterUnownedBlocks(resident, selection)).size() > 0) {
                            Town town;
                            if (selection.size() + resident.getTownBlocks().size() > TownySettings.getMaxResidentPlots(resident)) {
                                throw new TownyException(Translatable.of("msg_max_plot_own", TownySettings.getMaxResidentPlots(resident)));
                            }
                            if (!(resident.hasTown() || !townBlock.getTownOrNull().isOpen() || townBlock.getType().equals((Object)TownBlockType.EMBASSY) || (town = townBlock.getTownOrNull()) == null || TownySettings.getMaxNumResidentsWithoutNation() > 0 && !town.hasNation() && town.getResidents().size() >= TownySettings.getMaxNumResidentsWithoutNation() || TownySettings.getMaxResidentsPerTown() > 0 && town.getResidents().size() >= TownySettings.getMaxResidentsForTown(town))) {
                                List<WorldCoord> coords = selection;
                                Confirmation.runOnAccept(() -> {
                                    try {
                                        resident.setTown(town);
                                    }
                                    catch (AlreadyRegisteredException alreadyRegisteredException) {
                                        // empty catch block
                                    }
                                    try {
                                        this.continuePlotClaimProcess(coords, resident, player);
                                    }
                                    catch (TownyException e) {
                                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
                                    }
                                }).setTitle(Translatable.of("msg_you_must_join_this_town_to_claim_this_plot", town.getName())).sendTo((CommandSender)player);
                                return true;
                            }
                            this.continuePlotClaimProcess(selection, resident, player);
                        } else {
                            TownyMessaging.sendMessage((Object)player, Translatable.of("msg_err_empty_area_selection"));
                        }
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("evict")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_EVICT.getNode())) {
                            throw new TownyException(Translatable.of("msg_err_command_disable"));
                        }
                        if (TownyAPI.getInstance().isWarTime()) {
                            throw new TownyException(Translatable.of("msg_war_cannot_do"));
                        }
                        if (!townBlock.hasResident()) {
                            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_no_one_to_evict"));
                        } else {
                            PlotCommand.plotTestOwner(resident, townBlock);
                            if (townBlock.hasPlotObjectGroup()) {
                                townBlock.getPlotObjectGroup().getTownBlocks().stream().forEach(tb -> {
                                    tb.setResident(null);
                                    tb.setPlotPrice(-1.0);
                                    tb.setType(townBlock.getType());
                                    tb.save();
                                });
                                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_evict_group", townBlock.getPlotObjectGroup().getName()));
                                return true;
                            }
                            townBlock.setResident(null);
                            townBlock.setPlotPrice(-1.0);
                            townBlock.setType(townBlock.getType());
                            townBlock.save();
                            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_evict"));
                        }
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("unclaim")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_UNCLAIM.getNode())) {
                            throw new TownyException(Translatable.of("msg_err_command_disable"));
                        }
                        if (TownyAPI.getInstance().isWarTime()) {
                            throw new TownyException(Translatable.of("msg_war_cannot_do"));
                        }
                        if (split.length == 2 && split[1].equalsIgnoreCase("all")) {
                            new PlotClaim(plugin, player, resident, null, false, false, false).start();
                        } else {
                            List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                            if ((selection = AreaSelectionUtil.filterOwnedBlocks(resident, selection)).size() > 0) {
                                Iterator<WorldCoord> town = selection.iterator();
                                if (town.hasNext()) {
                                    WorldCoord coord = town.next();
                                    TownBlock block = coord.getTownBlock();
                                    if (!block.hasPlotObjectGroup()) {
                                        new PlotClaim(plugin, player, resident, selection, false, false, false).start();
                                        return true;
                                    }
                                    ArrayList groupSelection = new ArrayList();
                                    block.getPlotObjectGroup().getTownBlocks().forEach(tb -> groupSelection.add(tb.getWorldCoord()));
                                    Confirmation.runOnAccept(() -> new PlotClaim(Towny.getPlugin(), player, resident, groupSelection, false, false, false).start()).setTitle(Translatable.of("msg_plot_group_unclaim_confirmation", block.getPlotObjectGroup().getTownBlocks().size()) + " " + Translatable.of("are_you_sure_you_want_to_continue").forLocale((CommandSender)player)).sendTo((CommandSender)player);
                                    return true;
                                }
                            } else {
                                TownyMessaging.sendMessage((Object)player, Translatable.of("msg_err_empty_area_selection"));
                            }
                        }
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("notforsale") || split[0].equalsIgnoreCase("nfs")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_NOTFORSALE.getNode())) {
                            throw new TownyException(Translatable.of("msg_err_command_disable"));
                        }
                        List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                        selection = AreaSelectionUtil.filterPlotsForSale(selection);
                        if (permSource.testPermission(player, PermissionNodes.TOWNY_ADMIN.getNode())) {
                            for (WorldCoord worldCoord : selection) {
                                if (worldCoord.getTownBlock().hasPlotObjectGroup()) {
                                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group_plot_nfs", worldCoord));
                                    return false;
                                }
                                this.setPlotForSale(resident, worldCoord, -1.0);
                            }
                            return true;
                        }
                        selection = permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) && resident.hasTown() && townBlock.hasTown() && resident.getTown() == townBlock.getTownOrNull() ? AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection) : AreaSelectionUtil.filterOwnedBlocks(resident, selection);
                        if (selection.isEmpty()) {
                            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
                        }
                        for (WorldCoord worldCoord : selection) {
                            if (worldCoord.getTownBlock().hasPlotObjectGroup()) {
                                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group_plot_nfs", worldCoord));
                                continue;
                            }
                            this.setPlotForSale(resident, worldCoord, -1.0);
                        }
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("forsale") || split[0].equalsIgnoreCase("fs")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE.getNode())) {
                            throw new TownyException(Translatable.of("msg_err_command_disable"));
                        }
                        WorldCoord pos = new WorldCoord(world, Coord.parseCoord((Entity)player));
                        Town town = townBlock.getTownOrNull();
                        if (town == null) {
                            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
                        }
                        double plotPrice = town.getPlotTypePrice(pos.getTownBlock().getType());
                        if (split.length > 1) {
                            List<Object> selection;
                            int areaSelectPivot = AreaSelectionUtil.getAreaSelectPivot(split);
                            if (areaSelectPivot >= 0) {
                                selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.subArray(split, areaSelectPivot + 1, split.length));
                                if (permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) && resident.hasTown() && resident.getTown() == town) {
                                    selection = AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection);
                                    selection = AreaSelectionUtil.filterOutResidentBlocks(resident, selection);
                                } else {
                                    selection = AreaSelectionUtil.filterOwnedBlocks(resident, selection);
                                }
                                if (selection.isEmpty()) {
                                    throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
                                }
                            } else {
                                selection = new ArrayList<WorldCoord>();
                                selection.add(pos);
                            }
                            if (areaSelectPivot != 1) {
                                try {
                                    plotPrice = Double.parseDouble(split[1]);
                                    if (plotPrice < 0.0) {
                                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_negative_money"));
                                        return true;
                                    }
                                }
                                catch (NumberFormatException e) {
                                    TownyMessaging.sendMessage((Object)resident, Translatable.of("msg_error_must_be_num"));
                                    return true;
                                }
                            }
                            for (WorldCoord worldCoord : selection) {
                                TownBlock tb2 = worldCoord.getTownBlock();
                                if (tb2.hasPlotObjectGroup()) {
                                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group_plot_fs2", worldCoord));
                                    continue;
                                }
                                this.setPlotForSale(resident, worldCoord, plotPrice);
                            }
                            break block97;
                        }
                        if (pos.getTownBlock().hasPlotObjectGroup()) {
                            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group_plot_fs2", pos));
                            return false;
                        }
                        this.setPlotForSale(resident, pos, plotPrice);
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("perm")) {
                        this.parsePlotPermCommand(player, StringMgmt.remFirstArg(split));
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("info")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_INFO.getNode())) {
                            throw new TownyException(Translatable.of("msg_err_command_disable"));
                        }
                        this.sendPlotInfo(player, StringMgmt.remFirstArg(split));
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("toggle")) {
                        PlotCommand.plotTestOwner(resident, townBlock);
                        if (townBlock.hasPlotObjectGroup()) {
                            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group_toggle"));
                            return false;
                        }
                        this.plotToggle(player, new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock(), StringMgmt.remFirstArg(split));
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("set")) {
                        if ((split = StringMgmt.remFirstArg(split)).length == 0 || split[0].equalsIgnoreCase("?")) {
                            HelpMenu.PLOT_SET.send((CommandSender)player);
                            break block97;
                        }
                        if (split.length > 0) {
                            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_SET.getNode(split[0].toLowerCase()))) {
                                throw new TownyException(Translatable.of("msg_err_command_disable"));
                            }
                            if (townBlock.hasPlotObjectGroup()) {
                                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group_set"));
                                return false;
                            }
                            if (split[0].equalsIgnoreCase("perm")) {
                                PlotCommand.plotTestOwner(resident, townBlock);
                                PlotCommand.setTownBlockPermissions(player, townBlock.getTownBlockOwner(), townBlock, StringMgmt.remFirstArg(split));
                                return true;
                            }
                            if (split[0].equalsIgnoreCase("name")) {
                                PlotCommand.plotTestOwner(resident, townBlock);
                                if (split.length == 1) {
                                    townBlock.setName("");
                                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_name_removed"));
                                    townBlock.save();
                                    return true;
                                }
                                String newName = StringMgmt.join(StringMgmt.remFirstArg(split), "_");
                                if (!NameValidation.isBlacklistName(newName)) {
                                    townBlock.setName(newName);
                                    townBlock.save();
                                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_name_set_to", townBlock.getName()));
                                } else {
                                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
                                }
                                return true;
                            }
                            if (split[0].equalsIgnoreCase("outpost")) {
                                if (TownySettings.isAllowingOutposts()) {
                                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_OUTPOST.getNode())) {
                                        throw new TownyException(Translatable.of("msg_err_command_disable"));
                                    }
                                    PlotCommand.plotTestOwner(resident, townBlock);
                                    Town town = townBlock.getTownOrNull();
                                    TownyWorld townyWorld = townBlock.getWorld();
                                    boolean isAdmin = permSource.isTownyAdmin(player);
                                    Coord key = Coord.parseCoord(plugin.getCache(player).getLastLocation());
                                    if (OutpostUtil.OutpostTests(town, resident, townyWorld, key, isAdmin, true)) {
                                        if (TownyEconomyHandler.isActive() && !town.getAccount().canPayFromHoldings(TownySettings.getOutpostCost())) {
                                            throw new TownyException(Translatable.of("msg_err_cannot_afford_to_set_outpost"));
                                        }
                                        Confirmation.runOnAccept(() -> {
                                            if (TownyEconomyHandler.isActive() && TownySettings.getOutpostCost() > 0.0 && !town.getAccount().withdraw(TownySettings.getOutpostCost(), "Plot Set Outpost")) {
                                                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_cannot_afford_to_set_outpost"));
                                                return;
                                            }
                                            town.addOutpostSpawn(player.getLocation());
                                            TownyMessaging.sendMessage((Object)player, Translatable.of("msg_plot_set_cost", TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost()), Translatable.of("outpost")));
                                        }).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost()))).sendTo((CommandSender)player);
                                    }
                                }
                                return true;
                            }
                            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT_SET, split[0])) {
                                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT_SET, split[0]).execute((CommandSender)player, "plot", split);
                                return true;
                            }
                            try {
                                TownBlockType townBlockType;
                                String plotTypeName = split[0];
                                if (plotTypeName.equalsIgnoreCase("reset")) {
                                    plotTypeName = "default";
                                }
                                if ((townBlockType = TownBlockType.lookup(plotTypeName)) == null) {
                                    throw new TownyException(Translatable.of("msg_err_not_block_type"));
                                }
                                try {
                                    PlotCommand.plotTestOwner(resident, townBlock);
                                }
                                catch (TownyException e) {
                                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
                                    return false;
                                }
                                PlotPreChangeTypeEvent preEvent = new PlotPreChangeTypeEvent(townBlockType, townBlock, resident);
                                BukkitTools.getPluginManager().callEvent((Event)preEvent);
                                if (preEvent.isCancelled()) {
                                    TownyMessaging.sendMessage((Object)player, preEvent.getCancelMessage());
                                    return false;
                                }
                                double cost = townBlockType.getCost();
                                if (cost > 0.0 && TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
                                    throw new TownyException(Translatable.of("msg_err_cannot_afford_plot_set_type_cost", new Object[]{townBlockType, TownyEconomyHandler.getFormattedBalance(cost)}));
                                }
                                if (cost > 0.0 && TownyEconomyHandler.isActive()) {
                                    Confirmation.runOnAccept(() -> {
                                        if (!resident.getAccount().withdraw(cost, String.format("Plot set to %s", new Object[]{townBlockType}))) {
                                            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_cannot_afford_plot_set_type_cost", new Object[]{townBlockType, TownyEconomyHandler.getFormattedBalance(cost)}));
                                            return;
                                        }
                                        TownyMessaging.sendMessage((Object)resident, Translatable.of("msg_plot_set_cost", new Object[]{TownyEconomyHandler.getFormattedBalance(cost), townBlockType}));
                                        try {
                                            townBlock.setType(townBlockType, resident);
                                        }
                                        catch (TownyException e) {
                                            TownyMessaging.sendErrorMsg((Object)resident, e.getMessage((CommandSender)player));
                                            return;
                                        }
                                        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_set_type", new Object[]{townBlockType}));
                                    }).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(cost))).sendTo((CommandSender)BukkitTools.getPlayerExact(resident.getName()));
                                    break block97;
                                }
                                townBlock.setType(townBlockType, resident);
                                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_set_type", plotTypeName));
                            }
                            catch (TownyException te) {
                                TownyMessaging.sendErrorMsg((Object)player, te.getMessage((CommandSender)player));
                            }
                            break block97;
                        }
                        HelpMenu.PLOT_SET.send((CommandSender)player);
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("clear")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_CLEAR.getNode())) {
                            throw new TownyException(Translatable.of("msg_err_command_disable"));
                        }
                        if (townBlock != null) {
                            if (!townBlock.getWorld().isUsingPlotManagementMayorDelete()) {
                                throw new TownyException(Translatable.of("msg_err_plot_clear_disabled_in_this_world"));
                            }
                            PlotCommand.plotTestOwner(resident, townBlock);
                            PlotPreClearEvent preEvent = new PlotPreClearEvent(townBlock);
                            BukkitTools.getPluginManager().callEvent((Event)preEvent);
                            if (preEvent.isCancelled()) {
                                TownyMessaging.sendMessage((Object)player, preEvent.getCancelMessage());
                                return false;
                            }
                            for (String material : TownyAPI.getInstance().getTownyWorld(world).getPlotManagementMayorDelete()) {
                                if (Material.matchMaterial((String)material) != null) {
                                    TownyRegenAPI.deleteTownBlockMaterial(townBlock, Material.getMaterial((String)material));
                                    TownyMessaging.sendMessage((Object)player, Translatable.of("msg_clear_plot_material", material));
                                    continue;
                                }
                                throw new TownyException(Translatable.of("msg_err_invalid_property", material));
                            }
                            BukkitTools.getPluginManager().callEvent((Event)new PlotClearEvent(townBlock));
                        } else {
                            TownyMessaging.sendMessage((Object)player, Translatable.of("msg_err_empty_area_selection"));
                        }
                        break block97;
                    }
                    if (split[0].equalsIgnoreCase("group")) {
                        return this.handlePlotGroupCommand(StringMgmt.remFirstArg(split), player);
                    }
                    if (split[0].equalsIgnoreCase("jailcell")) {
                        this.parsePlotJailCell(player, TownyAPI.getInstance().getTownBlock(player.getLocation()), StringMgmt.remFirstArg(split));
                        return true;
                    }
                    if (split[0].equalsIgnoreCase("trust")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_TRUST.getNode())) {
                            throw new TownyException(Translatable.of("msg_err_command_disable"));
                        }
                        PlotCommand.parsePlotTrustCommand(player, StringMgmt.remFirstArg(split));
                        return true;
                    }
                    if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT, split[0])) {
                        TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT, split[0]).execute((CommandSender)player, "plot", split);
                        break block97;
                    }
                    throw new TownyException(Translatable.of("msg_err_invalid_property", split[0]));
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)player, x.getMessage((CommandSender)player));
                }
            }
        }
        return true;
    }

    private void parsePlotJailCell(Player player, TownBlock townBlock, String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("?") || args[0].equalsIgnoreCase("help")) {
            HelpMenu.PLOT_JAILCELL.send((CommandSender)player);
        }
        try {
            if (!TownyUniverse.getInstance().getPermissionSource().has(player, PermissionNodes.TOWNY_COMMAND_PLOT_JAILCELL.getNode())) {
                throw new TownyException("msg_err_command_disable");
            }
            Resident resident = TownyAPI.getInstance().getResident(player.getUniqueId());
            if (resident == null) {
                return;
            }
            if (townBlock == null || !townBlock.isJail()) {
                throw new TownyException("msg_err_location_is_not_within_a_jail_plot");
            }
            PlotCommand.plotTestOwner(resident, townBlock);
            Jail jail = townBlock.getJail();
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("add")) {
                    jail.addJailCell(player.getLocation());
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_jail_cell_set"));
                    jail.save();
                } else if (args[0].equalsIgnoreCase("remove")) {
                    if (!jail.hasCells()) {
                        throw new TownyException(Translatable.of("msg_err_this_jail_has_no_cells"));
                    }
                    if (jail.getCellMap().size() == 1) {
                        throw new TownyException(Translatable.of("msg_err_you_cannot_remove_the_last_cell"));
                    }
                    SpawnPointLocation cellLoc = SpawnPointLocation.parseSpawnPointLocation(player.getLocation());
                    if (!jail.hasJailCell(cellLoc)) {
                        throw new TownyException(Translatable.of("msg_err_no_cell_found_at_this_location"));
                    }
                    jail.removeJailCell(player.getLocation());
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_jail_cell_removed"));
                    jail.save();
                } else {
                    HelpMenu.PLOT_JAILCELL.send((CommandSender)player);
                }
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
        }
    }

    public static TownyPermissionChange setTownBlockPermissions(Player player, TownBlockOwner townBlockOwner, TownBlock townBlock, String[] split) {
        TownyPermissionChange permChange = null;
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle("/... set perm"));
            if (townBlockOwner instanceof Town) {
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Level", "[resident/nation/ally/outsider]", "", ""));
            }
            if (townBlockOwner instanceof Resident) {
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Level", "[friend/town/ally/outsider]", "", ""));
            }
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "set perm", "reset", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Eg", "/plot set perm", "friend build on", ""));
            return null;
        }
        TownyPermission perm = townBlock.getPermissions();
        if (split.length == 1) {
            if (split[0].equalsIgnoreCase("reset")) {
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.RESET, false, townBlock);
                perm.change(permChange);
                townBlock.save();
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_perms_reset_single"));
                plugin.resetCache();
                return permChange;
            }
            try {
                boolean b = StringMgmt.parseOnOff(split[0]);
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.ALL_PERMS, b, new Object[0]);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
        }
        if (split.length == 2) {
            boolean b;
            try {
                b = StringMgmt.parseOnOff(split[1]);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
            if (split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            } else if (split[0].equalsIgnoreCase("town")) {
                split[0] = "nation";
            } else if (split[0].equalsIgnoreCase("itemuse")) {
                split[0] = "item_use";
            }
            try {
                TownyPermission.PermLevel permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase());
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.PERM_LEVEL, b, new Object[]{permLevel});
            }
            catch (IllegalArgumentException permLevelException) {
                try {
                    TownyPermission.ActionType actionType = TownyPermission.ActionType.valueOf(split[0].toUpperCase());
                    permChange = new TownyPermissionChange(TownyPermissionChange.Action.ACTION_TYPE, b, new Object[]{actionType});
                }
                catch (IllegalArgumentException actionTypeException) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                    return null;
                }
            }
        } else if (split.length == 3) {
            TownyPermission.ActionType actionType;
            TownyPermission.PermLevel permLevel;
            if (split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            } else if (split[0].equalsIgnoreCase("town")) {
                split[0] = "nation";
            }
            if (split[1].equalsIgnoreCase("itemuse")) {
                split[1] = "item_use";
            }
            try {
                permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase());
                actionType = TownyPermission.ActionType.valueOf(split[1].toUpperCase());
            }
            catch (IllegalArgumentException ignore) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
            try {
                boolean b = StringMgmt.parseOnOff(split[2]);
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.SINGLE_PERM, b, new Object[]{permLevel, actionType});
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
        }
        if (permChange != null) {
            perm.change(permChange);
        }
        townBlock.setChanged(true);
        townBlock.save();
        if (!townBlock.hasPlotObjectGroup()) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_perms").forLocale((CommandSender)player));
            TownyMessaging.sendMessage((Object)player, "\u00a72" + Translatable.of("status_perm").forLocale((CommandSender)player) + " " + (townBlockOwner instanceof Resident ? perm.getColourString().replace("n", "t") : perm.getColourString().replace("f", "r")));
            TownyMessaging.sendMessage((Object)player, "\u00a72" + Translatable.of("status_pvp").forLocale((CommandSender)player) + " " + (perm.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + Translatable.of("explosions").forLocale((CommandSender)player) + " " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + Translatable.of("firespread").forLocale((CommandSender)player) + " " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + Translatable.of("mobspawns").forLocale((CommandSender)player) + " " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
        }
        TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(townBlock);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        plugin.resetCache();
        return permChange;
    }

    public void setPlotForSale(Resident resident, WorldCoord worldCoord, double forSale) throws TownyException {
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        if (townBlock == null || !townBlock.hasTown()) {
            throw new TownyException(Translatable.of("msg_err_not_part_town"));
        }
        PlotCommand.plotTestOwner(resident, townBlock);
        townBlock.setPlotPrice(Math.min(TownySettings.getMaxPlotPrice(), forSale));
        if (forSale != -1.0) {
            TownyMessaging.sendPrefixedTownMessage(townBlock.getTownOrNull(), Translatable.of("MSG_PLOT_FOR_SALE", resident.getName(), worldCoord.toString()));
            if (!resident.hasTown() || resident.hasTown() && townBlock.getTownOrNull() != resident.getTownOrNull()) {
                TownyMessaging.sendMsg(resident, Translatable.of("MSG_PLOT_FOR_SALE", resident.getName(), worldCoord.toString()));
            }
            Bukkit.getPluginManager().callEvent((Event)new PlotSetForSaleEvent(resident, forSale, townBlock));
        } else {
            TownyMessaging.sendMsg(resident, Translatable.of("msg_plot_set_to_nfs"));
            Bukkit.getPluginManager().callEvent((Event)new PlotNotForSaleEvent(resident, townBlock));
        }
        townBlock.save();
    }

    public void plotToggle(Player player, TownBlock townBlock, String[] split) {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_TOGGLE.send((CommandSender)player);
        } else {
            try {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                Town town = townBlock.getTownOrNull();
                if (town == null) {
                    throw new TownyException(Translatable.of("msg_not_claimed_1"));
                }
                Optional<Object> choice = Optional.empty();
                if (split.length == 2) {
                    choice = BaseCommand.parseToggleChoice(split[1]);
                }
                if (split[0].equalsIgnoreCase("pvp")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    if (TownySettings.getPVPCoolDownTime() > 0 && !permSource.testPermission(player, PermissionNodes.TOWNY_ADMIN.getNode())) {
                        if (CooldownTimerTask.hasCooldown(town.getName(), CooldownTimerTask.CooldownType.PVP)) {
                            throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(town.getName(), CooldownTimerTask.CooldownType.PVP)));
                        }
                        if (CooldownTimerTask.hasCooldown(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)) {
                            throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)));
                        }
                    }
                    if (town.isAdminDisabledPVP() && !townBlock.getPermissions().pvp) {
                        throw new TownyException(Translatable.of("msg_err_admin_controlled_pvp_prevents_you_from_changing_pvp", "adminDisabledPVP", "on"));
                    }
                    if (town.isAdminEnabledPVP() && townBlock.getPermissions().pvp) {
                        throw new TownyException(Translatable.of("msg_err_admin_controlled_pvp_prevents_you_from_changing_pvp", "adminEnabledPVP", "off"));
                    }
                    PlotTogglePvpEvent plotTogglePvpEvent = new PlotTogglePvpEvent(town, player, (Boolean)choice.orElse(!townBlock.getPermissions().pvp));
                    Bukkit.getPluginManager().callEvent((Event)plotTogglePvpEvent);
                    if (plotTogglePvpEvent.isCancelled()) {
                        throw new TownyException(plotTogglePvpEvent.getCancellationMsg());
                    }
                    townBlock.getPermissions().pvp = (Boolean)choice.orElse(!townBlock.getPermissions().pvp);
                    if (TownySettings.getPVPCoolDownTime() > 0 && !permSource.testPermission(player, PermissionNodes.TOWNY_ADMIN.getNode())) {
                        CooldownTimerTask.addCooldownTimer(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP);
                    }
                    TownyMessaging.sendMessage((Object)player, Translatable.of("msg_changed_pvp", "Plot", townBlock.getPermissions().pvp ? Translatable.of("enabled") : Translatable.of("disabled")));
                } else if (split[0].equalsIgnoreCase("explosion")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    PlotToggleExplosionEvent plotToggleExplosionEvent = new PlotToggleExplosionEvent(town, player, choice.orElse(!townBlock.getPermissions().explosion));
                    Bukkit.getPluginManager().callEvent((Event)plotToggleExplosionEvent);
                    if (plotToggleExplosionEvent.isCancelled()) {
                        throw new TownyException(plotToggleExplosionEvent.getCancellationMsg());
                    }
                    townBlock.getPermissions().explosion = (Boolean)choice.orElse(!townBlock.getPermissions().explosion);
                    TownyMessaging.sendMessage((Object)player, Translatable.of("msg_changed_expl", "the Plot", townBlock.getPermissions().explosion ? Translatable.of("enabled") : Translatable.of("disabled")));
                } else if (split[0].equalsIgnoreCase("fire")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    PlotToggleFireEvent plotToggleFireEvent = new PlotToggleFireEvent(town, player, (Boolean)choice.orElse(!townBlock.getPermissions().fire));
                    Bukkit.getPluginManager().callEvent((Event)plotToggleFireEvent);
                    if (plotToggleFireEvent.isCancelled()) {
                        throw new TownyException(plotToggleFireEvent.getCancellationMsg());
                    }
                    townBlock.getPermissions().fire = (Boolean)choice.orElse(!townBlock.getPermissions().fire);
                    TownyMessaging.sendMessage((Object)player, Translatable.of("msg_changed_fire", "the Plot", townBlock.getPermissions().fire ? Translatable.of("enabled") : Translatable.of("disabled")));
                } else if (split[0].equalsIgnoreCase("mobs")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    PlotToggleMobsEvent plotToggleMobsEvent = new PlotToggleMobsEvent(town, player, (Boolean)choice.orElse(!townBlock.getPermissions().mobs));
                    Bukkit.getPluginManager().callEvent((Event)plotToggleMobsEvent);
                    if (plotToggleMobsEvent.isCancelled()) {
                        throw new TownyException(plotToggleMobsEvent.getCancellationMsg());
                    }
                    townBlock.getPermissions().mobs = (Boolean)choice.orElse(!townBlock.getPermissions().mobs);
                    TownyMessaging.sendMessage((Object)player, Translatable.of("msg_changed_mobs", "the Plot", townBlock.getPermissions().mobs ? Translatable.of("enabled") : Translatable.of("disabled")));
                } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT_TOGGLE, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT_TOGGLE, split[0]).execute((CommandSender)player, "plot", split);
                } else {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", "plot"));
                    return;
                }
                townBlock.setChanged(true);
                TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(townBlock);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
            }
            townBlock.save();
        }
    }

    public void plotGroupToggle(Player player, PlotGroup plotGroup, String[] split) {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_GROUP_TOGGLE.send((CommandSender)player);
        } else {
            try {
                Translatable endingMessage = null;
                Optional<Object> choice = Optional.empty();
                if (split.length == 2) {
                    choice = BaseCommand.parseToggleChoice(split[1]);
                }
                for (TownBlock groupBlock : plotGroup.getTownBlocks()) {
                    Town town = groupBlock.getTownOrNull();
                    if (town == null) continue;
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(Translatable.of("msg_err_command_disable"));
                    }
                    if (split[0].equalsIgnoreCase("pvp")) {
                        this.toggleTest(player, groupBlock, StringMgmt.join(split, " "));
                        if (TownySettings.getPVPCoolDownTime() > 0) {
                            if (CooldownTimerTask.hasCooldown(town.getName(), CooldownTimerTask.CooldownType.PVP)) {
                                throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(town.getName(), CooldownTimerTask.CooldownType.PVP)));
                            }
                            if (CooldownTimerTask.hasCooldown(groupBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)) {
                                throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(groupBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)));
                            }
                        }
                        PlotTogglePvpEvent plotTogglePvpEvent = new PlotTogglePvpEvent(town, player, choice.orElse(!groupBlock.getPermissions().pvp));
                        Bukkit.getPluginManager().callEvent((Event)plotTogglePvpEvent);
                        if (plotTogglePvpEvent.isCancelled()) {
                            TownyMessaging.sendMessage((Object)player, plotTogglePvpEvent.getCancellationMsg());
                            return;
                        }
                        groupBlock.getPermissions().pvp = (Boolean)choice.orElse(!groupBlock.getPermissions().pvp);
                        if (TownySettings.getPVPCoolDownTime() > 0) {
                            CooldownTimerTask.addCooldownTimer(groupBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP);
                        }
                        endingMessage = Translatable.of("msg_changed_pvp", "Plot Group", groupBlock.getPermissions().pvp ? Translatable.of("enabled") : Translatable.of("disabled"));
                    } else if (split[0].equalsIgnoreCase("explosion")) {
                        this.toggleTest(player, groupBlock, StringMgmt.join(split, " "));
                        PlotToggleExplosionEvent plotToggleExplosionEvent = new PlotToggleExplosionEvent(town, player, (Boolean)choice.orElse(!groupBlock.getPermissions().explosion));
                        Bukkit.getPluginManager().callEvent((Event)plotToggleExplosionEvent);
                        if (plotToggleExplosionEvent.isCancelled()) {
                            TownyMessaging.sendMessage((Object)player, plotToggleExplosionEvent.getCancellationMsg());
                            return;
                        }
                        groupBlock.getPermissions().explosion = (Boolean)choice.orElse(!groupBlock.getPermissions().explosion);
                        endingMessage = Translatable.of("msg_changed_expl", "the Plot Group", groupBlock.getPermissions().explosion ? Translatable.of("enabled") : Translatable.of("disabled"));
                    } else if (split[0].equalsIgnoreCase("fire")) {
                        this.toggleTest(player, groupBlock, StringMgmt.join(split, " "));
                        PlotToggleFireEvent plotToggleFireEvent = new PlotToggleFireEvent(town, player, (Boolean)choice.orElse(!groupBlock.getPermissions().fire));
                        Bukkit.getPluginManager().callEvent((Event)plotToggleFireEvent);
                        if (plotToggleFireEvent.isCancelled()) {
                            TownyMessaging.sendMessage((Object)player, plotToggleFireEvent.getCancellationMsg());
                            return;
                        }
                        groupBlock.getPermissions().fire = (Boolean)choice.orElse(!groupBlock.getPermissions().fire);
                        endingMessage = Translatable.of("msg_changed_fire", "the Plot Group", groupBlock.getPermissions().fire ? Translatable.of("enabled") : Translatable.of("disabled"));
                    } else if (split[0].equalsIgnoreCase("mobs")) {
                        this.toggleTest(player, groupBlock, StringMgmt.join(split, " "));
                        PlotToggleMobsEvent plotToggleMobsEvent = new PlotToggleMobsEvent(town, player, (Boolean)choice.orElse(!groupBlock.getPermissions().mobs));
                        Bukkit.getPluginManager().callEvent((Event)plotToggleMobsEvent);
                        if (plotToggleMobsEvent.isCancelled()) {
                            TownyMessaging.sendMessage((Object)player, plotToggleMobsEvent.getCancellationMsg());
                            return;
                        }
                        groupBlock.getPermissions().mobs = (Boolean)choice.orElse(!groupBlock.getPermissions().mobs);
                        endingMessage = Translatable.of("msg_changed_mobs", player, "the Plot Group", groupBlock.getPermissions().mobs ? Translatable.of("enabled") : Translatable.of("disabled"));
                    } else {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", "plot"));
                        return;
                    }
                    groupBlock.setChanged(true);
                    TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(groupBlock);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    groupBlock.save();
                }
                if (endingMessage != null) {
                    TownyMessaging.sendMessage((Object)player, endingMessage);
                }
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
        }
    }

    private void toggleTest(Player player, TownBlock townBlock, String split) throws TownyException {
        if ((split = split.toLowerCase()).contains("mobs") && townBlock.getWorld().isForceTownMobs()) {
            throw new TownyException(Translatable.of("msg_world_mobs"));
        }
        if (split.contains("fire") && townBlock.getWorld().isForceFire()) {
            throw new TownyException(Translatable.of("msg_world_fire"));
        }
        if (split.contains("explosion") && townBlock.getWorld().isForceExpl()) {
            throw new TownyException(Translatable.of("msg_world_expl"));
        }
        if (split.contains("pvp") && townBlock.getWorld().isForcePVP()) {
            throw new TownyException(Translatable.of("msg_world_pvp"));
        }
        if ((split.contains("pvp") || split.trim().equalsIgnoreCase("off")) && townBlock.getType().equals((Object)TownBlockType.ARENA)) {
            throw new TownyException(Translatable.of("msg_plot_pvp"));
        }
    }

    public static void plotTestOwner(Resident resident, TownBlock townBlock) throws TownyException {
        Player player = BukkitTools.getPlayer(resident.getName());
        boolean isAdmin = TownyUniverse.getInstance().getPermissionSource().isTownyAdmin(player);
        boolean isMayor = player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode());
        if (townBlock.hasResident()) {
            boolean isMayorInTheirOwnTown;
            boolean bl = isMayorInTheirOwnTown = isMayor && resident.hasTown() && resident.getTownOrNull() == townBlock.getTownOrNull();
            if (isAdmin || isMayorInTheirOwnTown || townBlock.hasResident(resident)) {
                return;
            }
            throw new TownyException(Translatable.of("msg_area_not_own"));
        }
        boolean isSameTown = townBlock.getTownOrNull().hasResident(resident);
        if (isSameTown && !isMayor) {
            throw new TownyException(Translatable.of("msg_not_mayor_ass"));
        }
        if (!isSameTown && !isAdmin) {
            throw new TownyException(Translatable.of("msg_err_not_part_town"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handlePlotGroupCommand(String[] split, Player player) throws TownyException {
        Iterator<TownBlock> title3;
        TownBlockType type;
        String plotTypeName;
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        Resident resident = PlotCommand.getResidentOrThrow(player.getUniqueId());
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player.getLocation());
        if (townBlock == null) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
        Town town = townBlock.getTownOrNull();
        if (town == null) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
        PlotCommand.plotTestOwner(resident, townBlock);
        if (split.length <= 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_GROUP_HELP.send((CommandSender)player);
            if (!townBlock.hasPlotObjectGroup()) return true;
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("status_plot_group_name_and_size", townBlock.getPlotObjectGroup().getName(), townBlock.getPlotObjectGroup().getTownBlocks().size()));
            return true;
        }
        if (split[0].equalsIgnoreCase("add") || split[0].equalsIgnoreCase("new") || split[0].equalsIgnoreCase("create")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_ADD.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (split.length == 1) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_you_must_specify_a_group_name"));
                return false;
            }
            if (split.length != 2) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_group_name_required"));
                return false;
            }
            String plotGroupName = NameValidation.filterName(split[1]);
            if (town.hasPlotGroupName(plotGroupName = NameValidation.filterCommas(plotGroupName))) {
                TownBlockType groupType = town.getPlotObjectGroupFromName(plotGroupName).getTownBlockType();
                if (townBlock.getType() != groupType) {
                    throw new TownyException(Translatable.of("msg_err_this_townblock_doesnt_match_the_groups_type", groupType.getName()));
                }
            }
            if (!townBlock.hasPlotObjectGroup()) {
                this.createOrAddOnToPlotGroup(townBlock, town, plotGroupName);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_was_put_into_group_x", townBlock.getX(), townBlock.getZ(), townBlock.getPlotObjectGroup().getName()));
                return false;
            }
            if (townBlock.getPlotObjectGroup().getName().equalsIgnoreCase(plotGroupName)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_this_plot_is_already_part_of_the_plot_group_x", plotGroupName));
                return false;
            }
            String name = plotGroupName;
            Confirmation.runOnAccept(() -> {
                PlotGroup oldGroup = townBlock.getPlotObjectGroup();
                oldGroup.removeTownBlock(townBlock);
                oldGroup.save();
                this.createOrAddOnToPlotGroup(townBlock, town, name);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_transferred_from_x_to_x_group", oldGroup.getName(), townBlock.getPlotObjectGroup().getName()));
            }).setTitle(Translatable.of("msg_plot_group_already_exists_did_you_want_to_transfer", townBlock.getPlotObjectGroup().getName(), split[1])).sendTo((CommandSender)player);
            return false;
        }
        if (split[0].equalsIgnoreCase("delete")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_DELETE.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (!townBlock.hasPlotObjectGroup()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_not_associated_with_a_group"));
                return false;
            }
            Confirmation.runOnAccept(() -> {
                PlotGroup group = townBlock.getPlotObjectGroup();
                String name = group.getName();
                town.removePlotGroup(group);
                TownyUniverse.getInstance().getDataSource().removePlotGroup(group);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plotgroup_deleted", name));
            }).sendTo((CommandSender)player);
            return false;
        }
        if (split[0].equalsIgnoreCase("remove")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_REMOVE.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (!townBlock.hasPlotObjectGroup()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_not_associated_with_a_group"));
                return false;
            }
            PlotGroup group = townBlock.getPlotObjectGroup();
            String name = group.getName();
            group.removeTownBlock(townBlock);
            townBlock.removePlotObjectGroup();
            townBlock.save();
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_was_removed_from_group_x", townBlock.getX(), townBlock.getZ(), name));
            if (!group.getTownBlocks().isEmpty()) return false;
            town.removePlotGroup(group);
            TownyUniverse.getInstance().getDataSource().removePlotGroup(group);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plotgroup_empty_deleted", name));
            return false;
        }
        if (split[0].equalsIgnoreCase("rename")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_RENAME.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (!townBlock.hasPlotObjectGroup()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_not_associated_with_a_group"));
                return false;
            }
            if (split.length == 1) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_group_name_required"));
                return false;
            }
            String newName = split[1];
            String oldName = townBlock.getPlotObjectGroup().getName();
            TownyUniverse.getInstance().getDataSource().renameGroup(townBlock.getPlotObjectGroup(), newName);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_renamed_from_x_to_y", oldName, newName));
            return false;
        }
        if (split[0].equalsIgnoreCase("forsale") || split[0].equalsIgnoreCase("fs")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_FORSALE.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            PlotGroup group = townBlock.getPlotObjectGroup();
            if (group == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_not_associated_with_a_group"));
                return false;
            }
            if (split.length < 2) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_group_specify_price"));
                return false;
            }
            int price = 0;
            try {
                price = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_must_be_num"));
                return false;
            }
            if (price < 0) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_negative_money"));
                return false;
            }
            group.setPrice(price);
            group.save();
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_player_put_group_up_for_sale", player.getName(), group.getName(), TownyEconomyHandler.getFormattedBalance(group.getPrice())));
            return false;
        }
        if (split[0].equalsIgnoreCase("notforsale") || split[0].equalsIgnoreCase("nfs")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_NOTFORSALE.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            PlotGroup group = townBlock.getPlotObjectGroup();
            if (group == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_not_associated_with_a_group"));
                return false;
            }
            group.setPrice(-1.0);
            group.save();
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_player_made_group_not_for_sale", player.getName(), group.getName()));
            return false;
        }
        if (split[0].equalsIgnoreCase("toggle")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_TOGGLE.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (townBlock.getPlotObjectGroup() == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_not_associated_with_a_group"));
                return false;
            }
            PlotGroup plotGroup = townBlock.getPlotObjectGroup();
            String title2 = Translatable.of("msg_plot_group_toggle_confirmation", townBlock.getPlotObjectGroup().getTownBlocks().size()).forLocale((CommandSender)player) + " " + Translatable.of("are_you_sure_you_want_to_continue").forLocale((CommandSender)player);
            Confirmation.runOnAccept(() -> new PlotCommand(Towny.getPlugin()).plotGroupToggle(player, plotGroup, StringMgmt.remArgs(split, 1))).setTitle(title2).sendTo((CommandSender)player);
            return true;
        }
        if (split[0].equalsIgnoreCase("set")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_SET.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (townBlock.getPlotObjectGroup() == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_not_associated_with_a_group"));
                return false;
            }
            TownBlockOwner townBlockOwner = townBlock.getTownBlockOwner();
            if (split.length < 2) {
                TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle("/plot group set"));
                if (townBlockOwner instanceof Town) {
                    TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Level", "[resident/nation/ally/outsider]", "", ""));
                }
                if (townBlockOwner instanceof Resident) {
                    TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Level", "[friend/town/ally/outsider]", "", ""));
                }
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "perm", "[on/off]", "Toggle all permissions"));
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "perm", "[level/type] [on/off]", ""));
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "perm", "[level] [type] [on/off]", ""));
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "perm", "reset", ""));
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Eg", "/plot group set perm", "friend build on", ""));
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "[townblocktype]", "", "Farm, Wilds, Bank, Embassy, etc."));
                return false;
            }
            if (split[1].equalsIgnoreCase("perm")) {
                PlotGroup plotGroup = townBlock.getPlotObjectGroup();
                Runnable permHandler = () -> {
                    TownyPermissionChange permChange = PlotCommand.setTownBlockPermissions(player, townBlockOwner, townBlock, StringMgmt.remArgs(split, 2));
                    if (permChange != null) {
                        plotGroup.getPermissions().change(permChange);
                        plotGroup.getTownBlocks().stream().forEach(tb -> {
                            tb.setPermissions(plotGroup.getPermissions().toString());
                            tb.setChanged(!tb.getPermissions().toString().equals(town.getPermissions().toString()));
                            tb.save();
                            TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent((TownBlock)tb);
                            Bukkit.getServer().getPluginManager().callEvent((Event)event);
                        });
                        plugin.resetCache();
                        TownyPermission perm = plotGroup.getPermissions();
                        TownyMessaging.sendMessage((Object)player, Translatable.of("msg_set_perms").forLocale((CommandSender)player));
                        TownyMessaging.sendMessage((Object)player, "\u00a72" + Translatable.of("status_perm").forLocale((CommandSender)player) + " " + (townBlockOwner instanceof Resident ? perm.getColourString().replace("n", "t") : perm.getColourString().replace("f", "r")));
                        TownyMessaging.sendMessage((Object)player, "\u00a72" + Translatable.of("status_pvp").forLocale((CommandSender)player) + " " + (!CombatUtil.preventPvP(townBlock.getWorld(), townBlock) ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + Translatable.of("explosions").forLocale((CommandSender)player) + " " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + Translatable.of("firespread").forLocale((CommandSender)player) + " " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + Translatable.of("mobspawns").forLocale((CommandSender)player) + " " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
                    }
                };
                String title3 = Translatable.of("msg_plot_group_set_perm_confirmation", townBlock.getPlotObjectGroup().getTownBlocks().size()) + " " + Translatable.of("are_you_sure_you_want_to_continue").forLocale((CommandSender)player);
                Confirmation.runOnAccept(permHandler).setTitle(title3).sendTo((CommandSender)player);
                return true;
            }
            plotTypeName = split[1];
            if (plotTypeName.equalsIgnoreCase("jail")) {
                throw new TownyException(Translatable.of("msg_err_cannot_set_group_to_jail"));
            }
            if (plotTypeName.equalsIgnoreCase("reset")) {
                plotTypeName = "default";
            }
            if ((type = TownBlockType.lookup(plotTypeName)) == null) {
                throw new TownyException(Translatable.of("msg_err_not_block_type"));
            }
            title3 = townBlock.getPlotObjectGroup().getTownBlocks().iterator();
        } else {
            if (split[0].equalsIgnoreCase("trust")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_TRUST.getNode())) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                if (split.length < 3) {
                    HelpMenu.PLOT_GROUP_TRUST_HELP.send((CommandSender)player);
                    return true;
                }
                PlotGroup group = townBlock.getPlotObjectGroup();
                if (group == null) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_not_associated_with_a_group"));
                    return false;
                }
                Resident trustedResident = TownyAPI.getInstance().getResident(split[2]);
                if (trustedResident == null || trustedResident.isNPC()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", split[2]));
                    return false;
                }
                if (split[1].equalsIgnoreCase("add")) {
                    if (group.hasTrustedResident(trustedResident)) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_already_trusted", trustedResident.getName(), Translatable.of("plotgroup_sing")));
                        return false;
                    }
                    PlotTrustAddEvent event = new PlotTrustAddEvent(new ArrayList<TownBlock>(group.getTownBlocks()), trustedResident, player);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        TownyMessaging.sendErrorMsg((Object)player, event.getCancelMessage());
                        return false;
                    }
                    group.addTrustedResident(trustedResident);
                    plugin.deleteCache(trustedResident.getName());
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_added", trustedResident.getName(), Translatable.of("plotgroup_sing")));
                    if (!BukkitTools.isOnline(trustedResident.getName())) return true;
                    if (trustedResident.getName().equals(player.getName())) return true;
                    TownyMessaging.sendMsg(trustedResident, Translatable.of("msg_trusted_added_2", player.getName(), Translatable.of("plotgroup_sing"), group.getName()));
                    return true;
                }
                if (!split[1].equalsIgnoreCase("remove")) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", split[1]));
                    return false;
                }
                if (!group.hasTrustedResident(trustedResident)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_not_trusted", trustedResident.getName(), Translatable.of("plotgroup_sing")));
                    return false;
                }
                PlotTrustRemoveEvent event = new PlotTrustRemoveEvent(new ArrayList<TownBlock>(group.getTownBlocks()), trustedResident, player);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    TownyMessaging.sendErrorMsg((Object)player, event.getCancelMessage());
                    return false;
                }
                group.removeTrustedResident(trustedResident);
                plugin.deleteCache(trustedResident.getName());
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_removed", trustedResident.getName(), Translatable.of("plotgroup_sing")));
                if (!BukkitTools.isOnline(trustedResident.getName())) return true;
                if (trustedResident.getName().equals(player.getName())) return true;
                TownyMessaging.sendMsg(trustedResident, Translatable.of("msg_trusted_removed_2", player.getName(), Translatable.of("plotgroup_sing"), group.getName()));
                return true;
            }
            if (!split[0].equalsIgnoreCase("perm")) {
                HelpMenu.PLOT_GROUP_HELP.send((CommandSender)player);
                if (!townBlock.hasPlotObjectGroup()) return true;
                TownyMessaging.sendMessage((Object)player, Translatable.of("status_plot_group_name_and_size", townBlock.getPlotObjectGroup().getName(), townBlock.getPlotObjectGroup().getTownBlocks().size()));
                return true;
            }
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_PERM.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            if (split.length < 2) {
                HelpMenu.PLOT_GROUP_PERM_HELP.send((CommandSender)player);
                return true;
            }
            PlotGroup group = townBlock.getPlotObjectGroup();
            if (group == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_not_associated_with_a_group"));
                return false;
            }
            if (split[1].equalsIgnoreCase("gui")) {
                PermissionGUIUtil.openPermissionGUI(resident, townBlock);
                return false;
            }
            if (split.length < 3) {
                HelpMenu.PLOT_GROUP_PERM_HELP.send((CommandSender)player);
                return true;
            }
            Resident overrideResident = TownyAPI.getInstance().getResident(split[2]);
            if (overrideResident == null || overrideResident.isNPC()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", split[2]));
                return true;
            }
            if (split[1].equalsIgnoreCase("add")) {
                if (group.getPermissionOverrides() != null && group.getPermissionOverrides().containsKey(overrideResident)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_overrides_already_set", overrideResident.getName(), Translatable.of("plotgroup_sing")));
                    return true;
                }
                group.putPermissionOverride(overrideResident, new PermissionData(PermissionGUIUtil.getDefaultTypes(), player.getName()));
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_overrides_added", overrideResident.getName()));
                return false;
            }
            if (!split[1].equalsIgnoreCase("remove")) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", split[1]));
                return false;
            }
            if (group.getPermissionOverrides() != null && !group.getPermissionOverrides().containsKey(overrideResident)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_no_overrides_set", overrideResident.getName(), Translatable.of("plotgroup_sing")));
                return true;
            }
            group.removePermissionOverride(overrideResident);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_overrides_removed", overrideResident.getName()));
            return false;
        }
        while (title3.hasNext()) {
            TownBlock tb = title3.next();
            try {
                PlotCommand.plotTestOwner(resident, townBlock);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)resident, e.getMessage((CommandSender)player));
                return false;
            }
            PlotPreChangeTypeEvent preEvent = new PlotPreChangeTypeEvent(type, tb, resident);
            BukkitTools.getPluginManager().callEvent((Event)preEvent);
            if (!preEvent.isCancelled()) continue;
            TownyMessaging.sendMessage((Object)player, preEvent.getCancelMessage());
            return false;
        }
        int amount = townBlock.getPlotObjectGroup().getTownBlocks().size();
        double cost = type.getCost() * (double)amount;
        try {
            if (cost > 0.0 && TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
                throw new TownyException(Translatable.of("msg_err_cannot_afford_plot_set_type_cost", new Object[]{type, TownyEconomyHandler.getFormattedBalance(cost)}));
            }
            if (cost > 0.0 && TownyEconomyHandler.isActive()) {
                Confirmation.runOnAccept(() -> {
                    if (!resident.getAccount().withdraw(cost, String.format("Plot (" + amount + ") set to %s", new Object[]{type}))) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_cannot_afford_plot_set_type_cost", new Object[]{type, TownyEconomyHandler.getFormattedBalance(cost)}));
                        return;
                    }
                    TownyMessaging.sendMessage((Object)resident, Translatable.of("msg_plot_set_cost", new Object[]{TownyEconomyHandler.getFormattedBalance(cost), type}));
                    for (TownBlock tb : townBlock.getPlotObjectGroup().getTownBlocks()) {
                        try {
                            tb.setType(type, resident);
                        }
                        catch (TownyException townyException) {}
                    }
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_group_type_to_x", new Object[]{type}));
                }).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(cost))).sendTo((CommandSender)BukkitTools.getPlayerExact(resident.getName()));
                return false;
            }
            Iterator<TownBlock> iterator = townBlock.getPlotObjectGroup().getTownBlocks().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_group_type_to_x", plotTypeName));
                    return false;
                }
                TownBlock tb = iterator.next();
                tb.setType(type, resident);
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)resident, e.getMessage((CommandSender)player));
            return false;
        }
    }

    private void createOrAddOnToPlotGroup(TownBlock townBlock, Town town, String plotGroupName) {
        PlotGroup newGroup = null;
        if (town.hasPlotGroupName(plotGroupName)) {
            newGroup = town.getPlotObjectGroupFromName(plotGroupName);
            townBlock.setPermissions(newGroup.getPermissions().toString());
            townBlock.setChanged(!townBlock.getPermissions().toString().equals(town.getPermissions().toString()));
        } else {
            newGroup = new PlotGroup(UUID.randomUUID(), plotGroupName, town);
            TownyUniverse.getInstance().registerGroup(newGroup);
            newGroup.setPermissions(townBlock.getPermissions());
            newGroup.setTrustedResidents(townBlock.getTrustedResidents());
            newGroup.setPermissionOverrides(townBlock.getPermissionOverrides());
        }
        townBlock.setPlotObjectGroup(newGroup);
        if (townBlock.getPlotPrice() > 0.0) {
            newGroup.addPlotPrice(townBlock.getPlotPrice());
        }
        town.addPlotGroup(newGroup);
        newGroup.save();
        townBlock.save();
    }

    public static void parsePlotTrustCommand(Player player, String[] args) {
        if (args.length < 2) {
            HelpMenu.PLOT_TRUST_HELP.send((CommandSender)player);
            return;
        }
        TownBlock townBlock = WorldCoord.parseWorldCoord((Entity)player).getTownBlockOrNull();
        if (townBlock == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_not_claimed_1"));
            return;
        }
        try {
            PlotCommand.plotTestOwner(TownyAPI.getInstance().getResident(player.getName()), townBlock);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
            return;
        }
        if (townBlock.hasPlotObjectGroup()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group", "/plot group trust"));
            return;
        }
        Resident resident = TownyAPI.getInstance().getResident(args[1]);
        if (resident == null || resident.isNPC()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", args[1]));
            return;
        }
        if (args[0].equalsIgnoreCase("add")) {
            if (townBlock.hasTrustedResident(resident)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_already_trusted", resident.getName(), Translatable.of("townblock")));
                return;
            }
            PlotTrustAddEvent event = new PlotTrustAddEvent(townBlock, resident, player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, event.getCancelMessage());
                return;
            }
            townBlock.addTrustedResident(resident);
            plugin.deleteCache(resident.getName());
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_added", resident.getName(), Translatable.of("townblock")));
            if (BukkitTools.isOnline(resident.getName()) && !resident.getName().equals(player.getName())) {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_trusted_added_2", player.getName(), Translatable.of("townblock"), townBlock.getWorldCoord().getCoord().toString()));
            }
        } else if (args[0].equalsIgnoreCase("remove")) {
            if (!townBlock.hasTrustedResident(resident)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_not_trusted", resident.getName(), Translatable.of("townblock")));
                return;
            }
            PlotTrustRemoveEvent event = new PlotTrustRemoveEvent(townBlock, resident, player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, event.getCancelMessage());
                return;
            }
            townBlock.removeTrustedResident(resident);
            plugin.deleteCache(resident.getName());
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_removed", resident.getName(), Translatable.of("townblock")));
            if (BukkitTools.isOnline(resident.getName()) && !resident.getName().equals(player.getName())) {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_trusted_removed_2", player.getName(), Translatable.of("townblock"), townBlock.getWorldCoord().getCoord().toString()));
            }
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", args[0]));
            return;
        }
        townBlock.save();
    }

    private void continuePlotClaimProcess(List<WorldCoord> selection, Resident resident, Player player) throws TownyException {
        double cost = 0.0;
        for (WorldCoord worldCoord : new ArrayList<WorldCoord>(selection)) {
            if (!worldCoord.hasTownBlock()) {
                selection.remove(worldCoord);
                continue;
            }
            TownBlock tb = worldCoord.getTownBlockOrNull();
            if (tb == null) {
                selection.remove(worldCoord);
                continue;
            }
            double price = tb.getPlotPrice();
            if (tb.hasPlotObjectGroup()) {
                PlotGroup group = tb.getPlotObjectGroup();
                if (TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(group.getPrice())) {
                    throw new TownyException(Translatable.of("msg_no_funds_claim_plot_group", group.getTownBlocks().size(), TownyEconomyHandler.getFormattedBalance(group.getPrice())));
                }
                Confirmation.runOnAccept(() -> {
                    ArrayList<WorldCoord> coords = new ArrayList<WorldCoord>();
                    group.getTownBlocks().forEach(tblock -> coords.add(tblock.getWorldCoord()));
                    new PlotClaim(Towny.getPlugin(), player, resident, coords, true, false, true).start();
                }).setTitle(Translatable.of("msg_plot_group_claim_confirmation", group.getTownBlocks().size()).forLocale((CommandSender)player) + " " + TownyEconomyHandler.getFormattedBalance(group.getPrice()) + ". " + Translatable.of("are_you_sure_you_want_to_continue").forLocale((CommandSender)player)).sendTo((CommandSender)player);
                return;
            }
            if (price > -1.0) {
                cost += tb.getPlotPrice();
                continue;
            }
            if (tb.getTownOrNull().isMayor(resident)) continue;
            selection.remove(worldCoord);
        }
        int maxPlots = TownySettings.getMaxResidentPlots(resident);
        int extraPlots = TownySettings.getMaxResidentExtraPlots(resident);
        if (maxPlots != -1) {
            maxPlots += extraPlots;
        }
        if (maxPlots >= 0 && resident.getTownBlocks().size() + selection.size() > maxPlots) {
            throw new TownyException(Translatable.of("msg_max_plot_own", maxPlots));
        }
        if (TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_no_funds_claim_plot", TownyEconomyHandler.getFormattedBalance(cost)));
        }
        if (cost != 0.0) {
            String title = Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(cost)).forLocale((CommandSender)player);
            List<WorldCoord> finalSelection = selection;
            Confirmation.runOnAccept(() -> new PlotClaim(plugin, player, resident, finalSelection, true, false, false).start()).setTitle(title).sendTo((CommandSender)player);
        } else {
            new PlotClaim(plugin, player, resident, selection, true, false, false).start();
        }
    }

    public void parsePlotPermCommand(Player player, String[] args) throws TownyException {
        if (args.length == 0) {
            if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_INFO.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            this.sendPlotInfo(player, args);
            return;
        }
        if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM.getNode(args[0].toLowerCase()))) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        if (args[0].equalsIgnoreCase("hud")) {
            HUDManager.togglePermHUD(player);
        } else {
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player.getLocation());
            if (townBlock == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_not_claimed_1"));
                return;
            }
            if (args[0].equalsIgnoreCase("gui")) {
                Resident resident = TownyAPI.getInstance().getResident(player.getName());
                if (resident == null) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered"));
                    return;
                }
                PermissionGUIUtil.openPermissionGUI(resident, townBlock);
            } else if (args[0].equalsIgnoreCase("remove")) {
                if (args.length < 2) {
                    HelpMenu.PLOT_PERM_HELP.send((CommandSender)player);
                    return;
                }
                try {
                    PlotCommand.plotTestOwner(PlotCommand.getResidentOrThrow(player.getUniqueId()), townBlock);
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
                    return;
                }
                if (townBlock.hasPlotObjectGroup()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group", "/plot group perm remove"));
                    return;
                }
                Resident resident = TownyAPI.getInstance().getResident(args[1]);
                if (resident == null) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", args[1]));
                    return;
                }
                if (!townBlock.getPermissionOverrides().containsKey(resident)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_no_overrides_set", resident.getName(), Translatable.of("townblock")));
                    return;
                }
                townBlock.getPermissionOverrides().remove(resident);
                townBlock.save();
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_overrides_removed", resident.getName()));
            } else if (args[0].equalsIgnoreCase("add")) {
                if (args.length < 2) {
                    HelpMenu.PLOT_PERM_HELP.send((CommandSender)player);
                    return;
                }
                try {
                    PlotCommand.plotTestOwner(PlotCommand.getResidentOrThrow(player.getUniqueId()), townBlock);
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
                    return;
                }
                if (townBlock.hasPlotObjectGroup()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group", "/plot group perm add"));
                    return;
                }
                Resident resident = TownyAPI.getInstance().getResident(args[1]);
                if (resident == null || resident.isNPC()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", args[1]));
                    return;
                }
                if (townBlock.getPermissionOverrides().containsKey(resident)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_overrides_already_set", resident.getName(), Translatable.of("townblock")));
                    return;
                }
                townBlock.getPermissionOverrides().put(resident, new PermissionData(PermissionGUIUtil.getDefaultTypes(), player.getName()));
                townBlock.save();
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_overrides_added", resident.getName()));
            }
        }
    }

    public void sendPlotInfo(Player player, String[] args) {
        WorldCoord coord = WorldCoord.parseWorldCoord((Entity)player);
        String world = player.getWorld().getName();
        try {
            coord = new WorldCoord(world, Integer.parseInt(args[0]), Integer.parseInt(args[1]));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        if (TownyAPI.getInstance().isWilderness(coord)) {
            TownyMessaging.sendStatusScreen((CommandSender)player, TownyFormatter.getStatus(TownyAPI.getInstance().getTownyWorld(world), Translation.getLocale((CommandSender)player)));
        } else {
            TownyMessaging.sendStatusScreen((CommandSender)player, TownyFormatter.getStatus(coord.getTownBlockOrNull(), player, Translation.getLocale((CommandSender)player)));
        }
    }

    static {
        plotTabCompletes = Arrays.asList("claim", "unclaim", "forsale", "fs", "notforsale", "nfs", "evict", "perm", "set", "toggle", "clear", "group", "jailcell", "trust");
        plotGroupTabCompletes = Arrays.asList("add", "delete", "remove", "set", "toggle", "fs", "notforsale", "forsale", "perm", "rename", "trust");
        plotSetTabCompletes = Arrays.asList("reset", "shop", "embassy", "arena", "wilds", "inn", "jail", "farm", "bank", "outpost", "name", "perm");
        plotRectCircleCompletes = Arrays.asList("rect", "circle");
        plotToggleTabCompletes = Arrays.asList("fire", "pvp", "explosion", "mobs");
        plotPermTabCompletes = Arrays.asList("hud", "gui", "add", "remove");
    }
}

