/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.adventure.audience.Audience;
import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.adventure.text.format.NamedTextColor;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.statusscreens.StatusScreen;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class TownyMessaging {
    private static final Logger LOGGER = LogManager.getLogger(Towny.class);
    private static final Logger LOGGER_DEBUG = LogManager.getLogger((String)"com.palmergames.bukkit.towny.debug");

    public static void sendErrorMsg(String msg) {
        LOGGER.warn(ChatTools.stripColour("[Towny] Error: " + msg));
    }

    public static void sendErrorMsg(Object sender, String msg) {
        if (sender != null) {
            CommandSender toSend = (CommandSender)sender;
            if (toSend instanceof ConsoleCommandSender) {
                toSend.sendMessage(Translatable.of("default_towny_prefix").stripColors(true).defaultLocale() + ChatColor.stripColor((String)msg));
            } else {
                toSend.sendMessage(Translation.of("default_towny_prefix") + ChatColor.RED + msg);
            }
        } else {
            TownyMessaging.sendErrorMsg("Sender cannot be null!");
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendErrorMsg(Object sender, String[] msg) {
        for (String line : msg) {
            TownyMessaging.sendErrorMsg(sender, line);
        }
    }

    public static void sendMsg(String msg) {
        LOGGER.info("[Towny] " + ChatTools.stripColour(msg));
    }

    public static void sendMsg(CommandSender sender, String msg) {
        if (sender == null || msg.isEmpty()) {
            return;
        }
        CommandSender commandSender = sender;
        if (commandSender instanceof Player) {
            Player p = (Player)commandSender;
            p.sendMessage(Translatable.of("default_towny_prefix").forLocale((CommandSender)p) + ChatColor.GREEN + msg);
        } else if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(Translatable.of("default_towny_prefix").stripColors(true).defaultLocale() + ChatColor.stripColor((String)msg));
        } else {
            sender.sendMessage(Translatable.of("default_towny_prefix").forLocale(sender) + ChatColor.GREEN + msg);
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMsg(Resident resident, String msg) {
        if (BukkitTools.isOnline(resident.getName())) {
            TownyMessaging.sendMsg((CommandSender)resident.getPlayer(), msg);
        }
    }

    public static void sendMsg(Player player, String[] msg) {
        for (String line : msg) {
            TownyMessaging.sendMsg((CommandSender)player, line);
        }
    }

    public static void sendMsg(Player player, List<String> msg) {
        for (String line : msg) {
            TownyMessaging.sendMsg((CommandSender)player, line);
        }
    }

    public static void sendDevMsg(String msg) {
        Player townyDev;
        if (TownySettings.isDevMode() && (townyDev = BukkitTools.getPlayer(TownySettings.getDevName())) != null) {
            townyDev.sendMessage(Translatable.of("default_towny_prefix").forLocale((CommandSender)townyDev) + " DevMode: " + ChatColor.RED + msg);
        }
    }

    public static void sendDevMsg(String[] msg) {
        for (String line : msg) {
            TownyMessaging.sendDevMsg(line);
        }
    }

    public static void sendDebugMsg(String msg) {
        if (TownySettings.getDebug()) {
            LOGGER_DEBUG.info(ChatTools.stripColour("[Towny] Debug: " + msg));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMessage(Object sender, List<String> lines) {
        TownyMessaging.sendMessage(sender, lines.toArray(new String[0]));
    }

    public static void sendMessage(Object sender, String line) {
        if (line.isEmpty()) {
            return;
        }
        Object object = sender;
        if (object instanceof Player) {
            Player player = (Player)object;
            player.sendMessage(line);
        } else {
            object = sender;
            if (object instanceof CommandSender) {
                CommandSender commandSender = (CommandSender)object;
                commandSender.sendMessage(Colors.strip(line));
            } else {
                object = sender;
                if (object instanceof Resident) {
                    Resident resident = (Resident)object;
                    Player p = TownyAPI.getInstance().getPlayer(resident);
                    if (p != null) {
                        p.sendMessage(Colors.strip(line));
                    }
                }
            }
        }
    }

    public static void sendMessage(Object sender, String[] lines) {
        for (String line : lines) {
            TownyMessaging.sendMessage(sender, line);
        }
    }

    public static void sendGlobalMessage(List<String> lines) {
        TownyMessaging.sendGlobalMessage(lines.toArray(new String[0]));
    }

    public static void sendGlobalMessage(String[] lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour("[Global Msg] " + line));
        }
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (String line : lines) {
                player.sendMessage(Translation.of("default_towny_prefix") + line);
            }
        }
    }

    public static void sendGlobalMessage(String line) {
        LOGGER.info(ChatTools.stripColour("[Global Message] " + line));
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !TownyAPI.getInstance().isTownyWorld(player.getWorld())) continue;
            player.sendMessage(Translation.of("default_towny_prefix") + line);
        }
    }

    public static void sendPlainGlobalMessage(String line) {
        LOGGER.info(ChatTools.stripColour("[Global Message] " + line));
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !TownyAPI.getInstance().isTownyWorld(player.getWorld())) continue;
            player.sendMessage(line);
        }
    }

    public static void sendResidentMessage(Resident resident, String line) throws TownyException {
        LOGGER.info(ChatTools.stripColour("[Resident Msg] " + resident.getName() + ": " + line));
        Player player = TownyAPI.getInstance().getPlayer(resident);
        if (player == null) {
            throw new TownyException("Player could not be found!");
        }
        player.sendMessage(Translation.of("default_towny_prefix") + line);
    }

    public static void sendTownMessagePrefixed(Town town, String line) {
        LOGGER.info(ChatTools.stripColour(line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            player.sendMessage(Translation.of("default_towny_prefix") + line);
        }
    }

    public static void sendPrefixedTownMessage(Town town, String line) {
        LOGGER.info(ChatTools.stripColour("[Town Msg] " + StringMgmt.remUnderscore(town.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            player.sendMessage(Translation.of("default_town_prefix", StringMgmt.remUnderscore(town.getName())) + line);
        }
    }

    public static void sendPrefixedTownMessage(Town town, String[] lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour(line));
        }
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            for (String line : lines) {
                player.sendMessage(Translation.of("default_town_prefix", StringMgmt.remUnderscore(town.getName())) + line);
            }
        }
    }

    public static void sendPrefixedTownMessage(Town town, List<String> lines) {
        TownyMessaging.sendPrefixedTownMessage(town, lines.toArray(new String[0]));
    }

    public static void sendPrefixedNationMessage(Nation nation, String line) {
        LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            player.sendMessage(Translation.of("default_nation_prefix", StringMgmt.remUnderscore(nation.getName())) + line);
        }
    }

    public static void sendPrefixedNationMessage(Nation nation, List<String> lines) {
        TownyMessaging.sendPrefixedNationMessage(nation, lines.toArray(new String[0]));
    }

    public static void sendPrefixedNationMessage(Nation nation, String[] lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        }
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            for (String line : lines) {
                player.sendMessage(Translation.of("default_nation_prefix", StringMgmt.remUnderscore(nation.getName())) + line);
            }
        }
    }

    public static void sendNationMessagePrefixed(Nation nation, String line) {
        LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            player.sendMessage(Translation.of("default_towny_prefix") + line);
        }
    }

    public static void sendNationMessagePrefixed(Nation nation, List<String> lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        }
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            for (String line : lines) {
                player.sendMessage(Translation.of("default_towny_prefix") + line);
            }
        }
    }

    public static void sendTownBoard(Player player, Town town) {
        String tbColor1 = Translation.of("townboard_message_colour_1");
        String tbColor2 = Translation.of("townboard_message_colour_2");
        player.sendMessage(tbColor1 + "[" + StringMgmt.remUnderscore(town.getName()) + "] " + tbColor2 + town.getBoard());
    }

    public static void sendNationBoard(Player player, Nation nation) {
        String nbColor1 = Translation.of("nationboard_message_colour_1");
        String nbColor2 = Translation.of("nationboard_message_colour_2");
        player.sendMessage(nbColor1 + "[" + StringMgmt.remUnderscore(nation.getName()) + "] " + nbColor2 + nation.getBoard());
    }

    public static void sendMessageToMode(ResidentList residents, String msg, String modeRequired) {
        for (Resident resident : TownyAPI.getInstance().getOnlineResidents(residents)) {
            if (!resident.hasMode(modeRequired)) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendMessageToMode(Town town, String msg, String modeRequired) {
        for (Resident resident : town.getResidents()) {
            if (!BukkitTools.isOnline(resident.getName())) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendMessageToMode(Nation nation, String msg, String modeRequired) {
        for (Resident resident : nation.getResidents()) {
            if (!BukkitTools.isOnline(resident.getName())) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendTitleMessageToResident(Resident resident, String title, String subtitle) {
        Player player = TownyAPI.getInstance().getPlayer(resident);
        if (player == null) {
            return;
        }
        player.sendTitle(title, subtitle, 10, 70, 10);
    }

    public static void sendTitleMessageToTown(Town town, String title, String subtitle) {
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            player.sendTitle(title, subtitle, 10, 70, 10);
        }
    }

    public static void sendTitleMessageToNation(Nation nation, String title, String subtitle) {
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            player.sendTitle(title, subtitle, 10, 70, 10);
        }
    }

    public static void sendRequestMessage(CommandSender player, Invite invite) {
        String thirdline;
        String secondline;
        String firstline;
        if (invite.getSender() instanceof Town) {
            firstline = Translation.of("invitation_prefix") + Translation.of("you_have_been_invited_to_join2", invite.getSender().getName());
            secondline = "/" + TownySettings.getAcceptCommand() + " " + invite.getSender().getName();
            thirdline = "/" + TownySettings.getDenyCommand() + " " + invite.getSender().getName();
            TownyMessaging.sendConfirmationMessage(player, firstline, secondline, thirdline, "");
        }
        if (invite.getSender() instanceof Nation) {
            if (invite.getReceiver() instanceof Town) {
                firstline = Translation.of("invitation_prefix") + Translation.of("your_town_has_been_invited_to_join_nation", invite.getSender().getName());
                secondline = "/t invite accept " + invite.getSender().getName();
                thirdline = "/t invite deny " + invite.getSender().getName();
                TownyMessaging.sendConfirmationMessage(player, firstline, secondline, thirdline, "");
            }
            if (invite.getReceiver() instanceof Nation) {
                firstline = Translation.of("invitation_prefix") + Translation.of("you_have_been_requested_to_ally2", invite.getSender().getName());
                secondline = "/n ally accept " + invite.getSender().getName();
                thirdline = "/n ally deny " + invite.getSender().getName();
                TownyMessaging.sendConfirmationMessage(player, firstline, secondline, thirdline, "");
            }
        }
    }

    public static void sendConfirmationMessage(CommandSender player, String firstline, String confirmline, String cancelline, String lastline) {
        if (firstline == null) {
            firstline = Translation.of("are_you_sure_you_want_to_continue");
        }
        if (confirmline == null) {
            confirmline = "/" + TownySettings.getConfirmCommand();
        }
        if (cancelline == null) {
            cancelline = "/" + TownySettings.getCancelCommand();
        }
        TextComponent lastLineComponent = lastline == null ? (TextComponent)Component.newline().append(Component.text(Translation.of("this_message_will_expire2"))) : (TextComponent)Component.newline().append(Component.text(lastline));
        TextComponent confirmComponent = (TextComponent)((TextComponent)((TextComponent)Component.text(confirmline.replace("/", "[/").concat("]")).color(NamedTextColor.GREEN)).hoverEvent(HoverEvent.showText(Component.text(Translation.of("msg_confirmation_spigot_click_accept", confirmline.replace("/", ""), confirmline))))).clickEvent(ClickEvent.runCommand("/towny:" + confirmline.replace("/", "")));
        TextComponent cancelComponent = (TextComponent)((TextComponent)((TextComponent)Component.text(cancelline.replace("/", "[/").concat("]")).color(NamedTextColor.RED)).hoverEvent(HoverEvent.showText(Component.text(Translation.of("msg_confirmation_spigot_click_cancel", cancelline.replace("/", ""), cancelline))))).clickEvent(ClickEvent.runCommand("/towny:" + cancelline.replace("/", "")));
        Towny.getAdventure().sender(player).sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text(Translation.of("confirmation_prefix") + firstline).append(Component.newline())).append(confirmComponent)).append(Component.text(" "))).append(cancelComponent)).append(lastLineComponent));
    }

    public static void sendTownList(CommandSender sender, List<TextComponent> towns, ComparatorType compType, int page, int total) {
        int iMax = Math.min(page * 10, towns.size());
        TextComponent[] townsformatted = page * 10 > towns.size() ? new TextComponent[towns.size() % 10] : new TextComponent[10];
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            townsformatted[i % 10] = towns.get(i);
        }
        Audience audience = Towny.getAdventure().sender(sender);
        sender.sendMessage(ChatTools.formatTitle(Translation.of("town_plu")));
        sender.sendMessage("\u00a73" + Translation.of("town_name") + (TownySettings.isTownListRandom() ? "" : "\u00a78 - \u00a7b" + Translation.of(compType.getName())));
        for (TextComponent textComponent : townsformatted) {
            audience.sendMessage(textComponent);
        }
        TextComponent pageFooter = TownyMessaging.getPageNavigationFooter("towny:town list", page, compType.getCommandString(), total);
        audience.sendMessage(pageFooter);
    }

    public static TextComponent getPageNavigationFooter(String prefix, int page, String arg, int total) {
        TextComponent backButton = (TextComponent)((TextComponent)((TextComponent)Component.text("<<<").color(NamedTextColor.GOLD)).clickEvent(ClickEvent.runCommand("/" + prefix + " " + (arg.isEmpty() ? "" : arg + " ") + (page - 1)))).hoverEvent(HoverEvent.showText(Component.text(Translation.of("msg_hover_previous_page"))));
        TextComponent forwardButton = (TextComponent)((TextComponent)((TextComponent)Component.text(">>>").color(NamedTextColor.GOLD)).clickEvent(ClickEvent.runCommand("/" + prefix + " " + (arg.isEmpty() ? "" : arg + " ") + (page + 1)))).hoverEvent(HoverEvent.showText(Component.text(Translation.of("msg_hover_next_page"))));
        TextComponent pageText = Component.text("   " + Translation.of("LIST_PAGE", page, total) + "   ");
        if (page == 1 && page == total) {
            backButton = (TextComponent)((TextComponent)((TextComponent)backButton.clickEvent(null)).hoverEvent(null)).color(NamedTextColor.DARK_GRAY);
            forwardButton = (TextComponent)((TextComponent)((TextComponent)forwardButton.clickEvent(null)).hoverEvent(null)).color(NamedTextColor.DARK_GRAY);
        } else if (page == 1) {
            backButton = (TextComponent)((TextComponent)((TextComponent)backButton.clickEvent(null)).hoverEvent(null)).color(NamedTextColor.DARK_GRAY);
        } else if (page == total) {
            forwardButton = (TextComponent)((TextComponent)((TextComponent)forwardButton.clickEvent(null)).hoverEvent(null)).color(NamedTextColor.DARK_GRAY);
        }
        return (TextComponent)((TextComponent)backButton.append(pageText)).append(forwardButton);
    }

    public static void sendNationList(CommandSender sender, List<TextComponent> nations, ComparatorType compType, int page, int total) {
        int iMax = Math.min(page * 10, nations.size());
        TextComponent[] nationsformatted = page * 10 > nations.size() ? new TextComponent[nations.size() % 10] : new TextComponent[10];
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            nationsformatted[i % 10] = nations.get(i);
        }
        sender.sendMessage(ChatTools.formatTitle(Translatable.of("nation_plu").forLocale(sender)));
        sender.sendMessage("\u00a73" + Translatable.of("nation_name").forLocale(sender) + "\u00a78" + " - " + "\u00a7b" + Translatable.of(compType.getName()).forLocale(sender));
        Audience audience = Towny.getAdventure().sender(sender);
        for (TextComponent textComponent : nationsformatted) {
            audience.sendMessage(textComponent);
        }
        TextComponent pageFooter = TownyMessaging.getPageNavigationFooter("towny:nation list", page, compType.getCommandString(), total);
        audience.sendMessage(pageFooter);
    }

    public static void sendOutpostList(Player player, Town town, int page, int total) {
        int outpostsCount = town.getAllOutpostSpawns().size();
        int iMax = Math.min(page * 10, outpostsCount);
        List<Location> outposts = town.getAllOutpostSpawns();
        TextComponent[] outpostsFormatted = page * 10 > outpostsCount ? new TextComponent[outpostsCount % 10] : new TextComponent[10];
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            TextComponent[] outpost = outposts.get(i);
            TownBlock tb = TownyAPI.getInstance().getTownBlock((Location)outpost);
            if (tb == null) continue;
            String name = !tb.hasPlotObjectGroup() ? tb.getName() : tb.getPlotObjectGroup().getName();
            TextComponent dash = (TextComponent)Component.text(" - ").color(NamedTextColor.DARK_GRAY);
            TextComponent line = (TextComponent)((TextComponent)((TextComponent)Component.text(Integer.toString(i + 1)).color(NamedTextColor.GOLD)).clickEvent(ClickEvent.runCommand("/towny:town outpost " + (i + 1)))).append(dash);
            TextComponent outpostName = (TextComponent)Component.text(name).color(NamedTextColor.GREEN);
            TextComponent worldName = (TextComponent)Component.text(outpost.getWorld().getName()).color(NamedTextColor.BLUE);
            TextComponent coords = (TextComponent)Component.text("(" + outpost.getBlockX() + "," + outpost.getBlockZ() + ")").color(NamedTextColor.BLUE);
            if (!name.equalsIgnoreCase("")) {
                line = (TextComponent)((TextComponent)line.append(outpostName)).append(dash);
            }
            line = (TextComponent)((TextComponent)((TextComponent)line.append(worldName)).append(dash)).append(coords);
            String spawnCost = "Free";
            if (TownyEconomyHandler.isActive()) {
                spawnCost = ChatColor.RESET + Translation.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(town.getSpawnCost()));
            }
            outpostsFormatted[i % 10] = line = (TextComponent)line.hoverEvent(HoverEvent.showText(Component.text(Translation.of("msg_click_spawn", name.equalsIgnoreCase("") ? "outpost" : name) + "\n" + spawnCost).color(NamedTextColor.GOLD)));
        }
        Audience audience = Towny.getAdventure().player(player);
        player.sendMessage(ChatTools.formatTitle(Translatable.of("outpost_plu").forLocale((CommandSender)player)));
        for (TextComponent textComponent : outpostsFormatted) {
            audience.sendMessage(textComponent);
        }
        TextComponent pageFooter = TownyMessaging.getPageNavigationFooter("towny:town outpost list", page, "", total);
        audience.sendMessage(pageFooter);
    }

    public static void sendJailList(Player player, Town town, int page, int total) {
        int jailCount = town.getJails().size();
        int iMax = Math.min(page * 10, jailCount);
        ArrayList<Jail> jails = new ArrayList<Jail>(town.getJails());
        TextComponent[] jailsFormatted = page * 10 > jailCount ? new TextComponent[jailCount % 10] : new TextComponent[10];
        String headerMsg = ChatColor.GOLD + "# " + ChatColor.DARK_GRAY + "- " + ChatColor.GREEN + "Jail Name " + ChatColor.DARK_GRAY + "- " + ChatColor.BLUE + "Coord " + ChatColor.DARK_GRAY + "- " + ChatColor.YELLOW + "Cell Count " + ChatColor.DARK_GRAY + "- " + ChatColor.RED + "Primary Jail";
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            TextComponent[] jail = (TextComponent[])jails.get(i);
            TextComponent name = (TextComponent)Component.text(jail.getName()).color(NamedTextColor.GREEN);
            TextComponent coord = (TextComponent)Component.text(jail.getTownBlock().getWorldCoord().toString()).color(NamedTextColor.BLUE);
            TextComponent cellCount = (TextComponent)Component.text(String.valueOf(jail.getJailCellLocations().size())).color(NamedTextColor.YELLOW);
            TextComponent dash = (TextComponent)Component.text(" - ").color(NamedTextColor.DARK_GRAY);
            TextComponent line = (TextComponent)Component.text(Integer.toString(i + 1)).color(NamedTextColor.GOLD);
            if (jail.hasName()) {
                line = (TextComponent)((TextComponent)line.append(dash)).append(name);
            }
            line = (TextComponent)((TextComponent)((TextComponent)((TextComponent)line.append(dash)).append(coord)).append(dash)).append(cellCount);
            if (town.getPrimaryJail().getUUID().equals(jail.getUUID())) {
                line = (TextComponent)((TextComponent)line.append(dash)).append(Component.text("(Primary Jail)").color(NamedTextColor.RED));
            }
            jailsFormatted[i % 10] = line;
        }
        Audience audience = Towny.getAdventure().player(player);
        player.sendMessage(ChatTools.formatTitle(Translatable.of("jail_plu").forLocale((CommandSender)player)));
        player.sendMessage(headerMsg);
        for (TextComponent textComponent : jailsFormatted) {
            audience.sendMessage(textComponent);
        }
        TextComponent pageFooter = TownyMessaging.getPageNavigationFooter("towny:town jail list", page, "", total);
        audience.sendMessage(pageFooter);
    }

    public static void sendPlotGroupList(CommandSender sender, Town town, int page, int total) {
        int groupCount = town.getPlotGroups().size();
        int iMax = Math.min(page * 10, groupCount);
        ArrayList<PlotGroup> groups = new ArrayList<PlotGroup>(town.getPlotGroups());
        TextComponent[] groupsFormatted = page * 10 > groupCount ? new TextComponent[groupCount % 10] : new TextComponent[10];
        String headerMsg = ChatColor.GOLD + "# " + ChatColor.DARK_GRAY + "- " + ChatColor.GREEN + "Group Name " + ChatColor.DARK_GRAY + "- " + ChatColor.YELLOW + "Plot Size " + ChatColor.DARK_GRAY + "- " + ChatColor.BLUE + "For Sale";
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            TextComponent[] group = (TextComponent[])groups.get(i);
            TextComponent name = (TextComponent)Component.text(group.getFormattedName()).color(NamedTextColor.GREEN);
            TextComponent size = (TextComponent)Component.text(String.valueOf(group.getTownBlocks().size())).color(NamedTextColor.YELLOW);
            TextComponent dash = (TextComponent)Component.text(" - ").color(NamedTextColor.DARK_GRAY);
            TextComponent line = (TextComponent)Component.text(Integer.toString(i + 1)).color(NamedTextColor.GOLD);
            line = (TextComponent)((TextComponent)((TextComponent)((TextComponent)line.append(dash)).append(name)).append(dash)).append(size);
            if (TownyEconomyHandler.isActive() && group.getPrice() != -1.0) {
                line = (TextComponent)((TextComponent)line.append(dash)).append(Component.text("(" + Translatable.of("towny_map_forsale").forLocale(sender) + ": " + TownyEconomyHandler.getFormattedBalance(group.getPrice()) + ")").color(NamedTextColor.BLUE));
            }
            groupsFormatted[i % 10] = line;
        }
        Audience audience = Towny.getAdventure().sender(sender);
        sender.sendMessage(ChatTools.formatTitle(town.getName() + " " + Translatable.of("plotgroup_plu").forLocale(sender)));
        sender.sendMessage(headerMsg);
        for (TextComponent textComponent : groupsFormatted) {
            audience.sendMessage(textComponent);
        }
        TextComponent pageFooter = TownyMessaging.getPageNavigationFooter("towny:town plotgrouplist" + town.getName(), page, "", total);
        audience.sendMessage(pageFooter);
    }

    public static void sendMsg(CommandSender sender, Translatable ... translatables) {
        TownyMessaging.sendMsg(sender, Translation.translateTranslatables(sender, translatables));
    }

    public static void sendErrorMsg(CommandSender sender, Translatable ... translatables) {
        TownyMessaging.sendErrorMsg((Object)sender, Translation.translateTranslatables(sender, translatables));
    }

    public static void sendGlobalMessage(Translatable translatable) {
        LOGGER.info("[Global Message] " + translatable.stripColors(true).translate());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == null || !TownyAPI.getInstance().isTownyWorld(player.getWorld())) continue;
            TownyMessaging.sendMsg((CommandSender)player, translatable);
        }
    }

    public static void sendMessage(Object sender, Translatable message) {
        Object object = sender;
        if (object instanceof Player) {
            Player player = (Player)object;
            TownyMessaging.sendTranslatedMessage((CommandSender)player, message.translate(Translation.getLocale((CommandSender)player)));
        } else {
            object = sender;
            if (object instanceof CommandSender) {
                CommandSender commandSender = (CommandSender)object;
                TownyMessaging.sendTranslatedMessage(commandSender, message.stripColors(true).translate(Translation.getLocale(commandSender)));
            } else {
                object = sender;
                if (object instanceof Resident) {
                    Resident resident = (Resident)object;
                    Player p = TownyAPI.getInstance().getPlayer(resident);
                    if (p != null) {
                        TownyMessaging.sendTranslatedMessage((CommandSender)p, message.stripColors(true).translate(Translation.getLocale((CommandSender)p)));
                    }
                }
            }
        }
    }

    private static void sendTranslatedMessage(CommandSender sender, String message) {
        if (!message.isEmpty()) {
            sender.sendMessage(message);
        }
    }

    public static void sendPrefixedNationMessage(Nation nation, Translatable message) {
        LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + message.translate()));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            TownyMessaging.sendMessage((Object)player, Translation.translateTranslatables((CommandSender)player, "", Translatable.of("default_nation_prefix", StringMgmt.remUnderscore(nation.getName())), message));
        }
    }

    public static void sendPrefixedTownMessage(Town town, Translatable message) {
        LOGGER.info(ChatTools.stripColour("[Town Msg] " + StringMgmt.remUnderscore(town.getName()) + ": " + message.translate()));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            TownyMessaging.sendMessage((Object)player, Translation.translateTranslatables((CommandSender)player, "", Translatable.of("default_town_prefix", StringMgmt.remUnderscore(town.getName())), message));
        }
    }

    public static void sendNationMessagePrefixed(Nation nation, Translatable message) {
        LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + message.translate()));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            TownyMessaging.sendMsg((CommandSender)player, message);
        }
    }

    public static void sendTownMessagePrefixed(Town town, Translatable message) {
        LOGGER.info(ChatTools.stripColour("[Town Msg] " + StringMgmt.remUnderscore(town.getName())) + ": " + message.translate());
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            TownyMessaging.sendMsg((CommandSender)player, message);
        }
    }

    public static void sendResidentMessage(Resident resident, Translatable message) throws TownyException {
        LOGGER.info(ChatTools.stripColour("[Resident Msg] " + resident.getName() + ": " + message.translate()));
        Player player = TownyAPI.getInstance().getPlayer(resident);
        if (player == null) {
            throw new TownyException("Player could not be found!");
        }
        TownyMessaging.sendMsg((CommandSender)player, message);
    }

    public static void sendMsg(Resident resident, Translatable message) {
        if (BukkitTools.isOnline(resident.getName())) {
            TownyMessaging.sendMsg((CommandSender)resident.getPlayer(), message);
        }
    }

    public static void sendMsg(Translatable message) {
        LOGGER.info("[Towny] " + message.stripColors(true).translate());
    }

    public static void sendErrorMsg(Translatable message) {
        LOGGER.warn("[Towny] Error: " + message.stripColors(true).translate());
    }

    @Deprecated
    public static void sendMsg(Object object, String message) {
        TownyMessaging.sendMsg((CommandSender)object, message);
    }

    public static void sendStatusScreen(CommandSender sender, StatusScreen screen) {
        Audience audience = Towny.getAdventure().sender(sender);
        for (TextComponent string : screen.getFormattedStatusScreen()) {
            audience.sendMessage(string);
        }
    }
}

