/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.statusscreen.NationStatusScreenEvent;
import com.palmergames.bukkit.towny.event.statusscreen.ResidentStatusScreenEvent;
import com.palmergames.bukkit.towny.event.statusscreen.TownBlockStatusScreenEvent;
import com.palmergames.bukkit.towny.event.statusscreen.TownStatusScreenEvent;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.object.statusscreens.StatusScreen;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TownyFormatter {
    public static final SimpleDateFormat lastOnlineFormat = new SimpleDateFormat("MMMMM dd '@' HH:mm");
    public static final SimpleDateFormat lastOnlineFormatIncludeYear = new SimpleDateFormat("MMMMM dd yyyy");
    public static final SimpleDateFormat registeredFormat = new SimpleDateFormat("MMM d yyyy");
    public static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("MMMMM dd yyyy '@' HH:mm");
    public static final String listPrefixFormat = "%3$s%1$s %4$s[%2$d]%3$s:%5$s ";
    public static final String keyValueFormat = "%s%s %s%s";
    public static final String keyFormat = "%s%s";
    public static final String hoverFormat = "%s[%s%s%s]";
    public static final String bracketFormat = " %1$s[%2$s %3$s%1$s]";

    public static void initialize() {
    }

    public static StatusScreen getStatus(TownBlock townBlock, Player player, Locale locale) {
        List<String> fields;
        StatusScreen screen = new StatusScreen();
        Translator translator = Translator.locale(locale);
        Town town = townBlock.getTownOrNull();
        TownyWorld world = townBlock.getWorld();
        boolean preventPVP = CombatUtil.preventPvP(world, townBlock);
        TownyObject owner = townBlock.hasResident() ? townBlock.getResidentOrNull() : town;
        screen.addComponentOf("townblock_title", ChatTools.formatTitle("(" + townBlock.getCoord().toString() + ") " + owner.getFormattedName() + (TownyFormatter.playerIsOnlineAndVisible(owner.getName(), player) ? translator.of("online") : "")));
        if (townBlock.getClaimedAt() > 0L) {
            screen.addComponentOf("claimedat", TownyFormatter.colourKeyValue(translator.of("msg_plot_perm_claimed_at"), registeredFormat.format(townBlock.getClaimedAt())));
        }
        if (!townBlock.getType().equals((Object)TownBlockType.RESIDENTIAL)) {
            screen.addComponentOf("townblock_plotType", TownyFormatter.colourKeyValue(translator.of("status_plot_type"), townBlock.getType().toString()));
        }
        screen.addComponentOf("perm", TownyFormatter.colourKeyValue(translator.of("status_perm"), owner instanceof Resident ? townBlock.getPermissions().getColourString().replace("n", "t") : townBlock.getPermissions().getColourString().replace("f", "r")));
        screen.addComponentOf("pvp", TownyFormatter.colourKeyValue(translator.of("status_pvp"), !preventPVP ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("explosion", TownyFormatter.colourKeyValue(translator.of("explosions"), world.isForceExpl() || townBlock.getPermissions().explosion ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("firespread", TownyFormatter.colourKeyValue(translator.of("firespread"), town.isFire() || world.isForceFire() || townBlock.getPermissions().fire ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("mobspawns", TownyFormatter.colourKeyValue(translator.of("mobspawns"), world.isForceTownMobs() || townBlock.getPermissions().mobs ? translator.of("status_on") : translator.of("status_off")));
        if (townBlock.hasPlotObjectGroup()) {
            screen.addComponentOf("plotgroup", TownyFormatter.colourKey(translator.of("status_plot_group_name_and_size", townBlock.getPlotObjectGroup().getName(), townBlock.getPlotObjectGroup().getTownBlocks().size())));
        }
        if (townBlock.getTrustedResidents().size() > 0) {
            screen.addComponentOf("trusted", TownyFormatter.getFormattedTownyObjects(translator.of("status_trustedlist"), new ArrayList<TownyObject>(townBlock.getTrustedResidents())));
        }
        if (!(fields = TownyFormatter.getExtraFields(townBlock)).isEmpty()) {
            TextComponent comp = Component.empty();
            for (int i = 0; i < fields.size(); ++i) {
                comp = (TextComponent)comp.append(Component.text(fields.get(i)));
            }
            screen.addComponentOf("extraFields", comp);
        }
        TownBlockStatusScreenEvent event = new TownBlockStatusScreenEvent(screen, townBlock);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.hasAdditionalLines()) {
            TextComponent comp = Component.empty();
            for (int i = 0; i < event.getAdditionalLines().size(); ++i) {
                comp = (TextComponent)((TextComponent)comp.append(Component.newline())).append(Component.text(event.getAdditionalLines().get(i)));
            }
            screen.addComponentOf("eventAddedLines", comp);
        }
        return screen;
    }

    public static StatusScreen getStatus(Resident resident, Player player, Locale locale) {
        List<String> fields;
        StatusScreen screen = new StatusScreen();
        Translator translator = Translator.locale(locale);
        screen.addComponentOf("title", ChatTools.formatTitle(resident.getFormattedName() + (TownyFormatter.playerIsOnlineAndVisible(resident.getName(), player) ? translator.of("online2") : "")));
        screen.addComponentOf("registered", TownyFormatter.getResidentRegisteredLine(resident, translator));
        if (!resident.isNPC()) {
            screen.addComponentOf("lastonline", TownyFormatter.getResidentLastOnline(resident, translator));
        }
        String townLine = TownyFormatter.colourKeyValue(translator.of("status_town"), !resident.hasTown() ? translator.of("status_no_town") : resident.getTownOrNull().getFormattedName());
        if (!resident.hasTown()) {
            screen.addComponentOf("town", townLine);
        } else {
            Town town = resident.getTownOrNull();
            Object[] residents = TownyFormatter.getFormattedNames(town.getResidents().toArray(new Resident[0]));
            if (residents.length > 34) {
                residents = TownyFormatter.shortenOverlengthArray((String[])residents, 35, translator);
            }
            screen.addComponentOf("town", townLine, HoverEvent.showText(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text(Colors.translateColorCodes(String.format(TownySettings.getPAPIFormattingTown(), town.getFormattedName()))).append(Component.newline())).append(Component.text(TownyFormatter.colourKeyValue(translator.of("rank_list_mayor"), town.getMayor().getFormattedName())))).append(Component.newline())).append(Component.text(TownyFormatter.colourKeyValue(translator.of("res_list"), StringMgmt.join(residents, ", "))))).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:town " + town.getName()));
        }
        if (resident.hasNation()) {
            Nation nation = resident.getNationOrNull();
            Object[] towns = TownyFormatter.getFormattedNames(nation.getTowns().toArray(new Town[0]));
            if (towns.length > 10) {
                towns = TownyFormatter.shortenOverlengthArray((String[])towns, 11, translator);
            }
            screen.addComponentOf("nation", TownyFormatter.colourKeyValue(translator.of("status_town_nation"), nation.getName()), HoverEvent.showText(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text(Colors.translateColorCodes(String.format(TownySettings.getPAPIFormattingNation(), nation.getFormattedName()))).append(Component.newline())).append(Component.text(TownyFormatter.colourKeyValue(translator.of("status_nation_king"), nation.getCapital().getMayor().getFormattedName())))).append(Component.newline())).append(Component.text(TownyFormatter.colourKeyValue(translator.of("town_plu"), StringMgmt.join(towns, ", "))))).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:nation " + nation.getName()));
        }
        if (TownyEconomyHandler.isActive()) {
            screen.addComponentOf("bank", TownyFormatter.colourKeyValue(translator.of("status_bank"), resident.getAccount().getHoldingFormattedBalance()), HoverEvent.showText(Component.text(translator.of("status_hover_click_for_more"))), ClickEvent.runCommand("/towny:resident tax " + resident.getName()));
        }
        screen.addComponentOf("ownsXPlots", TownyFormatter.colourKey(translator.of("owner_of_x_plots", resident.getTownBlocks().size())));
        screen.addComponentOf("perm", TownyFormatter.colourKeyValue(translator.of("status_perm"), resident.getPermissions().getColourString().replace("n", "t")));
        screen.addComponentOf("pvp", TownyFormatter.colourKeyValue(translator.of("status_pvp"), resident.getPermissions().pvp ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("explosions", TownyFormatter.colourKeyValue(translator.of("explosions"), resident.getPermissions().explosion ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("firespread", TownyFormatter.colourKeyValue(translator.of("firespread"), resident.getPermissions().fire ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("mobspawns", TownyFormatter.colourKeyValue(translator.of("mobspawns"), resident.getPermissions().mobs ? translator.of("status_on") : translator.of("status_off")));
        if (resident.isNPC()) {
            screen.addComponentOf("npcstatus", translator.of("msg_status_npc", resident.getName()));
            List<String> fields2 = TownyFormatter.getExtraFields(resident);
            if (!fields2.isEmpty()) {
                TextComponent comp = Component.empty();
                for (int i = 0; i < fields2.size(); ++i) {
                    comp.append(Component.text(fields2.get(i)));
                }
                screen.addComponentOf("extraFields", comp);
            }
            return screen;
        }
        List<Town> townEmbassies = TownyFormatter.getResidentsEmbassyTowns(resident);
        if (townEmbassies.size() > 0) {
            screen.addComponentOf("embassiesInTowns", TownyFormatter.getFormattedTownyObjects(translator.of("status_embassy_town"), new ArrayList<TownyObject>(townEmbassies)));
        }
        if (resident.hasTown() && !resident.getTownRanks().isEmpty()) {
            screen.addComponentOf("townRanks", TownyFormatter.colourKeyValue(translator.of("status_town_ranks"), StringMgmt.capitalize(StringMgmt.join(resident.getTownRanks(), ", "))));
        }
        if (resident.hasNation() && !resident.getNationRanks().isEmpty()) {
            screen.addComponentOf("nationRanks", TownyFormatter.colourKeyValue(translator.of("status_nation_ranks"), StringMgmt.capitalize(StringMgmt.join(resident.getNationRanks(), ", "))));
        }
        if (resident.isJailed()) {
            screen.addComponentOf("jailLine", TownyFormatter.getResidentJailedLine(resident, translator));
        }
        if (resident.getFriends() != null && !resident.getFriends().isEmpty()) {
            screen.addComponentOf("friendsLine", TownyFormatter.getFormattedTownyObjects(translator.of("status_friends"), new ArrayList<TownyObject>(resident.getFriends())));
        }
        if (!(fields = TownyFormatter.getExtraFields(resident)).isEmpty()) {
            TextComponent comp = Component.empty();
            for (int i = 0; i < fields.size(); ++i) {
                comp = (TextComponent)((TextComponent)comp.append(Component.newline())).append(Component.text(fields.get(i)));
            }
            screen.addComponentOf("extraFields", comp);
        }
        ResidentStatusScreenEvent event = new ResidentStatusScreenEvent(screen, resident);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.hasAdditionalLines()) {
            TextComponent comp = Component.empty();
            for (int i = 0; i < event.getAdditionalLines().size(); ++i) {
                comp = (TextComponent)((TextComponent)comp.append(Component.newline())).append(Component.text(event.getAdditionalLines().get(i)));
            }
            screen.addComponentOf("eventAddedLines", comp);
        }
        return screen;
    }

    public static StatusScreen getStatus(Town town, Locale locale) {
        List<String> fields;
        String string;
        Translator translator = Translator.locale(locale);
        StatusScreen screen = new StatusScreen();
        TownyWorld world = town.getHomeblockWorld();
        screen.addComponentOf("title", ChatTools.formatTitle(town));
        List<String> sub = TownyFormatter.getTownSubtitle(town, world, translator);
        if (!sub.isEmpty()) {
            screen.addComponentOf("subtitle", ChatTools.formatSubTitle(StringMgmt.join(sub, " ")));
        }
        if (town.getBoard() != null && !town.getBoard().isEmpty()) {
            screen.addComponentOf("board", TownyFormatter.colourKeyValue(translator.of("status_town_board"), town.getBoard()));
        }
        if (town.getRegistered() != 0L) {
            screen.addComponentOf("registered", TownyFormatter.colourKeyValue(translator.of("status_founded"), registeredFormat.format(town.getRegistered())));
        }
        StringBuilder stringBuilder = new StringBuilder().append(TownyFormatter.colourKeyValue(translator.of("status_town_size"), translator.of("status_fractions", town.getTownBlocks().size(), TownySettings.getMaxTownBlocks(town)))).append(TownySettings.isSellingBonusBlocks(town) ? TownyFormatter.colourBracketElement(translator.of("status_town_size_bought"), translator.of("status_fractions", town.getPurchasedBlocks(), TownySettings.getMaxPurchasedBlocks(town))) : "").append(town.getBonusBlocks() > 0 ? TownyFormatter.colourBracketElement(translator.of("status_town_size_bonus"), String.valueOf(town.getBonusBlocks())) : "").append(TownySettings.getNationBonusBlocks(town) > 0 ? TownyFormatter.colourBracketElement(translator.of("status_town_size_nationbonus"), String.valueOf(TownySettings.getNationBonusBlocks(town))) : "");
        if (!town.isPublic()) {
            string = "";
        } else {
            Object[] objectArray = new Object[1];
            objectArray[0] = TownySettings.getTownDisplaysXYZ() ? (town.hasSpawn() ? BukkitTools.convertCoordtoXYZ(town.getSpawnOrNull()) : translator.of("status_no_town")) : (town.hasHomeBlock() ? town.getHomeBlockOrNull().getCoord().toString() : translator.of("status_no_town"));
            string = translator.of("status_home_element", objectArray);
        }
        screen.addComponentOf("townblocks", stringBuilder.append(string).toString());
        if (TownySettings.isAllowingOutposts()) {
            String outpostLine = "";
            if (TownySettings.isOutpostsLimitedByLevels()) {
                int nationBonus;
                outpostLine = TownyFormatter.colourKeyValue(translator.of("status_town_outposts"), translator.of("status_fractions", town.getMaxOutpostSpawn(), town.getOutpostLimit()));
                if (town.hasNation() && (nationBonus = ((Integer)TownySettings.getNationLevel(town.getNationOrNull()).get((Object)TownySettings.NationLevel.NATION_BONUS_OUTPOST_LIMIT)).intValue()) > 0) {
                    outpostLine = outpostLine + TownyFormatter.colourBracketElement(translator.of("status_town_size_nationbonus"), String.valueOf(nationBonus));
                }
            } else if (town.hasOutpostSpawn()) {
                outpostLine = TownyFormatter.colourKeyValue(translator.of("status_town_outposts"), String.valueOf(town.getMaxOutpostSpawn()));
            }
            screen.addComponentOf("outposts", outpostLine, HoverEvent.showText(Component.text(translator.of("status_hover_click_for_more"))), ClickEvent.runCommand("/towny:town outpost list"));
        }
        screen.addComponentOf("perm", TownyFormatter.colourKeyValue(translator.of("status_perm"), town.getPermissions().getColourString().replace("f", "r")));
        screen.addComponentOf("explosion", TownyFormatter.colourKeyValue(translator.of("explosions"), town.isBANG() || world.isForceExpl() ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("firespread", TownyFormatter.colourKeyValue(translator.of("firespread"), town.isFire() || world.isForceFire() ? translator.of("status_on") : translator.of("status_off")));
        screen.addComponentOf("mobspawns", TownyFormatter.colourKeyValue(translator.of("mobspawns"), town.hasMobs() || world.isForceTownMobs() ? translator.of("status_on") : translator.of("status_off")));
        if (town.isRuined()) {
            screen.addComponentOf("ruinedTime", TownyFormatter.colourKey(translator.of("msg_time_remaining_before_full_removal", TownySettings.getTownRuinsMaxDurationHours() - TownRuinUtil.getTimeSinceRuining(town))));
            if (TownySettings.getTownRuinsReclaimEnabled()) {
                if (TownRuinUtil.getTimeSinceRuining(town) < TownySettings.getTownRuinsMinDurationHours()) {
                    screen.addComponentOf("reclaim", TownyFormatter.colourKeyImportant(translator.of("msg_time_until_reclaim_available", TownySettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town))));
                } else {
                    screen.addComponentOf("reclaim", TownyFormatter.colourKeyImportant(translator.of("msg_reclaim_available")));
                }
            }
        } else {
            String[] residents;
            if (TownyEconomyHandler.isActive()) {
                screen.addComponentOf("bankstring", TownyFormatter.getTownBankString(town, translator));
            }
            screen.addComponentOf("mayor", TownyFormatter.colourKeyValue(translator.of("rank_list_mayor"), town.getMayor().getFormattedName()), HoverEvent.showText(((TextComponent)Component.text(translator.of("registered_last_online", registeredFormat.format(town.getMayor().getRegistered()), lastOnlineFormatIncludeYear.format(town.getMayor().getLastOnline()))).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:resident " + town.getMayor().getName()));
            if (town.hasNation()) {
                Object[] towns = TownyFormatter.getFormattedNames(town.getNationOrNull().getTowns().toArray(new Town[0]));
                if (towns.length > 10) {
                    towns = TownyFormatter.shortenOverlengthArray((String[])towns, 11, translator);
                }
                screen.addComponentOf("nation", TownyFormatter.colourKeyValue(translator.of("status_town_nation"), town.getNationOrNull().getName()), HoverEvent.showText(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text(Colors.translateColorCodes(String.format(TownySettings.getPAPIFormattingNation(), town.getNationOrNull().getFormattedName()))).append(Component.newline())).append(Component.text(TownyFormatter.colourKeyValue(translator.of("status_nation_king"), town.getNationOrNull().getCapital().getMayor().getFormattedName())))).append(Component.newline())).append(Component.text(TownyFormatter.colourKeyValue(translator.of("town_plu"), StringMgmt.join(towns, ", "))))).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:nation " + town.getNationOrNull().getName()));
            }
            screen.addComponentOf("newline", Component.newline());
            List<String> ranklist = TownyFormatter.getRanks(town, locale);
            if (ranklist.size() > 0) {
                screen.addComponentOf("townranks", TownyFormatter.colourHoverKey(translator.of("status_rank_list")), HoverEvent.showText(((TextComponent)Component.text(String.join((CharSequence)"\n", ranklist)).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:town ranklist " + town.getName()));
            }
            if ((residents = TownyFormatter.getFormattedNames(town.getResidents().toArray(new Resident[0]))).length > 34) {
                residents = TownyFormatter.shortenOverlengthArray(residents, 35, translator);
            }
            screen.addComponentOf("residents", TownyFormatter.colourHoverKey(translator.of("res_list")), HoverEvent.showText(((TextComponent)Component.text(TownyFormatter.getFormattedStrings(translator.of("res_list"), Arrays.stream(residents).collect(Collectors.toList()))).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:town reslist " + town.getName()));
        }
        if (!(fields = TownyFormatter.getExtraFields(town)).isEmpty()) {
            TextComponent comp = Component.empty();
            for (int i = 0; i < fields.size(); ++i) {
                comp = (TextComponent)comp.append(Component.text(fields.get(i)));
            }
            screen.addComponentOf("extraFields", comp);
        }
        TownStatusScreenEvent event = new TownStatusScreenEvent(screen, town);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.hasAdditionalLines()) {
            TextComponent comp = Component.empty();
            for (int i = 0; i < event.getAdditionalLines().size(); ++i) {
                comp = (TextComponent)comp.append(Component.text(event.getAdditionalLines().get(i)));
            }
            screen.addComponentOf("eventAddedLines", comp);
        }
        return screen;
    }

    public static StatusScreen getStatus(Nation nation, Locale locale) {
        List<String> fields;
        String[] enemies;
        String[] towns;
        long registered;
        StatusScreen screen = new StatusScreen();
        Translator translator = Translator.locale(locale);
        screen.addComponentOf("nation_title", ChatTools.formatTitle(nation));
        List<String> sub = TownyFormatter.getNationSubtitle(nation, translator);
        if (!sub.isEmpty()) {
            screen.addComponentOf("subtitle", ChatTools.formatSubTitle(StringMgmt.join(sub, " ")));
        }
        if (nation.getBoard() != null && !nation.getBoard().isEmpty()) {
            screen.addComponentOf("board", TownyFormatter.colourKeyValue(translator.of("status_town_board"), nation.getBoard()));
        }
        if ((registered = nation.getRegistered()) != 0L) {
            screen.addComponentOf("registered", TownyFormatter.colourKeyValue(translator.of("status_founded"), registeredFormat.format(nation.getRegistered())));
        }
        if (TownyEconomyHandler.isActive()) {
            String bankline = TownyFormatter.colourKeyValue(translator.of("status_bank"), nation.getAccount().getHoldingFormattedBalance());
            if (TownySettings.getNationUpkeepCost(nation) > 0.0) {
                bankline = bankline + TownyFormatter.colourKey(translator.of("status_bank_town2") + " " + TownyFormatter.colourKeyImportant(TownyFormatter.formatMoney(TownySettings.getNationUpkeepCost(nation))));
            }
            bankline = bankline + translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_nation_tax")) + " " + TownyFormatter.colourKeyImportant(TownyFormatter.formatMoney(nation.getTaxes()));
            screen.addComponentOf("bankLine", bankline);
        }
        if (nation.isPublic()) {
            screen.addComponentOf("home", translator.of("status_home_element", nation.hasSpawn() ? Coord.parseCoord(nation.getSpawnOrNull()).toString() : translator.of("status_no_town")));
        }
        if (nation.getNumTowns() > 0 && nation.hasCapital() && nation.getCapital().hasMayor()) {
            Resident king = nation.getCapital().getMayor();
            screen.addComponentOf("king", TownyFormatter.colourKeyValue(translator.of("status_nation_king"), king.getFormattedName()), HoverEvent.showText(((TextComponent)Component.text(translator.of("registered_last_online", registeredFormat.format(king.getRegistered()), lastOnlineFormatIncludeYear.format(king.getLastOnline()))).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:resident " + king.getName()));
        }
        screen.addComponentOf("newline", Component.newline());
        List<String> ranklist = TownyFormatter.getRanks(nation, locale);
        if (ranklist.size() > 0) {
            screen.addComponentOf("nationranks", TownyFormatter.colourHoverKey(translator.of("status_rank_list")), HoverEvent.showText(((TextComponent)Component.text(String.join((CharSequence)"\n", ranklist)).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:nation ranklist " + nation.getName()));
        }
        if ((towns = TownyFormatter.getFormattedNames(nation.getTowns().toArray(new Town[0]))).length > 10) {
            towns = TownyFormatter.shortenOverlengthArray(towns, 11, translator);
        }
        screen.addComponentOf("towns", TownyFormatter.colourHoverKey(translator.of("status_nation_towns")), HoverEvent.showText(((TextComponent)Component.text(TownyFormatter.getFormattedStrings(translator.of("status_nation_towns"), Arrays.stream(towns).collect(Collectors.toList()))).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:nation townlist " + nation.getName()));
        String[] allies = TownyFormatter.getFormattedNames(nation.getAllies().toArray(new Nation[0]));
        if (allies.length > 10) {
            allies = TownyFormatter.shortenOverlengthArray(allies, 11, translator);
        }
        if (allies.length > 0) {
            screen.addComponentOf("allies", TownyFormatter.colourHoverKey(translator.of("status_nation_allies")), HoverEvent.showText(((TextComponent)Component.text(TownyFormatter.getFormattedStrings(translator.of("status_nation_allies"), Arrays.stream(allies).collect(Collectors.toList()))).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:nation allylist " + nation.getName()));
        }
        if ((enemies = TownyFormatter.getFormattedNames(nation.getEnemies().toArray(new Nation[0]))).length > 10) {
            enemies = TownyFormatter.shortenOverlengthArray(enemies, 11, translator);
        }
        if (enemies.length > 0) {
            screen.addComponentOf("enemies", TownyFormatter.colourHoverKey(translator.of("status_nation_enemies")), HoverEvent.showText(((TextComponent)Component.text(TownyFormatter.getFormattedStrings(translator.of("status_nation_enemies"), Arrays.stream(enemies).collect(Collectors.toList()))).append(Component.newline())).append(Component.text(translator.of("status_hover_click_for_more")))), ClickEvent.runCommand("/towny:nation enemylist " + nation.getName()));
        }
        if (!(fields = TownyFormatter.getExtraFields(nation)).isEmpty()) {
            TextComponent comp = Component.empty();
            for (int i = 0; i < fields.size(); ++i) {
                comp = (TextComponent)comp.append(Component.text(fields.get(i)));
            }
            screen.addComponentOf("extraFields", comp);
        }
        NationStatusScreenEvent event = new NationStatusScreenEvent(screen, nation);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.hasAdditionalLines()) {
            TextComponent comp = Component.empty();
            for (int i = 0; i < event.getAdditionalLines().size(); ++i) {
                comp = (TextComponent)comp.append(Component.text(event.getAdditionalLines().get(i)));
            }
            screen.addComponentOf("eventAddedLines", comp);
        }
        return screen;
    }

    public static StatusScreen getStatus(TownyWorld world, Locale locale) {
        StatusScreen screen = new StatusScreen();
        Translator translator = Translator.locale(locale);
        screen.addComponentOf("townyworld_title", ChatTools.formatTitle(world.getFormattedName()));
        screen.addComponentOf("subtitle", ChatTools.formatSubTitle(StringMgmt.join(TownyFormatter.getWorldSubtitle(world, translator), " ")));
        if (!world.isUsingTowny()) {
            screen.addComponentOf("not_using_towny", translator.of("msg_set_use_towny_off"));
        } else {
            screen.addComponentOf("war_allowed", TownyFormatter.colourKey(world.isWarAllowed() ? translator.of("msg_set_war_allowed_on") : translator.of("msg_set_war_allowed_off")));
            screen.addComponentOf("pvp", TownyFormatter.colourKeyValue(translator.of("status_world_forcepvp"), world.isForcePVP() ? translator.of("status_on") : translator.of("status_off")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_friendlyfire"), world.isFriendlyFireEnabled() ? translator.of("status_on") : translator.of("status_off")));
            screen.addComponentOf("fire", TownyFormatter.colourKeyValue(translator.of("status_world_fire"), world.isFire() ? translator.of("status_on") : translator.of("status_off")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_forcefire"), world.isForceFire() ? translator.of("status_forced") : translator.of("status_adjustable")));
            screen.addComponentOf("explosions", TownyFormatter.colourKeyValue(translator.of("explosions"), world.isExpl() ? translator.of("status_on") : translator.of("status_off")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_forceexplosion"), world.isForceExpl() ? translator.of("status_forced") : translator.of("status_adjustable")));
            screen.addComponentOf("mobs", TownyFormatter.colourKeyValue(translator.of("status_world_worldmobs"), world.hasWorldMobs() ? translator.of("status_on") : translator.of("status_off")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_wildernessmobs"), world.hasWildernessMobs() ? translator.of("status_on") : translator.of("status_off")));
            screen.addComponentOf("townmobs", TownyFormatter.colourKeyValue(translator.of("status_world_forcetownmobs"), world.isForceTownMobs() ? translator.of("status_forced") : translator.of("status_adjustable")));
            screen.addComponentOf("unclaim_revert", TownyFormatter.colourKeyValue("\n" + translator.of("status_world_unclaimrevert"), world.isUsingPlotManagementRevert() ? translator.of("status_on_good") : translator.of("status_off_bad")));
            screen.addComponentOf("explosion_reverts", TownyFormatter.colourKeyValue(translator.of("status_world_explrevert_entity"), world.isUsingPlotManagementWildEntityRevert() ? translator.of("status_on_good") : translator.of("status_off_bad")) + translator.of("status_splitter") + TownyFormatter.colourKeyValue(translator.of("status_world_explrevert_block"), world.isUsingPlotManagementWildBlockRevert() ? translator.of("status_on_good") : translator.of("status_off_bad")));
            screen.addComponentOf("plot_clear", TownyFormatter.colourKeyValue(translator.of("status_plot_clear_deletion"), world.isUsingPlotManagementMayorDelete() ? translator.of("status_on") + "\u00a7a" + " (see /towny plotclearblocks)" : translator.of("status_off")));
            screen.addComponentOf("wilderness", TownyFormatter.colourKey(world.getUnclaimedZoneName() + ": \n"));
            screen.addComponentOf("perms1", "    " + (world.getUnclaimedZoneBuild() != false ? "\u00a7a" : "\u00a7c") + translator.of("build") + "\u00a78" + ", " + (world.getUnclaimedZoneDestroy() != false ? "\u00a7a" : "\u00a7c") + translator.of("destroy") + "\u00a78" + ", " + (world.getUnclaimedZoneSwitch() != false ? "\u00a7a" : "\u00a7c") + translator.of("switch") + "\u00a78" + ", " + (world.getUnclaimedZoneItemUse() != false ? "\u00a7a" : "\u00a7c") + translator.of("item_use"));
            screen.addComponentOf("perms2", "    " + TownyFormatter.colourKey(translator.of("status_world_ignoredblocks") + "\u00a7a" + " see /towny wildsblocks"));
            List<String> fields = TownyFormatter.getExtraFields(world);
            if (!fields.isEmpty()) {
                TextComponent comp = Component.empty();
                for (int i = 0; i < fields.size(); ++i) {
                    comp = (TextComponent)comp.append(Component.text(fields.get(i)));
                }
                screen.addComponentOf("extraFields", comp);
            }
        }
        return screen;
    }

    private static String colourKeyValue(String key, String value) {
        return String.format(keyValueFormat, Translation.of("status_format_key_value_key"), key, Translation.of("status_format_key_value_value"), value);
    }

    private static String colourKey(String key) {
        return String.format(keyFormat, Translation.of("status_format_key_value_key"), key);
    }

    private static String colourKeyImportant(String key) {
        return String.format(keyFormat, Translation.of("status_format_key_important"), key);
    }

    private static String colourBracketElement(String key, String value) {
        return String.format(bracketFormat, Translation.of("status_format_bracket_element"), key, value);
    }

    private static String colourHoverKey(String key) {
        return String.format(hoverFormat, Translation.of("status_format_hover_bracket_colour"), Translation.of("status_format_hover_key"), key, Translation.of("status_format_hover_bracket_colour"));
    }

    private static String getResidentRegisteredLine(Resident resident, Translator translator) {
        return !resident.isNPC() ? TownyFormatter.colourKeyValue(translator.of("status_registered"), registeredFormat.format(resident.getRegistered())) : TownyFormatter.colourKeyValue(translator.of("npc_created"), registeredFormat.format(resident.getRegistered()));
    }

    private static String getResidentLastOnline(Resident resident, Translator translator) {
        return TownyFormatter.sameYear(resident) ? TownyFormatter.colourKeyValue(translator.of("status_lastonline"), lastOnlineFormat.format(resident.getLastOnline())) : TownyFormatter.colourKeyValue(translator.of("status_lastonline"), lastOnlineFormatIncludeYear.format(resident.getLastOnline()));
    }

    private static boolean sameYear(Resident resident) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(resident.getLastOnline());
        int currentYear = cal.get(1);
        cal.setTimeInMillis(System.currentTimeMillis());
        int lastOnlineYear = cal.get(1);
        return currentYear == lastOnlineYear;
    }

    private static String getResidentJailedLine(Resident resident, Translator translator) {
        String jailLine = TownyFormatter.colourKeyValue(translator.of("status_jailed"), resident.isJailed() ? translator.of("status_bad_yes") : translator.of("status_good_no"));
        if (resident.isJailed()) {
            jailLine = jailLine + TownyFormatter.colourKey(translator.of("jailed_in_town", resident.getJailTown().getName()));
        }
        if (resident.isJailed() && resident.hasJailTime()) {
            jailLine = jailLine + TownyFormatter.colourKey(translator.of("msg_jailed_for_x_hours", resident.getJailHours()));
        }
        return jailLine;
    }

    private static List<Town> getResidentsEmbassyTowns(Resident resident) {
        ArrayList<Town> townEmbassies = new ArrayList<Town>();
        String actualTown = resident.hasTown() ? TownyAPI.getInstance().getResidentTownOrNull(resident).getName() : "";
        for (TownBlock tB : resident.getTownBlocks()) {
            Town town = tB.getTownOrNull();
            if (town == null || actualTown.equals(town.getName()) || townEmbassies.contains(town)) continue;
            townEmbassies.add(town);
        }
        return townEmbassies;
    }

    private static List<String> getRanks(Government gov, Locale locale) {
        ArrayList<String> ranklist = new ArrayList<String>();
        ArrayList<Resident> residents = new ArrayList<Resident>(gov.getResidents());
        List<String> ranks = gov instanceof Nation ? TownyPerms.getNationRanks() : TownyPerms.getTownRanks();
        ArrayList<Resident> residentWithRank = new ArrayList<Resident>();
        for (String rank : ranks) {
            for (Resident r : residents) {
                if (gov instanceof Nation && r.getNationRanks() != null && r.getNationRanks().contains(rank)) {
                    residentWithRank.add(r);
                }
                if (!(gov instanceof Town) || r.getTownRanks() == null || !r.getTownRanks().contains(rank)) continue;
                residentWithRank.add(r);
            }
            if (!residentWithRank.isEmpty()) {
                ranklist.add(TownyFormatter.getFormattedTownyObjects(StringMgmt.capitalize(rank), new ArrayList<TownyObject>(residentWithRank)));
            }
            residentWithRank.clear();
        }
        if (gov instanceof Town && ((Town)gov).getTrustedResidents().size() > 0) {
            ranklist.add(TownyFormatter.getFormattedTownyObjects(Translation.of("status_trustedlist", locale), new ArrayList<TownyObject>(((Town)gov).getTrustedResidents())));
        }
        return ranklist;
    }

    private static String[] shortenOverlengthArray(String[] array, int i, Translator translator) {
        String[] entire = array;
        array = new String[i + 1];
        System.arraycopy(entire, 0, array, 0, i);
        array[i] = translator.of("status_town_reslist_overlength");
        return array;
    }

    private static String getTownBankString(Town town, Translator translator) {
        String bankString = TownyFormatter.colourKeyValue(translator.of("status_bank"), town.getAccount().getHoldingFormattedBalance());
        if (town.isBankrupt()) {
            bankString = bankString + " " + TownyFormatter.colourKeyImportant(translator.of("status_bank_bankrupt"));
            if (town.getAccount().getDebtCap() == 0.0) {
                town.getAccount().setDebtCap(MoneyUtil.getEstimatedValueOfTown(town));
            }
            bankString = bankString + " " + TownyFormatter.colourKeyValue(translator.of("status_debtcap"), "-" + TownyFormatter.formatMoney(town.getAccount().getDebtCap()));
        }
        if (town.hasUpkeep()) {
            bankString = bankString + translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_bank_town2")) + " " + TownyFormatter.colourKeyImportant(TownyFormatter.formatMoney(BigDecimal.valueOf(TownySettings.getTownUpkeepCost(town)).setScale(2, RoundingMode.HALF_UP).doubleValue()));
        }
        if (TownySettings.getUpkeepPenalty() > 0.0 && town.isOverClaimed()) {
            bankString = bankString + translator.of("status_bank_town_penalty_upkeep", TownySettings.getTownPenaltyUpkeepCost(town));
        }
        bankString = bankString + translator.of("status_splitter") + TownyFormatter.colourKey(translator.of("status_bank_town3")) + " " + TownyFormatter.colourKeyImportant(town.isTaxPercentage() ? town.getTaxes() + "%" : TownyFormatter.formatMoney(town.getTaxes()));
        return bankString;
    }

    private static String formatMoney(double money) {
        return TownyEconomyHandler.getFormattedBalance(money);
    }

    private static List<String> getTownSubtitle(Town town, TownyWorld world, Translator translator) {
        ArrayList<String> sub = new ArrayList<String>();
        if (!town.isAdminDisabledPVP() && (town.isPVP() || world.isForcePVP())) {
            sub.add(translator.of("status_title_pvp"));
        }
        if (town.isOpen()) {
            sub.add(translator.of("status_title_open"));
        }
        if (town.isPublic()) {
            sub.add(translator.of("status_public"));
        }
        if (town.isNeutral()) {
            sub.add(translator.of("status_town_title_peaceful"));
        }
        if (town.isConquered()) {
            sub.add(translator.of("msg_conquered"));
        }
        return sub;
    }

    private static List<String> getNationSubtitle(Nation nation, Translator translator) {
        ArrayList<String> sub = new ArrayList<String>();
        if (nation.isOpen()) {
            sub.add(translator.of("status_title_open"));
        }
        if (nation.isPublic()) {
            sub.add(translator.of("status_public"));
        }
        if (nation.isNeutral()) {
            sub.add(translator.of("status_town_title_peaceful"));
        }
        return sub;
    }

    private static List<String> getWorldSubtitle(TownyWorld world, Translator translator) {
        ArrayList<String> sub = new ArrayList<String>();
        if (world.isPVP() || world.isForcePVP()) {
            sub.add(translator.of("status_title_pvp"));
        }
        if (world.isClaimable()) {
            sub.add(translator.of("status_world_claimable"));
        } else {
            sub.add(translator.of("status_world_noclaims"));
        }
        return sub;
    }

    public static List<String> getExtraFields(TownyObject to) {
        if (!to.hasMeta()) {
            return new ArrayList<String>();
        }
        String field = "";
        ArrayList<String> extraFields = new ArrayList<String>();
        for (CustomDataField<?> cdf : to.getMetadata()) {
            String newAdd = "";
            if (!cdf.shouldDisplayInStatus()) continue;
            newAdd = Translation.of("status_format_key_value_key") + cdf.getLabel() + ": ";
            newAdd = newAdd + cdf.displayFormattedValue();
            newAdd = newAdd + "  ";
            if ((field + newAdd).length() > 65) {
                extraFields.add(field);
                field = newAdd;
                continue;
            }
            field = field + newAdd;
        }
        if (!field.isEmpty()) {
            extraFields.add(field);
        }
        return extraFields;
    }

    private static boolean playerIsOnlineAndVisible(String name, Player player) {
        return BukkitTools.isOnline(name) && player != null && player.canSee(BukkitTools.getPlayer(name));
    }

    public static String getFormattedOnlineResidents(String prefix, ResidentList residentList, Player player) {
        return TownyFormatter.getFormattedTownyObjects(prefix, new ArrayList<TownyObject>(ResidentUtil.getOnlineResidentsViewable(player, residentList)));
    }

    public static String getFormattedTownyObjects(String prefix, List<TownyObject> objectlist) {
        return String.format(listPrefixFormat, prefix, objectlist.size(), Translation.of("status_format_list_1"), Translation.of("status_format_list_2"), Translation.of("status_format_list_3")) + StringMgmt.join(TownyFormatter.getFormattedTownyNames(objectlist), ", ");
    }

    public static String getFormattedStrings(String prefix, List<String> list) {
        return String.format(listPrefixFormat, prefix, list.size(), Translation.of("status_format_list_1"), Translation.of("status_format_list_2"), Translation.of("status_format_list_3")) + StringMgmt.join(list, ", ");
    }

    public static List<String> getFormattedTownyNames(List<TownyObject> objs) {
        ArrayList<String> names = new ArrayList<String>();
        for (TownyObject obj : objs) {
            names.add(Colors.translateColorCodes(obj.getFormattedName()) + "\u00a7f");
        }
        return names;
    }

    public static String[] getFormattedNames(TownyObject[] objs) {
        ArrayList<String> names = new ArrayList<String>();
        for (TownyObject obj : objs) {
            names.add(Colors.translateColorCodes(obj.getFormattedName()) + "\u00a7f");
        }
        return names.toArray(new String[0]);
    }

    public static List<String> getTaxStatus(Resident resident, Locale locale) {
        Town town;
        ArrayList<String> out = new ArrayList<String>();
        Translator translator = Translator.locale(locale);
        boolean taxExempt = TownyPerms.getResidentPerms(resident).containsKey("towny.tax_exempt");
        double plotTax = 0.0;
        double townTax = 0.0;
        out.add(ChatTools.formatTitle(translator.of("status_resident_tax_title", resident.getName())));
        out.add(TownyFormatter.colourKey(translator.of("owner_of_x_plots", resident.getTownBlocks().size())));
        if (resident.hasTown()) {
            town = TownyAPI.getInstance().getResidentTownOrNull(resident);
            if (taxExempt) {
                out.add(TownyFormatter.colourKey(translator.of("status_res_taxexempt")));
            } else {
                townTax = town.isTaxPercentage() ? Math.min(resident.getAccount().getHoldingBalance() * town.getTaxes() / 100.0, town.getMaxPercentTaxAmount()) : town.getTaxes();
                out.add(TownyFormatter.colourKeyValue(translator.of("status_res_tax"), TownyFormatter.formatMoney(townTax)));
            }
        }
        if (resident.getTownBlocks().size() > 0) {
            for (TownBlock townBlock : new ArrayList<TownBlock>(resident.getTownBlocks())) {
                town = townBlock.getTownOrNull();
                if (town == null || taxExempt && town.hasResident(resident)) continue;
                plotTax += townBlock.getType().getTax(town);
            }
            out.add(TownyFormatter.colourKeyValue(translator.of("status_res_plottax"), TownyFormatter.formatMoney(plotTax)));
        }
        out.add(TownyFormatter.colourKeyValue(translator.of("status_res_totaltax"), TownyFormatter.formatMoney(townTax + plotTax)));
        return out;
    }

    public static List<String> getRanksForTown(Town town, Locale locale) {
        Translator translator = Translator.locale(locale);
        ArrayList<String> ranklist = new ArrayList<String>();
        ranklist.add(ChatTools.formatTitle(translator.of("rank_list_title", town.getFormattedName())));
        ranklist.add(TownyFormatter.colourKeyValue(translator.of("rank_list_mayor"), town.getMayor().getFormattedName()));
        ranklist.addAll(TownyFormatter.getRanks(town, locale));
        return ranklist;
    }

    public static List<String> getRanksForNation(Nation nation, Locale locale) {
        Translator translator = Translator.locale(locale);
        ArrayList<String> ranklist = new ArrayList<String>();
        ranklist.add(ChatTools.formatTitle(translator.of("rank_list_title", nation.getFormattedName())));
        ranklist.add(TownyFormatter.colourKeyValue(translator.of("status_nation_king"), nation.getKing().getFormattedName()));
        ranklist.addAll(TownyFormatter.getRanks(nation, locale));
        return ranklist;
    }

    public static String getTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm aa");
        return sdf.format(System.currentTimeMillis());
    }

    @Deprecated
    public static String getFormattedName(TownyObject obj) {
        return obj.getFormattedName();
    }

    @Deprecated
    public static String getFormattedResidentName(Resident resident) {
        return resident.getFormattedName();
    }

    @Deprecated
    public static String getFormattedTownName(Town town) {
        return town.getFormattedName();
    }

    @Deprecated
    public static String getFormattedNationName(Nation nation) {
        return nation.getFormattedName();
    }

    @Deprecated
    public static String getFormattedResidentTitleName(Resident resident) {
        return resident.getFormattedTitleName();
    }

    @Deprecated
    public static String getNamePrefix(Resident resident) {
        return resident.getNamePrefix();
    }

    @Deprecated
    public static String getNamePostfix(Resident resident) {
        return resident.getNamePostfix();
    }
}

