package com.palmergames.bukkit.towny.event.mobs;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class MobSpawnRemovalEvent extends Event implements Cancellable {
	private static final HandlerList handlers = new HandlerList();

	private boolean cancelled = false;
	private final Entity entity;

	public MobSpawnRemovalEvent(Entity entity) {
		super(!Bukkit.getServer().isPrimaryThread());
		this.entity = entity;
	}

	@Override
	public HandlerList getHandlers() {
		return handlers;
	}

	public static HandlerList getHandlerList() {
		return handlers;
	}

	@Override
	public boolean isCancelled() {
		return cancelled;
	}

	@Override
	public void setCancelled(boolean isCancelled) {
		cancelled = isCancelled;
	}

	public Entity getEntity() {
		return this.entity;
	}

	public EntityType getEntityType() {
		return this.entity.getType();
	}

}
